# PleasantWeb

PleasantWeb is a smart browser extension that alerts users of unsuitable content online. It can detect both images (opened in new tabs) and text!

## Table of Contents

- [Introduction](#Introduction)
- [Languages Used](#languages-used)
- [APIs Used](#apis-used)
- [Contribution Guidelines](#contribution-guidelines)
- [Getting Started](#getting-started)


## Introduction

PleasantWeb is a smart browser extension designed to enhance your online experience by alerting you of unsuitable content. It analyses web pages in real-time and provides warnings for content that may be inappropriate or offensive. PleasantWeb helps ensure your online environment remains positive and safe. It’s an excellent tool for users of all ages, particularly for those who wish to avoid negative or harmful content. PleasantWeb is not just an extension it’s your companion for a more pleasant and secure web experience.

## Languages Used

- Vanilla JavaScript
- CSS
- HTML

## APIs Used

- Perspective API By Google Jigsaw (https://perspectiveapi.com/)
- Clarifai (https://www.clarifai.com/)

## Contribution Guidelines

We welcome contributions from everyone! Whether its code or documentation, your contributions are valuable to us.

- Ask to be assigned to a existing issue or create a new one and wait to be assigned
- Fork this Repository using the button at the top on the right corner.
- Clone your forked repository to your PC ( `git clone "url"` from clone option.)
- Create a new branch for your modifications (i.e. `git branch new-user` and check it out  `git checkout new-user` or simply do `git checkout -b new-user`)
- Make your changes
- Star this repository

## How To Run The Extension

1. **Download** the zip code and extract it on your pc.
2. **Open** extension manager page from chrome settings.
3. **Turn** on developer mode.
4. **Click** on "load unpacked" and select the extracted folder on your pc.
5. **Congrats**, you have added the extension on chrome.

## Getting Started

1. **Fork** this repository.
2. **Clone** your forked repository to your local machine.
```bash
git clone https://github.com/imkrishnasarathi/PleasantWeb.git
cd PleasantWeb
```
3. **Make Changes**
4. **Commit** your changes with a meaningful commit message.
```bash
git add .
git commit -m "Your meaningful commit message here"
```
5. **Push** your changes to your forked repository.
```bash
git push origin main
```
6. Create a **Pull Request** to this repository. (Option to create will be available in the repository after you make the Pull request)
7. Wait for your Pull Request to be reviewed and merged!

Please ensure that your code is properly commented and follows best practices.

[![Open Source Helpers](https://www.codetriage.com/imkrishnasarathi/pleasantweb/badges/users.svg)](https://www.codetriage.com/imkrishnasarathi/pleasantweb)
  
