---
title: Python Web 开发系统学习路线（2024年就业版）
description:  Python Web学习，Python应用场景，Python简介，Python特点
meta:
  - name: description
    content: Python Web学习，Python应用场景，Python简介，Python特点
  - name: keywords
    content: Python Web、爬虫、Python后台、python自动化运维、Python就业
---

# Python Web 开发系统学习路线（2024就业版）

国内目前用 Python 做后台开发的公司不多，据我所知就知乎、腾讯云控制台是 Python开发的，但是由于 Python 是动态语言，对于这种大型项目维护起来非常难受。

不过 Python 做一些中小 Web 后台开发还是非常方便和快捷的，以下是学习Python Web 开发的推荐路线和资源。

在这分享一下我学习过程中整理的书籍、面经、博客等，不是在网上那种打包下载的，而是自己需要学到某个方向知识的时候，去挨个找的，最后汇总而成。

有需自取: [计算机必看经典书单(含下载方式)](/resource/pdf.html)

## 一、核心知识点

1. Python基础知识
2. Web开发基础概念（HTTP、请求、响应等）
3. 数据库（关系型数据库如MySQL、非关系型数据库如MongoDB）
4. 前端基础知识（HTML、CSS、JavaScript）
5. RESTful API设计和实现

## 二、主要框架

1. Flask（轻量级Web框架）
2. Django（全功能Web框架）
3. FastAPI（现代、快速的API框架）

## 三、如何学习

1. 学习Python基础知识
2. 学习Web开发基础概念
3. 学习数据库知识
4. 学习前端基础知识
5. 学习并实践一个Web框架（如Flask、Django或FastAPI）
6. 动手实践，制作自己的项目

## 四、学习材料

### 书籍

1. 《Python编程：从入门到实践》 - Eric Matthes
2. 《Flask Web开发：基于Python的Web应用开发实战》 - Miguel Grinberg
3. 《Django 3 实战：构建高性能Web应用》 - Will Vincent
4. 《FastAPI入门与实战》 - 黄哲

### 视频教程

1. [Python官方教程](https://docs.python.org/3/tutorial/index.html)
2. [Flask Mega-Tutorial](https://blog.miguelgrinberg.com/post/the-flask-mega-tutorial-part-i-hello-world)
3. [Django for Beginners](https://djangoforbeginners.com/)
4. [FastAPI官方文档](https://fastapi.tiangolo.com/tutorial/)

### 在线资源

1. [Python官方文档](https://docs.python.org/3/)
2. [Flask官方文档](https://flask.palletsprojects.com/en/2.1.x/)
3. [Django官方文档](https://docs.djangoproject.com/en/4.1/)
4. [FastAPI官方文档](https://fastapi.tiangolo.com/)

