---
title: 如何快速学习掌握一门编程语言？
description: 如何快速学习编程语言，学习编程语言的方法，不同编程语言的特点，编程语言的特性
meta:
  - name: description
    content: 如何快速学习编程语言，学习编程语言的方法，不同编程语言的特点，编程语言的特性
  - name: keywords
    content: 编程语言、函数、定义、垃圾回收、指针、C++、Go、Java、语言特性
--- 

# 如何快速学习掌握一门编程语言？

今天聊聊如何学习编程语言这件事~

我们学校只在大一上教了 C 语言，大一下教了 Java，除此之外，其它编程语言语言都是靠自学。

比如后来想搞 C++ 开发，去学习 C++，后来听说先学习函数式编程对于学习 C++ 模板元编程有帮助，又跑去学习 Haskell，为了写脚本抢课去学 Python....

到现在，如果有需要的话，一般一两周就能入门一门语言，简单的可能几天就入门了。

在这分享一下我学习过程中整理的书籍、面经、博客等，不是在网上那种打包下载的，而是自己需要学到某个方向知识的时候，去挨个找的，最后汇总而成。

有需自取: [计算机必看经典书单(含下载方式)](/resource/pdf.html)

## 一、学习语法特性

正如之前在这篇文章中所表达的[如何掌握所有编程语言](https://www.yuque.com/csguide/index/gn5cl1c650f33919)，学习编程语言已经成了学习一堆语言特性的组合。

比如 Java 几乎就是 C++ 的子集，再加一点反射、接口这些，如果你会 C++ 的话，那么学习其它语言确实会快很多。

### 1.1 常见语法特性
常见的语法特性就那么多，换作比如变量、循环、算术运算、函数等，基本哪门编程语言都有：
- 函数定义，函数调用
- 递归
- 静态类型系统
- 类型推导
- lambda 函数
- 面向对象
- 垃圾回收
- 指针算术
- goto 语句

学习语言就是学习这些语言特性的组合，所有完全没必要去比较哪门语言更强，甚至有人还学出了优越感。。。

比如，居然有人瞧不起 Java？
![](https://cdn.how2cs.cn/gzh/008i3skNgy1gs0qu7n6dbj30ol0ktn04.jpg)

不同语言之间没有优劣之分，只有取舍，谁更适合不同的场景

## 二、不同语言的特点

### 2.1 C/C++
C/C++ 由于对内存控制非常精准、实时性很好，适合做底层对性能要求高的开发。

### 2.2 Java
Java 开发迅速，整个应用生态也非常好，很适合搞 Web、大数据开发。

### 2.3 Go
Go 天生支持协称，适合一些互联网并发高的业务。

### 2.4 Python

Python 库非常强大，包括机器学习、数据计算、分析、爬虫、Web等。

### 2.5 Haskell
haskell 这种函数式编程语言，适合学习函数式编程，尤其是你想掌握C++ TMP 的话，推荐先学下函数式，你会爽得飞起~~

### 2.6 大学科班首选 C/C++

另外，如果你还是大一科班学生的话，不着急找工作，我建议你把Java先扔掉，首选学 C/C++ ，无它，这是最贴近操作系统的语言，对于学习计算机系统帮助非常大~

### 2.7 转行首选 Java
如果你是转行、培训班的话，我建议你把 C++ 扔掉，首选 Java，因为没有计算机组成、计算机系统方面的知识你还驾驭不了C、C++，选择 Java 这是最容易就业的语言！！

**这些常见语言中，C++ 学习曲线应该算比较陡峭的，可以去看看《C++设计与演进》，学习下 C++ 之父设计之初的一些理念。**

**C++ 就是想给你足够的抽象能力，zero overhead abstraction 以及足够的自由！**

## 三、适合入门的编程语言
推荐一些适合入门的编程语言吧：

- **Scheme**（国外CS导论课特别喜欢用这个，比如 SICP 这本神书）
- **C/C++**
- **Java**
- **Python**

这些语言就不太适合作为入门语言：
* **Shell**
* **Php**
* **Basic**

我觉得一个适合入门的编程语言，特点应该是本身是“朴实”，就是拥有那些最常见的语言特性，你学会这门语言之后可以快速的迁移学习其它语言，C、Java 基本都符合。

但是 Shell、PHP 这类个人感觉就差点意思，而且 Shell 这种脚本语言学习重点反而在一些非语言层面的东西，比如 正则、环境、命令等。

但是编程语言最核心的应该是变量、循环、递归、类型系统、函数...

## 五、如何快速掌握一门语言
那么如何快速掌握一门语言呢：
### 5.1 入门阶段

#### 5.1.1 了解语言基本语法特性

如变量、字符串、循环、函数、递归等

#### 5.1.2 基本输入输出

了解基本输入输出、字符串处理如截取、查找、子串等

#### 5.1.3 了解该语言常用编程范式

如面向对象、面向过程、函数式编程等

#### 5.1.4 了解语言工具类
如 C++ STL、Java JDK 等，这样写代码才会顺畅~

### 5.2 提高阶段

#### 5.2.1 熟悉语言类库实现

比如 STL 源码、JDK 源码

#### 5.2.2 熟悉一些高级语言特性及其原理

比如 lambda、callback、Node 事件循环等
#### 5.2.3 熟悉并且深入理解编程范式

面向对象、函数式编程、数据驱动编程、状态驱动等

#### 5.2.4 了解语言 runtime 实现机制

比如 C++ 对象模型、Java JVM 原理、操作系统加载、链接机制等

#### 5.2.5 熟悉语言包管理系统

能够排查各种编译问题，调试程序 Bug

### 5.3 高手阶段

* **熟悉掌握一些类库设计语法和工具、序列化和反序列化等，比如 Java 的反射基本是写库、框架必备**
* **熟悉泛型编程、反射、动态编程、元数据等，这其实是写库必备，C++本身不支持反射，但是可以通过其它扩展，比如 protobuf 来描述类元信息实现反射**
* **熟悉语言的设计、演化过程**
* **熟悉语言编译、链接、解释执行的一些细节**

## END
按这个思路学习编程语言思路就非常清晰，你也知道哪一个阶段该重点关注的是什么~