---
title: C 语言超详细系统学习路线（2024年最新）
description: 如何系统学习C语言，C语言该怎么去学习，冲击大厂，指针和内存如何深入学习，C语言和计算机系统
meta:
  - name: description
    content:  如何系统学习C语言，C语言该怎么去学习，冲击大厂，指针和内存如何深入学习，C语言和计算机系统
  - name: keywords
    content: C++、C、内存、指针、C语言、计算机系统、学习路线
---


# C 语言超详细系统学习路线（2024年最新）

> 原文首发于个人公众号: [如何系统学习C语言](https://mp.weixin.qq.com/s/SQESC1_zv-EfNzyPrA8HsQ)

大家好，我是小北。

今天这篇文章分享一下 C 语言的系统学习路线，那么在这里再次强调下 C 语言的重要性哈：

![](https://cdn.how2cs.cn/gzh/008eGmZEgy1gpmscfojuzj30hk0awdkv.jpg)

* **C 语言应该是绝大部分同学的编程第一课。**
* **对于非 CS 专业的同学，学 C 语言主要是掌握一些基本的编程方法，C 语言只是媒介。**
* **但是对于 CS 科班的同学，C 语言是后续的计组、体系结构、操作系统、编译原理等课程的基石，对于 C 语言本身甚至程序设计语言基础原理的深入理解都是应该掌握的。**

在这分享一下我学习过程中整理的书籍、面经、博客等，不是在网上那种打包下载的，而是自己需要学到某个方向知识的时候，去挨个找的，最后汇总而成。

有需自取: [计算机必看经典书单(含下载方式)](/resource/pdf.html)

## 一、一图胜千言

如果你不想看冗余的文字，直接看我画的这个思维导图即可：
![](https://cdn.how2cs.cn/gzh/008eGmZEgy1gpmtrv7cu4j31450raq87.jpg)

前面会写一些 C 语言的学习经验，如果想直接看资源推荐和学习路线，直接点击到第三点： [系统学习C语言](/roadmap/c/how_to_learn_c.html#三、系统学习c语言)

## 二、C 语言易学难精？

很多同学都反映 C 语言难。

实际上，相比 C++、Java 之类的更加现代的语言， C 语言本身的语法特性非常少，不像 C++ 成了一锅大杂烩。

**C 语言本身只包含了编程语言最基本的语法，比如变量、if、else、for、while、枚举、结构体等，外加一个指针。**
**但是为什么大家都觉得难呢？**

说下我大一时觉得难的原因吧，主要两点：

### 2.1 库太少，太原始

用 C 语言写个稍微复杂点的项目，你需要上来先把数据结构、常见算法先实现一遍，更别说字符串，序列化这些了。

比如 Redis 里 SDS、LIST、ZSET、HASH等，这其实对新手极其的不友好。

想做点有趣的东西，来，先写个链表？

而在 Java 里直接 New 一个 LinkedLits、HashMap，简直不要太高效。

再到后来，学了 Python，才发现这才是高级编程语言，写个爬虫直接 import xx，几句话就完事了。

而在 C 语言里，你需要裸写 Socket 发网络包，还要解析 HTTP 协议，还要序列化 JSON，处理 HTTPS 这些（当然，你也可以导入库，但是由于 C/C++ 弱鸡等同于没有的包管理，也挺麻烦的。

这就是新手学 C 容易被劝退的原因，做不出好玩的东西，全是一堆黑框框。

### 2.2 指针

另外，常另 C 语言初学者感到头疼的就是指针了。

指针其实本身不难，就是变量的地址嘛。

但是问题在于地址是个什么东西？

理解地址，就需要理解内存，但是鉴于大多数同学学习 C 语言，都是在大一，那时候没有计算机基础知识，其实理解起来还是稍微吃力的。

内存，其实也很简单啊，你就把它当做一个黑盒，提供了读和写的能力。

就像快递柜一样，提供了存东西、放东西的能力：
![](https://cdn.how2cs.cn/gzh/008eGmZEgy1gpmqv6oe24j30i40bp49g.jpg)

读哪里？写哪里？

### 2.3 内存

当然是需要地址啊，地址就跟快递柜上的编号一样，而快递柜格子里就相对于内存中真正存放的内容。

记住这张快递柜的照片，其实指针你就理解了。

什么是二级指针？

就是快递柜格子里放的是另外一个格子的编号，对应到 C 语言举个例子：
```c
int a = 10;
int *pa = &a;
int **ppa = &pa;
```
ppa 所指向的内存存放的内容是 pa 的地址，pa 存放的是 a 的地址(就不画图了，脑补

那你要问了，那指针和二级指针以及更多级的指针有什么区别呢？

为什么二级指针就要两个```**```？

很简单啊，不用两个 ```**``` 的话，你怎么告诉编译器，这个地方放的其实是另外一个内存的地址。

这样编译器才能去做语法检查，不然谁知道你这是放的变量地址还是另外一个指针的地址啊。

更加详细的内容其实我在公众号这篇指针的文章中讲过：
[为什么指针被誉为 C 语言灵魂？](https://mp.weixin.qq.com/s/d1ng1-AFFdPGLWDXVKPJZg)

不过现在站在我的角度，觉得指针很简单，似乎很好理解，也许是知识诅咒的原因。

> 知识诅咒：指的就是一旦我们自己知道某样东西，我们就会发现很难想象不知道它的时候会是什么样子。

后来接触到 Java，如同发现了新大陆一般。

在 C 语言里，申请一个内存，你得随时记得在合适的地方释放。

释放得不合适？
对不起 coredump 随时等着你。

忘了释放？
对不起，内存泄露等着你~

乱写指针？

对不起，内存越界等着你~

栈内存越界？

VS下，烫烫烫等着你~

这些东西想必是每一位 C Programmer 的家常便饭了。

而在 Java 这类更加高级语言中，直接 ```new``` 一个就行了。

**好了，扯淡完毕，在这里给出一条系统化学习 C 语言的路线吧：**

## 三、系统学习C语言

主要分为两个阶段：
* **初学C语言 && 入门**
* **提高& 深入**

## 四、第一阶段：初学少看书，多看视频

这真的是血泪教训，我大一会傻乎乎的去把课本看一遍，然后做课本后面编程练习题。

学得那叫一个艰难呀，大家都知道，课本为了保留其严谨性和全面性，往往都具有一个特点，那就是「不说人话」。

对于 C 语言，初学者有一个难点需要克服，就是容易遇到各种编译、链接错误，而且不知道怎么解决：

![](https://cdn.how2cs.cn/gzh/008eGmZEgy1gpmtvjw2khj30wv0hiqbw.jpg)

比如这种很初级的报错，但是初学者往往看到就慌了。
遇到这种情况，我的建议是仔细读报错的提示，解决方法往往就在这些 note 中，如果实在解决不了，就复制 note 去 Google 上搜。

这个阶段你需要三份资料：

* **一是补 CS 基础概念，也就是计算机导论**
* **二是一本 C 语言的好书。**
* **三是一个优质的 C 语言视频。**

对于每一点，我都只推荐一份我觉得最合适的，避免你陷入选择困难症。

### 4.1 计算机导论：CS 50

计算机导论这门课推荐CS 50，这是哈佛的一门计算机入门神课，忘了是在大一下还是大二看的了，当时觉得如获至宝，点燃了我对计算机的热情！

官网课程链接如下：
[https://cs50.harvard.edu/college/2021/spring](https://cs50.harvard.edu/college/2021/spring)

B站视频链接：[https://www.bilibili.com/video/BV1Rb411378V](https://www.bilibili.com/video/BV1Rb411378V)

让我现在还记忆尤新的一个点，是这个老师讲到 binary search 的时候，直接举了查字典这个过程，然后现场手撕字典。。。

![](https://cdn.how2cs.cn/gzh/008eGmZEgy1gpmu2o4v7bj318w0lr7o1.jpg)

另外，这门课是用 C 语言作为教学语言的，非常难得。

因为现在国外很多 CS 名校的导论课都会采用类似 Python、Schema 这样的语言。

**但其实你会发现，在 CS 50，不会讲多少 C 语言的语法，C 语言只是作为一种传递编程思想、引领你入门计算机的媒介。**

而不是在教 C 语言。

课程下方有条评论说的挺好的：

> 在别的地方看到有人说这个教的太浅、没实际用处之类的，但我真的很感谢这门课。当年我还是个cs专业萌新，觉得这个专业又难又无聊，结果看了这个看世界观都被颠覆了，哇，原来学计算机可以那么酷，原来学cs的人都这么聪明、自信、有激情。一个导论课能让原本对计算机不感兴趣的学生都感受到了这门科学的魅力所在，从这个角度来说，这门课实在是非常伟大

### 4.2 翁恺 C 语言视频
推荐一个我以前在地铁都在刷的，浙大翁恺老师教授的，直接去中国大学 MOOC 搜索即可，这是链接：

[https://www.icourse163.org/course/ZJU-199001](https://www.icourse163.org/course/ZJU-199001)

说到这，我不得不多说两句翁恺老师了，我看了好几门他的课，最直观的感受是：

讲解透彻、声音好听，而且特别注重细节，娓娓道来。

![](https://cdn.how2cs.cn/csguide/014836.png)

贴一张浙大匿名教室系统关于翁凯老师的评价吧：

![](https://cdn.how2cs.cn/gzh/008eGmZEgy1gpmufbro0nj30q30koqa3.jpg)

一句话，翁凯老师是真的想把计算机内部原理、编程语言以深入浅出的方式教给大家。

### 4.3 C语言书 《C程序设计语言》

这本书被称作 C 语言圣经。

在短小的篇幅中，涵盖了 <stdio.h>、<string.h> 中的大部分例子，习题也都是经典，从 hello world 开始，到二分查找、二叉树、快排、哈希表等，甚至还用递归下降写了词法分析，帮你理解复杂的声明。

不过要看懂里面的每一个例子，也是有一定难度的，需要有一点点基础，但是不妨碍作为入门书，可以多看几遍。
对了，一直说学编程要多写，但是很多初学者也不知道写什么。
在这里，我给出一些学完 C 语言基本语法后，可以练手的例子：

### 4.4 C语言练习题
* **链表**
就用 C 语言把链表翻来覆去的写，从最基本的链表插入、删除、单向、双向、环装链表，到链表反转、合并、分割等。

别看基础，但是很多同学到大四了，可能都写不对，这里考察是否足够细心、逻辑是否缜密。

会不会操作着就把链给断了。

* **写点小东西**
比如图书管理系统、俄罗斯方块、贪吃蛇之类。

这种代码量大多在 500 - 1000，会综合运用函数、文件操作、动态内存、指针这些关键的东西。

## 五、第二阶段：系统深入学习

### 5.1 计算机系统知识

这个阶段，是需要掌握一些计算机系统知识才能学好的，比如虚拟地址就和操作系统相关了，而函数调用栈这些又和汇编相关。

又比如很多学了很久的同学，还不太清楚变量的声明和定义区别，extern 又有什么作用，这些实际上就需要理解内存分区的东西。

C 语言的核心就在于指针、内存，能不能学好、用好 C 语言，更多在于是否拥有扎实的计算机结构、存储、运算原理方面的知识。

所以强烈建议在学习 C 语言的同时去了解一下补码、数的二进制表示、内存、汇编等知识，尤其是内存和汇编，这两个对于深刻理解指针和熟练运用有很大的帮助。

我就不仔细介绍了，要介绍的书都在这张思维导图里了：

![](https://cdn.how2cs.cn/gzh/008eGmZEgy1gpmuz13u6xj30r20gs773.jpg)


### 5.2 深入学习指针

#### 《C和指针》、《深入理解C指针》

《C和指针》、《深入理解C指针》，真的是涉及指针方方面面的好书，墙裂推荐。

### 5.3 编译、链接

这俩兄弟懂了其实也不能帮你提高写代码的水平，主要是对于一些编译、链接过程的报错，更加的明确，不至于懵。

比如链接过程中常见的错误是符号未找到（undefined reference）和符号重定义（redefinition）

当你熟悉链接过程，符号查找过程之后，解决对应的报错也会得心应手。

推荐：

#### 5.3.1 《深入理解计算机系统》--第七章《链接》

![](https://cdn.how2cs.cn/csguide/021112.png)
首先推荐大家阅读 CSAPP 的第七章，读完这张你就能搞懂静态链接、动态链接、加载、目标文件、重定位、符号表之类的东西。

#### 5.3.2 《程序员自我修养: 链接、装载与库》

这本书的主要内容其实体现在副标题：链接、装载、库。

这本书是属于偏底层的内容，最好是在你对操作系统、指针、内存这些都有一定基础的时候再去看，否则容易懵逼。

#### 5.3.3 《汇编语言-王爽》、《CSAPP》第三章。
为什么要学汇编语言呢，因为 C 语言之下就是汇编，会汇编，你就能直接把 C 语言衣服扒掉，看看背后的实现，比如大家都在讨论数组和指针有什么区别？

你去写个程序，然后 gcc -S 一下，看下汇编代码，你就会发现计算机访问的指令没啥区别，都是基地址 + 偏移的形式。

汇编不需要会写，会看懂部分记得，大可不必去刻意的记住各种指令、寻址方式。

好了，今天的 C 语言学习之路就到这里了，其实还有很多东西没提，比如 Linux C 方向的，主要是为了突出学习 C 语言本身，不想喧宾夺主，让大家迷失了方向。

## END 学习资料
另外，我推荐的这些书籍，我也都汇总了，可以去微信公众号: 【编程指北】回复【C语言】即可。
