---
title: 计算机网络超详细系统学习路线（2024年最新）
description: 如何系统学习计算机网络，计算机网络该怎么去学习，冲击大厂，TCP、HTTP、网络协议
meta:
  - name: description
    content:  如何系统学习计算机网络，计算机网络该怎么去学习，冲击大厂，TCP、HTTP、网络协议
  - name: keywords
    content: 计算机网络, 学习路线, TCP, UDP, HTTPS, MAC地址, IP地址
---

# 计算机网络超详细系统学习路线（2024年最新）

大家好，我是小北。

经常有同学来问我，计算机网络学不懂，只会背一堆协议怎么办，如何学习计网等等。

那么这篇文章就给大家聊聊关于计算机网络的一些**学习体会和学习路线。**

前面先会讲计算机网络的一些学习方法，如果你想直接看相关学习资源请点击这里 [系统学习计算机网络](/roadmap/basic/how_to_learn_networking.html#五、系统学习计网)

在这分享一下我学习过程中整理的书籍、面经、博客等，不是在网上那种打包下载的，而是自己需要学到某个方向知识的时候，去挨个找的，最后汇总而成。

有需自取: [计算机必看经典书单(含下载方式)](/resource/pdf.html)

## 一、经典面试题

首先从一道经典面试题开始：

**在浏览器输入一个 URL，到网页显示出来，中间发生了什么 ？**

不知道小伙伴们面试被问过这个问题么？

这个问题其实在 **《Computer Networking: A Top-Down Approach》** 这本书的末尾花了十几页的篇幅完整的描述过。

如果你还是无法很清晰的说出其中过程，那就说明还需要去补课哈，最终检验学习计网的效果也是回答这个问题，回答得越详细，越清晰说明对于网络理解也就到位了。

**当然了，不同岗位的同学可能关注的重点会不一样，前端同学可能更关注 HTTP、浏览器网络请求、渲染过程，后台同学则更关注网络层和传输层。**

我们暂时不写这个问题的具体答案是什么，先聊聊如何学习计算机网络。

## 二、学习计网的误区

不少初学的小伙伴，在学习计网过程中，特别容易陷入一个误区：

**挨个的背下每一个网络协议的作用，头部字段以及通信双方的交互过程。**

比如这个 IP 数据包的头部：

![IP头部格式](https://cdn.how2cs.cn/gzh/007S8ZIlgy1gi8p3mt4t4j30sw0jyju6.jpg)

花了好大的力气，终于背完了 HTTP、TCP、IP、ARP、DHCP 等一堆协议。

**最后还是说不清数据包是如何在网络世界传输的。**

也就是没有对计算机网络建立起一个全局的视角，这是多么大的悲伤呀！

所以学习计网一定不要完全去死记硬背，不然就会今天记、明天忘。

## 三、 如何理解计算机网络？

我们要明白，网络存在的目的就是解决主机之间的通信问题。

最简单的，我们可以直接将两台主机通过网线连接：

![点对点直连](https://cdn.how2cs.cn/gzh/007S8ZIlgy1gi8xv13mcbj30bp01z744.jpg)

这个时候是不需要什么 IP 协议、ARP 之类的东西，

但是随着越来的越多的主机加入，会遇到如何寻址、数据包发送冲突等问题。

为了解决这些问题，我们引入了 MAC 地址、ARP、IP 这些协议。

从问题出发，按照 **Why -> How -> What**  这样的顺序。

先谈遇到了什么问题，再说如何去解决，最终才是搬出前辈们的 RFC 文档，这样就会顺畅很多。

而且这是在引导我们去思考如何解决问题，从**点对点连接**开始如何构造一个网络。

如果一上来就搬出原理，比如 TCP 连接管理、状态转换、超时重传、IP 包如何分段与重组这样的东西，我觉得是比较懵逼的。

作为初学者我们并不太清楚为什么需要这样做，不这样做行不行？

以前学计网的时候，我也有一堆的困惑：

* **比如路由器和交换机有什么区别？**
* **为什么有了 MAC 地址还要 IP 地址呢？**
* **只用 IP 地址行不行呢？**
* **如何理解广播域和冲突域？**
* **大家有过这些问题么？**

如果你脑海里对这些问题的答案非常的清晰，那么恭喜你，你对网络掌握得还不错！ 

## 四、自底向上 or 自顶向下

网络世界分层极其明显，所以教材包括教学方式一般分为两类：

* **自顶向下**
* **自底向上**

当然了，学习其它东西也是同理，只不过分层的感觉可能没有计网这么强烈。

### 4.1 自顶向下的好处

我们大学老师就是从应用层开始往下讲的，自顶向下的好处是直观，上层的直观感受会让你有探索下层实现的欲望。

我们教材也恰好使用的是 **《计算机网络-自顶向下》** 这本经典的计算机网络书籍，并且书名里就说了这是自顶向下的。

按照网络的五层模型，从我们日常接触的应用层往下依次把网络的面纱解开。

### 4.2 自底向上的好处
当然了，国内也有不少高校是以自底向上的方式上课的，一上来就是一堆的物理层、链路层协议，典型教材如 **《Computer Networks, Fourth Edition》。**

我个人其实也是很喜欢这种方式的，自底向上也有其独特的魅力。

独特在哪？

**因为自顶向下是一层层的从外向内打开，然而最初设计网络的时候肯定不可能是自顶向下的吧。**

**真实的世界一定是自底向上演变的，不可能先定义了 HTTP 协议再去考虑如何设计 TCP 传输层，这显然不合理嘛。**

网络的演变一定是最初有两台电脑互相通信的需求，然后是多台电脑，他们之间构成了局域网，再往后局域网之间组成了广域网。

### 4.3、分层的思想

**最关键的是，自底向上是解决问题导向，比如有了 IP层 为什么还需要传输层呢？**

**我们都知道一台电脑可能有多个进程在使用网络连接，那么当 IP 包到达主机时，怎么区分这是发给哪个进程的呢？**

**操作系统为了能够区分数据是传给上层哪个应用的，才引入了传输层。**

这是自底向上解决问题的过程。

但是自顶向下可能就是学完应用层，直接告诉你，下一层是传输层，然后接着讲 TCP 和 UDP 是什么。

比如在《自顶向下》第三章讲传输层的时候，是这样开篇的:

>  运输层位于应用层和网络层之间，是分层的网络体系结构的重要部分。该层为运行在不同主机上的应用进程提供直接的通信服务起着至关重要的作用。我们在本章采用的教学方法是，交替地讨论运输层的原理和这些原理在现有的协议中是如何实现的。与往常一 样，我们将特别关注因特网协议，即 TCP 和 UDP 运输层协议。

那我可能就会想，**为什么在应用层和网络层之间需要运输层，直接把应用数据包打包在网络层里发送出去不行吗？**

当然可以，只要给每个应用分配一个唯一的ID，一起放在网络层的数据包发送出去，接收方使用这个 ID 来定位数据是给哪个应用的。

其实你也看出来了，这就是把 TCP、UDP 做的事情放在了 IP 层去做。

**所以为了保持 IP 层的灵活性和功能独立，这里引入了传输层，这就是分层。**
分层这个思想在计算机世界中非常重要，你可以在任何地方看到它的身影。

有一句名言：

> **“计算机科学领域的任何问题都可以通过增加一个间接的中间层来解决”**

### 4.4  深入理解计网
学习计网过程中也需要建立结构化的思维，最直观的结构就是按照计网的层次来，即：**应用层、传输层、网络层、数据链路层、物理层。**

然后在去学习每个层的功能和其中的每个协议，这个过程既可以自顶而下，也可以自底向上。

**分层学习过程中除了要掌握每一层之外，最重要的其实是要学习层与层之间是如何链接起来的，比如 IP 层和数据链路层就是 ARP 协议。**

最后当你学完所有的协议后，再回顾一下，一个数据包是如何从 send() 函数发送出去的。

离散的 IP 数据包又是如何抽象出“面向连接”的 TCP 层，并且要清晰的认识到这里的连接是一种逻辑状态，建立、断开连接则是同步双方的通信状态。

基于这样的认识，才能轻易的回答出类似：

**“TCP连接建立后出现服务器崩溃、断电、网线被拔...会发生什么情况”这样的问题。**

## 五、系统学习计网

上面讲得一些都是我对于计算机网络学习的一些粗浅认识，接下来就给大家推荐一些，我看过的一些不错的资料。

## 六、网络入门学习资料

### 6.1《网络是怎么连接的》

![](https://cdn.how2cs.cn/csguide/083700.png)

这本书在豆瓣评分挺高的，这本书以探索之旅的形式，从在浏览器中输入网址开始，一路追踪了到显示出网页内容为止的整个过程。

以图配文，讲解了网络的全貌，能够快速让我们建立起对计算机网络的整体认识。

### 6.2《图解HTTP》、《图解TCP/IP》
![](https://cdn.how2cs.cn/csguide/083700.png)
这两本书以非常丰富的图的形式来分别讲解 HTTP、TCP 协议，优点是浅显易懂，缺点就是不够深入。

## 七、系统深入学习： 书籍篇

### 7.1 《计算机网络：自顶向下》

在前面已经提到了，这本书是以自顶向下的视角来逐层介绍计算机网络的，还算比较深入。

并且在介绍 TCP 之前，作者先用了很大的篇幅来讲明白《如何设计一个可靠传输协议》，之后再讲解 TCP，你就能明白为什么 TCP 需要滑动窗口、重传等机制了。

### 7.2 《TCP/IP详解 卷一》

这本书是黑皮书，非常系统、且全面的介绍了网络相关知识，其中 TCP 的部分更是细致入微，但是这本书我不建议你看完，因为太厚了，有点浪费时间，对于一般的应用开发程序员来说，重点看 TCP 部分章节即可。

### 7.3 RFC 文档
RFC 文档是计算机网络的协议标准文档，有时候如果需要扣一些细节的时候，就可以去搜索对应的 RFC 文档。

### 7.4 《Wireshark 网络分析就这么简单》

学习网络过程中一定要自己去抓包看看，看看各种协议的包头都有哪些字段，这样记忆会更加的深刻。

![](https://cdn.how2cs.cn/csguide/085908.png)

### 7.5 TCP 源码分析
学习网络的最高层次就是直接入手学习 Linux 的网络源码实现，当然这个难度很高，一般人没有这个精力和动力。

之前看了一个 PDF《TCP源码分析》，写的很不错，对于 TCP 感兴趣的小伙伴可以看下 ：
![](https://cdn.how2cs.cn/gzh/008i3skNgy1gqje8e2yfjj31c10u0b2b.jpg)

**需要这本书的话，可以在我公众号【编程指北】后台回复关键词：TCP**

## 八、系统学习：视频版

### 8.1 哈工大计算机网络

官网的课程介绍：
> 哈工大《计算机网络》课程分为三个单元：“计算机网络之网尽其用”、“计算机网络之探赜索隐”和“计算机网络之危机四伏”。
>
> “计算机网络之网尽其用”将带你快速了解、认识计算机网络，理解并掌握计算机网络与网络协议等基本概念、网络组成与网络体系结构。
>
> “计算机网络之探赜索隐”将带你深入计算机网络内部，探究计算机网络深层奥秘，了解并掌握计算机网络深层次的原理、协议及网络技术，让你不仅知其然而且知其所以然，真正成为计算机网络的行家里手。
>
> 这部分主要讲授：可靠数据传输基本原理、停-等协议与滑动窗口协议、典型传输层协议（UDP与TCP）、虚电路网络与数据报网络、路由与转发、IP协议与IP地址、CIDR、子网划分与路由聚集、ICMP协议、DHCP协议、NAT、IPv6、路由算法、路由协议、差错编码、MAC协议、ARP协议、以太网、VLAN、PPP协议、无线局域网等。

地址：[https://www.icourse163.org/course/HIT-154005](https://www.icourse163.org/course/HIT-154005)

B 站也有对应的视频，B站弹幕会丰富一些，学起来也更有意思，可以去搜索下~

### 8.2 计算机网络-湖大教书匠

这个 UP 主讲的计算机网络十分通俗易懂，并且还有一些实验，还有考研 408 相关的题目讲解，适合考研党和找工作面试的同学。

地址：[https://www.bilibili.com/video/BV1c4411d7jb](https://www.bilibili.com/video/BV1c4411d7jb/?p=1&vd_source=dbac6fa7bb0e0e4d77d2421a5d3792cd)
![](https://cdn.how2cs.cn/csguide/091845.png)

### 8.3 CS 144--实现TCP 协议栈

国外经典课程：

斯坦佛 CS144，在这门课的 Project 中，你将用 C++ 循序渐进地搭建出整个 TCP/IP 协议栈，实现 IP 路由以及 ARP 协议，最后利用你自己的协议栈代替 Linux Kernel 的网络协议栈和其他学生的计算机进行通信，非常 amazing！

课程网站：[https://cs144.github.io/](https://cs144.github.io)

课程视频：[https://www.youtube.com/watch?v=r2WZNaFyrbQ&list=PL6RdenZrxrw9inR-IJv-erlOKRHjymxMN](https://www.youtube.com/watch?v=r2WZNaFyrbQ&list=PL6RdenZrxrw9inR-IJv-erlOKRHjymxMN)

课程作业：[https://cs144.github.io/](https://cs144.github.io/)   8 个 Project 带你实现整个 TCP/IP 协议栈。

## 九、网络编程
这一部分的知识可以看这篇文章: [如何学习网络编程?](/roadmap/basic/network_programming_learning_path.html)

## 十、网络攻击
简单网络攻击：比如去玩玩 ARP 攻击，在寝室或者你们家里搞点“网络攻击”。

我觉得学习计网，做点网络编程、简单网络攻击、抓包，会让学习更加有趣，我当时是这几个都玩了下，你对这些网络协议的认识就会更加深刻的。

当然这里说网络攻击不是让大家去干坏事哈，像上面的 ARP 攻击，如果在一个大的局域网内，比如校园网，也可能造成别人无法上网，所以大家所有的网络攻击实验都最好在虚拟机网络环境下。



