---
title: Redis 超详细系统学习路线（2023）
description: 如何系统学习Redis，Redis 有哪些应用，后端开发冲击大厂，KV存储
meta:
  - name: description
    content:  如何系统学习Redis，Redis 有哪些应用，后端开发冲击大厂，KV存储
  - name: keywords
    content: Redis, 学习路线, 高性能, AOF, RDB
---

# Redis 超详细系统学习路线（2023）

## 一、Redis应用场景

这篇文章聊下关于 Redis 的学习路线，作为目前非常热门的键值数据库，Redis 的应用非常广泛，常见的用来做**缓存、分布式锁，还有做数据库持久化数据的**。

如果你是后端开发工程师，不管是工作还是面试，大概率都会涉及到 Redis 相关的问题，或者有些公司会有内部自研的 KV 存储系统，不过这些大的思想其实都是类似的，只不过公司内部的可能是做了特定场景的优化。

比如说，为了保证数据的可靠性，Redis 需要在磁盘上读写 AOF 和 RDB，但在高并发场景里，这就会直接带来两个新问题：

一个是写 AOF 和 RDB 会造成 Redis 性能抖动，另一个是 Redis 集群数据同步和实例恢复时，读 RDB 比较慢，限制了同步和恢复速度。

在这分享一下我学习过程中整理的书籍、面经、博客等，不是在网上那种打包下载的，而是自己需要学到某个方向知识的时候，去挨个找的，最后汇总而成。

有需自取: [计算机必看经典书单(含下载方式)](/resource/pdf.html)

## 二、学习路线

### 2.1 两大维度、三大主线

引用 [Redis核心技术与实战](http://gk.link/a/11ZGR) 里的图，Redis 的学习要抓住“两个大的维度，三大主线”。

![](https://cdn.how2cs.cn/csguide/053731.jpg)

“两大维度”就是指系统维度和应用维度，“三大主线”也就是指高性能、高可靠和高可扩展（可以简称为“三高”）。

从系统维度上说，需要了解 Redis 的各项关键技术的设计原理，这些能够为我们判断和推理问题打下坚实的基础，而且，还能从中掌握一些优雅的系统设计规范，例如 run-to-complete 模型、epoll 网络模型，这些可以应用到我们后续的系统开发实践中。

别看技术点是零碎的，其实完全可以按照这三大主线，给它们分下类，就像图片中展示的那样，具体如下：

- **高性能主线，包括线程模型、数据结构、持久化、网络框架；**

- **高可靠主线，包括主从复制、哨兵机制；**

- **高可扩展主线，包括数据分片、负载均衡。**

### 2.2 学习新知识

我们知道，缓存和集群是 Redis 的两大广泛的应用场景。在这些场景中，本身就具有一条显式的技术链。

比如说，提到缓存场景，肯定会想到缓存机制、缓存替换、缓存异常等一连串的问题。

基本上学习任何一个东西我们都可以按照以下步骤来：

* **了解是什么、怎么用、什么场景用**
* **学习为什么有这样的能力**
* **学习底层实现的原理**

对于 Redis 来说，首先我们需要安装一个 Redis，然后自己去命令行或者写代码实践一下，把 Redis 用起来。

会用之后，我们应该思考 Redis 底层是如何去存储 KV 数据的，如何高效组织的数据，那么这块就需要掌握 Redis 内部的数据结构。

除此之外，还需要学习 Redis 的网络模型、高可用、高性能是如何做的。

## 三、学习资料

## 3.1 官网

Redis官网：[https://redis.io/](https://redis.io/)

在官网有 Get Started 能带领我们一步步熟悉 Redis 的安装和使用，也有各自官方文档，这里是 Redis 的第一手资料。

官网有所有 Redis 支持的命令，以及用法:

[https://redis.io/commands/](https://redis.io/commands/)

如果你想看中文的话，这里也有翻译版:

[http://redisdoc.com/](http://redisdoc.com/)

### 3.2 源码

[https://github.com/redis/redis](https://github.com/redis/redis)

Redis 源码全部是用 C 语言写的，看的时候也不一定要完全看，可以带着问题去跟踪具体的函数是怎么执行的，也可以是看某一个文件，比如 sds.c，去学习 Redis 是如何设计字符串结构的：
![](https://cdn.how2cs.cn/csguide/092737.png)

### 3.3《Redis 使用手册》

《Redis 使用手册》是一本非常好用的工具书，在这本书中，作者把 Redis 的内容分成了三大部分，分别是“数据结构与应用”“附加功能”和“多机功能”。

其中，我认为最有用的就是“数据结构与应用”的内容，因为它提供了丰富的操作命令介绍，不仅涵盖了 Redis 的 5 大基本数据类型的主要操作命令，还介绍了 4 种扩展数据类型的命令操作，包括位图、地址坐标、HyperLogLog 和流。

只要这本书在手边，我们就能很轻松地了解和正确使用 Redis 的大部分操作命令了。

### 3.4 《Redis设计与实现》
这本书重点从源码和底层原理出发，系统全面的剖析了 Redis 的核心数据结构和内部运行机制。

这本书讲解得非常透彻，尤其是在 Redis 底层数据结构、RDB 和 AOF 持久化机制，以及哨兵机制和切片集群的介绍上，非常容易理解，建议重点学习下这些部分的内容。

### 3.5 实战书：《Redis 开发与运维》
这本书首先介绍了 Redis 的 Java 和 Python 客户端，以及 Redis 用于缓存设计的关键技术和注意事项，这些内容在其他参考书中不太常见，可以重点学习下。

其次，它围绕客户端、持久化、主从复制、哨兵、切片集群等几个方面，着重介绍了在日常的开发运维过程中遇到的问题和“坑”，都是经验之谈，可以帮助我们提前做规避。

### 3.6 极客时间专栏: 《Redis核心技术与实战》
这个专栏，我基本看完了，感觉写的都是 “Redis核心” 知识，尤其是如果你去面试，需要突击的话，看之前推荐的书可能有点慢，看这个专栏会快很多，这个是专栏目录：

![](https://cdn.how2cs.cn/csguide/094431.png)
[专栏阅读地址](http://gk.link/a/11ZGR)




