---
title: 计算机校招如何高效复习?
meta:
  - name: description
    content:  介绍互联网技术岗校招流程，计算机校招高效复习方法，包括操作系统、计网、算法、数据结构等，提供科学的复习方法
  - name: keywords
    content: 计算机专业, 校招, 春招, 秋招, 复习、操作系统、学习方法
---

# 计算机校招如何高效复习?

::: tip 摘要
计算机校招高效复习方法，包括操作系统、计网、算法等。
:::

## 一、offer收割机特征
每年都有一些同学成为 offer 收割机，总结了一下这类同学大概有以下几类:

* ACM 出身，各种金牌、银牌拿到手软的竞赛大佬
* 985、211以及一些计算机强校毕业，在学习能力、逻辑能力方面都比较优秀，还有大厂实习经历
* 对计网、操作系统等计算机基础知识理解深刻，技术涉猎也比较广，对于分布式、RPC、消息队列这类后台必备技术栈比较熟悉

对于我们普通人来说，ACM 金牌显然不那么容易，而且这个是需要大学里长期积累，不断打比赛才有机会拿到的。

如果读者里有大一、大二的同学，我建议你们可以去试试这条路，要是能够拿到个金牌、银牌对以后找面试找工作加分也是很大的。

学校这个肯定没法改变，如果觉得自己学校还不太好的话，可以考虑考研提升下学历，不过说心里话，计算机这个行业相对来说没有那么唯学历论，与学历相比，算法、基础、工程实践能力更加重要，每年也是有很多优秀的非985、211同学拿到BAT这些大厂 offer。

既然学历短期无法改变，那我们何不针对当前能够改变的东西，努力一把！

什么能够快速补短板？

肯定是技术呀，首先计网、操作系统等计算机基础知识那都是必备滴，像线程和进程区别，堆和栈的区别这种问题我都听同事问了面试的学生好多次了。

这里要注意回答的时候，除了那些标准答案之外最好加入一些深入的一点的东西，比如具体到在 Linux 中，线程和进程都是用 task_struct 表示的，区别在哪等等。

除此之外最好懂一点常用中间件的原理，还有后台服务架构设计方面的一些知识，如缓存、读写分离、分库分表、分布式、微服务等等。这些当然不是一个校招生的必备知识，但是熟悉的话会比较加分。

## 二、信息搜集
还是那句话，很多同学是等到室友、同班同学拿到腾讯、阿里 offer了，才知道现在就开始校招了，更有甚者，以为找工作是大四毕业做的事......

大家不要以为这个不可能，我以前就有同学完全不知道暑期实习、也不知道秋招这回事，等到九月都快结束了才开始做简历，最后当然也是错过了很多大公司的机会。

所以希望大家准备秋招的时候，也可以把信息分享给身边的室友、同学，大家一起准备更有氛围，帮助别人也是帮助自己。

对于互联网招聘，尤其是技术岗来说，我强推[牛客网！！](https://www.nowcoder.com/link/pc_kol_bianchengzb)

还不知道这个网站的同学，请立马点这个链接去[牛客网](https://www.nowcoder.com/link/pc_kol_bianchengzb)注册下，然后加到收藏下。

找工作这段时间，每天都去逛逛！每天逛够 半 小时以上吧！

（牛客网打钱！！

我之所以如此推荐牛客网，主要有三点原因：

1. 面经发源地，是的，你在网上看到的 80 %以上面经估计都是从牛客网发出来的

2. 内推满天飞，特别是到了春秋招，很多工作后的学长学姐来发内推信息的

3. 各种公司校招时间牛客网上同步很及时

当然了，牛客网上很多都是大公司和一些网红独角兽，小公司比较少。

也可以关注一些官网微信公众号，比如腾讯招聘、美团招聘、字节跳动招聘等。

其次就是你的直系学长学姐了，一般他们所在组也会招人，都会在朋友圈发内推的。

其次就是脉脉、知乎这类软件，平时逛的时候多关注一些意向公司的大佬，一般不少 leader、hr 都会去上面发一些招聘的帖子，这时候是很精准的，一般就是简历直接到组内。

内推真的要自己主动去找，比如我当时就在牛客网找了很多：

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gqrmstlnrrj30d304rwer.jpg)

在[知识星球](https://www.yuque.com/csguide/go)里也会发一些大厂朋友的内推信息，可以关注下。

## 三、简历

简历这个话题有点大，就留在单独一篇文章吧。

在这简单说几点我的看法：

* 好的简历需要反复修改
* 实习项目、竞赛、做的外包、实验室科研项目这些都可以作为项目来源
* 项目一定要提炼出亮点，最好能数字化具象一点，比如性能提升了 50%，并发 xx ，数据量、用户数等等
* 适当包装，但是不作假
* 格式一定使用 PDF，word 这些容易乱码，且浏览器无法打开（HR在线直接打开简历，如果是word，很可能你就失去这次机会了

具体的话看这篇文章[技术岗简历如何写？](/offer/how_to_resume.html)

## 四、校招考察什么？

首先，我们要明白，对于大公司老说，看中校招，就是看中应届生的潜力，毕竟校招生不是招来即用的。

其实说白了，就是要考察学习能力、聪明度，还有就是对基础知识的掌握程度。

对技术岗来说了，核心就是：

### 4.1 算法和数据结构、智力题

数据结构: Vector, List、Stack、Queue、Heap、 BST、AVL、B/B+树、跳表

算法: 排序、二分查找、哈希、贪心、分治、回溯、动态规划、二叉树相关的、字符串相关、kmp、图: 最短路径、最小生成树、拓扑排序、搜索

### 4.2 计算机基础 

* 操作系统（进程线程内存管理同步锁文件系统）

* 计网（TCP、IP、HTTPS）

* 计组（Cache、数的表示等）

### 4.3 语言底层机制和 Runtime:

核心就是要懂你常用语言的底层机制，比如 Java JVM、JDK，C++ 虚机制、memory layout、STL等，JS 事件模型、闭包、原型链等

### 4.4 特定领域方向

比如后台常问存储（Redis、MySQL）、RPC 这些，前端则是浏览器相关、JS

### 4.5 项目

这里建议准备 2-3 个即可，大家最大的问题是缺乏项目，觉得自己的项目太简单了，给大家说吧，大多数校招生的项目其实大同小异，在面试官眼里都挺简单的。

最大的区别在于谁能把一个项目讲清楚、把里面的难点、亮点、解决方案讲透彻。

另外，要学会适度包装、挖掘项目的难点，可以去网上搜下同类项目看看别人都是怎么总结的。

那么每一个方向要做到什么程度，怎么复习呢？

简单花了一个图，这里后面也会单独写出一篇文章的，会把图补充更多的细节：

![秋招](https://cdn.how2cs.cn/gzh/008i3skNgy1gqropy0lw6j30u00waahh.jpg)


总的来说，建议复习的时候每天都去刷几篇面经、刷一两道题，毕竟面经就是等于真题呀，通过面经进一步查漏补缺比自己闷着头看书强得多。

## 如何正确打开面经？

在这里特别想强调一下，虽然时间紧，我也推荐大家看面经，但是一定不要去背。

我推荐的是以面经上的问题作为线索，一次性把相关的问题都搞透彻，而不是记住那短短的几句结论。

针对，面经这个事，我再多说几句，就举个我在牛客上看到的很火的某 Java 7W 字总结来说吧：

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gqrp777qzbj30iy0mrn10.jpg)

看下这些问题和回答，整理得非常有条理且十分简洁，但是如果你不懂这个东西，你看了这几行描述极大概率还是不懂。

就拿引用传递和值传递这个问题来说吧，你至少得像这篇文章[值传递与引用传递，传的到底是什么?](https://mp.weixin.qq.com/s/-PscWmBqTFFAq2jSVPpqNw)

才能说懂了这个东西吧，面试的的时候你才能和面试官侃侃而谈吧，不然光是背几段话，多提两个问题你就暴露了。

用牛客上一个老哥的话来说：

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gqrpbvikr3j30ij03sjry.jpg)

>  只是。。。就是没什么用

这也是我一直没有去弄这些总结的原因，我承认有不少同学是靠主要刷面经拿到 offer的，如果是这样，我真的觉得只是你运气好，没有遇到什么都喜欢深挖的面试官。

但是，我之前不是还推荐大家去每天刷面经吗？

是的，这并不矛盾，**我是让大家把面经上的问题作为索引，去横向查漏补缺，比如你看到阿里某篇面经问到了数据库索引，而你恰好不清楚。**

你要做的是去看[《极客时间MySQL45讲》](http://gk.link/a/10JVv)关于索引的那些篇幅，还有《高性能MySQL》第五章索引，这样你才是以点带动面的复习，而不是面经指哪你去背哪，那个真的没用。

所以这些大佬总结的面经还是有价值的，你需要把它当做一个知识清单，然后自己主动去扩展它，因为一般限于篇幅，面经都不可能非常详细的把一个东西讲透的。

注意我这里推荐尽可能去看权威的资料。

看书的一些方法可以看下这篇文章：[如何高效看技术书？](/roadmap/how_to_read_books.html)

我知道，很多同学会说看书那不会很浪费时间吗？

还真不，一次看一两章，大概五六十页就能把一个主题搞清楚，而且是系统性的，你看的越多，后面看得也就越快，个人觉得反而是节省时间。

-----

这是我之前大三的时候，受辅导员的邀请，还在年级大会上给同级同学讲过春招的一些注意事项，不过这个由于只是一个大概提纲：

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gqroz1jai4j310k0ll0vm.jpg)