---
title: 程序员简历如何写？｜ 附程序员简历模版下载
meta:
  - name: description
    content:  一篇关于如何撰写程序员技术岗位简历的文章，包括Java、C++、算法、后台、前端等岗位。提供简历内容、结构、个人信息、求职意向等方面的建议，并附带真实简历示例。
  - name: keywords
    content: 简历, 技术岗, 程序员求职, 个人信息, 求职意向, 项目经历, 专业技能, 实习经历, 自我评价, 互联网校招
---

# 程序员简历如何写？｜ 附程序员简历模版下载

::: tip 摘要
关于 Java、C++、算法、后台、前端等岗位简历如何写~
:::

简历是面试官对我们的第一印象，往往决定了我们是否有机会收到面试邀请。

所以一定要对简历重视起来，不断的修改、迭代。

缺少简历模板的同学可以点击这个链接下载: [互联网简约简历模板下载](/offer/resume.html)

![互联网简历模板](https://cdn.how2cs.cn/csguide/012500.jpg)

我在公司看了不少同事从简历库中捞取简历，大家都会倾向于捞取那种学历不不错、实习经历也不错的，其次就是捞取技术栈、项目经历匹配的。

说这个的目的就是为了强调下，简历的排版、书写技巧其实只是表层的东西，最核心的还是我们的“经历” 要丰富，这样的你的简历才有东西可写，才能写得好，否则那就是无源之水，简历造假了。

那么这篇文章对两类同学我觉得起的作用是不同的：

* **已经到找工作阶段的同学（大三、研二），那么你们的重点是学到一些简历润色的东西，能更好的表现你们的专业技能和项目经历。**

* **还在学校学习阶段的同学（大一、大二、研一等），你们的重点是知道哪些东西未来写到简历里很加分，从而在平常的学习生活中，”面向简历“去学习，比如可以的丰富自己的竞赛经历、项目经历。**

(PS: 这篇文章主要针对的是**互联网校招技术岗位**，其它岗位仅做参考~

## 一、简历应该包含哪些信息
HR 和 面试官对我们的第一印象都是来自于简历，所以简历的重要性毋庸置疑。

首先是简历上的内容，一般包括以下几部分：

* **个人信息（年龄、学历信息、获奖）**
* **专业技能**
* **实习经历**
* **项目经历**
* **自我评价** 

简历内容基本就这几个，但是顺序和描述篇幅要讲究扬长避短。

拿教育背景来讲，如果你是985、211的硕士、海龟等等，可以提前写，如果是专科或者普通本科则可以靠后一点。

接下来我会放一些真实的简历作为例子给大家做参考：

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gthdotf3anj60u0128q7e02.jpg)

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gthdsdvsejj60li0oy41302.jpg)

这份简历其实写得挺好的，只是有些地方可能表述上可以适当精炼一下。
## 二、个人基本信息

### 2.1 博客链接 & 照片？

这部分主要是姓名、联系方式（手机、邮箱）、年龄等，如果平时有不错的**博客积累、Github 项目积累，也可以直接贴上 CSDN、掘金等博客链接、Github 链接**。

个人照片的话仁者见仁吧，如果对自己颜值比较有信心可以放，但是我倾向于不放，毕竟大部分人都是普通人，程序员也是靠技术吃饭的，不是选秀。

### 2.2 求职岗位要明确

另外就是「**求职意向**」，一定要明确一点，比如 「**Java后台开发**」、「**C++ 后台开发**」、「**NLP/图像算法工程师**」、「**前端开发**」、「**安卓开发**」等。

并且你的【求职意向】最好是针对你所投递公司的 JD（岗位描述）适当调整，比如拼多多当时是招「**服务端研发**」、阿里云数据库是**数据库开发**，腾讯是**后台开发**，那么我就在投递不同公司的时候，在文件命名也是不同的：

![简历命名](https://cdn.how2cs.cn/gzh/008i3skNgy1gthe2zjhuzj613s0joq5202.jpg)

**并且简历内容也会做适当的修改，比如数据库开发，可能会增加一些自己对DB、存储、分布式相关的学习和理解，后台开发可能会有一些实际项目等。**

这样做的好处是，让面试官的第一印象觉得你是匹配这个岗位的~

### 2.3 简历格式和命名

一个比较好的习惯是，简历的文件名以「**姓名-学校-求职意向**」组成，比如『小北-清华大学-数据库开发』。

这样子面试官或者HR直接从你的文件名其实就能读到很多信息了，对你这个人的印象也会觉得细心靠谱，为他人考虑（简历阅读者）。

并且文件格式统一为**PDF**，**千万别上传一个 Word！！！ 一定要记住哟！！！！ **

因为一般面试官都是在浏览器打开你的简历，而很多公司的面试系统，是不支持在线打开的 Word 的，那么如果你传的 Word，面试官还需要下载到本地打开，并且可能存在乱码问题。

你觉得如果你是面试官的话，你会去多一步下载到本地，还是说直接看下一位（简历库里是不缺简历的）？

## 三、教育经历

这部分主要是体现本科、研究生学校等信息，如果绩点排名靠前，也可以写一下，如果过了 6 级也可以写下，分数较高的话甚至可以写下分数。

如果你四级都还没过的话，那么这部分忽略，不要主动提起四六级即可，一般互联网公司也不会限制。

### 3.1  例子
![](https://cdn.how2cs.cn/gzh/008i3skNgy1gthebkeg18j61ka0akgmx02.jpg)

## 四、荣誉奖项

这是一个可选部分，如果有过一些比较大的奖项，比如 ACM、互联网+、挑战杯、国奖、蓝桥杯等都可以写上去，也可以和教育经历合并到一栏。

如果没什么获奖也没关系，可以直接跳过这个环节，问题不大。

如果所获得的奖项和互联网、学习关系不大的话就不要写上去，比如什 动物保护奖、校园歌手之类的，这部分可以考虑放到自我评价里带一嘴。

## 五、专业技能

这部分小北总结起来就是：

### 5.1 语言基础 +  计算机基础 + 领域知识/组件/编程环境

**语言基础**就是挑你的主语言里面重要的语言特性写，一般1-2门，比如C++、Java、Go。

**计算机专业基础课**就是OS、网络、算法、数据结构、数据库这几块，基本上描述语言你都可以照着我这个模板写，稍微根据自己实际掌握情况改改。

**领域知识/组件/编程环境** 就是类似 Linux、Shell、Git、Spring、MQ、Redis、Unity 这种和写代码息息相关的框架、周边等。

下面👇是一个实际例子：

* **操作系统（操作系统基本原理 + Linux）**
* **计算机网络 （TCP流量控制、拥塞控制、UDP、IP、HTTP、HTTPS 、等）**
* **算法与数据结构（list、heap、queue、bst、avl、RBtree、B+树、二分、BFS、DFS、回溯等）**
* **数据库（数据库原理、三大范式、事务、索引、日志系统redo、undo，锁、MVCC等）**
* **编程语言（Java：多线程、JVM、JDK集合，C++: 编译链接、STL源码、虚函数、多态、智能指针、C++11 新特性等）**
* **框架：SpringBoot、MQ、Vue 、Redis 等**

基本上 80 %的同学都是上面这些内容了，如果你对于一些企业里用的比较多的技术，比如 **ES、 Docker、k8s、RPC框架、MQ、DB**等了解比较多的话，也可以写上去。

### 5.2 堆砌技术名词要慎重

对于只是听过一些名字、简单使用过的就不要写上去了，凡是写在简历上的名词，都要保证自己能够把原理说出几条。

**比如 Docker 可能要学习过  Cgroups 、Namespace等**，**MQ 则要对使用场景，消峰、异步、解耦这些了然于胸，甚至 MQ 是怎么保证消息不丢、如何解决消费重复等问题也要有一定了解，甚至还有消息序列化、基于 MQ 做分布式事务这些。**

当然，校招不会对这些有要求，但是一旦你写上去了，可能就会被问，所以建议不是很了解的技术点就不用。

### 5.3 专业技能: 了解、熟悉、精通？

大家常用的几个词：了解/熟练/掌握/熟悉/精通，我们先对齐一下这些词大概含义

- **了解**：就是你知道有这么一个东西，大概能用来干嘛
- **熟悉**：就是你经常在使用，但是未必有很多的了解，也没深入的学习
- **掌握**：就是你能用这个东西来完成一些功能，解决一些问题，但是还不熟练，还需要边查边做
- **熟练**：就是你成为一个熟练工了（大多数人在此水平），能够快速的搞定功能模块，代码需求，完全不用思考。甚至高端点的人，有自己的代码库和工具箱了，那搭建项目，完成功能，就是复制黏贴（自己的代码），飞快的。而且很多地方都自动化完成了。
- **精通**：在某一方面的技术有一定的影响力，对这种技术的优缺点，适用场景有非常深刻的理解。提交过开源代码，回答过别人的问题，一般这方面的问题都难不倒你。

但是面试者的理解可能是
- **了解**：听说过名字
- **熟悉**：会 'Hello World'
- **掌握**：基本上看过文档，知道相关知识
- **熟练**：拿来写过项目
- **精通**：用这个技术写了很久的业务

大多数面试者同学都是按照使用的年限来选择词汇。但是又对技术本身有种敬畏的。

所以就会出现通篇「熟练」。

面试者心态：我要是写精通，会被面试官问死吧~

如何解决这一问题，让专业技能看起来不那么死板且重点突出（扣原则：**突出重点**)
> 这里参考：https://developers.pub/resume

### 5.4 技能的深度和广度

技能的**广度**和**深度**。

好多同学简历中恨不得将自己知道的或者看过的技术都写上。

比如：
- 熟练xxxxx
- 熟悉xxxx
- 熟练xxxxx
- 熟悉xxxx
- 熟练xxxxx
- 熟悉xxxx

**广度**和**深度**在时间成本上是对立的两方面。小公司人不多，可能更多注重广度。大公司大家各司其职，深度更重要。

但是总体上 **深度** > **广度**。所以在简历上的写法要注意。专业技能尽可能的要深入。广度可以放在项目经历中写。

以上两个问题在专业技能板块的解决方式就是：**减少样板词汇+过滤合并技术栈+字体加粗**。

### 5.5 技术栈到底详细写还是简单写

这里如何写这些点，也有一些度的把握，到底是非常详细列出技术点，还是详略的写“熟悉xxx，了解xxx”。

我的建议是简历中的技能部分，**具体一些，不要单纯的写“熟悉数据结构与算法”、“熟悉计算机网络”。。。**

毕竟算法、网络这么多内容，你到底熟悉哪部分呢？

最好自己写清楚，写清楚的一个好处是可以引导面试官问这些。

当然也不是所有的点都要列出来，而是挑出其中的重要部分。

另外，我建议简历上坚决不要出现**精通**，我相信绝大部分同学是没有办法做到精通的，即便你真的觉得你非常非常了解这个东西，那也写**熟悉**足够了。

写精通有可能会被问得很惨，还显得你这个浮夸。

### 5.6 反面例子

* **熟悉计算机网络、TCP、UDP**
* **熟悉操作系统、Linux**

### 5.7 正面例子

* **熟悉TCP/IP五层模型，熟悉常见网络协议原理，如 TCP拥塞控制、流量控制、UDP、IP、ICMP 等**
* **熟悉 HTTPS，了解对称加密、非对称加密、数字签名、数字证书等，了解 HTTPS 链接交互等过程**
* **熟悉常见数据结构与算法，如栈、队列、堆、二叉树、BST、AVL、二分查找、八大排序算法、BFS、DFS等**
* ....

### 5.8 实际案例

这里贴几个例子，第一个是特别详细的：

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gthf2z7rqhj60xy0u0gr202.jpg)

这两个就比较详略得当了，既能引导面试官提问，又不至于过于详细，大家可以参考下：

![一位球友](https://cdn.how2cs.cn/gzh/008i3skNgy1gthekaayt7j61lw0fwaew02.jpg)

![小神仙](https://cdn.how2cs.cn/gzh/008i3skNgy1gthejvvjagj61a00m6tce02.jpg)

### 5.9 专业名词 & 排版

写这些名词的时候，注意排版和专有名词大小写。

比如 MySQL 而不是 Mysql，Java 而不是 java，iOS 而不是 ios，TCP 而不是 Tcp 等等。

关于中文排版，请参考「**中文文案排版指北**」:

[https://github.com/sparanoid/chinese-copywriting-guidelines](https://github.com/sparanoid/chinese-copywriting-guidelines)

**这些都是细节，但是细节体现了一个人的专业度，也会让面试官和 HR 看起来更加的舒服。**

## 六、实习经历 & 项目经历

### 6.1 项目经历怎么写？

**这部分写 1-3 个就差不多了，2 个最好。**

如果你是第一次找实习/找工作，那么直接写你做的项目即可，不要觉得自己的项目 Low，在校学生的大部分项目其实在面试官眼里都是 Demo 级别，关键在于你是否通过这个项目能体现一些你的专业度。

**如果你的实习经历比较多，那么可以适当挑其中和求职岗位比较符合的经历，且你做的东西觉得比较有意思，能吸引到面试官的写上去。**

主要是写**项目背景、自己负责的模块、使用到的技术、解决的问题（难题、重点）、效果如何、以及项目的效果、自己学到的东西等**

### 6.2 实际案例

也举两个例子：

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gthfonel0yj60zi0l4mzu02.jpg)

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gthfqw6yw9j61lm0mm7bv02.jpg)

这两个都觉得写得挺好的，但还是存在专业名字大小写、中英文之间空格等排版问题，还有语言还可以适当优化下。
比如第二个说：

* **减少了内存占用、提高了系统吞吐率**

最好是有具体的内存占用降低比例，系统吞吐率提升比例等，这块面试的时候也是很有可能被问到的，也就是表现咱们系统性能、负载这方面就拿一些数据出来，这样更有说服力。

同样的：

* **数据由 MySQL 迁移至 HBase，提高的了写入性能**

那么这里最好能把提高的写入性能量化。

面试官一般也非常关注这些点。

### 6.3 STAR 原则

写项目这里可以采用 STAR 原则，关于STAR原则，百科上给出的定义是：

- **S——Situation 事情是在什么情况下发生**
- **T——Task 你是如何明确你的任务的**
- **A——Action 针对这样的情况分析，你采用了什么行动方式**
- **R——Result 结果怎样，在这样的情况下你学习到了什么**

### 6.4 如何挖掘项目？

#### 觉得项目太Low怎么办？

另外一个点就是，大家可能觉得好像没什么项目可以写在简历上，自己的项目太 low 了！

对于没有实习经历的同学，可以自己去网上找一些项目，参考着做，甚至就算把别人代码看完，自己再写一遍也是可以的，关键是其中的技术自己都掌握了。

甚至是学校的大作业、做过的 Lab 包装一下也是可以的。

比如我就见过不少同学写**文件加解密、JSON 库、网络库、WebServer、mini os、mini stl 的**。

这里面看着是简单，实际上如果你要做一个商业的文件压缩、加解密软件那可不简单，所以说项目到底简单还是复杂取决于你实现的深度。

还有就是自己确确实实写过，不要伪造，自己有学到东西，我觉得就可以包装一下写上去。

比如文件加解密，可以写用到的算法，自己是如何去优化文件读取、写入速度的，这块肯定要涉及操作系统IO的，以及自己如何做的性能测试的。

####  实习都在打杂怎么办？

对于有实习经历的同学，可能也有担忧，觉得实习期间都是打杂，没有参与什么核心模块，都是做一些边角工作。

这很正常的，别说实习同学了，可能刚入职半年一年的同学，甚至工作几年的员工，让他们去答辩，可能都会觉得自己做的东西没什么含金量，都是业务代码。

这就需要适当包装了，比如你把你做的一个小模块放在一个稍大的背景上去，可能效果就不太一样了，同时你完全可以在实习期间，了解一下参与项目的核心模块逻辑，看下相关的设计、文档、代码等，只要能理解透，就可以适当写在简历上。

当然了，这里不是让大家去杜撰哈，包装是建立在有真实内容、产出的基础上，将自己的工作放在一个更大的背景下或者将自己的工作内容适当扩大一些。

## 七、自我评价
这部分就不说了，都是九年义务教育过来的，大家写这些话肯定比我厉害，原则就是务实一点，别假大空哈哈哈。

不要忘了我们的写简历的原则 「突出重点」 。

例：
* 3年ToB类产品开发经验，经常跨部门沟通，能够站在产品角度考虑问题。
* 较强的执行力，能推动和协同其他人实现需求落地，并取得预期效果
* 善于学习总结 （这里可以再次附上自己的博客地址）
* 经常复盘项目和技术方案，反思自己，进一步提升自己的业务和技术水平。
* 较强的产品思维，多次协助 PM 打造出优秀的项目

类似这种就可以啦：
![](https://cdn.how2cs.cn/csguide/153704.png)

## 八、简历模板

在这给大家准备了一些**清晰、高效、突出重点**的简历模板，可以点击这个链接下载: [互联网简约简历模板下载](/offer/resume.html)

![互联网简历模板](https://cdn.how2cs.cn/csguide/012500.jpg)
