---
title: 互联网校招流程指南
meta:
  - name: description
    content:  介绍互联网技术岗校招流程，包括春招和秋招的准备阶段和注意事项，帮助计算机专业学生更好地应对互联网校招。
  - name: keywords
    content: 计算机专业, 互联网校招, 春招, 秋招, 流程指南
---

# 互联网校招流程指南

::: tip 摘要
计算机专业、互联网校招、春招、秋招流程指南
:::

互联网上经常说一个词“内卷”，程序员之间也相互调侃越来越卷了，但是的确是这样的，大家都知道的嘛，互联网行业薪资比大多数行业都会高一点。

各路大佬总结的各类牛逼的技术文、学习路线会让后来者少走很多弯路。

俗话说 “站在巨人的肩膀上我们才能看得更高”，虽然算不上巨人，但是总能算走在前面的。

我是20年毕业的，当时正是互联网寒冬的前夜，但是竞争也已非常激烈。

在当年校招面试中，我几乎通过了所有技术岗面试，有字节、网易、阿里、腾讯，当然也有没被捞的，比如快手，可能是我不够老铁哈哈。

现在已经工作两三年了，给不少同学做过模拟面试，也在公司做过初面面试官。

对于**互联网技术岗校招**还算积累了一些经验，分享给大家，仅供参考~

## 一、校招流程

据我所知，不少同学对于校招没什么了解。

甚至不少同学还以为找工作是大四毕业那个学期的事！！！

所以这里先梳理一下**互联网比较典型的校招流程，**  让大家知道什么时间段该做什么准备。

### 1.1 两个集中招聘点

春招 && 秋招，关于这两个时间点，我画了一张图:

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gqrfsyk51dj30o40a2gmx.jpg)

下面👇具体聊一下各个阶段：

### 1.2 春招

春招就是春季招聘的意思，一般集中在 1 月至 5 月，分为 3 个阶段：

#### 提前批（12 月 - 1 月）

是的，春招有少数的企业可能在昨年的 12 月就提前开始了，但是大部分来说还是 2月-3月之后开始。

一般来说每年过完年后2周左右，很多大公司就会放出职位开始招聘了。

与正式批相比，提前批的招聘周期更短，招聘流程更快，一般只有**网申/内推→面试**两个阶段。

划重点！！！：**提前批一般没有笔试，会大大提高通过率，所以早就是优势！！**

#### 正式批（2 月 - 4 月）

3 月为春招的集中释放期，有个词叫**金三银四**，说的就是每年 3 月份是春招的黄金时间段。

基本上，参加春招中有实力的企业都会在这个时间段启动简历投递，这是第一波机会；	

正式批主要有 4 大流程：**网申/内推→笔试→群面（针对非技术岗现场面试）→单面**。

#### 补录批（5 月）

5月后，尽管还是会有一些企业招聘，但数量零星及质量都不高，基本上大公司好的坑位，提前批就招得差不多了，再次强调**早就是优势！**

### 1.3 秋招

秋招就是秋季招聘，一般集中在 8-10月，同样也分为三个阶段：

#### 提前批（6-8月）

少数公司，不过现在都开始的很早，有些公司六七月就陆续开启了。
招聘流程和春招类似，基本上只有 内推/网申-> 面试。

#### 正式批（8-10月）

9 月为秋招的高峰期，**金九银十**就是形容这段时间的，大家一定要在这之前就把简历准备好。

正式批面试流程：
**网申/内推->笔试->面试**

#### 补录（11-12月）

一般是正式批没有招够人，会零星的继续招聘。

## 二、春招和秋招的差别
主要以下两个差别：

### 2.1 春招面向的是两类人群：

* 大三、研二，也就是第二年暑期将要毕业的同学，那么在大三、研二下学期开学就会迎来**春季暑期实习生招聘**
* 大四、研三，也就是暑期马上要毕业的同学，这是招聘的**正式员工**，大四的同学可能是在去年的秋招中没找到合适的工作，或者是去年考研失利了，那么要利用好春招的机会。

### 2.2 秋招
秋招一般仅仅是面向第二年暑期就毕业的同学，招聘的是**正式员工**，秋招失利还有第二年的春招可以冲一波。

所以对于互联网、计算机专业的同学来说我强烈建议你这样备战工作：

1. **大三下学期开学就参与春招，找份实习工作**
2. **5月-9月，实习2-3个月，实习中途也要坚持刷题，准备秋招**
3. **8-9月开始投秋招提前批面试，同时可能也要准备实习转正答辩之类的**
4. **如果秋招中的Offer不理想，那么继续不松懈，备战第二年的春招。**

研究生同学也是类似的阶段。

**总之能实习一定要去实习，不能实习也不慌，好好利用好时间将计算机基础 + 算法 + 项目经历这几块强化一下，秋招收割 Offer。**

这段时间一定会很累，但请一定要坚持，等你拿到满意的 Offer 后，回想起来，这一切都很值~

## 三、面试流程
上面👆说的是整体的春招、秋招流程，那么具体到每一次面试机会都是怎么样的呢？

对于我们每个人来说大概有以下流程：

- **准备简历**
- **网申 / 内推**
- **面试官/HR 进行简历筛选**
- **笔试 （提前批一般没有）**
- **技术面试：初筛、组长面、总监面、跨部门面等等**
- **HR 面试**
- **发放 offer**
- **谈薪、签订三方**

### 3.1 准备简历

对于还不知道怎么写简历的同学直接看这篇文章：

[技术岗简历怎么写？](/offer/how_to_resume.html)

缺少简历模板的同学看这里: [互联网简约简历模板下载](/offer/resume.html)

里面附带了简历模板和实际案例分析，相信看完之后，你一定可以写一份不错的简历！

除了**怎么写**简历以外，我更想强调大家一定要**尽早写**。

我知道很多同学的想法：再复习复习、再完善一下项目，现在简历还没什么可写的。

是的我就是这样过来的，但是你会发现永远没有准备好的时候，最好的方式是先写简历，甚至可以写一些你觉得重要但是你还没有掌握的知识，那么简历就成了倒逼你去快速学习的一种形式。

现在当你看到这篇文章的时候就去开始写简历吧！

简历写完后，可以直接发到[知识星球](https://www.yuque.com/csguide/go)（关键隐私信息可以打码）让大家一起看下有什么优化的点，我也会提出修改的建议~

提前批往往没有笔试，收到面试的机会会大很多，你简历准备得越早，机会也就越多！

### 3.2 网申/内推
无论网申还是内推，其实都是让你的简历进入公司的候选库，这样面试官或者 HR 才能刷到你的简历。

内推其实分两种：

* 一种就是大家常常见到的各种带有二维码，直接扫码投递的，这种可能和你自己投递差别不大，唯一多了一个**内部员工推荐**的标签之类
* 第二种就是组内/部门内部直接招人，你的简历是直接被送到了面试官手上，这种就有极大的优势，免去了简历筛选这一步。

无论如何大家有内推的情况下，还是优先通过内推投递吧，实在找不到也可以直接网申。

内推渠道也是非常好找的，比如牛客网、脉脉、知乎等，有很多大厂员工发一些内推信息，大家平时对这种信息保持一定的关注度。

在[知识星球](https://www.yuque.com/csguide/go)里也会发一些大厂朋友的内推信息，可以关注下。

### 3.3 简历筛选

目前就校招来说，简历筛选这块大多还是由一线面试官完成的，HR 筛选的比较少（至少鹅厂是这样的）

因为 HR 不一定是计算机这个专业的，很多专业名词和项目啥的不一定能搞得比较清楚。

这块其实我们能做的不多，唯一能做的就是好好写简历。

我看过同事从简历库（一列列全是简历）里筛简历:
大概一眼看上去能看到的核心信息是学校、学历、年龄、专业这块，具体简历需要点开。

点开之后比较关注的是**实习经历、竞赛经历、项目经历、专业技能**

一般会挑选那种 **专业技能看起来就和岗位匹配度高的，以及项目/实习经历丰富的**。

所以又回到简历书写上来了，大家还是仔细去看下这篇文章：[技术岗简历怎么写？](/offer/how_to_resume.html)

简历写完后，可以直接发到[知识星球](https://wx.zsxq.com/dweb2/index/group/28511155228881)（关键隐私信息可以打码）让大家一起看下有什么优化的点，我也会提出修改的建议~

### 3.4  笔试
正如前文所说，提前批一般是没有公司统一组织的笔试的（针对大公司）

笔试一般是 3-6 道左右算法题，一般是简单、中等难度的题，偶尔会有一道 Hard 的题。

如果你提前刷过 100 -200 道以上的算法题（分类刷过），那么笔试不是很大的问题。

还有些公司的笔试题中会加入类似 408 的考题，涉及计算机网络、操作系统、数据库、组成原理等课程。

笔试只要能过就行，成绩多少不重要，后面的面试才是关键环节。

### 3.5  技术面试
技术面试是整个校招中最重要的环节，决定了你是否能拿到 Offer，而面试评级也决定了你拿到 Offer 的级别是白菜、SP 还是 SSP。

对于多数公司，技术面试会有很多轮，且面试官的级别会逐渐提升：

一般来说是这样：
* **工作 2 年以上的一线员工初面，初面主要是问一些八股文、以及做 2-3 道，如果答得不错那么有机会进入到下一个环节。**
* **二面一般是资深员工/高级工程师等Title 亦或是团队 Leader（可理解为组长），二面还是会问一些八股文，但是会深挖一些，还会涉及到系统设计方面的问题，可能是围绕你做的项目进行发散。**
* **三面一般是总监级别的面试，不怎么会问八股文了，可能是开放性问题居多，或者还会继续做题**
* **再往后可能是部门交叉面（不是很清楚交叉的目的，可能是防止用人部门作弊吧emm）**

总之大多数公司来说，技术面试一般就是 2 - 5 轮，大多是 3 轮居多。

### 3.6 HR 面试
在通过了所有的技术面试之后，除了少数没有 HR 面试的公司，对于多数公司，最后一轮面试即是 HR 面试。

不同公司的 HR 面试差别较大。

许多公司的 HR 面试仅仅用于和候选人沟通一些技术之外的事项，比如对工作地点、薪资的期望，只要不表现得过于出格，这一轮面试不过是走个过场，双方互相沟通，以便发放 offer。因此，这些公司的 HR 面试往往很简截，不会超过半小时，甚至不到十分钟。

（典型的如鹅厂HR，都比较轻松

不过，一些公司的 HR 面试比较严肃，不少人折戟于此。在这些公司的 HR 面试中，HR 会从许多角度探查候选人，比如性格习惯、对公司文化价值观的看法等，甚至有些 HR 会显得有些「咄咄逼人」。

不过，也不必过于悲观，如果在此面试失败，便说明这家公司确实与你不合，即便顺利通过面试而入职，也大概率是踏入了坑中，日后并不会开心。早点终结对彼此都好。

（阿里HR就比较咄咄逼人，我记得我当时春招，阿里的技术面了三四轮过了，然后清明节回家的时候 HR 打电话来面试，居然足足问了我四十分钟，最后我挂了。。。。也不知道是不是阿里味不够。

## 四、常见互联网校招术语
找工作期间，你一定会见到各种术语/英文简写，如果不特意了解下，可能会看得一脸懵逼，就像我当时知道 YYDS 居然是永远滴神。。。。

### 4.1 岗位相关术语
* HR：Human Resource，即人力资源，全称人力资源管理，又称人事。人事管理是为实现一定的目标，对所属工作人员进行选拔、使用、培养、考核、奖惩等一系列的管理活动。说人话就是招人的，招打工人的（PS: 裁人也是他们
* HC:  Head Count，说人话就是招多少人
* BG：Business Group，指的就是事业群，比如腾讯的微信事业群（WeiXin Group，简称 WXG）和互动娱乐事业群（Interactive Entertainment Group，简称 IEG），可以理解为一个上千人的大部门~
* BU：Business Unit，通常指挂靠在 BG 下细分的业务单元，通常指业务线或者产品线。
* OD：Outsourcing Dispacth（直译为“外包派遣”）的简称，只有研发类岗位，比如华为 OD。
* OT：overtime，指加班。
* base：两个意思：
	* 一个是薪水，举个例子，15k * 16 base 代表一个月基本工资 15k；
	* 一个是地点，比如这个 base 是在北京还是在上海，就是指的具体的工作地点。
* JD：job description，就是职位的描述，岗位职责和要求。例如招聘后端研发，一般会要求你熟悉 Java/C++/Golang 等主流语言；熟悉常见的数据结构与算法等等。
* RD：Research and Development engineer，研发工程师，一般分为前端开发工程师或者后端开发工程师，比如 C++ 后端开发工程师、Java 后端开发工程师、Golang 后端开发工程师等都属于 RD。
QA：Qualtiy Assurance，品质保证，QA 的主要职责就是质量保证工作，也就是很多人口中俗称的测试。
* PM：Product Manager/Project Manager，产品经理或项目经理。在产品的研发过程中，PM 会负责调查并根据用户的需求，确定开发何种产品，选择何种技术、商业模式等。
* PR：Public Relationship，公共关系，即平时说的公关，一般在传媒、互联网、品牌营销各种行业会出现。主要的工作范围就是舆情监测、客户管理、媒体关系、文案输出、活动策划等等。
* PD：Product Designer，产品设计或产品负责人。程序员经常需要和 PD 和 PM 打交道，他们需要程序员去实现 XXX 的功能，然后程序员去编码实现，在此过程中也会出现一些撕逼，这就是产品和研发之间的爱恨情仇了。
### 4.2 面试相关术语
* **八股文**
八股文一般指的是概念性题目，比如：操作系统中进程和线程的区别是什么？数据结构与算法中的栈和队列的区别是什么？又或者是计算机网络中的三次握手四次挥手过程这类问题与回答。
因为这些问题与回答往往问法固定，标准回答也固定，类似于我国明清科举制度规定的八股文。
特别指技术的同学，就是面试喜欢考的一些理论知识，这些偏向于比较严格的答案，一般同学都会直接背。
* **OC/意向书**
意向书的意思是指，在秋招中顺利通过面试获得口头 offer 的一种录用意向，没有具体的薪资待遇说明，换句话说就是：你很不错，我们打算要你了。意向书一般在每年的 7-10 月份会逐渐发放，而带有薪资待遇的详细 offer 一般是 10 月中下旬开始陆续发放。
* **开奖**
互联工作基本上是先有意向，之后打电话的形式，或者直接发邮件给你，这个时候你的薪水，互联网人称之为开奖。
* **Argue**
开出来的薪资不满意，想要跟 HR A 一下薪资，建议是有更高 offer 的情况下再去 A，要不然很难成功。
* **总包**
指总收入，年薪，包括基础工资+绩效+年终奖+补贴+各类奖金+岗位福利。
这个时候同学们一定要注意 base（基础薪资）到底是多少，然后其他项的薪资情况是多少，很多同学是会在这里栽跟头了。
* **白菜**
指校招生中占据 60%-70% 的人拿到的 offer 薪资待遇，毕竟大佬还是比较少的，大部分人的 offer 都是白菜价格。
* **SP**
一般面试表现不错的同学可以拿到这一等级的 Offer，薪资普遍会比白菜高出 20% 左右。
* **SSP**
真大佬才能拿到的，能够拿到 SSP 的同学基本都是校招生中的极少数

完整版可以参考公众号这篇文章[**互联网黑话**](https://mp.weixin.qq.com/s/OP4Awn7wSOwi3iWOtb0j1g)


