# 为什么 C++ 构造函数不能是虚函数？

**面试高频指数：★★★☆☆**

这个题经常会在C++面试中遇到，背后的原理会涉及到 C++ 的虚函数机制实现。

简单回答下：

### 1.  从语法层面来说

虚函数的主要目的是实现多态，即允许在派生类中覆盖基类的成员函数。

但是，构造函数负责初始化类的对象，每个类都应该有自己的构造函数。

在派生类中，基类的构造函数会被自动调用，用于初始化基类的成员。因此，构造函数没有被覆盖的必要，不需要使用虚函数来实现多态。

### 2. 从虚函数表机制回答

虚函数使用了一种称为虚函数表（vtable）的机制。然而，在调用构造函数时，对象还没有完全创建和初始化，所以虚函数表可能尚未设置。

这意味着在构造函数中使用虚函数表会导致未定义的行为。

只有执行完了对象的构造，虚函数表才会被正确的初始化。