# 面向对象三大特性

**面试高频指数：★★★★☆**

C++ 面向对象编程 (OOP) 的三大特性包括：封装、继承和多态。

## 封装（Encapsulation）

封装是将数据（属性）和操作这些数据的函数（方法）组合在一个类（Class）中的过程。

封装的主要目的是隐藏类的内部实现细节，仅暴露必要的接口给外部。

通过封装，我们可以控制类成员的访问级别（例如：public、protected 和 private），限制对类内部数据的直接访问，确保数据的完整性和安全性。

## 继承（Inheritance）

继承是一个类（派生类，Derived Class）从另一个类（基类，Base Class）那里获得其属性和方法的过程。

继承允许我们创建具有共享代码的类层次结构，减少重复代码，提高代码复用性和可维护性。

在 C++ 中，访问修饰符（如 public、protected、private）控制了派生类对基类成员的访问权限。

## 多态（Polymorphism）

多态是允许不同类的对象使用相同的接口名字，但具有不同实现的特性。

在 C++ 中，多态主要通过虚函数（Virtual Function）和抽象基类（Abstract Base Class）来实现。

虚函数允许在派生类中重写基类的方法，而抽象基类包含至少一个纯虚函数（Pure Virtual Function），不能被实例化，只能作为其他派生类的基类。

通过多态，我们可以编写更加通用、可扩展的代码，提高代码的灵活性。

**总结：封装、继承和多态是面向对象编程的三大核心特性，能够帮助我们编写更加模块化、可重用和可维护的代码。**




