---
title: C++ 面试指北介绍：C/C++ 面试题
description: 本文详细介绍了C++面试的重点知识和学习资源，包括内存管理、面向对象编程、基础语言特性、C++11等，涵盖了从基础到高级的所有主题。
meta:
  - name: description
    content: 本文详细介绍了C++面试的重点知识和学习资源，包括内存管理、面向对象编程、基础语言特性、C++11等，涵盖了从基础到高级的所有主题。
  - name: keywords
    content: C++, 面试, 内存管理, 指针, 智能指针, 虚函数, C++11, 面向对象编程, 类和对象, RAII, 多态, 内存分区, 基础语言特性
---

# C++ 面试指北介绍：C/C++ 面试题

对于 C++ 语法重点内容进行讲解，包括内存、指针、智能指针、虚函数、C++11、面向对象等等，共计 10w+ 字。

面试重点及复习指南看这里: [C/C++后台开发面试重点知识](/cpp/)

- **C++ 基础篇** 👇
::: details 点击展开
  - [sizeof 关键字](/cpp/basics/sizeof.html)
  - [sizeof 和 strlen](/cpp/basics/sizeof_and_strlen.html)
  - [数组做参数退化为指针](/cpp/basics/array_and_pointer.html)
  - [const 关键字](/cpp/basics/const.html)
  - [static 关键字](/cpp/basics/static.html)
  - [volatile 的作用](/cpp/basics/volatile.html)
  - [C/C++ 字节对齐](/cpp/basics/byte_alignment.html)
  - [C/C++ 字节序](/cpp/basics/byte_order.html)
  - [C++ 中 class 和 struct 区别](/cpp/basics/class_and_struct.html)
  - [宏定义（define）和内联函数（inline）的区别](/cpp/basics/define_and_inline.html)
  - [宏定义 (define) 和 typedef 的区别](/cpp/basics/define_and_typedef.html)
  - [explicit 关键字](/cpp/basics/explicit.html)
  - [C/C++ 中 extern 作用](/cpp/basics/extern.html)
  - [extern C 的作用](/cpp/basics/extern_c.html)
  - [mutable 的作用](/cpp/basics/mutable.html)
  - [C++ 几种类型转换](/cpp/basics/type_conversions.html)
:::


- **C++面向对象篇** 👇
::: details 点击展开
  - [面向对象三大特性](/cpp/object_oriented/features_object-oriented.html)
  - [C++ 类成员访问权限](/cpp/object_oriented/member_accessibility.html)
  - [重载、重写、隐藏的区别](/cpp/object_oriented/overloading_overriding_and_hiding.html)
  - [C++ 类对象的初始化和析构顺序](/cpp/object_oriented/initialization_and_destruction_order.html)
  - [C++ 析构函数可以抛出异常吗？](/cpp/object_oriented/can_destructors_throw_exceptions.html)
  - [C++ 中对象深拷贝和浅拷贝](/cpp/object_oriented/deep_copy_and_shallow_copy.html)
  - [C++多态的实现方式](/cpp/object_oriented/polymorphism_in_cplusplus.html)
  - [C++ this 指针](/cpp/object_oriented/this.html)
  - [C++ 虚函数表](/cpp/object_oriented/virtual_function.html)
  - [C++ 纯虚函数是什么？](/cpp/object_oriented/pure_virtual_function.html)
  - [为什么 C++ 构造函数不能是虚函数？](/cpp/object_oriented/why_constructor_cannot_be_virtual.html)
  - [为什么 C++ 基类析构函数需要是虚函数？](/cpp/object_oriented/why_destructor_be_virtual.html)
  - [为什么C++的成员模板函数不能是 virtual](/cpp/object_oriented/why_template_cannot_be_virtual.html)
  - [sizeof 一个空类大小是多大](/cpp/object_oriented/size_of_an_empty_class.html)
:::

- **C++内存管理篇** 👇
::: details 点击展开
  - [C/C++ 内存是什么？](/cpp/memory/what_is_memory.html)
  - [深入理解 C/C++ 指针](/cpp/memory/understanding_of_pointers.html)
  - [快速搞懂 C/C++ 指针声明](/cpp/memory/pointer_declaration.html)
  - [C/C++内存分区](/cpp/memory/cpp_memory_partition.html)
  - [C++指针和引用的区别](/cpp/memory/difference_of_pointers_and_ref.html)
  - [指针传递、值传递、引用传递](/cpp/memory/function_argument_passing.html)
  - [C++ RAII 思想](/cpp/memory/raii_in_cpp.html)
  - [C++ 智能指针解析](/cpp/memory/smart_pointers.html)
  - [深入理解 C++ shared_ptr](/cpp/memory/shared_ptr.html)
  - [深入理解 C++ weak_ptr](/cpp/memory/how_to_understand_weak_ptr.html)
  - [C/C++ malloc-free底层原理](/cpp/memory/malloc_free.html)
  - [C++ malloc、new，free、delete 区别](/cpp/memory/malloc_and_new.html)
  - [C/C++ 内存泄露如何检测和避免](/cpp/memory/memory_leak.html)
  - [C/C++ 野指针和空悬指针](/cpp/memory/dangling_pointers.html)
  - [常见的 C/C++ 内存错误](/cpp/memory/memory_errors.html)
:::

- **C++11** 👇
::: details 点击展开
  - [nullptr 和 NULL的区别](/cpp/modern_cpp/nullptr.html)
  - [C++ 类型萃取](/cpp/modern_cpp/type_traits.html)
:::

持续更新中...
