---
title: C/C++后台开发面试重点知识
description: 本文详细介绍了C/C++后台开发面试的重点知识和学习资源，包括基础和进阶语言特性、重要书籍和视频课程等，还提供了有效的学习和准备方法。
meta:
  - name: description
    content:  本文详细介绍了C/C++后台开发面试的重点知识和学习资源，包括基础和进阶语言特性、重要书籍和视频课程等，还提供了有效的学习和准备方法。
  - name: keywords
    content:  C/C++, 后台开发, 面试知识点, 学习资源, C++11, STL, 指针, 内存, Runtime, 虚函数, 多态, 智能指针, C++底层实现
---

# C/C++后台开发面试重点知识

## 一、目录
本专栏目录如下:

![](https://cdn.how2cs.cn/csguide/041351.png)

[！！！！点击这里查看目录](/cpp/intro.html)

## 一、C++ 面试重点

本篇主要是关于 C++ 语言本身，如果是整个后台技术栈的学习路线，可以看这篇文章: [Linux C++ 后台开发学习路线](/roadmap/cpp/linux_cpp.html)

对于 C++ 后台开发面试来说，基本上语言层面考察候选人以下几个方面(其它算法、计算机基础暂时不在这里列出来)：

* **对于指针、内存的理解**

* **对于运行时 Runtime 的理解**

* **一些语法特性和关键字的掌握**

* **C++11 及现代 C++ 的一些特性，比如智能指针**

* **STL 部分容器的算法和内存分配原理**

下面👇细化一下这些具体的知识：

## 三、基础语言特性(必备)
首先是语言的基础知识，一些关键字和实现原理等：
- **指针、引用、数组、内存**
- **引用与指针区别**
- **C 和 C++ 的一些区别，比如 new、delete 和 malloc、free 的区别**
- **虚机制：虚函数、虚函数表、纯虚函数**
- **继承、虚继承、菱形继承等**
- **多态： 动态绑定，静态多态**
- **重写、重载**
- **智能指针原理：引用计数、RAII（资源获取即初始化）思想**
- **智能指针使用：shared_ptr、weak_ptr、unique_ptr等**
- **一些关键字的作用：static、const、volatile、extern**
- **四种类型转换：static_cast, dynamic_cast, const_cast, reinterpret_cast**
- **STL 部分容器的实现原理，如 vector、deque、map、hashmap**

## 四、进阶语言特性(推荐)
- **模板特化、偏特化，萃取 traits 技巧**
- **编译链接机制、内存布局（memory layout）、对象模型**
- **C++11 部分新特性，比如右值引用、完美转发等**

这里列出来的只是一些比较重要的部分，实际上可能只算 C++ 的冰山一角， 大家且学且珍惜吧，这不 C11 还没整透彻，C 20 又出来了，生命不息，学习不止。

## 五、怎么准备？

### 5.1 《C++ Primer》

这本书基本包括了 C++ 11 的全部特性，最好把前面三部分：C++基础、C++标准库、类设计者的工具都看一遍。

我当时花了一个多月断断续续看到了第16章模板那里。

**如果时间不够的情况下，不建议挨着挨着看了，一定要翻目录，挑重点的看。**

### 5.2 Effective 系列

包含以下几本书:
* **《Effective C++》**
* **《More Effective C++》**
* **《Effective STL》**

第一本是重点，光看《C++ Primer》缺少实践的话，大概率还写不出合格的 C++ 代码，而《Effective C++》就是通过 55 条非常具体的做法告诉你什么样才是符合 C++ 编码规范的，可以缩短你写出合格 C++ 代码的时间，减少踩坑，强烈推荐必读。

后面两本优先级稍低，可以有时间再读，或者挑选自己薄弱的章节看。

### 5.3 《STL 源码剖析》和《深度探索 C++ 对象模型》

看完 Primer 和 Effective，你应该已经能够比较熟练的使用 C++ 了，但是还缺少对 C++ 底层实现机制的认识。

比如虚函数表、成员变量布局等，同时对于 STL 库可能也仅仅停留在使用上。

推荐的这两本可以分别完善你在 C++ 底层实现和 STL 源码、原理上的认识。

而面试如果问 C++ 的比较深入的话，就会涉及 STL 源码和 C++ 一些底层机制。

### 5.4 侯捷老师视频

以上书籍同时建议和侯捷老师的视频配合服用，效果更佳。

直接在 B 站搜索「候捷 C++」即可，主要有以下几个系列（最新消息：目前公开视频网站平台几乎都已经下架了）：

- **《C++内存管理》**
- **《STL源码分析》**
- **《C++ STL与泛型编程高级》**
- **《C++11 新特性》**

我基本都看了，收获挺大的，建议看下，可以开倍速。

侯捷老师的视频课程可以在这获取学习: [侯捷C++视频全系列，包括C++面向对象开发、STL标准库与泛型编程、C++11、C++14、内存管理、C++程序生前死后](/resource/houjie.html)

## 六、快速突击版

**看完以上资料，算是 C++ 入门了，应付面试也是足够的，基本到达了正确高效地使用 C++ 这一层面。**

但是我预估，完整的将上述资料仔细的看完，至少需要给自己预留 3-6 个月年以上的时间，时间如果不够半年，那么只能挑重点，我认为的重点：

* **《C++ Primer》 按照目录索引看你欠缺的部分**
* **《Effective C++》这本书建议看完，估计2周能看完**
*  **《深度探索 C++ 对象模型》这本书将前面3章左右看完，建立起对于内存模型的整体概念，大概1-2周**
*  **《STL源码剖析》，重点看下 map、vector、queue 这几个，其它的选看**

最后再记得把这个专栏里的内容都看一下，这都是 C++ 面试核心考点。







