---
title: 如何阅读《深入理解计算机系统》
description:  如何阅读深入理解计算机系统（CSAPP），为什么要读CSAPP，CSAPP的看书方法，深入理解计算机系统相关资源推荐
meta:
  - name: description
    content:  如何阅读深入理解计算机系统（CSAPP），为什么要读CSAPP，CSAPP的看书方法，深入理解计算机系统相关资源推荐
  - name: keywords
    content: 深入理解计算机系统, 下载, 阅读方法, CSAPP
---

# 如何阅读《深入理解计算机系统》

**《深入理解计算机系统》这本书被誉为计算机届的神书，豆瓣评分也是接近10分，个人感觉不至于神书，但是确实是一本适合程序员初步了解 System 知识的好书。**

主要讲解了计算机系统的各个方面，涵盖了底层的硬件组成、高层的应用与工具，以及操作系统、C与汇编、缓存、内存、网络协议等

上大学时，也完整的看过一遍，部分章节看过两三遍，有些是校招准备面试的时候看看，真的挺合适的。

现在基本搬家都带着：

![](https://cdn.how2cs.cn/gzh/e6c9d24egy1gojj8mx8s5j21400u0e8c.jpg)

CSAPP 全称 Computer Systems A Programmer's perspective，出版社翻译的中文书名是《深入理解计算机系统》，感觉中英文完全不搭边。

这本书可能叫做“程序员需要了解的计算机知识”更为恰当一点。

需要看书的同学可以看下这个：[深入理解计算机系统高清版PDF](https://csguide.cn/resource/csapp.html)

先看下这本书我们能学到啥？

然后聊聊我看这本书的历程

最后说说我推荐的阅读方式~


## 首先是关于这本书

在第一章《计算机系统漫游》里已经总结了：

从一个简单的hello world程序在计算机上的执行过程：

预处理->编译->汇编->链接->可执行文件->装载->数据流->屏幕输出显示

汇总成一句：**信息 = 位+上下文。**

![](https://cdn.how2cs.cn/csguide/135106.png)


- 第1章是计算机系统漫游，核心就是讲清楚一个程序是如何编译运行起来的，以及如何将程序转换为字节码；介绍了可执行文件的组成、链接的过程和链接器的作用；阐述了系统的层次结构和抽象，硬件和软件之间的互动。

- 第2章《信息的表示与处理》是关于二进制的，这部分内容会在数字逻辑这类课里学到，都比较熟悉，但是csapp里确实我见过关于进制讲得最透彻的书，不像其它书都是一句话让你背取反+1，具体会涉及到二进制表示法和进制转换；字符编码和格式；计算机中整数和浮点数的表示和运算；逻辑运算和位操作，

- 第3章《程序的机器级表示》核心就是C与汇编，会讲到C语言中各种关键词、指令是如何在汇编层面实现的，比如if、switch、函数调用、数组访问分配等，如果你有汇编基础的话，学起来会很快

- 第4章《处理器体系结构》这章中定义了一个简单的类X86的指令集：Y86-64, 用来做教学，主要介绍了处理器硬件的设计，HCL(Hardware Control Language)，流水线处理等，这一块呢，偏底层硬件一点，对于上层应用开发的同学可以做了解

- 第5章《优化程序性能》这里内容对于程序员来说相对更"有用一些"，优化程序性能核心就是”缓存友好“、”编译器友好“，会通过二维数组访问方式说明缓存对程序性能的影响，还有提高程序并行度、循环展开等方法

- 第6章《存储器层次》主要就在讲缓存、局部性原理、以及编写缓存友好的代码。

- 第7章《链接》这部分内容篇幅不多，原理上讲的很简洁，文件节和符号解析表只是给出了几个图示，并没有过多的关注其实现，链接相关可以看看《程序员自我修养》

- 第8章《异常》关于硬件异常和操作系统的异常处理机制，异常处理流程和异常控制流转移，进程控制、信号处理和面向异常的编程思想。

- 第9章 虚拟内存从内存管理和虚拟内存实现上讲的，会涉及到malloc、free等原理

- 后面几章讲系统级IO，网络编程、并发编程感觉不是特别突出，就不一一介绍了。


**看书容易被劝退的同学可以看下视频：**

```https://www.bilibili.com/video/BV1iW411d7hd```

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gsl1n8vztfj316i0u0djr.jpg)

## 为什么推荐程序员都去看看？

这本书包含的内容其实都是在数字逻辑、操作系统、网络、体系结构等课程中学过的。

但是csapp 从一个 hello world 程序运行引入，将进制、汇编、指令集、C语言、性能优化、编译、链接、加载、虚拟内存、并发、网络编程等整合在一起。

对于想学好 System 的同学强烈建议看一遍这本书。

这本书里的内容其实就是大家经常说的底层知识/内功。

而我们国内大部分学校都是不注重系统知识的培养的，只有少数 985 高校有开设系统编程课程。

这本书最精华的还有它的配套实验，墙裂建议大家看书的时候一起干掉，实现shell、缓存优化、缓冲区溢出攻击...... 每一个实验都有助于你理解系统原理。

不管是前端、后端还是算法，CSAPP 上的内容都算是基本功。

网上有不少读都没读的同学，就在疯狂跟风推荐初学者也去看，我觉得是有一定误导性的，虽然这本书被封神，在 CMU 这门课的定位也是导论课，但是根据我们国内大部分学校 CS 的教学节奏，这本书更加适合在大二以上阶段去看。

**也就是有了一定的 计算机基础，否则的话，可能比较难以看懂。**


## 分享下我自己看这本书的历程：

这本书是在大一逛知乎听大佬们说起的，大一暑假有大四学长学姐在学校广场摆摊卖书，我也买了些，其中有一本就是被称为计算机专业神书的 CSAPP。

大二时，在上一些无聊的课时，我总把这本书带着，每节课可能会翻个几页，那时候看到里面的汇编、内存管理、存储器层次我是真的云里雾里，因为还没学操作系统，C 语言也学得很差。

所以断断续续的看了几章，说不上学到了什么，但让我对这种枯燥的基础知识第一次产生了兴趣，有一种想彻底搞懂它们的想法。

后来在知乎大佬的指引下，为了看懂这本书，去看了王爽那本《汇编语言》，在下图。

重学了 C 语言（主要是指针和内存），由于已经学了汇编，指针对我再也不是问题了，同时看完了《C和指针》、《C专家编程》、《C陷阱与缺陷》，对 C 语言使用得也愈加的熟练。

同时，在大二、大三上陆续学习

操作系统、计算机组成原理、数字逻辑等，其实熟悉的同学就知道，这已经涵盖了csapp书里的绝大部分内容。

值得一提的是，大三我们学院有门 System Programing 的课，教材就是使用的 CSAPP，因此我之前大二草草看完的书，得以再次翻开，这一次我把附带的是个实验也挨着挨着做了，收获良多，有位运算各种奇技淫巧，有 Bomb lab 刺激的打怪通关、也知道了buffer overflow attack.... 还有实现基本的内存管理等等。

印象最深的便是做 bomb lab，一个个 phase 的通过真的很让人兴奋，我几乎是熬夜连着把这几个 phase 过掉的，当然头发也没少掉。

当时还在简书写了个万字长文记录：
![](https://cdn.how2cs.cn/gzh/0081Kckwgy1gkslx2ftlbj30u00z1ng8.jpg)

[https://www.jianshu.com/p/479333cbccc4](https://www.jianshu.com/p/479333cbccc4)

其它个人觉得比较有意思的lab有：

Malloc Lab：实现一个类似C语言的malloc函数，主要学习内存管理

Proxy Lab：http server，学习linux下网络编程和多线程编程，锁、条件变量等

Attack Lab：缓存区溢出攻击，主要学习Linux下函数调用过程和堆栈等


## 如何去阅读这本书？

读一本书，尤其是专业技术类，决定你能否看下去的一个重要因素就是你是否具备前置知识。

总不能高中数学都没学就想去看高数吧。

那这本书的前置知识，我认为你需要具备一些 C 语言知识、以及系统知识，比如 Unix、Linux基本操作，有 C 语言背景最好，如果完全没学过 C 的话，那么前几章看起来会比较吃力。

这本书有我个人认为有两种打开方式：

* 第一种是学习过操作系统、计算机组成等，所以看起来应该不存在很大的难度，从头到尾一章章啃，看完一章一定要做一些课后的作业和配套的lab，lab可以算这本书的精华之一了。

* 第二种是按需学习，之前说过，这本书涵盖了计算机学科主要的知识，将整个线串起来了，所以在这里面你能找到链接&加载，也能找到内存管理、还有语言的机器级表示汇编等，所以当你学习内存管理时你就去看看第九章虚拟内纯，学到C&C++编译链接时，可以去看看第七章链接，学习到存储的时候，可以去看看第六章存储器层次结构。

每一章都是比较独立的，所以完全可以跳着挑自己感兴趣的去学习

## 扩展资源

配套的lab:

[http://csapp.cs.cmu.edu/3e/labs.html](http://csapp.cs.cmu.edu/3e/labs.html)

![](https://cdn.how2cs.cn/gzh/0081Kckwgy1gkxvluztpnj30vo0u01kx.jpg)

配套视频，B站：

[https://www.bilibili.com/video/BV1iW411d7hd](https://www.bilibili.com/video/BV1iW411d7hd)

![](https://cdn.how2cs.cn/gzh/0081Kckwgy1gkxtczd2awj31hc0u0b06.jpg)

其它相关资源：

南京大学计算机系统基础（一）、（二）、（三）等

[https://www.icourse163.org/course/NJU-1449521162](https://www.icourse163.org/course/NJU-1449521162)

书籍：

《汇编语言-王爽》

《现代操作系统》

《C与指针》

《Unix环境高级编程》

## 大概需要具备哪些基础呢？

1. 较好的 C 语言基础，至少对 指针、内存理解不错
2. 学习了解过数的表示、二进制、数字逻辑相关内容
3. 有一定的操作系统或者说计算机系统概念，比如内存、磁盘、虚拟内存等

如果你都还不太具备，那么我建议你先把我之前组织的《C语言训练营》里进阶部分内容学习完，再来看，这样效果会更好。

**哪些同学最适合现在看这本书？**

1. 学了操作系统、计组等课程，这本书能帮你串联起来
2. 秋招复习，跳着挑一些章节看，这本书里虚拟内存、存储器层次都很不错
3. 大二以上(大一基础好的也可以)

**如果你看过以下书籍，那么看 csapp 的难度会低很多(画外音：最好先去看下)**

1. 王爽的《汇编语言》
2. 《C和指针》
3. 《现代操作系统》虚拟内存、进程线程、磁盘等章节

## 相关资源

[深入理解计算机系统高清版PDF下载](https://csguide.cn/resource/csapp.html)