---
title: 计算机必读书单推荐
description: 推荐计算机领域的经典书籍，涵盖C语言、C++、Java、操作系统、系统编程、分布式、代码设计等方面，帮助你提升编程技能，成为计算机行业的专业人士。
meta:
  - name: description
    content:  推荐计算机领域的经典书籍，涵盖C语言、C++、Java、操作系统、系统编程、分布式、代码设计等方面，帮助你提升编程技能，成为计算机行业的专业人士。
  - name: keywords
    content: 计算机书籍, C语言, C++, Java
---

# 计算机必读书单推荐

读大学期间，我买了很多书，也看了很多技术书，后来发现书不在于多，而在于经典。

读经典的书是站在巨人的肩膀上，看得远、悟得深~

所以我在这里列出的书，尽量保持少，精简。

我主要做后台开发的，所以推荐的书可能偏后台一点，但是一些基础书都是类似的。

这是我大学买过看过的一些书，以至于毕业的时候搬不走，大部分都甩卖掉了:
![](https://cdn.how2cs.cn/csguide/032626.jpg)
![](https://cdn.how2cs.cn/csguide/032642.jpg)

之前写过一篇关于如何阅读计算机类书籍的文章： [如何高效看计算机大黑书--看书的小建议？](https://www.yuque.com/csguide/index/mmi2ucp464g8kip9)

然后贴了一张大学毕业时寝室的书，很多小伙伴问我要一个书单。

今天我给大家找来了我当时看过或者准备看的一些书：

![](https://cdn.how2cs.cn/gzh/008i3skNgy1gshj5elnb6j319k0u04qp.jpg)

这是我的备忘录，从大学 18 年开始整理的，为了方便大家分门别类的找，我都把这些书分为 C、C++、Java、操作系统、系统编程、分布式、代码设计等等方面了，绝对都是非常不错的书籍，大家可以收藏一波~

并且有些书籍直接搜名字可能会有多本，为了方便大家确认，我直接放上该本书籍的封面图。

## 一、C语言
### 1.1 教材类
#### 《C Programming Language》- C程序设计语言
这是由  C语言之父Dennis Ritchie和Brian Kernighan合著的经典著作，被誉为C语言的圣经。详细介绍了C语言的基本语法、数据类型、控制结构和函数等方面的内容，并且包含很多实用的技巧和建议。
#### 《Head First C》
这是一本非常有趣的C语言入门书籍，作者 David Griffiths 和 Dawn Griffiths 通过大量的图表、练习和实例，以及富有幽默感的风格，帮助读者轻松学习C语言的基本知识。
### 1.2 指针类
#### 《彻底搞懂C指针》
#### 《深入理解C指针》
上面这两本都是关于指针的一个 PDF，讲得挺不错的，能够加深大家对于指针的理解。
#### 《C和指针》
这本书我是在大一下左右看的，比较深入的讲解了指针的概念、用法以及它们在实际编码中的应用。此外，还介绍了内存管理、函数指针、结构体指针和指针数组等高级主题。
对于想要深入学习 C 语言或者需要进行低级别编程的 C 程序员来说是必读的。不仅能掌握指针的概念，还教会了大家如何避免指针错误和内存泄漏等常见问题。
不过本书的内容相对较为深入，适合有一定编程经验的同学阅读。
### 1.3 其它
* **《C程序性能优化  20个实验与达人技巧》**
* **《C专家编程》**
* **《高质量C编程指南》**
这几本书，如果有时间的话，可以大概翻阅一下，寻找自己感兴趣的章节进行学习，实际上不看也是可以的~
C专家编程这本书实际上我看得也挺懵的，讲了很多故事。
## 二、C++ 语言
### 2.1  手册类 – 所有级别皆适用：
#### 《 C++程序设计语言(The C++ Programming Language) 》
![](https://cdn.how2cs.cn/csguide/041017.png)
《C++程序设计语言》的定位是，教已经懂编程的人 C++ 语言本身。
比如你有 C、Java 等语言基础，可以直接看这本书。
如果你是 Java 程序员，或者 C 程序员，想学 C++，可以直接看这本书。
#### 《C++标准程序库(C++ Standard Library Tutorial and Reference) 》**
《C++标准程序库》适合已经具备一定 C++ 编程基础并且使用过 C++标准库的同学，想深入了解C++标准库的用法和实现原理。

#### 其它
* **《The C++ IO Streams and Locales》 **
* **《The C++ Standard》**
* **《Overview of the New C++ (C++11/14)》**
以上这些书都可以作为 C++ 语法手册类书籍翻阅，包括学习 C++基本语法、STL 用法等、
### 2.2 教材类-- 适合系统入门
#### 《C++ Primer》
这本书是大家最推崇的系统学习 C++ 的教材，几乎 C++ 的所有知识都能在里面找到，当然了书也非常的厚，推荐大家系统学习阶段，把这本书看一遍。
#### 《Accelerated C++》
这本书被很多人评价是最适合初学者的书，不会包含所有 C++ 的知识点，但是初学者最需要学习的部分都包含了，并且里面的例子也很实用。
#### 《C++编程思想（Thinking in C++)》
这本书的作者也是《Thinking in Java》的作者，不过这本书相对古老，里面缺少现代 C++ 语言方面的特性，比较强调面向对象的设计思想。
#### 《C++程序设计原理与实践 （Programming: Principles and Practice Using C++ ）》
这本书是 C++ 之父 Bjarne Stroustrup 所著，他在官网这样描述这本书：
> a programming text book aimed at beginners who want eventually to become professionals.
> 一本针对希望最终成为专业人士的初学者的编程教科书。
### 2.2 最实用的C++书
#### 《Effective C++》
这本书里列举了四十多条 C++ 编程中的最佳实践，你可以把这本书当做 C++ 防踩坑的一个小册子。每天看一条，一个月也大概看完了。
这本书里很多最佳实践也是面试常考的内容，学习完这本书，你应该会对C++编程有一个更深刻的认识。
#### 《Effective STL》
这本书也是帮我我们高效使用 STL 的，书中讨论了许多STL的关键概念和技术，包括容器、迭代器、算法等等。通过深入讲解每个STL组件的用法和实现原理，写了很多实用的技巧和建议，大家避免一些常见的陷阱和错误。
#### 《深度探索C++对象模型 (Inside the C++ Object Model ) 》
这本书是关于 C++ 对象模型的，所谓对象模型就是 C++ 中的类、对象在内存中是如何组织的。
### 2.3 中级
这部分书籍还是围绕如何更好的使用 C++，提高大家对于 C++ 编程的规范和效率，感兴趣的可以自行阅读~
#### 《More Effective C++》 
#### 《Exceptional C++》 
#### 《More Exceptional C++》
#### 《Exceptional C++ Style》
#### 《C++编程规范(C++ Coding Standards)》 
#### 《C++ 模板完全指南(C++ Templates: The Complete Guide)》
### 2.4 高级
这部分内容涉及到 C++ 中一些比较进阶的话题，比如 GP 泛型编程、模板元编程、并发编程等等。
这部分的内容，大家还是根据自己的实际情况进行选择。
#### 《C++设计新思维-泛型编程与设计模式之应用(Modern C++ Design )》 
#### 《C++模板元编程(C++ Template Metaprogramming)》
#### 《C++ Concurrency In Action》 
#### 《Advanced C++ Metaprogramming》 
### 2.5 理解 C++ 设计与实现
这部分书籍更多的是关注 C++ 这门编程语言的基本原理以及设计与实现，还有讨论诸如 C++ 对象模型的。
#### 《C++的设计与演化(The Design and Evolution of C++ )》
#### 《C++沉思录(Ruminations on C++)》 
#### 《Advanced C++ Programming Styles and Idioms》 
#### 《大规模C++程序设计（Large Scale C++ Software Design）》
#### 《深度探索C++对象模型 (Inside the C++ Object Model ) 》
## 三、Java
### 3.1 Java SE
#### 《Java编程思想》
这本书被誉为 Java 编程圣经，实际上并不适合初学者阅读，适合有一定 Java 使用经验的同学。
####  《Java核心技术卷一》
#### 《Effective Java》
### 3.2  Java 并发编程
#### 《Java并发编程实战》
#### 《Java并发编程艺术》
### 3.3 Java 虚拟机
#### 《深入理解JVM虚拟机》
#### 《Java性能调优指南》
### 3.4 Java Web相关
#### 《深入JavaWeb技术内幕》
#### 《How Tomcat Works》
#### 《Spring实战》
## 四、网络编程
#### 《计算机网络-自顶向下》
学习网络编程，那么首先要大概了解整个计算机网络模型，推荐这本自顶向下，这本书从应用层开始，沿着 TCP/IP 五层模型往底层介绍，非常适合学习计算机网络。
#### 《TCP/IP详解-卷一》
这本书相对来说更加专注，对于 TCP 这一块讲解非常深入。
#### 《Unix网络编程》
这本书是网络编程方向的圣经，和下面👇这本 APUE 合称为 腾讯后台开发 敲门砖~
#### 《Unix 环境高级编程》
Unix 系统编程圣经
#### 《Linux高性能服务器编程》
游双写的，这本书里能学到 Linux 下常见的网络编程模型，学习 C++ 后台方向的同学比较推荐。
#### 《Linux多线程服务端编程》
这本书是知乎大佬陈硕写的，书里很大篇幅是在介绍 Muduo C++ 网络库的，老实说，这本书不适合初学者，估计很多人看第一章就会被劝退，是关于多线程下对象生命周期的。
![](https://cdn.how2cs.cn/csguide/055850.png)
但是对于走 C++ 后台开发的同学来说，这本书包括 Muduo 网络库还是非常值得学习的。
能够学习到非常多的网络编程、网络库开发经验。

## 五、代码 & 程序设计
#### 《代码整洁之道》 
#### 《重构》
上面这两本书是关于如何写好代码的、如何避免你的代码变成屎山的，建议工作后的小伙伴都读一读。
#### 《设计模式》
#### 《代码大全 》
#### 《程序员修炼之道》
#### 《计算机程序的构造与解释》
#### 《编码：隐匿在计算机软硬件背后的语言》
## 六、System
### 6.1  系统编程
#### 《深入理解计算机系统》
#### 《程序员自我修养》
-别被名字迷惑了，这本书真正该叫 《编译链接与运行》，真是好书
#### 《设计数据密集型应用》
#### 《链接器和加载器》
#### 《COM 本质论》
#### 《代码优化：有效使用内存》
### 6.2  操作系统 
#### 《现代操作系统》
#### 《操作系统真象还原》
这是一本教你如何从 0 写一个mini os 的，对于通过写一个操作系统来学习的同学是一本非常不错的教材。
#### 《 Windows 核心编程 》
#### 《深入理解 Linux 内核》
## 七、软件开发 & 其它
#### 《程序员修炼之道》
#### 《UNIX 编程艺术》
#### 《人月神话》
#### 《黑客与画家》
#### 《清醒思考的艺术》
#### 《当下的幸福》
#### 《异类：不一样的成功启示录》
#### 《漫步华尔街》（了解下资本的运作
#### 《领域驱动设计》
## END
这篇文章的目的并不是详细的介绍每一本书，而是给大家一个索引，让大家知道哪些领域都有哪些还不错的书籍，下次需要学习的时候，再根据这个索引去详细的了解相应书籍然后做出选择。