# 编程能力从什么时候开发突飞猛进？

> 原文发表于公众号: [你的编程能力从什么时候开发突飞猛进？](https://mp.weixin.qq.com/s/uq67R4jHpYkbMUQqIBgpHA)

## 前言

知乎上有个提问：

> 你的编程能力从什么时候开发突飞猛进？

觉得挺有意思的，所以顺手回答了下 [https://www.zhihu.com/question/356351510/answer/1578302782](https://www.zhihu.com/question/356351510/answer/1578302782) ，

这篇文章纯碎是记流水账，**也没什么干货**，大家权当看个故事~

> 以下是正文

**啃完一本本书，做完一个个 lab，没有突飞猛进，一切都是量变最终累积成质变。**

**但是有那样一些时间节点，你会明显感觉到自己的编程能力确实有提高不少，能够编码实现更多的想法，接受新知识的速度也会加快，我想这是不是就是零散的知识点逐渐连成线、组成面呢？**

不过老实说，就编程能力上确实没有“突飞猛进”的感觉。

我们都是普通的剧本，不可能像张无忌一样因跌落悬崖，意外获得《九阳神功》，从此突飞猛进、开挂，走向人生巅峰。

只有靠不断的看书、coding、学习优秀开源项目，构建自己的计算机知识体系，并且在特定的领域不断专研，这样才能成为一个优秀的工程师。

下面聊聊我自己的编程学习之路吧。

## 一、迷茫的大一

### 1.1 毫无编程基础
我在大学之前完全没有编程经验，高考后，填的专业前几个也是清一色的传统工科，被软件工程录取纯碎是意外。

当时甚至很担心完全没有编程基础的我，上大学会不会跟不上，还因为考虑过复读，现在想想也是天真。

### 1.2 指针都搞不懂

大一开学，第一门编程语言就是学的 C 语言，怎么说呢，老师讲的，书上写的我都能看懂，但是让我写一个大的程序，我就摸不到头脑。不知从何下手，学了半学期，也只能写写课后习题，算算水仙花数什么的。

而且当时对计算机缺乏系统认识，即便我记住了指针就是变量地址，也很难理解它到底有啥用。甚至分不太清数组和指针的区别，以至于会出现对函数局部变量取地址返回这样现在看来很低级的错误。

大一上考完 C 语言后，我便在心里默默念想，这辈子再也不写 C 了，但没想到的是，后来这成了我最爱的一门语言。

大一下，开始学习数据结构与算法、数字逻辑这些计算机核心课了。

### 1.3 爱上Java

**此外，还学了一门当时我看来非常牛逼的语言：Java。**

为啥说我当时觉得它牛逼呢？

因为刚经历过 C 语言的摧残，发现 Java 有丰富的类库，各种方便的工具类。

再也没有指针了，变成了对象引用，简直是新大陆。

所以我学得很认真，还记得当时看过马士兵和高琪的 Java Se 教程，不过现在马老师已经出来单干了哈哈哈。

自己也用 Java 写了不少好玩的东西，比如联机五子棋、HTTP Server 等等。

这让我第一次感受到编程这么有趣，俗话说兴趣是最好的老师，Java 也算是帮我解锁了对于编程的兴趣。

在学 Java 的时候喜欢在网上搜资料，但总觉得各种博客上的知识过于零散，为了“精通” Java，我在知乎搜索各种书单，先后看了《Java编程思想》、
《Java核心技术卷》、《Java并发编程》好几本书，自觉 Java 基础还算可以，不过现在已经快两年没写了，至于原因后面会提到。

### 1.4 大一暑假自学安卓开发

就这样来到了大一暑假，在家实在没事干，当时觉得开发 APP 好牛逼，于是开始自学了安卓，并写了点 APP 玩，比如天气、贪吃蛇，现在他们还躺在我的 Github 上。

不过学了一段时间，自己就感觉不太喜欢客户端开发，似乎写 APP 那点成就感被消磨耗尽了。

于是大二开学就开始学 Java Web，从 Servlet 到 SSH、SpringBoot，基本上都过了一遍，甚至还买了本现在看来很脑残的书《Java Web整合开发-王者归来》，就是下面图中那本：
![](https://cdn.how2cs.cn/gzh/0081Kckwgy1gksl3ddzzbj30tb1hce82.jpg)

后来，越来越觉得这条路就是在学各种框架，虽然学到了东西，但是总觉得不太对劲。

同时，大一暑假有大四学长学姐在学校广场摆摊卖书，我也买了些，其中有一本就是被称为计算机专业神书的 CSAPP。

## 二、疯狂尝试的大二

### 2.1 CSAPP 看得云里雾里

大二时，在上一些无聊的课时，我总把这本书（CSAPP) 带着，每节课可能会翻个几页，那时候看到里面的汇编、内存管理、存储器层次我是真的云里雾里，因为还没学操作系统，C 语言也学得很差。

所以断断续续的看了几章，说不上学到了什么，但让我对这种枯燥的基础知识第一次产生了兴趣，有一种想彻底搞懂它们的想法。

### 2.2 补学汇编

后来在知乎大佬的指引下，为了看懂这本书，去看了王爽那本《汇编语言》，也在上图。

### 2.3 系统学习C

重学了 C 语言（主要是指针和内存），由于已经学了汇编，指针对我再也不是问题了，同时看完了《C和指针》、《C专家编程》、《C陷阱与缺陷》，对 C 语言使用得也愈加的熟练。

## 2.4 全员机器学习
大二那段时间，学院里突然刮起全员学机器学习的风气，虽然不至于全部，但是真的是很多人都在学，明明 16 年大一时客户端安卓开发还挺火的，到了 17 年各种机器学习、神经网络就席卷而来。

不能不感叹，IT 行业日新月异呀，不学习就可能被淘汰。

当然了，我也不例外的加入了，先后看了些吴恩达的视频、西瓜书。

跟着做了手写数字识别这种入门必做的项目，但是后来总觉得对机器学习、深度学习提不起兴趣，原因之一就是我觉得无法完全掌握每一步，了解每一步背后的原理，再加上自己数学也学得不太好，这让我学得很没底气。

于是机器学习之路也止于大二。

### 2.5 为了抢课学Python
大二是学习内容最丰富的时间，当时室友用 Python 写了抢课脚本，感觉很好玩。

然后自己又跑去学 Python，学爬虫。

写了一堆爬虫，什么爬豆瓣电影、知乎回答、抢课脚本，玩了一段时间也没太大兴趣了。
![](https://cdn.how2cs.cn/csguide/142857.png)

### 2.6 学习写 mini os

时间来到了大二下，按照课程安排，开始上操作系统了。

于是我又在知乎搜索「操作系统怎么学」，不得不说知乎上各位前辈大佬的回答对我的指引作用极其的大。

顺着一堆回答，我发现原来还能跟着别人写一个 mini OS，这对我吸引力太大了。

于是我买了一本《操作系统真象还原》，这本书真的非常仔细，把写 OS 需要用到的前置理论知识、Intel手册、汇编、内联汇编全都给你讲清了。

我一路跟着书写，写到了汇编开机打印出我的名字，再到后来进入 C 语言写内核各个模块，写到内存管理我就中断了，没有继续写下去，这也算个遗憾吧。

这本八百多页的书，我花了两个月时间啃了五百多页，一下课就跑去图书馆，在我的虚拟机中跑 qemu，那时候就沉浸在类似下图这种界面：
![](https://cdn.how2cs.cn/gzh/0081Kckwgy1gksldl0nwzj30yw0kmk0q.jpg)

当时我真的对这个入迷了，为了写 mini os我还去看了 Linux0.11 的部分代码，看了哈工大李治军老师的 OS 公开课，原因就是哈工大 OS 实验课是用的 Linux 0.11 来魔改。

还很奇葩的把我 QQ 签名改成了 jmp 0x7c00 

![](https://pic4.zhimg.com/50/v2-d14caf049e7ddd128874d32819a56b6d_b.jpg)

(PS: 这句汇编就是跳转到 0x7c00 地址，BIOS 开始引导操作系统
于是就这样，我越来越喜欢偏底层一点的东西，所以决定走 Linux C/C++ 路线，然而现在看来确实太年轻了，Linux C/C++ 在鹅厂好多也是用来写业务滴。。。

大二下在知乎、牛客网搜索学习路线，我大概清楚了需要看些什么书（**搜索**敲黑板，一定要学会主动搜索各种信息。

## 三、专注的大三

### 3.1 Linux C++之路
于是在大三上左右开始了非常标准的 Linux C/C++学习之路，也得益于之前学习汇编、C、CSAPP、操作系统等打下的基础，后续这些偏底层的知识学起来也是非常快的：

前前后后看了《C++ Primer》、《APUE》、《UNP》、《深度探索C++对象模型》、《STL源码剖析》、《C++设计与演化》、《Linux内核设计与实现》、《Linux内核完全注释》、《effecitve C++》 、《effective modern C++》、《程序员自我修养》、《Linux高性能服务端编程》、《Linux多线程服务端编程》(知乎陈硕大佬写的)......

顺便还看了点 Muduo 源码，自己模仿着基于 Epoll 写一个 Reactor模型的 Web 静态服务器，跟着知乎 Milo 大佬写 Json 库，总之，这段时期是写了一些小”轮子“的。

（PS：知乎上有朋友问我是如何看完这么多书的，其实在之前的文章中就写了，看书我会有选择的挑章节看，不会从头看到尾的，而且大三开始课就少了，我基本就在刷这些书，其实时间还蛮多的？毕竟我也没参加什么社团、学生会之类，也没女朋友。。。

那时候会每天记录看书的进度，感觉特别有劲：

![](https://cdn.how2cs.cn/gzh/0081Kckwgy1gksls75u3zj30u01t012u.jpg)

### 3.2 深入C++ + 存储 + 网络编程 + 分布式
书看得越多，其实你越能找到自己的方向，大三上我就给自己学习定位：

深入C++语言（多线程）+ 存储（学习 Redis、leveldb）+ 网络编程（学习muduo，各种网络编程模型）+ 学习分布式（MIT 6.824、ddia、google 三大论文等）

基本上是沿着上面几个方向去展开学习的，有的看书，有的论文，也有的看博客看源码。

总之，知识面在大三不断扩充，自己开始关注学习 C10K、C100K 这样的后台服务器开发高性能、高并发的解决方法。

当然了，还有些到现在还没开始，比如 leveldb 的源码、6.824 的 lab，可能是变懒了......

也可能是学习变得不那么纯碎面向技术了，变成面向工作、面向赚钱了哈哈哈。

### 3.3 重学CSAPP并且完成lab

值得一提的是，大三上我们学院有门 System Programing 的课，教材就是使用的 CSAPP，因此我之前大二草草看完的书，得以再次翻开，这一次我把附带的是个实验也挨着挨着做了，收获良多。

有位运算各种奇技淫巧，有 Bomb lab 刺激的打怪通关、也知道了buffer overflow attack.... 还有实现基本的内存管理等等。

印象最深的便是做 bomb lab，一个个 phase 的通过真的很让人兴奋，我几乎是熬夜连着把这几个 phase 过掉的，当然头发也没少掉。

通过后非常高兴，当时还在简书写了个万字长文记录：

![](https://cdn.how2cs.cn/gzh/0081Kckwgy1gkslx2ftlbj30u00z1ng8.jpg)

### 3.4 微信实习 & 转正
再到后来，我拿到了微信实习 offer，然后顺利转正。

关于实习的经历可以看这篇文章: [https://www.yuque.com/csguide/index/cb2zdx7981d7x385](https://www.yuque.com/csguide/index/cb2zdx7981d7x385)

![](https://cdn.how2cs.cn/csguide/143354.png)
![](https://cdn.how2cs.cn/csguide/143427.png)

在我大三下拿到实习 offer 后，开始帮留学生做一些国外计算机课程 lab或者课程辅导（也就是代写），一方面有钱赚，而且还不低，总计在这块赚了 10w+，另一方面这些 lab 有些很有意思，靠这个我在大三下就实现了经济独立，对提高基础和编程能力很有帮助。

这里是部分做过的记录：
![](https://cdn.how2cs.cn/csguide/143632.jpg)

在这里列举一些我做过的觉得有意思的 lab（之前有篇文章写过）：

## 四、Lab之路

### 4.1 第一个是文件系统
这个玩意挺有意思的，就是要让你自己去设计一个文件系统，比如文件、数据块、目录等等，而且你要提供创建、读写、删除、随机读、随机写等等接口，然后通过 Linux 的 VFS（虚拟文件系统） 机制挂载到 Linux 内核中，然后就可以用系统调用 open、read、write 这些来在你的文件系统上进行读写。

VFS 是Linux一个机制，它规定了 IO 接口，然后你去实现这些接口，你就可以挂载在上面。通过这个东西我深入的学习和了解了文件系统，报酬也是非常值的。
![](https://pic1.zhimg.com/50/v2-3bb18b22491c665c8bb3fd9fd53e5fdc_b.jpg)

### 4.2 第二个是SVC
就是版本管理系统，类似 SVN 和 GIT的，但是相对 GIT 做了很多简化，核心的就是创建分支、分支合并、回滚、commit 这些，通过这个我又去详细了解了 GIT 的实现原理，并且自己写了一个简单版本的 GIT，受益匪浅，也赚到了几千大洋。

![](https://pic4.zhimg.com/50/v2-b78851f49339614046809318282185d9_b.jpg)

### 4.3 第三个是操作系统的锁实现

这个就是让你基于硬件的原子指令 xchg、cmpxchg 这些实现一个锁，这个需要内联汇编、汇编等知识，简直是硬核！！！做完这个也解开了我对锁实现的一些疑惑。

![](https://pic4.zhimg.com/50/v2-8ac3dcc1381733761d128b142beb8e69_b.jpg)

### 4.4 Web Proxy

这个就更有意思了，要求用 C++ 写一个代理服务器，类似 Nginx 的代理功能，当然，相比 Nginx 弱鸡很多，但是麻雀虽小，五张俱全，而且老外最有意思的是要求代理服务器对一些图片和 HTML 恶作剧。

就是代理服务器随机的在原始服务器，返回的响应里 插入一些图片和文字，因为那天是愚人节。。。 不得不说老外还是很有趣的。

![](https://pic1.zhimg.com/50/v2-585da1a27e987b8ef311c8ed754ad7d9_b.jpg)

### 4.5 模拟实现可靠传输的

这个就更硬核了，人家老外老师就是给力，直接做了一个网站，这个网站你可以通过 TCP 连接上去，然后你需要运行几个节点，互相发消息，他们之间的消息都会经过老师的网站，所以通过网站上是可以控制丢包率的，也能控制节点的拓扑结构，要求就是让你基于这种不可靠的信道，做出可靠数据传输！

这简直就是翻版 TCP 嘛，超时重传、ACK、滑动窗口啥的都给我上！就是像下面图中一样，圆圈就表示你可达的范围，不同节点形成各种网络拓扑，可以调节网络 丢包率 Loss chance。

![img](https://pic4.zhimg.com/50/v2-13c19827354a3192fe752a6007a996e2_b.jpg)

当然也有很多写算法的，数据结构实现的，图搜索的，反正各个方向都有：

![](https://cdn.how2cs.cn/csguide/133204.png)


做这些 lab 真的实实在在的提高了我的编程实践能力，也算是检验了前期看那么多书还是有效果滴。

**所以写了这么多，再点次题吧，我认为自己编程能力突飞猛进就是在看完一本本大黑书、做完一个个 lab、写下一行行代码之后。**

## 五、附录

附上大学期间买的一些书，毕业的时候大部分都卖了，因为实在不便携带：

这是带去图书馆自习室的书（常占位置）

![](https://pic3.zhimg.com/50/v2-b0692dd2bfecd3abbc8da8f2fce3f7a0_b.jpg)

这是毕业整理的书：

![](https://pic4.zhimg.com/50/v2-1760498178bf329f57a3b8a59ad5ed8e_b.jpg)

买这些书花了我不少钱，大家都知道计算机这些书一本就是五六十、七八十起步。大学四年光买书就花了几千块。不过我一直认为这也是我花的最值的一笔投资。


**在这也顺便分享一下我的小电子书库，不多，但贵在精：**

![计算机书籍PDF](https://cdn.how2cs.cn/csguide/103902-1.png)

有需自取: [计算机必看经典书单(含下载方式)](/resource/pdf.html)

最后真心想说一句，滴水穿石非一日之功，学习计算机还是需要沉下心来好好啃书、看源码、写“轮子”。

逐渐构建起属于自己的计算机知识体系，然后选择一个专业方向不断专研。

大家一起加油！