---
blog: false
home: true
icon: home
title: Java Design Patterns
heroImage: /coffee.svg
heroText: 软件设计模式，编程原则还有代码片段
tagline: 最好的设计师会使用许多相互吻合和交织的设计模式，以产生更大的整体 --Erich Gamma
heroFullScreen: false
action:
  - text: 学习设计模式 💡
    link: /zh/patterns/
    type: primary
features:
  - title: 设计模式
    details: 学习世界上最大的用 Java 实现的软件设计模式集合。
    link: /zh/patterns/
    icon: home
  - title: 软件设计原则
    details: 软件设计有一定的普遍规律和原则来指导实施者。
    link: /zh/principles/
    icon: certificate
  - title: 代码片段
    details: 30秒钟Java是一组可重用、经过测试、可复制粘贴的 Java 17 兼容代码片段，您可以在 30 秒或更短的时间内理解这些代码片段。
    link: /zh/snippets/
    icon: code
footer: MIT licensed
---

# 介绍

设计模式是程序员在设计应用程序或系统时可以用来解决常见问题的最佳形式化实践。
设计模式可以通过提供经过测试的、经过验证的开发范例来加速开发过程。
重用设计模式有助于防止导致重大问题的细微问题，并且还提高了熟悉这些模式的编码人员和架构师的代码可读性。

# 开始

该站点展示了基于 Java 的设计模式、原则和代码片段。 这些解决方案由来自开源社区的经验丰富的程序员和架构师开发。 这些模式可以通过它们的高级描述或通过查看它们的源代码来浏览。 源代码示例有很好的注释，可以被认为是关于如何实现特定模式的编程教程。 我们使用最流行的久经考验的开源 Java 技术。
希望您发现本网站上提供的面向对象的解决方案对您的体系结构很有用，并且在学习它们时和我们开发它们时一样有趣。

# 如何贡献

该网站是开源社区工作的结果。 要对内容做出贡献，请按照下面的 Github 仓库链接进行操作。

- [Website](https://github.com/iluwatar/java-design-patterns-vuepress-web)
- [Design Patterns](https://github.com/iluwatar/java-design-patterns)
- [Software design principles](https://github.com/iluwatar/programming-principles)
- [Snippets](https://github.com/iluwatar/30-seconds-of-java)
