---
blog: false
home: true
icon: home
title: Java Design Patterns
heroImage: /coffee.svg
heroText: 소프트웨어 디자인 패턴, 원칙 및 스니펫
tagline: 최고의 디자이너는 더 큰 전체를 생산하기 위해 얽히고 얽힌 많은 디자인 패턴을 사용할 것입니다. --Erich Gamma
heroFullScreen: false
action:
  - text: 디자인 패턴 연구 💡
    link: /patterns/
    type: primary
features:
  - title: 디자인 패턴
    details: Java로 구현된 세계 최대의 소프트웨어 디자인 패턴 모음을 학습합니다.
    link: /patterns/
    icon: home
  - title: 소프트웨어 설계 원칙
    details: 소프트웨어 디자인에는 구현자를 안내하는 특정 보편적인 법칙과 원칙이 있습니다.
    link: /principles/
    icon: certificate
  - title: 코드 조각
    details: 30 Seconds of Java는 30초 이내에 이해할 수 있는 재사용, 테스트, 복사-붙여넣기 가능한 Java 17 호환 코드 조각 모음입니다.
    link: /snippets/
    icon: code
---

# 소개

디자인 패턴은 프로그래머가 사용할 수 있는 최고의 공식화 방법입니다.
응용 프로그램이나 시스템을 설계할 때 일반적인 문제를 해결합니다.

디자인 패턴은 테스트되고 입증된 정보를 제공하여 개발 프로세스의 속도를 높일 수 있습니다.
개발 패러다임.

디자인 패턴을 재사용하면 주요 원인이 되는 미묘한 문제를 방지할 수 있습니다.
문제를 해결하고 코드 가독성을 향상시키는
패턴에 익숙하다.

# 시작하기

이 사이트는 Java 기반 디자인 패턴, 원칙 및 코드 조각을 보여줍니다. 그만큼
경험이 풍부한 프로그래머와 건축가가 솔루션을 개발했습니다.
오픈 소스 커뮤니티. 패턴은 높은 수준의 설명으로 찾아볼 수 있습니다.
또는 소스 코드를 살펴봄으로써. 소스 코드 예제는 주석 처리가 잘 되어 있으며
특정 패턴을 구현하는 방법에 대한 프로그래밍 자습서로 생각할 수 있습니다. 우리
전투에서 입증된 가장 인기 있는 오픈 소스 Java 기술을 사용합니다.

이 사이트에 제공된 객체 지향 솔루션이 유용하기를 바랍니다.
당신의 아키텍처에서 우리가 그것들을 개발하는 것만큼 재미있게 배우십시오.

# 기여 방법

웹사이트는 오픈 소스 커뮤니티의 작업 결과입니다. 기부하다
내용을 보려면 아래 Github 저장소 링크를 따르십시오.

- [Website](https://github.com/iluwatar/java-design-patterns-vuepress-web)
- [Design Patterns](https://github.com/iluwatar/java-design-patterns)
- [Software design principles](https://github.com/iluwatar/programming-principles)
- [Snippets](https://github.com/iluwatar/30-seconds-of-java)
