---
blog: false
home: true
icon: home
title: Java Design Patterns
heroImage: /coffee.svg
heroText: Patrones, principios y fragmentos de diseño de software
tagline: Los mejores diseñadores utilizan muchos patrones de diseño que encajan y se entrelazan para producir un todo mayor --Erich Gamma
heroFullScreen: false
actions:
  - text: Estudiar los patrones de diseño 💡
    link: /es/patterns/
    type: primary
features:
  - title: Patrones de diseño
    details: Estudie la mayor colección del mundo de patrones de diseño de software implementados en Java.
    link: /es/patterns/
    icon: home
  - title: Principios de diseño de software
    details: El diseño de software se rige por ciertas leyes y principios universales.
    link: /es/principles/
    icon: certificate
  - title: Fragmentos de código
    details: 30 Seconds of Java es una colección de fragmentos de código reutilizables, probados y compatibles con Java 17 que se pueden copiar y pegar y que se pueden entender en 30 segundos o menos.
    link: /es/snippets/
    icon: code
---

# Introducción

Los patrones de diseño son las mejores prácticas formalizadas que un programador puede usar para resolver problemas
comunes al diseñar una aplicación o sistema.

Los patrones de diseño pueden acelerar el proceso de desarrollo al proporcionar paradigmas de desarrollo probados y
comprobados.

Reutilizar patrones de diseño ayuda a prevenir problemas sutiles que causan problemas mayores, y también mejora la
legibilidad del código para los programadores y arquitectos que están familiarizados con los patrones.

# Cómo empezar

Este sitio muestra patrones de diseño basados en Java, principios y fragmentos de código. Las soluciones han sido
desarrolladas por programadores y arquitectos experimentados de la comunidad de código abierto. Los patrones se pueden
explorar por sus descripciones de alto nivel o mirando su código fuente. Los ejemplos de código fuente están bien
comentados y se pueden considerar como tutoriales de programación sobre cómo implementar un patrón específico.
Utilizamos las tecnologías Java de código abierto más populares y probadas en batalla.

Esperamos que encuentres las soluciones orientadas a objetos presentadas en este sitio útiles en tus arquitecturas y te
diviertas tanto aprendiéndolas como nosotros desarrollándolas.

# Cómo contribuir

El sitio web es el resultado del trabajo de la comunidad de código abierto. Para contribuir al contenido, por favor
sigue los enlaces del repositorio de GitHub a continuación.

- [Sitio web](https://github.com/iluwatar/java-design-patterns-vuepress-web)
- [Patrones de diseño](https://github.com/iluwatar/java-design-patterns)
- [Principios de diseño de software](https://github.com/iluwatar/programming-principles)
- [Fragmentos](https://github.com/iluwatar/30-seconds-of-java)
