/*
Copyright (c) 2009-2010 Mikko Mononen memon@inside.org
recast4j copyright (c) 2015-2019 Piotr Piastucki piotr@jtilia.org
DotRecast Copyright (c) 2023-2024 Choi Ikpil ikpil@naver.com

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:
1. The origin of this software must not be misrepresented; you must not
 claim that you wrote the original software. If you use this software
 in a product, an acknowledgment in the product documentation would be
 appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
 misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

using NUnit.Framework;

namespace DotRecast.Detour.Crowd.Test;


public class Crowd1Test : AbstractCrowdTest
{
    static readonly float[][] EXPECTED_A1Q0TVTA =
    {
        new[] { 22.322426f, 10.197294f, -45.771397f, -3.107285f, 0.000000f, 1.610831f },
        new[] { 21.754303f, 10.197294f, -45.476715f, -3.106887f, 0.000000f, 1.611599f },
        new[] { 21.133097f, 10.197294f, -45.154068f, -3.106033f, 0.000000f, 1.613245f },
        new[] { 20.512094f, 10.197294f, -44.831028f, -3.105014f, 0.000000f, 1.615205f },
        new[] { 19.891315f, 10.197294f, -44.507557f, -3.103898f, 0.000000f, 1.617350f },
        new[] { 19.270782f, 10.197294f, -44.183617f, -3.102670f, 0.000000f, 1.619704f },
        new[] { 18.650520f, 10.197294f, -43.859158f, -3.101315f, 0.000000f, 1.622296f },
        new[] { 18.030558f, 10.197294f, -43.534126f, -3.099816f, 0.000000f, 1.625158f },
        new[] { 17.410927f, 10.197294f, -43.208462f, -3.098152f, 0.000000f, 1.628329f },
        new[] { 16.791668f, 10.197294f, -42.882092f, -3.096297f, 0.000000f, 1.631854f },
        new[] { 16.172823f, 10.197294f, -42.554935f, -3.094221f, 0.000000f, 1.635786f },
        new[] { 15.554445f, 10.197294f, -42.226898f, -3.091888f, 0.000000f, 1.640191f },
        new[] { 14.936594f, 10.197294f, -41.897869f, -3.089255f, 0.000000f, 1.645145f },
        new[] { 14.319340f, 10.197294f, -41.567722f, -3.086269f, 0.000000f, 1.650741f },
        new[] { 13.702767f, 10.197294f, -41.236305f, -3.082862f, 0.000000f, 1.657094f },
        new[] { 13.086977f, 10.197294f, -40.903435f, -3.078954f, 0.000000f, 1.664345f },
        new[] { 12.472089f, 10.197294f, -40.568901f, -3.074442f, 0.000000f, 1.672665f },
        new[] { 11.858250f, 10.197294f, -40.232449f, -3.069196f, 0.000000f, 1.682271f },
        new[] { 11.245640f, 10.197294f, -39.893761f, -3.063048f, 0.000000f, 1.693439f },
        new[] { 10.634483f, 10.197294f, -39.552460f, -3.055783f, 0.000000f, 1.706514f },
        new[] { 10.025061f, 10.197294f, -39.208069f, -3.047112f, 0.000000f, 1.721948f },
        new[] { 9.417730f, 10.197294f, -38.860004f, -3.036654f, 0.000000f, 1.740326f },
        new[] { 8.812954f, 10.197294f, -38.507519f, -3.023880f, 0.000000f, 1.762429f },
        new[] { 8.211343f, 10.197294f, -38.149658f, -3.008055f, 0.000000f, 1.789302f },
        new[] { 7.613717f, 10.197294f, -37.785183f, -2.988129f, 0.000000f, 1.822385f },
        new[] { 7.021209f, 10.197294f, -37.412445f, -2.962540f, 0.000000f, 1.863695f },
        new[] { 6.435429f, 10.197294f, -37.029221f, -2.928901f, 0.000000f, 1.916126f },
        new[] { 5.858753f, 10.197294f, -36.632427f, -2.883380f, 0.000000f, 1.983965f },
        new[] { 5.294861f, 10.197294f, -36.217667f, -2.819461f, 0.000000f, 2.073798f },
        new[] { 4.749827f, 10.197294f, -35.778419f, -2.725170f, 0.000000f, 2.196236f },
        new[] { 4.234636f, 10.197294f, -35.304523f, -2.575954f, 0.000000f, 2.369486f },
        new[] { 3.772264f, 10.197294f, -34.778965f, -2.311863f, 0.000000f, 2.627792f },
        new[] { 3.428036f, 10.197294f, -34.169453f, -1.721137f, 0.000000f, 3.047571f },
        new[] { 3.033963f, 10.197294f, -33.590916f, -1.970364f, 0.000000f, 2.892692f },
        new[] { 2.656040f, 10.197294f, -33.001701f, -1.889616f, 0.000000f, 2.946074f },
        new[] { 2.307335f, 10.197294f, -32.394737f, -1.743529f, 0.000000f, 3.034816f },
        new[] { 2.021275f, 10.197294f, -31.755856f, -1.430300f, 0.000000f, 3.194408f },
        new[] { 1.935164f, 10.197294f, -31.061172f, -0.430555f, 0.000000f, 3.473417f },
        new[] { 1.847493f, 10.197294f, -30.366684f, -0.438351f, 0.000000f, 3.472441f },
        new[] { 1.943488f, 10.197294f, -29.673298f, 0.479975f, 0.000000f, 3.466933f },
        new[] { 2.170555f, 10.197294f, -29.011150f, 1.135336f, 0.000000f, 3.310742f },
        new[] { 2.415170f, 10.197294f, -28.355282f, 1.223072f, 0.000000f, 3.279344f },
        new[] { 2.677041f, 10.197294f, -27.706110f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 2.938912f, 10.197294f, -27.056938f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.200784f, 10.197294f, -26.407766f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 3.462655f, 10.197294f, -25.758595f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.724526f, 10.197294f, -25.109423f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.986398f, 10.197294f, -24.460251f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 4.248269f, 10.197294f, -23.811079f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.510140f, 10.197294f, -23.161907f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.772012f, 10.197294f, -22.512735f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 5.033883f, 10.197294f, -21.863564f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.295755f, 10.197294f, -21.214392f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.557627f, 10.197294f, -20.565220f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.819499f, 10.197294f, -19.916048f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.081370f, 10.197294f, -19.266876f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.322058f, 10.197294f, -18.670219f, 1.203439f, 0.000000f, 2.983284f },
        new[] { 6.372280f, 10.197294f, -18.330706f, -0.014387f, 0.000000f, 1.339125f },
        new[] { 6.398773f, 10.197294f, -18.310312f, 0.124516f, 0.000000f, -0.004893f },
        new[] { 6.415949f, 10.197294f, -18.317240f, 0.085881f, 0.000000f, -0.034633f },
        new[] { 6.428115f, 10.197294f, -18.322145f, 0.060833f, 0.000000f, -0.024530f },
        new[] { 6.436733f, 10.197294f, -18.325621f, 0.043090f, 0.000000f, -0.017376f },
        new[] { 6.442838f, 10.197294f, -18.328083f, 0.030522f, 0.000000f, -0.012308f },
        new[] { 6.447162f, 10.197294f, -18.329826f, 0.021620f, 0.000000f, -0.008717f },
        new[] { 6.450224f, 10.197294f, -18.331062f, 0.015314f, 0.000000f, -0.006175f },
        new[] { 6.450224f, 10.197294f, -18.331062f, 0.000000f, 0.000000f, 0.000000f }
    };

    static readonly float[][] EXPECTED_A1Q0TVT =
    {
        new[] { 22.322426f, 10.197294f, -45.771397f, -3.107285f, 0.000000f, 1.610831f },
        new[] { 21.754303f, 10.197294f, -45.476715f, -3.106887f, 0.000000f, 1.611599f },
        new[] { 21.133097f, 10.197294f, -45.154068f, -3.106033f, 0.000000f, 1.613245f },
        new[] { 20.512094f, 10.197294f, -44.831028f, -3.105014f, 0.000000f, 1.615205f },
        new[] { 19.891315f, 10.197294f, -44.507557f, -3.103898f, 0.000000f, 1.617350f },
        new[] { 19.270782f, 10.197294f, -44.183617f, -3.102670f, 0.000000f, 1.619704f },
        new[] { 18.650520f, 10.197294f, -43.859158f, -3.101315f, 0.000000f, 1.622296f },
        new[] { 18.030558f, 10.197294f, -43.534126f, -3.099816f, 0.000000f, 1.625158f },
        new[] { 17.410927f, 10.197294f, -43.208462f, -3.098152f, 0.000000f, 1.628329f },
        new[] { 16.791668f, 10.197294f, -42.882092f, -3.096297f, 0.000000f, 1.631854f },
        new[] { 16.172823f, 10.197294f, -42.554935f, -3.094221f, 0.000000f, 1.635786f },
        new[] { 15.554445f, 10.197294f, -42.226898f, -3.091888f, 0.000000f, 1.640191f },
        new[] { 14.936594f, 10.197294f, -41.897869f, -3.089255f, 0.000000f, 1.645145f },
        new[] { 14.319340f, 10.197294f, -41.567722f, -3.086269f, 0.000000f, 1.650741f },
        new[] { 13.702767f, 10.197294f, -41.236305f, -3.082862f, 0.000000f, 1.657094f },
        new[] { 13.086977f, 10.197294f, -40.903435f, -3.078953f, 0.000000f, 1.664345f },
        new[] { 12.472089f, 10.197294f, -40.568901f, -3.074442f, 0.000000f, 1.672665f },
        new[] { 11.858250f, 10.197294f, -40.232449f, -3.069196f, 0.000000f, 1.682271f },
        new[] { 11.245640f, 10.197294f, -39.893761f, -3.063048f, 0.000000f, 1.693439f },
        new[] { 10.634483f, 10.197294f, -39.552460f, -3.055783f, 0.000000f, 1.706514f },
        new[] { 10.025061f, 10.197294f, -39.208069f, -3.047112f, 0.000000f, 1.721948f },
        new[] { 9.417730f, 10.197294f, -38.860004f, -3.036654f, 0.000000f, 1.740326f },
        new[] { 8.812955f, 10.197294f, -38.507519f, -3.023879f, 0.000000f, 1.762429f },
        new[] { 8.211344f, 10.197294f, -38.149658f, -3.008055f, 0.000000f, 1.789302f },
        new[] { 7.613718f, 10.197294f, -37.785183f, -2.988129f, 0.000000f, 1.822385f },
        new[] { 7.021210f, 10.197294f, -37.412445f, -2.962540f, 0.000000f, 1.863695f },
        new[] { 6.435430f, 10.197294f, -37.029221f, -2.928901f, 0.000000f, 1.916126f },
        new[] { 5.858754f, 10.197294f, -36.632427f, -2.883381f, 0.000000f, 1.983965f },
        new[] { 5.294862f, 10.197294f, -36.217667f, -2.819461f, 0.000000f, 2.073798f },
        new[] { 4.749828f, 10.197294f, -35.778419f, -2.725170f, 0.000000f, 2.196235f },
        new[] { 4.234637f, 10.197294f, -35.304523f, -2.575955f, 0.000000f, 2.369484f },
        new[] { 3.772264f, 10.197294f, -34.778965f, -2.311864f, 0.000000f, 2.627791f },
        new[] { 3.428036f, 10.197294f, -34.169453f, -1.721139f, 0.000000f, 3.047570f },
        new[] { 3.033963f, 10.197294f, -33.590916f, -1.970364f, 0.000000f, 2.892692f },
        new[] { 2.656040f, 10.197294f, -33.001701f, -1.889616f, 0.000000f, 2.946074f },
        new[] { 2.307335f, 10.197294f, -32.394737f, -1.743529f, 0.000000f, 3.034816f },
        new[] { 2.021275f, 10.197294f, -31.755856f, -1.430300f, 0.000000f, 3.194408f },
        new[] { 1.935164f, 10.197294f, -31.061172f, -0.430555f, 0.000000f, 3.473417f },
        new[] { 1.847493f, 10.197294f, -30.366684f, -0.438351f, 0.000000f, 3.472441f },
        new[] { 1.943488f, 10.197294f, -29.673298f, 0.479975f, 0.000000f, 3.466933f },
        new[] { 2.170555f, 10.197294f, -29.011150f, 1.135336f, 0.000000f, 3.310742f },
        new[] { 2.415170f, 10.197294f, -28.355282f, 1.223072f, 0.000000f, 3.279344f },
        new[] { 2.677041f, 10.197294f, -27.706110f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 2.938912f, 10.197294f, -27.056938f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.200784f, 10.197294f, -26.407766f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 3.462655f, 10.197294f, -25.758595f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.724526f, 10.197294f, -25.109423f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.986398f, 10.197294f, -24.460251f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 4.248269f, 10.197294f, -23.811079f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.510140f, 10.197294f, -23.161907f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.772012f, 10.197294f, -22.512735f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.033883f, 10.197294f, -21.863564f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.295755f, 10.197294f, -21.214392f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.557627f, 10.197294f, -20.565220f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.819499f, 10.197294f, -19.916048f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.081370f, 10.197294f, -19.266876f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.300874f, 10.197294f, -18.722734f, 1.097519f, 0.000000f, 2.720711f },
        new[] { 6.400665f, 10.197294f, -18.475355f, 0.457299f, 0.000000f, 1.133632f },
        new[] { 6.433914f, 10.197294f, -18.392933f, 0.166243f, 0.000000f, 0.412109f },
        new[] { 6.447767f, 10.197294f, -18.358591f, 0.069268f, 0.000000f, 0.171711f },
        new[] { 6.453539f, 10.197294f, -18.344282f, 0.028861f, 0.000000f, 0.071547f },
        new[] { 6.455945f, 10.197294f, -18.338320f, 0.012026f, 0.000000f, 0.029813f },
        new[] { 6.455945f, 10.197294f, -18.338320f, 0.000000f, 0.000000f, 0.000000f }
    };

    static readonly float[][] EXPECTED_A1Q0TV =
    {
        new[] { 22.333418f, 10.197294f, -45.751896f, -2.987050f, 0.000000f, 1.824153f },
        new[] { 21.787214f, 10.197294f, -45.418335f, -2.987049f, 0.000000f, 1.824153f },
        new[] { 21.189804f, 10.197294f, -45.053505f, -2.987050f, 0.000000f, 1.824153f },
        new[] { 20.592394f, 10.197294f, -44.688675f, -2.987049f, 0.000000f, 1.824153f },
        new[] { 19.994984f, 10.197294f, -44.323845f, -2.987049f, 0.000000f, 1.824153f },
        new[] { 19.397573f, 10.197294f, -43.959015f, -2.987049f, 0.000000f, 1.824154f },
        new[] { 18.800163f, 10.197294f, -43.594185f, -2.987049f, 0.000000f, 1.824154f },
        new[] { 18.202753f, 10.197294f, -43.229355f, -2.987049f, 0.000000f, 1.824154f },
        new[] { 17.605343f, 10.197294f, -42.864525f, -2.987049f, 0.000000f, 1.824154f },
        new[] { 17.007933f, 10.197294f, -42.499695f, -2.987049f, 0.000000f, 1.824154f },
        new[] { 16.410522f, 10.197294f, -42.134865f, -2.987049f, 0.000000f, 1.824155f },
        new[] { 15.813112f, 10.197294f, -41.770035f, -2.987049f, 0.000000f, 1.824155f },
        new[] { 15.215703f, 10.197294f, -41.405205f, -2.987048f, 0.000000f, 1.824155f },
        new[] { 14.618294f, 10.197294f, -41.040375f, -2.987048f, 0.000000f, 1.824155f },
        new[] { 14.020885f, 10.197294f, -40.675545f, -2.987048f, 0.000000f, 1.824155f },
        new[] { 13.423475f, 10.197294f, -40.310715f, -2.987048f, 0.000000f, 1.824155f },
        new[] { 12.826066f, 10.197294f, -39.945885f, -2.987048f, 0.000000f, 1.824156f },
        new[] { 12.228657f, 10.197294f, -39.581055f, -2.987048f, 0.000000f, 1.824156f },
        new[] { 11.631248f, 10.197294f, -39.216225f, -2.987048f, 0.000000f, 1.824156f },
        new[] { 11.033838f, 10.197294f, -38.851395f, -2.987048f, 0.000000f, 1.824156f },
        new[] { 10.436429f, 10.197294f, -38.486565f, -2.987047f, 0.000000f, 1.824157f },
        new[] { 9.839020f, 10.197294f, -38.121735f, -2.987047f, 0.000000f, 1.824157f },
        new[] { 9.241611f, 10.197294f, -37.756905f, -2.987047f, 0.000000f, 1.824157f },
        new[] { 8.644201f, 10.197294f, -37.392075f, -2.987047f, 0.000000f, 1.824158f },
        new[] { 8.046792f, 10.197294f, -37.027245f, -2.987046f, 0.000000f, 1.824158f },
        new[] { 7.449383f, 10.197294f, -36.662415f, -2.987046f, 0.000000f, 1.824160f },
        new[] { 6.851974f, 10.197294f, -36.297581f, -2.987045f, 0.000000f, 1.824160f },
        new[] { 6.254564f, 10.197294f, -35.932751f, -2.987046f, 0.000000f, 1.824159f },
        new[] { 5.657155f, 10.197294f, -35.567917f, -2.987045f, 0.000000f, 1.824161f },
        new[] { 5.059746f, 10.197294f, -35.203087f, -2.987046f, 0.000000f, 1.824160f },
        new[] { 4.462337f, 10.197294f, -34.838253f, -2.987044f, 0.000000f, 1.824162f },
        new[] { 3.864928f, 10.197294f, -34.473423f, -2.987046f, 0.000000f, 1.824159f },
        new[] { 3.267520f, 10.197294f, -34.108589f, -2.987040f, 0.000000f, 1.824169f },
        new[] { 2.910351f, 10.197294f, -33.532368f, -1.429270f, 0.000000f, 3.194869f },
        new[] { 2.648150f, 10.197294f, -32.883331f, -1.311005f, 0.000000f, 3.245191f },
        new[] { 2.385949f, 10.197294f, -32.234291f, -1.311003f, 0.000000f, 3.245192f },
        new[] { 2.123748f, 10.197294f, -31.585253f, -1.311006f, 0.000000f, 3.245191f },
        new[] { 1.861547f, 10.197294f, -30.936214f, -1.311005f, 0.000000f, 3.245191f },
        new[] { 1.916189f, 10.197294f, -30.242338f, 0.359062f, 0.000000f, 3.481533f },
        new[] { 2.011134f, 10.197294f, -29.548807f, 0.474725f, 0.000000f, 3.467656f },
        new[] { 2.246398f, 10.197294f, -28.889526f, 1.176323f, 0.000000f, 3.296402f },
        new[] { 2.481663f, 10.197294f, -28.230246f, 1.176324f, 0.000000f, 3.296402f },
        new[] { 2.716928f, 10.197294f, -27.570965f, 1.176325f, 0.000000f, 3.296401f },
        new[] { 2.979683f, 10.197294f, -26.922150f, 1.313774f, 0.000000f, 3.244071f },
        new[] { 3.242438f, 10.197294f, -26.273335f, 1.313774f, 0.000000f, 3.244071f },
        new[] { 3.505193f, 10.197294f, -25.624521f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 3.767948f, 10.197294f, -24.975708f, 1.313774f, 0.000000f, 3.244071f },
        new[] { 4.030703f, 10.197294f, -24.326893f, 1.313774f, 0.000000f, 3.244071f },
        new[] { 4.293458f, 10.197294f, -23.678078f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 4.556212f, 10.197294f, -23.029263f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 4.818967f, 10.197294f, -22.380449f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 5.081722f, 10.197294f, -21.731636f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 5.344477f, 10.197294f, -21.082821f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 5.607232f, 10.197294f, -20.434008f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 5.869987f, 10.197294f, -19.785194f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 6.132742f, 10.197294f, -19.136379f, 1.313774f, 0.000000f, 3.244071f },
        new[] { 6.322279f, 10.197294f, -18.668360f, 0.947685f, 0.000000f, 2.340096f },
        new[] { 6.401253f, 10.197294f, -18.473352f, 0.394869f, 0.000000f, 0.975039f },
        new[] { 6.434158f, 10.197294f, -18.392099f, 0.164529f, 0.000000f, 0.406268f },
        new[] { 6.447869f, 10.197294f, -18.358244f, 0.068554f, 0.000000f, 0.169280f },
        new[] { 6.453582f, 10.197294f, -18.344137f, 0.028564f, 0.000000f, 0.070535f },
        new[] { 6.455962f, 10.197294f, -18.338259f, 0.011902f, 0.000000f, 0.029390f },
        new[] { 6.455962f, 10.197294f, -18.338259f, 0.000000f, 0.000000f, 0.000000f }
    };

    static readonly float[][] EXPECTED_A1Q0T =
    {
        new[] { 22.333418f, 10.197294f, -45.751896f, -2.987050f, 0.000000f, 1.824153f },
        new[] { 21.787214f, 10.197294f, -45.418335f, -2.987049f, 0.000000f, 1.824153f },
        new[] { 21.189804f, 10.197294f, -45.053505f, -2.987050f, 0.000000f, 1.824153f },
        new[] { 20.592394f, 10.197294f, -44.688675f, -2.987049f, 0.000000f, 1.824153f },
        new[] { 19.994984f, 10.197294f, -44.323845f, -2.987049f, 0.000000f, 1.824153f },
        new[] { 19.397573f, 10.197294f, -43.959015f, -2.987049f, 0.000000f, 1.824154f },
        new[] { 18.800163f, 10.197294f, -43.594185f, -2.987049f, 0.000000f, 1.824154f },
        new[] { 18.202753f, 10.197294f, -43.229355f, -2.987049f, 0.000000f, 1.824154f },
        new[] { 17.605343f, 10.197294f, -42.864525f, -2.987049f, 0.000000f, 1.824154f },
        new[] { 17.007933f, 10.197294f, -42.499695f, -2.987049f, 0.000000f, 1.824154f },
        new[] { 16.410522f, 10.197294f, -42.134865f, -2.987049f, 0.000000f, 1.824155f },
        new[] { 15.813112f, 10.197294f, -41.770035f, -2.987049f, 0.000000f, 1.824155f },
        new[] { 15.215703f, 10.197294f, -41.405205f, -2.987048f, 0.000000f, 1.824155f },
        new[] { 14.618294f, 10.197294f, -41.040375f, -2.987048f, 0.000000f, 1.824155f },
        new[] { 14.020885f, 10.197294f, -40.675545f, -2.987048f, 0.000000f, 1.824155f },
        new[] { 13.423475f, 10.197294f, -40.310715f, -2.987048f, 0.000000f, 1.824155f },
        new[] { 12.826066f, 10.197294f, -39.945885f, -2.987048f, 0.000000f, 1.824156f },
        new[] { 12.228657f, 10.197294f, -39.581055f, -2.987048f, 0.000000f, 1.824156f },
        new[] { 11.631248f, 10.197294f, -39.216225f, -2.987048f, 0.000000f, 1.824156f },
        new[] { 11.033838f, 10.197294f, -38.851395f, -2.987048f, 0.000000f, 1.824156f },
        new[] { 10.436429f, 10.197294f, -38.486565f, -2.987047f, 0.000000f, 1.824157f },
        new[] { 9.839020f, 10.197294f, -38.121735f, -2.987047f, 0.000000f, 1.824157f },
        new[] { 9.241611f, 10.197294f, -37.756905f, -2.987047f, 0.000000f, 1.824157f },
        new[] { 8.644201f, 10.197294f, -37.392075f, -2.987047f, 0.000000f, 1.824158f },
        new[] { 8.046792f, 10.197294f, -37.027245f, -2.987046f, 0.000000f, 1.824158f },
        new[] { 7.449383f, 10.197294f, -36.662415f, -2.987046f, 0.000000f, 1.824160f },
        new[] { 6.851974f, 10.197294f, -36.297581f, -2.987045f, 0.000000f, 1.824160f },
        new[] { 6.254564f, 10.197294f, -35.932751f, -2.987046f, 0.000000f, 1.824159f },
        new[] { 5.657155f, 10.197294f, -35.567917f, -2.987045f, 0.000000f, 1.824161f },
        new[] { 5.059746f, 10.197294f, -35.203087f, -2.987046f, 0.000000f, 1.824160f },
        new[] { 4.462337f, 10.197294f, -34.838253f, -2.987044f, 0.000000f, 1.824162f },
        new[] { 3.864928f, 10.197294f, -34.473423f, -2.987046f, 0.000000f, 1.824159f },
        new[] { 3.267520f, 10.197294f, -34.108589f, -2.987040f, 0.000000f, 1.824169f },
        new[] { 2.910351f, 10.197294f, -33.532368f, -1.429270f, 0.000000f, 3.194869f },
        new[] { 2.648150f, 10.197294f, -32.883331f, -1.311005f, 0.000000f, 3.245191f },
        new[] { 2.385949f, 10.197294f, -32.234291f, -1.311003f, 0.000000f, 3.245192f },
        new[] { 2.123748f, 10.197294f, -31.585253f, -1.311006f, 0.000000f, 3.245191f },
        new[] { 1.861547f, 10.197294f, -30.936214f, -1.311005f, 0.000000f, 3.245191f },
        new[] { 1.916189f, 10.197294f, -30.242338f, 0.359062f, 0.000000f, 3.481533f },
        new[] { 2.011134f, 10.197294f, -29.548807f, 0.474725f, 0.000000f, 3.467656f },
        new[] { 2.246398f, 10.197294f, -28.889526f, 1.176323f, 0.000000f, 3.296402f },
        new[] { 2.481663f, 10.197294f, -28.230246f, 1.176324f, 0.000000f, 3.296402f },
        new[] { 2.716928f, 10.197294f, -27.570965f, 1.176325f, 0.000000f, 3.296401f },
        new[] { 2.979683f, 10.197294f, -26.922150f, 1.313774f, 0.000000f, 3.244071f },
        new[] { 3.242438f, 10.197294f, -26.273335f, 1.313774f, 0.000000f, 3.244071f },
        new[] { 3.505193f, 10.197294f, -25.624521f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 3.767948f, 10.197294f, -24.975708f, 1.313774f, 0.000000f, 3.244071f },
        new[] { 4.030703f, 10.197294f, -24.326893f, 1.313774f, 0.000000f, 3.244071f },
        new[] { 4.293458f, 10.197294f, -23.678078f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 4.556212f, 10.197294f, -23.029263f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 4.818967f, 10.197294f, -22.380449f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 5.081722f, 10.197294f, -21.731636f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 5.344477f, 10.197294f, -21.082821f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 5.607232f, 10.197294f, -20.434008f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 5.869987f, 10.197294f, -19.785194f, 1.313775f, 0.000000f, 3.244071f },
        new[] { 6.132742f, 10.197294f, -19.136379f, 1.313774f, 0.000000f, 3.244071f },
        new[] { 6.322279f, 10.197294f, -18.668360f, 0.947685f, 0.000000f, 2.340096f },
        new[] { 6.401253f, 10.197294f, -18.473352f, 0.394869f, 0.000000f, 0.975039f },
        new[] { 6.434158f, 10.197294f, -18.392099f, 0.164529f, 0.000000f, 0.406268f },
        new[] { 6.447869f, 10.197294f, -18.358244f, 0.068554f, 0.000000f, 0.169280f },
        new[] { 6.453582f, 10.197294f, -18.344137f, 0.028564f, 0.000000f, 0.070535f },
        new[] { 6.455962f, 10.197294f, -18.338259f, 0.011902f, 0.000000f, 0.029390f },
        new[] { 6.455962f, 10.197294f, -18.338259f, 0.000000f, 0.000000f, 0.000000f }
    };

    static readonly float[][] EXPECTED_A1Q1TVTA =
    {
        new[] { 22.322426f, 10.197294f, -45.771397f, -3.107285f, 0.000000f, 1.610831f },
        new[] { 21.754303f, 10.197294f, -45.476715f, -3.106887f, 0.000000f, 1.611599f },
        new[] { 21.133097f, 10.197294f, -45.154068f, -3.106033f, 0.000000f, 1.613245f },
        new[] { 20.512094f, 10.197294f, -44.831028f, -3.105014f, 0.000000f, 1.615205f },
        new[] { 19.891315f, 10.197294f, -44.507557f, -3.103898f, 0.000000f, 1.617350f },
        new[] { 19.270782f, 10.197294f, -44.183617f, -3.102670f, 0.000000f, 1.619704f },
        new[] { 18.650520f, 10.197294f, -43.859158f, -3.101315f, 0.000000f, 1.622296f },
        new[] { 18.030558f, 10.197294f, -43.534126f, -3.099816f, 0.000000f, 1.625158f },
        new[] { 17.410927f, 10.197294f, -43.208462f, -3.098152f, 0.000000f, 1.628329f },
        new[] { 16.791668f, 10.197294f, -42.882092f, -3.096297f, 0.000000f, 1.631854f },
        new[] { 16.172823f, 10.197294f, -42.554935f, -3.094221f, 0.000000f, 1.635786f },
        new[] { 15.554445f, 10.197294f, -42.226898f, -3.091888f, 0.000000f, 1.640191f },
        new[] { 14.936594f, 10.197294f, -41.897869f, -3.089255f, 0.000000f, 1.645145f },
        new[] { 14.319340f, 10.197294f, -41.567722f, -3.086269f, 0.000000f, 1.650741f },
        new[] { 13.702767f, 10.197294f, -41.236305f, -3.082862f, 0.000000f, 1.657094f },
        new[] { 13.086977f, 10.197294f, -40.903435f, -3.078954f, 0.000000f, 1.664345f },
        new[] { 12.472089f, 10.197294f, -40.568901f, -3.074442f, 0.000000f, 1.672665f },
        new[] { 11.858250f, 10.197294f, -40.232449f, -3.069196f, 0.000000f, 1.682271f },
        new[] { 11.245640f, 10.197294f, -39.893761f, -3.063048f, 0.000000f, 1.693439f },
        new[] { 10.634483f, 10.197294f, -39.552460f, -3.055783f, 0.000000f, 1.706514f },
        new[] { 10.025061f, 10.197294f, -39.208069f, -3.047112f, 0.000000f, 1.721948f },
        new[] { 9.417730f, 10.197294f, -38.860004f, -3.036654f, 0.000000f, 1.740326f },
        new[] { 8.812954f, 10.197294f, -38.507519f, -3.023880f, 0.000000f, 1.762429f },
        new[] { 8.211343f, 10.197294f, -38.149658f, -3.008055f, 0.000000f, 1.789302f },
        new[] { 7.613717f, 10.197294f, -37.785183f, -2.988129f, 0.000000f, 1.822385f },
        new[] { 7.021209f, 10.197294f, -37.412445f, -2.962540f, 0.000000f, 1.863695f },
        new[] { 6.435429f, 10.197294f, -37.029221f, -2.928901f, 0.000000f, 1.916126f },
        new[] { 5.858753f, 10.197294f, -36.632427f, -2.883380f, 0.000000f, 1.983965f },
        new[] { 5.294861f, 10.197294f, -36.217667f, -2.819461f, 0.000000f, 2.073798f },
        new[] { 4.749827f, 10.197294f, -35.778419f, -2.725170f, 0.000000f, 2.196236f },
        new[] { 4.234636f, 10.197294f, -35.304523f, -2.575954f, 0.000000f, 2.369486f },
        new[] { 3.772264f, 10.197294f, -34.778965f, -2.311863f, 0.000000f, 2.627792f },
        new[] { 3.428036f, 10.197294f, -34.169453f, -1.721137f, 0.000000f, 3.047571f },
        new[] { 3.033963f, 10.197294f, -33.590916f, -1.970364f, 0.000000f, 2.892692f },
        new[] { 2.656040f, 10.197294f, -33.001701f, -1.889616f, 0.000000f, 2.946074f },
        new[] { 2.307335f, 10.197294f, -32.394737f, -1.743529f, 0.000000f, 3.034816f },
        new[] { 2.021275f, 10.197294f, -31.755856f, -1.430300f, 0.000000f, 3.194408f },
        new[] { 1.935164f, 10.197294f, -31.061172f, -0.430555f, 0.000000f, 3.473417f },
        new[] { 1.847493f, 10.197294f, -30.366684f, -0.438351f, 0.000000f, 3.472441f },
        new[] { 1.943488f, 10.197294f, -29.673298f, 0.479975f, 0.000000f, 3.466933f },
        new[] { 2.170555f, 10.197294f, -29.011150f, 1.135336f, 0.000000f, 3.310742f },
        new[] { 2.415170f, 10.197294f, -28.355282f, 1.223072f, 0.000000f, 3.279344f },
        new[] { 2.677041f, 10.197294f, -27.706110f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 2.938912f, 10.197294f, -27.056938f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.200784f, 10.197294f, -26.407766f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 3.462655f, 10.197294f, -25.758595f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.724526f, 10.197294f, -25.109423f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.986398f, 10.197294f, -24.460251f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 4.248269f, 10.197294f, -23.811079f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.510140f, 10.197294f, -23.161907f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.772012f, 10.197294f, -22.512735f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 5.033883f, 10.197294f, -21.863564f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.295755f, 10.197294f, -21.214392f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.557627f, 10.197294f, -20.565220f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.819499f, 10.197294f, -19.916048f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.081370f, 10.197294f, -19.266876f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.322058f, 10.197294f, -18.670219f, 1.203439f, 0.000000f, 2.983284f },
        new[] { 6.429398f, 10.197294f, -18.364454f, 0.320910f, 0.000000f, 1.058088f },
        new[] { 6.437642f, 10.197294f, -18.355589f, 0.041219f, 0.000000f, 0.044324f },
        new[] { 6.443481f, 10.197294f, -18.349310f, 0.029197f, 0.000000f, 0.031395f },
        new[] { 6.447618f, 10.197294f, -18.344862f, 0.020681f, 0.000000f, 0.022238f },
        new[] { 6.450547f, 10.197294f, -18.341711f, 0.014649f, 0.000000f, 0.015752f },
        new[] { 6.452622f, 10.197294f, -18.339479f, 0.010377f, 0.000000f, 0.011157f },
        new[] { 6.452622f, 10.197294f, -18.339479f, 0.000000f, 0.000000f, 0.000000f },
    };

    static readonly float[][] EXPECTED_A1Q2TVTA =
    {
        new[] { 22.322426f, 10.197294f, -45.771397f, -3.107285f, 0.000000f, 1.610831f },
        new[] { 21.754303f, 10.197294f, -45.476715f, -3.106887f, 0.000000f, 1.611599f },
        new[] { 21.133097f, 10.197294f, -45.154068f, -3.106033f, 0.000000f, 1.613245f },
        new[] { 20.512094f, 10.197294f, -44.831028f, -3.105014f, 0.000000f, 1.615205f },
        new[] { 19.891315f, 10.197294f, -44.507557f, -3.103898f, 0.000000f, 1.617350f },
        new[] { 19.270782f, 10.197294f, -44.183617f, -3.102670f, 0.000000f, 1.619704f },
        new[] { 18.650520f, 10.197294f, -43.859158f, -3.101315f, 0.000000f, 1.622296f },
        new[] { 18.030558f, 10.197294f, -43.534126f, -3.099816f, 0.000000f, 1.625158f },
        new[] { 17.410927f, 10.197294f, -43.208462f, -3.098152f, 0.000000f, 1.628329f },
        new[] { 16.791668f, 10.197294f, -42.882092f, -3.096297f, 0.000000f, 1.631854f },
        new[] { 16.172823f, 10.197294f, -42.554935f, -3.094221f, 0.000000f, 1.635786f },
        new[] { 15.554445f, 10.197294f, -42.226898f, -3.091888f, 0.000000f, 1.640191f },
        new[] { 14.936594f, 10.197294f, -41.897869f, -3.089255f, 0.000000f, 1.645145f },
        new[] { 14.319340f, 10.197294f, -41.567722f, -3.086269f, 0.000000f, 1.650741f },
        new[] { 13.702767f, 10.197294f, -41.236305f, -3.082862f, 0.000000f, 1.657094f },
        new[] { 13.086977f, 10.197294f, -40.903435f, -3.078954f, 0.000000f, 1.664345f },
        new[] { 12.472089f, 10.197294f, -40.568901f, -3.074442f, 0.000000f, 1.672665f },
        new[] { 11.858250f, 10.197294f, -40.232449f, -3.069196f, 0.000000f, 1.682271f },
        new[] { 11.245640f, 10.197294f, -39.893761f, -3.063048f, 0.000000f, 1.693439f },
        new[] { 10.634483f, 10.197294f, -39.552460f, -3.055783f, 0.000000f, 1.706514f },
        new[] { 10.025061f, 10.197294f, -39.208069f, -3.047112f, 0.000000f, 1.721948f },
        new[] { 9.417730f, 10.197294f, -38.860004f, -3.036654f, 0.000000f, 1.740326f },
        new[] { 8.812954f, 10.197294f, -38.507519f, -3.023880f, 0.000000f, 1.762429f },
        new[] { 8.211343f, 10.197294f, -38.149658f, -3.008055f, 0.000000f, 1.789302f },
        new[] { 7.613717f, 10.197294f, -37.785183f, -2.988129f, 0.000000f, 1.822385f },
        new[] { 7.021209f, 10.197294f, -37.412445f, -2.962540f, 0.000000f, 1.863695f },
        new[] { 6.435429f, 10.197294f, -37.029221f, -2.928901f, 0.000000f, 1.916126f },
        new[] { 5.858753f, 10.197294f, -36.632427f, -2.883380f, 0.000000f, 1.983965f },
        new[] { 5.294861f, 10.197294f, -36.217667f, -2.819461f, 0.000000f, 2.073798f },
        new[] { 4.749827f, 10.197294f, -35.778419f, -2.725170f, 0.000000f, 2.196236f },
        new[] { 4.234636f, 10.197294f, -35.304523f, -2.575954f, 0.000000f, 2.369486f },
        new[] { 3.772264f, 10.197294f, -34.778965f, -2.311863f, 0.000000f, 2.627792f },
        new[] { 3.428036f, 10.197294f, -34.169453f, -1.721137f, 0.000000f, 3.047571f },
        new[] { 3.033963f, 10.197294f, -33.590916f, -1.970364f, 0.000000f, 2.892692f },
        new[] { 2.656040f, 10.197294f, -33.001701f, -1.889616f, 0.000000f, 2.946074f },
        new[] { 2.307335f, 10.197294f, -32.394737f, -1.743529f, 0.000000f, 3.034816f },
        new[] { 2.021275f, 10.197294f, -31.755856f, -1.430300f, 0.000000f, 3.194408f },
        new[] { 1.935164f, 10.197294f, -31.061172f, -0.430555f, 0.000000f, 3.473417f },
        new[] { 1.847493f, 10.197294f, -30.366684f, -0.438351f, 0.000000f, 3.472441f },
        new[] { 1.943488f, 10.197294f, -29.673298f, 0.479975f, 0.000000f, 3.466933f },
        new[] { 2.170555f, 10.197294f, -29.011150f, 1.135336f, 0.000000f, 3.310742f },
        new[] { 2.415170f, 10.197294f, -28.355282f, 1.223072f, 0.000000f, 3.279344f },
        new[] { 2.677041f, 10.197294f, -27.706110f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 2.938912f, 10.197294f, -27.056938f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.200784f, 10.197294f, -26.407766f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 3.462655f, 10.197294f, -25.758595f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.724526f, 10.197294f, -25.109423f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.986398f, 10.197294f, -24.460251f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 4.248269f, 10.197294f, -23.811079f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.510140f, 10.197294f, -23.161907f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.772012f, 10.197294f, -22.512735f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 5.033883f, 10.197294f, -21.863564f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.295755f, 10.197294f, -21.214392f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.557627f, 10.197294f, -20.565220f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.819499f, 10.197294f, -19.916048f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.081370f, 10.197294f, -19.266876f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.305691f, 10.197294f, -18.710793f, 1.121604f, 0.000000f, 2.780417f },
        new[] { 6.420408f, 10.197294f, -18.455353f, 0.541385f, 0.000000f, 1.188869f },
        new[] { 6.450006f, 10.197294f, -18.371796f, 0.147987f, 0.000000f, 0.417789f },
        new[] { 6.452239f, 10.197294f, -18.360790f, 0.011167f, 0.000000f, 0.055030f },
        new[] { 6.453821f, 10.197294f, -18.352995f, 0.007909f, 0.000000f, 0.038981f },
        new[] { 6.454941f, 10.197294f, -18.347473f, 0.005603f, 0.000000f, 0.027612f },
        new[] { 6.455735f, 10.197294f, -18.343561f, 0.003969f, 0.000000f, 0.019560f },
        new[] { 6.455735f, 10.197294f, -18.343561f, 0.000000f, 0.000000f, 0.000000f },
    };

    static readonly float[][] EXPECTED_A1Q3TVTA =
    {
        new[] { 22.322426f, 10.197294f, -45.771397f, -3.107285f, 0.000000f, 1.610831f },
        new[] { 21.754303f, 10.197294f, -45.476715f, -3.106887f, 0.000000f, 1.611599f },
        new[] { 21.133097f, 10.197294f, -45.154068f, -3.106033f, 0.000000f, 1.613245f },
        new[] { 20.512094f, 10.197294f, -44.831028f, -3.105014f, 0.000000f, 1.615205f },
        new[] { 19.891315f, 10.197294f, -44.507557f, -3.103898f, 0.000000f, 1.617350f },
        new[] { 19.270782f, 10.197294f, -44.183617f, -3.102670f, 0.000000f, 1.619704f },
        new[] { 18.650520f, 10.197294f, -43.859158f, -3.101315f, 0.000000f, 1.622296f },
        new[] { 18.030558f, 10.197294f, -43.534126f, -3.099816f, 0.000000f, 1.625158f },
        new[] { 17.410927f, 10.197294f, -43.208462f, -3.098152f, 0.000000f, 1.628329f },
        new[] { 16.791668f, 10.197294f, -42.882092f, -3.096297f, 0.000000f, 1.631854f },
        new[] { 16.172823f, 10.197294f, -42.554935f, -3.094221f, 0.000000f, 1.635786f },
        new[] { 15.554445f, 10.197294f, -42.226898f, -3.091888f, 0.000000f, 1.640191f },
        new[] { 14.936594f, 10.197294f, -41.897869f, -3.089255f, 0.000000f, 1.645145f },
        new[] { 14.319340f, 10.197294f, -41.567722f, -3.086269f, 0.000000f, 1.650741f },
        new[] { 13.702767f, 10.197294f, -41.236305f, -3.082862f, 0.000000f, 1.657094f },
        new[] { 13.086977f, 10.197294f, -40.903435f, -3.078954f, 0.000000f, 1.664345f },
        new[] { 12.472089f, 10.197294f, -40.568901f, -3.074442f, 0.000000f, 1.672665f },
        new[] { 11.858250f, 10.197294f, -40.232449f, -3.069196f, 0.000000f, 1.682271f },
        new[] { 11.245640f, 10.197294f, -39.893761f, -3.063048f, 0.000000f, 1.693439f },
        new[] { 10.634483f, 10.197294f, -39.552460f, -3.055783f, 0.000000f, 1.706514f },
        new[] { 10.025061f, 10.197294f, -39.208069f, -3.047112f, 0.000000f, 1.721948f },
        new[] { 9.417730f, 10.197294f, -38.860004f, -3.036654f, 0.000000f, 1.740326f },
        new[] { 8.812954f, 10.197294f, -38.507519f, -3.023880f, 0.000000f, 1.762429f },
        new[] { 8.211343f, 10.197294f, -38.149658f, -3.008055f, 0.000000f, 1.789302f },
        new[] { 7.613717f, 10.197294f, -37.785183f, -2.988129f, 0.000000f, 1.822385f },
        new[] { 7.021209f, 10.197294f, -37.412445f, -2.962540f, 0.000000f, 1.863695f },
        new[] { 6.435429f, 10.197294f, -37.029221f, -2.928901f, 0.000000f, 1.916126f },
        new[] { 5.858753f, 10.197294f, -36.632427f, -2.883380f, 0.000000f, 1.983965f },
        new[] { 5.294861f, 10.197294f, -36.217667f, -2.819461f, 0.000000f, 2.073798f },
        new[] { 4.749827f, 10.197294f, -35.778419f, -2.725170f, 0.000000f, 2.196236f },
        new[] { 4.234636f, 10.197294f, -35.304523f, -2.575954f, 0.000000f, 2.369486f },
        new[] { 3.772264f, 10.197294f, -34.778965f, -2.311863f, 0.000000f, 2.627792f },
        new[] { 3.428036f, 10.197294f, -34.169453f, -1.721137f, 0.000000f, 3.047571f },
        new[] { 3.033963f, 10.197294f, -33.590916f, -1.970364f, 0.000000f, 2.892692f },
        new[] { 2.656040f, 10.197294f, -33.001701f, -1.889616f, 0.000000f, 2.946074f },
        new[] { 2.307335f, 10.197294f, -32.394737f, -1.743529f, 0.000000f, 3.034816f },
        new[] { 2.021275f, 10.197294f, -31.755856f, -1.430300f, 0.000000f, 3.194408f },
        new[] { 1.935164f, 10.197294f, -31.061172f, -0.430555f, 0.000000f, 3.473417f },
        new[] { 1.847493f, 10.197294f, -30.366684f, -0.438351f, 0.000000f, 3.472441f },
        new[] { 1.943488f, 10.197294f, -29.673298f, 0.479975f, 0.000000f, 3.466933f },
        new[] { 2.170555f, 10.197294f, -29.011150f, 1.135336f, 0.000000f, 3.310742f },
        new[] { 2.415170f, 10.197294f, -28.355282f, 1.223072f, 0.000000f, 3.279344f },
        new[] { 2.677041f, 10.197294f, -27.706110f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 2.938912f, 10.197294f, -27.056938f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.200784f, 10.197294f, -26.407766f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 3.462655f, 10.197294f, -25.758595f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.724526f, 10.197294f, -25.109423f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.986398f, 10.197294f, -24.460251f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 4.248269f, 10.197294f, -23.811079f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.510140f, 10.197294f, -23.161907f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.772012f, 10.197294f, -22.512735f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 5.033883f, 10.197294f, -21.863564f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.295755f, 10.197294f, -21.214392f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.557627f, 10.197294f, -20.565220f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.819499f, 10.197294f, -19.916048f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.081370f, 10.197294f, -19.266876f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.297070f, 10.197294f, -18.723810f, 1.078498f, 0.000000f, 2.715334f },
        new[] { 6.397289f, 10.197294f, -18.479179f, 0.456429f, 0.000000f, 1.107728f },
        new[] { 6.439916f, 10.197294f, -18.384853f, 0.213137f, 0.000000f, 0.471627f },
        new[] { 6.454712f, 10.197294f, -18.342505f, 0.073981f, 0.000000f, 0.211745f },
        new[] { 6.454712f, 10.197294f, -18.342505f, 0.000000f, 0.000000f, 0.000000f }
    };

    static readonly float[][] EXPECTED_A1Q3TVTAS =
    {
        new[] { 22.322426f, 10.197294f, -45.771397f, -3.107285f, 0.000000f, 1.610831f },
        new[] { 21.754303f, 10.197294f, -45.476715f, -3.106887f, 0.000000f, 1.611599f },
        new[] { 21.133097f, 10.197294f, -45.154068f, -3.106033f, 0.000000f, 1.613245f },
        new[] { 20.512094f, 10.197294f, -44.831028f, -3.105014f, 0.000000f, 1.615205f },
        new[] { 19.891315f, 10.197294f, -44.507557f, -3.103898f, 0.000000f, 1.617350f },
        new[] { 19.270782f, 10.197294f, -44.183617f, -3.102670f, 0.000000f, 1.619704f },
        new[] { 18.650520f, 10.197294f, -43.859158f, -3.101315f, 0.000000f, 1.622296f },
        new[] { 18.030558f, 10.197294f, -43.534126f, -3.099816f, 0.000000f, 1.625158f },
        new[] { 17.410927f, 10.197294f, -43.208462f, -3.098152f, 0.000000f, 1.628329f },
        new[] { 16.791668f, 10.197294f, -42.882092f, -3.096297f, 0.000000f, 1.631854f },
        new[] { 16.172823f, 10.197294f, -42.554935f, -3.094221f, 0.000000f, 1.635786f },
        new[] { 15.554445f, 10.197294f, -42.226898f, -3.091888f, 0.000000f, 1.640191f },
        new[] { 14.936594f, 10.197294f, -41.897869f, -3.089255f, 0.000000f, 1.645145f },
        new[] { 14.319340f, 10.197294f, -41.567722f, -3.086269f, 0.000000f, 1.650741f },
        new[] { 13.702767f, 10.197294f, -41.236305f, -3.082862f, 0.000000f, 1.657094f },
        new[] { 13.086977f, 10.197294f, -40.903435f, -3.078954f, 0.000000f, 1.664345f },
        new[] { 12.472089f, 10.197294f, -40.568901f, -3.074442f, 0.000000f, 1.672665f },
        new[] { 11.858250f, 10.197294f, -40.232449f, -3.069196f, 0.000000f, 1.682271f },
        new[] { 11.245640f, 10.197294f, -39.893761f, -3.063048f, 0.000000f, 1.693439f },
        new[] { 10.634483f, 10.197294f, -39.552460f, -3.055783f, 0.000000f, 1.706514f },
        new[] { 10.025061f, 10.197294f, -39.208069f, -3.047112f, 0.000000f, 1.721948f },
        new[] { 9.417730f, 10.197294f, -38.860004f, -3.036654f, 0.000000f, 1.740326f },
        new[] { 8.812954f, 10.197294f, -38.507519f, -3.023880f, 0.000000f, 1.762429f },
        new[] { 8.211343f, 10.197294f, -38.149658f, -3.008055f, 0.000000f, 1.789302f },
        new[] { 7.613717f, 10.197294f, -37.785183f, -2.988129f, 0.000000f, 1.822385f },
        new[] { 7.021209f, 10.197294f, -37.412445f, -2.962540f, 0.000000f, 1.863695f },
        new[] { 6.435429f, 10.197294f, -37.029221f, -2.928901f, 0.000000f, 1.916126f },
        new[] { 5.858753f, 10.197294f, -36.632427f, -2.883380f, 0.000000f, 1.983965f },
        new[] { 5.294861f, 10.197294f, -36.217667f, -2.819461f, 0.000000f, 2.073798f },
        new[] { 4.749827f, 10.197294f, -35.778419f, -2.725170f, 0.000000f, 2.196236f },
        new[] { 4.234636f, 10.197294f, -35.304523f, -2.575954f, 0.000000f, 2.369486f },
        new[] { 3.772264f, 10.197294f, -34.778965f, -2.311863f, 0.000000f, 2.627792f },
        new[] { 3.428036f, 10.197294f, -34.169453f, -1.721137f, 0.000000f, 3.047571f },
        new[] { 3.033963f, 10.197294f, -33.590916f, -1.970364f, 0.000000f, 2.892692f },
        new[] { 2.656040f, 10.197294f, -33.001701f, -1.889616f, 0.000000f, 2.946074f },
        new[] { 2.307335f, 10.197294f, -32.394737f, -1.743529f, 0.000000f, 3.034816f },
        new[] { 2.021275f, 10.197294f, -31.755856f, -1.430300f, 0.000000f, 3.194408f },
        new[] { 1.935164f, 10.197294f, -31.061172f, -0.430555f, 0.000000f, 3.473417f },
        new[] { 1.847493f, 10.197294f, -30.366684f, -0.438351f, 0.000000f, 3.472441f },
        new[] { 1.943488f, 10.197294f, -29.673298f, 0.479975f, 0.000000f, 3.466933f },
        new[] { 2.170555f, 10.197294f, -29.011150f, 1.135336f, 0.000000f, 3.310742f },
        new[] { 2.415170f, 10.197294f, -28.355282f, 1.223072f, 0.000000f, 3.279344f },
        new[] { 2.677041f, 10.197294f, -27.706110f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 2.938912f, 10.197294f, -27.056938f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.200784f, 10.197294f, -26.407766f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 3.462655f, 10.197294f, -25.758595f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.724526f, 10.197294f, -25.109423f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 3.986398f, 10.197294f, -24.460251f, 1.309357f, 0.000000f, 3.245857f },
        new[] { 4.248269f, 10.197294f, -23.811079f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.510140f, 10.197294f, -23.161907f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 4.772012f, 10.197294f, -22.512735f, 1.309357f, 0.000000f, 3.245856f },
        new[] { 5.033883f, 10.197294f, -21.863564f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.295755f, 10.197294f, -21.214392f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.557627f, 10.197294f, -20.565220f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 5.819499f, 10.197294f, -19.916048f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.081370f, 10.197294f, -19.266876f, 1.309358f, 0.000000f, 3.245856f },
        new[] { 6.297070f, 10.197294f, -18.723810f, 1.078498f, 0.000000f, 2.715334f },
        new[] { 6.397289f, 10.197294f, -18.479179f, 0.456429f, 0.000000f, 1.107728f },
        new[] { 6.439916f, 10.197294f, -18.384853f, 0.213137f, 0.000000f, 0.471627f },
        new[] { 6.454712f, 10.197294f, -18.342505f, 0.073981f, 0.000000f, 0.211745f },
        new[] { 6.454712f, 10.197294f, -18.342505f, 0.000000f, 0.000000f, 0.000000f }
    };

    [Test]
    public void TestAgent1Quality0TVTA()
    {
        int updateFlags = DtCrowdAgentUpdateFlags.DT_CROWD_ANTICIPATE_TURNS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_VIS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_TOPO |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OBSTACLE_AVOIDANCE;

        AddAgentGrid(1, 0.4f, updateFlags, 0, startPoss[0]);
        SetMoveTarget(endPoss[0], false);
        for (int i = 0; i < EXPECTED_A1Q0TVTA.Length; i++)
        {
            crowd.Update(1 / 5f, null);
            foreach (DtCrowdAgent ag in crowd.GetActiveAgents())
            {
                Assert.That(ag.npos.X, Is.EqualTo(EXPECTED_A1Q0TVTA[i][0]).Within(0.001f));
                Assert.That(ag.npos.Y, Is.EqualTo(EXPECTED_A1Q0TVTA[i][1]).Within(0.001f));
                Assert.That(ag.npos.Z, Is.EqualTo(EXPECTED_A1Q0TVTA[i][2]).Within(0.001f));
                Assert.That(ag.nvel.X, Is.EqualTo(EXPECTED_A1Q0TVTA[i][3]).Within(0.001f));
                Assert.That(ag.nvel.Y, Is.EqualTo(EXPECTED_A1Q0TVTA[i][4]).Within(0.001f));
                Assert.That(ag.nvel.Z, Is.EqualTo(EXPECTED_A1Q0TVTA[i][5]).Within(0.001f));
            }
        }
    }

    [Test]
    public void TestAgent1Quality0TVT()
    {
        int updateFlags = DtCrowdAgentUpdateFlags.DT_CROWD_ANTICIPATE_TURNS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_VIS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_TOPO;

        AddAgentGrid(1, 0.4f, updateFlags, 0, startPoss[0]);
        SetMoveTarget(endPoss[0], false);
        for (int i = 0; i < EXPECTED_A1Q0TVT.Length; i++)
        {
            crowd.Update(1 / 5f, null);
            foreach (DtCrowdAgent ag in crowd.GetActiveAgents())
            {
                Assert.That(ag.npos.X, Is.EqualTo(EXPECTED_A1Q0TVT[i][0]).Within(0.001f));
                Assert.That(ag.npos.Y, Is.EqualTo(EXPECTED_A1Q0TVT[i][1]).Within(0.001f));
                Assert.That(ag.npos.Z, Is.EqualTo(EXPECTED_A1Q0TVT[i][2]).Within(0.001f));
                Assert.That(ag.nvel.X, Is.EqualTo(EXPECTED_A1Q0TVT[i][3]).Within(0.001f));
                Assert.That(ag.nvel.Y, Is.EqualTo(EXPECTED_A1Q0TVT[i][4]).Within(0.001f));
                Assert.That(ag.nvel.Z, Is.EqualTo(EXPECTED_A1Q0TVT[i][5]).Within(0.001f));
            }
        }
    }

    [Test]
    public void TestAgent1Quality0TV()
    {
        int updateFlags = DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_TOPO | DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_VIS;

        AddAgentGrid(1, 0.4f, updateFlags, 0, startPoss[0]);
        SetMoveTarget(endPoss[0], false);
        for (int i = 0; i < EXPECTED_A1Q0TV.Length; i++)
        {
            crowd.Update(1 / 5f, null);
            foreach (DtCrowdAgent ag in crowd.GetActiveAgents())
            {
                Assert.That(ag.npos.X, Is.EqualTo(EXPECTED_A1Q0TV[i][0]).Within(0.001f));
                Assert.That(ag.npos.Y, Is.EqualTo(EXPECTED_A1Q0TV[i][1]).Within(0.001f));
                Assert.That(ag.npos.Z, Is.EqualTo(EXPECTED_A1Q0TV[i][2]).Within(0.001f));
                Assert.That(ag.nvel.X, Is.EqualTo(EXPECTED_A1Q0TV[i][3]).Within(0.001f));
                Assert.That(ag.nvel.Y, Is.EqualTo(EXPECTED_A1Q0TV[i][4]).Within(0.001f));
                Assert.That(ag.nvel.Z, Is.EqualTo(EXPECTED_A1Q0TV[i][5]).Within(0.001f));
            }
        }
    }

    [Test]
    public void TestAgent1Quality0T()
    {
        int updateFlags = DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_TOPO;

        AddAgentGrid(1, 0.4f, updateFlags, 0, startPoss[0]);
        SetMoveTarget(endPoss[0], false);
        for (int i = 0; i < EXPECTED_A1Q0T.Length; i++)
        {
            crowd.Update(1 / 5f, null);
            foreach (DtCrowdAgent ag in crowd.GetActiveAgents())
            {
                Assert.That(ag.npos.X, Is.EqualTo(EXPECTED_A1Q0T[i][0]).Within(0.001));
                Assert.That(ag.npos.Y, Is.EqualTo(EXPECTED_A1Q0T[i][1]).Within(0.001));
                Assert.That(ag.npos.Z, Is.EqualTo(EXPECTED_A1Q0T[i][2]).Within(0.001));
                Assert.That(ag.nvel.X, Is.EqualTo(EXPECTED_A1Q0T[i][3]).Within(0.001));
                Assert.That(ag.nvel.Y, Is.EqualTo(EXPECTED_A1Q0T[i][4]).Within(0.001));
                Assert.That(ag.nvel.Z, Is.EqualTo(EXPECTED_A1Q0T[i][5]).Within(0.001));
            }
        }
    }

    [Test]
    public void TestAgent1Quality1TVTA()
    {
        int updateFlags = DtCrowdAgentUpdateFlags.DT_CROWD_ANTICIPATE_TURNS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_VIS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_TOPO |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OBSTACLE_AVOIDANCE;

        AddAgentGrid(1, 0.4f, updateFlags, 1, startPoss[0]);
        SetMoveTarget(endPoss[0], false);
        for (int i = 0; i < EXPECTED_A1Q1TVTA.Length; i++)
        {
            crowd.Update(1 / 5f, null);
            foreach (DtCrowdAgent ag in crowd.GetActiveAgents())
            {
                Assert.That(ag.npos.X, Is.EqualTo(EXPECTED_A1Q1TVTA[i][0]).Within(0.001f));
                Assert.That(ag.npos.Y, Is.EqualTo(EXPECTED_A1Q1TVTA[i][1]).Within(0.001f));
                Assert.That(ag.npos.Z, Is.EqualTo(EXPECTED_A1Q1TVTA[i][2]).Within(0.001f));
                Assert.That(ag.nvel.X, Is.EqualTo(EXPECTED_A1Q1TVTA[i][3]).Within(0.001f));
                Assert.That(ag.nvel.Y, Is.EqualTo(EXPECTED_A1Q1TVTA[i][4]).Within(0.001f));
                Assert.That(ag.nvel.Z, Is.EqualTo(EXPECTED_A1Q1TVTA[i][5]).Within(0.001f));
            }
        }
    }

    [Test]
    public void TestAgent1Quality2TVTA()
    {
        int updateFlags = DtCrowdAgentUpdateFlags.DT_CROWD_ANTICIPATE_TURNS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_VIS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_TOPO |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OBSTACLE_AVOIDANCE;

        AddAgentGrid(1, 0.4f, updateFlags, 2, startPoss[0]);
        SetMoveTarget(endPoss[0], false);
        for (int i = 0; i < EXPECTED_A1Q2TVTA.Length; i++)
        {
            crowd.Update(1 / 5f, null);
            foreach (DtCrowdAgent ag in crowd.GetActiveAgents())
            {
                Assert.That(ag.npos.X, Is.EqualTo(EXPECTED_A1Q2TVTA[i][0]).Within(0.001f));
                Assert.That(ag.npos.Y, Is.EqualTo(EXPECTED_A1Q2TVTA[i][1]).Within(0.001f));
                Assert.That(ag.npos.Z, Is.EqualTo(EXPECTED_A1Q2TVTA[i][2]).Within(0.001f));
                Assert.That(ag.nvel.X, Is.EqualTo(EXPECTED_A1Q2TVTA[i][3]).Within(0.001f));
                Assert.That(ag.nvel.Y, Is.EqualTo(EXPECTED_A1Q2TVTA[i][4]).Within(0.001f));
                Assert.That(ag.nvel.Z, Is.EqualTo(EXPECTED_A1Q2TVTA[i][5]).Within(0.001f));
            }
        }
    }

    [Test]
    public void TestAgent1Quality3TVTA()
    {
        int updateFlags = DtCrowdAgentUpdateFlags.DT_CROWD_ANTICIPATE_TURNS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_VIS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_TOPO |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OBSTACLE_AVOIDANCE;

        AddAgentGrid(1, 0.4f, updateFlags, 3, startPoss[0]);
        SetMoveTarget(endPoss[0], false);
        for (int i = 0; i < EXPECTED_A1Q3TVTA.Length; i++)
        {
            crowd.Update(1 / 5f, null);
            foreach (DtCrowdAgent ag in crowd.GetActiveAgents())
            {
                Assert.That(ag.npos.X, Is.EqualTo(EXPECTED_A1Q3TVTA[i][0]).Within(0.001f));
                Assert.That(ag.npos.Y, Is.EqualTo(EXPECTED_A1Q3TVTA[i][1]).Within(0.001f));
                Assert.That(ag.npos.Z, Is.EqualTo(EXPECTED_A1Q3TVTA[i][2]).Within(0.001f));
                Assert.That(ag.nvel.X, Is.EqualTo(EXPECTED_A1Q3TVTA[i][3]).Within(0.001f));
                Assert.That(ag.nvel.Y, Is.EqualTo(EXPECTED_A1Q3TVTA[i][4]).Within(0.001f));
                Assert.That(ag.nvel.Z, Is.EqualTo(EXPECTED_A1Q3TVTA[i][5]).Within(0.001f));
            }
        }
    }

    [Test]
    public void TestAgent1Quality3TVTAS()
    {
        int updateFlags = DtCrowdAgentUpdateFlags.DT_CROWD_ANTICIPATE_TURNS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_VIS |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OPTIMIZE_TOPO |
                          DtCrowdAgentUpdateFlags.DT_CROWD_OBSTACLE_AVOIDANCE |
                          DtCrowdAgentUpdateFlags.DT_CROWD_SEPARATION;

        AddAgentGrid(1, 0.4f, updateFlags, 3, startPoss[0]);
        SetMoveTarget(endPoss[0], false);
        for (int i = 0; i < EXPECTED_A1Q3TVTAS.Length; i++)
        {
            crowd.Update(1 / 5f, null);
            foreach (DtCrowdAgent ag in crowd.GetActiveAgents())
            {
                Assert.That(ag.npos.X, Is.EqualTo(EXPECTED_A1Q3TVTAS[i][0]).Within(0.001f));
                Assert.That(ag.npos.Y, Is.EqualTo(EXPECTED_A1Q3TVTAS[i][1]).Within(0.001f));
                Assert.That(ag.npos.Z, Is.EqualTo(EXPECTED_A1Q3TVTAS[i][2]).Within(0.001f));
                Assert.That(ag.nvel.X, Is.EqualTo(EXPECTED_A1Q3TVTAS[i][3]).Within(0.001f));
                Assert.That(ag.nvel.Y, Is.EqualTo(EXPECTED_A1Q3TVTAS[i][4]).Within(0.001f));
                Assert.That(ag.nvel.Z, Is.EqualTo(EXPECTED_A1Q3TVTAS[i][5]).Within(0.001f));
            }
        }
    }
}