# Community Plugins

The following plugins were created by members of the open source community. Like any open source plugin directory,
listings here do not imply endorsement by the Known project team in any way.

## Plugin listings


### Content types

* [Video](https://github.com/cweiske/withknownVideo) – Post videos to your Known site, by [Christian Weiske][]
* [Recipe](https://github.com/cleverdevil/Known-Recipes) – Post recipes to your Known site, by [Jonathan LaCour][]
* [Review](https://github.com/cleverdevil/Known-Reviews) – Post reviews to your Known site, by [Jonathan LaCour][]
* [Food](https://github.com/cleverdevil/Known-Food) – Log your eating and drinking to your Known site, by [Jonathan LaCour][]
* [Watching](https://github.com/cleverdevil/Known-Watching) - Log what you watch (movies and TV) to your Known site, including an experimental Plex webhook, by [Jonathan LaCour][]
* [Reactions](https://github.com/kylewm/KnownReactions) – Indieweb–style likes and reposts, by [Kyle Mahan][] 

### Syndication plugins

* [LinkedIn](https://github.com/mapkyca/KnownLinkedin) – Provides support for LinkedIn, 
    by [Marcus Povey][]
* [WordPress](https://github.com/timmmmyboy/WordPress) – Syndicate your content to a WordPress blog, by [Tim Owens][]
* [Tumblr](https://github.com/timmmmyboy/Tumblr) – Syndicate your content to a Tumblr feed, by [Tim Owens][]
* [Diigo](https://github.com/timmmmyboy/Diigo) – Syndicate your bookmarks to Diigo, by [Tim Owens][]
* [Github](https://github.com/mapkyca/KnownGithub) – Create issues and reply to comments on Github, all from your own site, 
    by [Marcus Povey][]
* [App.net](https://github.com/mapkyca/KnownAppNet) – Syndicate to App.net (note: ADN shut down on 2017-03-15), 
    by [Marcus Povey][]
* [Known Crosspost](https://github.com/mapkyca/KnownKnown) – Crosspost content to another Known site via the API, 
    by [Marcus Povey][]
* [Diaspora](https://github.com/Phyks/KnownDiaspora) – Crosspost content to a Diaspora site, by [Lukas Verney][]
* [IRC](https://github.com/mapkyca/KnownIRC) – Post messages and links into IRC channels, 
    by [Marcus Povey][]
* [IndieSyndicate](https://github.com/kylewm/KnownIndieSyndicate) – Syndicate via Micropub and Webmention, by [Kyle Mahan][]
* [Pinboard](https://github.com/egoexpress/known-pinboard) - Syndicate your bookmarks to [Pinboard.in](https://pinboard.in), by [Björn Stierand][]
* [Archive.org/WayBackMachine](https://github.com/mapkyca/KnownWaybackMachine) – Provides Wayback Machine archive.org support for Known, 
    by [Marcus Povey][]
* [Pnut.io](https://github.com/dg01d/KnownPnut) – Syndicate to [pnut.io](https://pnut.io/), 
    by [Daniel Goldsmith][] 
* [Mastodon](https://github.com/danito/KnownMastodon) - Syndicate to Mastodon, by [Daniel Nix][]

### System and Security

* [Two Factor Authentication](https://github.com/mapkyca/Known2FA) – Two factor authentication for logins, 
    by [Marcus Povey][]
* [Sitemap.xml](https://github.com/mapkyca/KnownSitemap) – Automatically generate a sitemap.xml for your site, 
    by [Marcus Povey][]
* [Bitly URL shortener](https://github.com/mapkyca/KnownBitlyShorten) – Provide short links for shared content, 
    by [Marcus Povey][]
* [OAuth2 Server](https://github.com/mapkyca/KnownOAuth2) – Allow API integration via OAuth2, 
    by [Marcus Povey][]
* [NIST Passwords](https://github.com/mapkyca/KnownNISTPasswords) – Enforce minimum entropy requirements for passwords, 
    by [Marcus Povey][]
* [Akismet](https://github.com/mapkyca/KnownAkismet) – Wordpress Akismet spam filtering support for comments and webmentions, 
    by [Marcus Povey][]
* [Matomo](https://codeberg.org/argovaerts/KnownMatomo) – Add Matomo Analytics to your site,
    by [Arne Govaerts][]


### Browser Integration and Apps

* [Chrome Extension](https://github.com/mapkyca/KnownChrome) – Chromium/Google Chrome integration for your site, 
    by [Marcus Povey][]

### Import and Export

* [Flickr Import](https://github.com/mapkyca/KnownFlickrDumpImport) – Import content from your Flickr account, 
    by [Marcus Povey][]
* [File Picker](https://github.com/Decentralized-Sharing-Working-Group/idno-file-picker) – pick files from your
    Cozy, ownCloud, or remoteStorage server, by [Decentralized Sharing Community Group][decsharing]
* [Moves Import](https://github.com/danito/KnownImportMoves) – Import your Moves–app.com data, 
    by [Daniel Nix][]

### Themes

* [Material](https://github.com/physcocode/Material) – Google Material design style theme for known , by [Pranjal Pandey][]
* [Nature](https://github.com/physcocode/nature) – Warm natural theme for known , by [Pranjal Pandey][]


### Misc

* [Gist Support](https://github.com/mapkyca/IdnoGist) – Automatically render gist links in your content, 
    by [Marcus Povey][]
* [UserColors](https://github.com/misuba/UserColors) – Let users choose the colors on their profile pages on multi–user
    Known sites, by [Mike Sugarbaker][]
* [Pushover](https://github.com/timmmmyboy/Pushover) – Push notifications from Known to your iOS and Android devices via
   the Pushover.net service, by [Tim Owens][]
* [KnownTracks](https://github.com/klermor/KnownTracks) – View GPS Exchange (GPX) files from your Known site, by
   [Yann Sallou][]
* [Markdown](https://github.com/mapkyca/IdnoMarkdown) – Adds Markdown support for status and blog posts, 
   by [Marcus Povey][]
* [InstagramShim](https://github.com/kylewm/KnownInstagramShim) – Sets POSSE links for Instagram photos imported via Micropub (e.g. using OwnYourGram), by [Kyle Mahan][]
* [Lightbox](https://github.com/mapkyca/KnownLightbox) – Lightbox style popups for photos and pictures, 
    by [Marcus Povey][]
* [Emoji rendering](https://github.com/mapkyca/KnownEmoji) – Render Emoji characters (e.g. in Bridgy comments), 
    by [Marcus Povey][]
* [Short Profile](https://github.com/egoexpress/known-shortprofile) – Cleans up the URLs displayed in the profile page. Also adds some additional icons, by [Björn Stierand][]  
* [Cleverdevil Customizations](https://github.com/cleverdevil/CleverCustomize) – A small collection of customizations, by [Jonathan LaCour][]
* [MastodonEmbed](https://github.com/danito/KnownEmbedMastodon) - Embed Mastodon status , by [Daniel Nix][]

[Pranjal Pandey]: https://www.github.com/physcocode
[Daniel Nix]: https://nxd4n.nixekinder.be
[decsharing]: https://www.w3.org/community/decsharing/
[Jonathan LaCour]: https://cleverdevil.io
[Kyle Mahan]: https://kylewm.com
[Lukas Verney]: http://phyks.me/
[Marcus Povey]: https://www.marcus–povey.co.uk
[Mike Sugarbaker]: http://gibberish.com/
[Tim Owens]: http://timowens.io/
[Tyler Gillies]: http://tylergillies.club/
[Yann Sallou]: http://winds.fr/
[Tino Kremer]: https://tinokremer.nl/
[Björn Stierand]: https://bjoern.stierand.org/
[Christian Weiske]: https://cweiske.de/
[Daniel Goldsmith]: https://ascraeus.org/
[Arne Govaerts]: https://q4.re

## Submissions

To add a new plugin, submit a pull request with the following details in the appropriate section:

```
* [Plugin name](http://link/to/plugin) – A short description (no more than a paragraph), 
  by [Author name](http://link/to/author)
```
