/*! wavesurfer.js 1.0.52
* https://github.com/katspaugh/wavesurfer.js
* @license CC-BY-3.0 */"use strict";WaveSurfer.Spectrogram={init:function(a){this.params=a;var b=this.wavesurfer=a.wavesurfer;if(!this.wavesurfer)throw Error("No WaveSurfer instance provided");this.frequenciesDataUrl=a.frequenciesDataUrl;var c=this.drawer=this.wavesurfer.drawer;if(this.container="string"==typeof a.container?document.querySelector(a.container):a.container,!this.container)throw Error("No container for WaveSurfer spectrogram");this.width=c.width,this.pixelRatio=this.params.pixelRatio||b.params.pixelRatio,this.fftSamples=this.params.fftSamples||b.params.fftSamples||512,this.height=this.fftSamples/2,this.createWrapper(),this.createCanvas(),this.render(),b.drawer.wrapper.onscroll=this.updateScroll.bind(this),b.on("redraw",this.render.bind(this)),b.on("destroy",this.destroy.bind(this))},destroy:function(){this.unAll(),this.wrapper&&(this.wrapper.parentNode.removeChild(this.wrapper),this.wrapper=null)},createWrapper:function(){var a=this.container.querySelector("spectrogram");a&&this.container.removeChild(a);var b=this.wavesurfer.params;this.wrapper=this.container.appendChild(document.createElement("spectrogram")),this.drawer.style(this.wrapper,{display:"block",position:"relative",userSelect:"none",webkitUserSelect:"none",height:this.height+"px"}),(b.fillParent||b.scrollParent)&&this.drawer.style(this.wrapper,{width:"100%",overflowX:"hidden",overflowY:"hidden"});var c=this;this.wrapper.addEventListener("click",function(a){a.preventDefault();var b="offsetX"in a?a.offsetX:a.layerX;c.fireEvent("click",b/c.scrollWidth||0)})},createCanvas:function(){var a=this.canvas=this.wrapper.appendChild(document.createElement("canvas"));this.spectrCc=a.getContext("2d"),this.wavesurfer.drawer.style(a,{position:"absolute",zIndex:4})},render:function(){this.updateCanvasStyle(),this.frequenciesDataUrl?this.loadFrequenciesData(this.frequenciesDataUrl):this.getFrequencies(this.drawSpectrogram)},updateCanvasStyle:function(){var a=Math.round(this.width/this.pixelRatio)+"px";this.canvas.width=this.width,this.canvas.height=this.height,this.canvas.style.width=a},drawSpectrogram:function(a,b){for(var c=(b.spectrCc,b.wavesurfer.backend.getDuration(),b.height),d=b.resample(a),e=b.buffer?2/b.buffer.numberOfChannels:1,f=0;f<d.length;f++)for(var g=0;g<d[f].length;g++){var h=255-d[f][g];b.spectrCc.fillStyle="rgb("+h+", "+h+", "+h+")",b.spectrCc.fillRect(f,c-g*e,1,e)}},getFrequencies:function(a){var b=this.fftSamples,c=this.buffer=this.wavesurfer.backend.buffer;if(!c)return void this.fireEvent("error","Web Audio buffer is not available");var d=[],e=new(window.OfflineAudioContext||window.webkitOfflineAudioContext)(1,c.length,c.sampleRate),f=e.createBufferSource(),g=e.createScriptProcessor?e.createScriptProcessor(0,1,1):e.createJavaScriptNode(0,1,1),h=e.createAnalyser();h.fftSize=b,h.smoothingTimeConstant=this.width/c.duration<10?.75:.25,f.buffer=c,f.connect(h),h.connect(g),g.connect(e.destination),g.onaudioprocess=function(){var a=new Uint8Array(h.frequencyBinCount);h.getByteFrequencyData(a),d.push(a)},f.start(0),e.startRendering();var i=this;e.oncomplete=function(){a(d,i)}},loadFrequenciesData:function(a){var b=this,c=WaveSurfer.util.ajax({url:a});return c.on("success",function(a){b.drawSpectrogram(JSON.parse(a),b)}),c.on("error",function(a){b.fireEvent("error","XHR error: "+a.target.statusText)}),c},updateScroll:function(a){this.wrapper.scrollLeft=a.target.scrollLeft},resample:function(a,b){for(var b=this.width,c=[],d=1/a.length,e=1/b,f=0;b>f;f++){for(var g=new Array(a[0].length),h=0;h<a.length;h++){var i=h*d,j=i+d,k=f*e,l=k+e,m=k>=j||i>=l?0:Math.min(Math.max(j,k),Math.max(l,i))-Math.max(Math.min(j,k),Math.min(l,i));if(m>0)for(var n=0;n<a[0].length;n++)null==g[n]&&(g[n]=0),g[n]+=m/e*a[h][n]}for(var o=new Uint8Array(a[0].length),n=0;n<a[0].length;n++)o[n]=g[n];c.push(o)}return c}},WaveSurfer.util.extend(WaveSurfer.Spectrogram,WaveSurfer.Observer);