module.exports = {
  'alert': {
    base: [
      'alert',
    ],
    styled: [
      'alert-primary',
      'alert-success',
      'alert-warning',
      'alert-error',
      'alert-neutral',
      'alert-secondary',
      'alert-accent',
      'alert-info',
    ],
    utils: [],
  },
  'avatar': {
    base: [
      'avatar',
      'placeholder',
    ],
    styled: [
      'avatar-group',
    ],
    utils: [],
  },
  'badge': {
    base: [
      'badge',
    ],
    styled: [
      'badge-primary',
      'badge-success',
      'badge-warning',
      'badge-error',
      'badge-neutral',
      'badge-secondary',
      'badge-accent',
      'badge-info',
      'badge-ghost',
      'badge-outline',
    ],
    utils: [
      'badge-xs',
      'badge-sm',
      'badge-md',
      'badge-lg',
    ],
  },
  'button': {
    base: [
      'btn',
      'btn-disabled',
      'btn-square',
      'btn-circle',
    ],
    styled: [
      'btn-focus-visible',
      'btn-hover',
      'btn-primary',
      'btn-active',
      'btn-success',
      'btn-warning',
      'btn-error',
      'btn-neutral',
      'btn-secondary',
      'btn-accent',
      'btn-info',
      'glass',
      'btn-ghost',
      'btn-link',
      'btn-outline',
    ],
    utils: [
      'btn-xs',
      'btn-sm',
      'btn-md',
      'btn-lg',
      'btn-wide',
      'btn-block',
      'btn-square',
      'btn-circle',
    ],
  },
  'chat': {
    base: [
      'chat',
      'chat-image',
      'chat-header',
      'chat-footer',
      'chat-bubble',
      'chat-start',
      'chat-end',
    ],
    styled: [
      'chat-bubble-primary',
      'chat-bubble-success',
      'chat-bubble-warning',
      'chat-bubble-error',
      'chat-bubble-neutral',
      'chat-bubble-secondary',
      'chat-bubble-accent',
      'chat-bubble-info',
    ],
    utils: [],
  },
  'checkbox': {
    base: [
      'checkbox',
    ],
    styled: [
      'checkbox-primary',
      'checkbox-success',
      'checkbox-warning',
      'checkbox-error',
      'checkbox-neutral',
      'checkbox-secondary',
      'checkbox-accent',
      'checkbox-info',
      'checkbox-mark',
    ],
    utils: [
      'checkbox-xs',
      'checkbox-sm',
      'checkbox-md',
      'checkbox-lg',
    ],
  },
  'input': {
    base: [
      'input',
    ],
    styled: [
      'input-bordered',
      'input-ghost',
      'input-primary',
      'input-success',
      'input-warning',
      'input-error',
      'input-neutral',
      'input-secondary',
      'input-accent',
      'input-info',
      'input-disabled',
    ],
    utils: [
      'input-xs',
      'input-md',
      'input-lg',
      'input-sm',
    ],
  },
  'link': {
    base: [
      'link',
      'link-hover',
    ],
    styled: [
      'link-primary',
      'link-success',
      'link-warning',
      'link-error',
      'link-neutral',
      'link-secondary',
      'link-accent',
      'link-info',
    ],
    utils: [],
  },
  'progress': {
    base: [
      'progress',
    ],
    styled: [
      'progress-primary',
      'progress-success',
      'progress-warning',
      'progress-error',
      'progress-neutral',
      'progress-secondary',
      'progress-accent',
      'progress-info',
    ],
    utils: [],
  },
  'radio': {
    base: [
      'radio',
    ],
    styled: [
      'radio-primary',
      'radio-success',
      'radio-warning',
      'radio-error',
      'radio-neutral',
      'radio-secondary',
      'radio-accent',
      'radio-info',
      'radio-mark',
    ],
    utils: [
      'radio-xs',
      'radio-sm',
      'radio-md',
      'radio-lg',
    ],
  },
  'range': {
    base: [
      'range',
    ],
    styled: [
      'range-primary',
      'range-success',
      'range-warning',
      'range-error',
      'range-neutral',
      'range-secondary',
      'range-accent',
      'range-info',
    ],
    utils: [
      'range-xs',
      'range-sm',
      'range-md',
      'range-lg',
    ],
  },
  'select': {
    base: [
      'select',
    ],
    styled: [
      'select-bordered',
      'select-ghost',
      'select-primary',
      'select-success',
      'select-warning',
      'select-error',
      'select-neutral',
      'select-secondary',
      'select-accent',
      'select-info',
      'select-disabled',
      'select-multiple',
    ],
    utils: [
      'select-md',
      'select-lg',
      'select-sm',
      'select-xs',
    ],
  },
  'textarea': {
    base: [
      'textarea',
    ],
    styled: [
      'textarea-bordered',
      'textarea-ghost',
      'textarea-primary',
      'textarea-success',
      'textarea-warning',
      'textarea-error',
      'textarea-neutral',
      'textarea-secondary',
      'textarea-accent',
      'textarea-info',
      'textarea-disabled',
    ],
    utils: [
      'textarea-xs',
      'textarea-sm',
      'textarea-md',
      'textarea-lg',
    ],
  },
  'toggle': {
    base: [
      'toggle',
    ],
    styled: [
      'toggle-primary',
      'toggle-success',
      'toggle-warning',
      'toggle-error',
      'toggle-neutral',
      'toggle-secondary',
      'toggle-accent',
      'toggle-info',
      'toggle-mark',
    ],
    utils: [
      'toggle-xs',
      'toggle-sm',
      'toggle-md',
      'toggle-lg',
    ],
  },
  'loading': {
    base: [
      'loading',
    ],
    styled: [],
    utils: [
      'loading-audio',
      'loading-ball-triangle',
      'loading-bars',
      'loading-circles',
      'loading-grid',
      'loading-hearts',
      'loading-oval',
      'loading-puff',
      'loading-rings',
      'loading-spinning-circles',
      'loading-tail-spin',
      'loading-three-dots',
      'loading-xs',
      'loading-sm',
      'loading-md',
      'loading-lg',
    ],
  },
  'mask': {
    base: [
      'mask',
      'mask-half-1',
      'mask-half-2',
    ],
    styled: [],
    utils: [
      'mask-squircle',
      'mask-decagon',
      'mask-diamond',
      'mask-heart',
      'mask-hexagon',
      'mask-hexagon-2',
      'mask-circle',
      'mask-parallelogram',
      'mask-parallelogram-2',
      'mask-parallelogram-3',
      'mask-parallelogram-4',
      'mask-pentagon',
      'mask-square',
      'mask-star',
      'mask-star-2',
      'mask-triangle',
      'mask-triangle-2',
      'mask-triangle-3',
      'mask-triangle-4',
    ],
  },
  'table': {
    base: [
      'table',
      'table-pin-rows',
      'table-pin-cols',
      'table-zebra',
    ],
    styled: [
      'active',
      'hover',
      'table-zebra-zebra',
    ],
    utils: [
      'table-xs',
      'table-sm',
      'table-md',
      'table-lg',
    ],
  },
  'skeleton': {
    base: [
      'skeleton',
    ],
    styled: [],
    utils: [
      'skeleton-title',
      'skeleton-paragraph',
      'skeleton-avatar',
    ],
  },
  'form': {
    base: [
      'form-control',
      'label',
    ],
    styled: [
      'label-text',
      'label-text-alt',
    ],
    utils: [],
  },
  'radial-progress': {
    base: [
      'radial-progress',
    ],
    styled: [],
    utils: [],
  },
  'countdown': {
    base: [
      'countdown',
    ],
    styled: [],
    utils: [],
  },
  'diff': {
    base: [
      'diff',
      'diff-resizer',
      'diff-item-1',
      'diff-item-2',
    ],
    styled: [],
    utils: [],
  },
  'kbd': {
    base: [
      'kbd',
    ],
    styled: [],
    utils: [
      'kbd-xs',
      'kbd-sm',
      'kbd-md',
      'kbd-lg',
    ],
  },
  'tooltip': {
    base: [
      'tooltip',
      'tooltip-top',
      'tooltip-bottom',
      'tooltip-left',
      'tooltip-right',
    ],
    styled: [
      'tooltip-open',
      'tooltip-primary',
      'tooltip-success',
      'tooltip-warning',
      'tooltip-error',
      'tooltip-neutral',
      'tooltip-secondary',
      'tooltip-accent',
      'tooltip-info',
    ],
    utils: [],
  },
  'toast': {
    base: [
      'toast',
    ],
    styled: [],
    utils: [
      'toast',
      'toast-start',
      'toast-center',
      'toast-end',
      'toast-bottom',
      'toast-middle',
      'toast-top',
    ],
  },
  'steps': {
    base: [
      'steps',
      'step',
    ],
    styled: [
      'step-primary',
      'step-success',
      'step-warning',
      'step-error',
      'step-neutral',
      'step-secondary',
      'step-accent',
      'step-info',
    ],
    utils: [
      'steps-horizontal',
      'step',
      'steps-vertical',
    ],
  },
  'collapse': {
    base: [
      'collapse',
      'collapse-title',
      'collapse-content',
      'collapse-open',
      'collapse-close',
    ],
    styled: [
      'collapse-arrow',
      'collapse-plus',
    ],
    utils: [],
  },
  'join': {
    base: [
      'join',
      'join-item',
      'dropdown',
    ],
    styled: [],
    utils: [
      'join',
      'join-vertical',
      'join-item',
      'join-horizontal',
    ],
  },
  'indicator': {
    base: [
      'indicator',
      'indicator-item',
    ],
    styled: [
      'indicator-start',
      'indicator-center',
      'indicator-end',
      'indicator-bottom',
      'indicator-middle',
      'indicator-top',
    ],
    utils: [],
  },
  'divider': {
    base: [
      'divider',
      'divider-start',
      'divider-end',
    ],
    styled: [
      'divider-primary',
      'divider-success',
      'divider-warning',
      'divider-error',
      'divider-neutral',
      'divider-secondary',
      'divider-accent',
      'divider-info',
    ],
    utils: [
      'divider-horizontal',
      'divider-vertical',
    ],
  },
  'stack': {
    base: [
      'stack',
    ],
    styled: [],
    utils: [],
  },
  'tab': {
    base: [
      'tabs',
      'tabs-lifted',
      'tab-content',
      'tab',
      'tab-active',
    ],
    styled: [
      'tab-disabled',
      'tabs-bordered',
      'tabs-boxed',
    ],
    utils: [
      'tabs-md',
      'tab',
      'tabs-lg',
      'tabs-sm',
      'tabs-xs',
    ],
  },
  'dropdown': {
    base: [
      'dropdown',
      'dropdown-content',
      'dropdown-end',
      'dropdown-left',
      'dropdown-right',
      'dropdown-bottom',
      'dropdown-top',
      'dropdown-open',
      'dropdown-hover',
    ],
    styled: [],
    utils: [],
  },
  'swap': {
    base: [
      'swap',
      'swap-on',
      'swap-indeterminate',
      'swap-off',
      'swap-active',
    ],
    styled: [
      'swap-rotate',
      'swap-flip',
    ],
    utils: [],
  },
  'card': {
    base: [
      'card',
      'card-body',
      'card-actions',
      'image-full',
    ],
    styled: [
      'bordered',
      'card-bordered',
      'compact',
      'card-title',
    ],
    utils: [
      'card-side',
      'card-compact',
      'card-body',
      'card-title',
      'card-normal',
    ],
  },
  'carousel': {
    base: [
      'carousel',
      'carousel-vertical',
      'carousel-item',
      'carousel-center',
      'carousel-end',
    ],
    styled: [],
    utils: [],
  },
  'stat': {
    base: [
      'stats',
      'stat',
      'stat-figure',
      'stat-title',
      'stat-value',
      'stat-desc',
      'stat-actions',
    ],
    styled: [],
    utils: [
      'stats-horizontal',
      'stats-vertical',
    ],
  },
  'timeline': {
    base: [
      'timeline',
      'timeline-start',
      'timeline-middle',
      'timeline-end',
    ],
    styled: [
      'timeline-box',
    ],
    utils: [
      'timeline-vertical',
      'timeline-compact',
      'timeline-horizontal',
      'timeline-start',
      'timeline-end',
      'timeline-snap-icon',
      'timeline-middle',
    ],
  },
  'breadcrumbs': {
    base: [
      'breadcrumbs',
    ],
    styled: [],
    utils: [],
  },
  'bottom-navigation': {
    base: [
      'btm-nav',
    ],
    styled: [
      'active',
      'disabled',
      'label',
    ],
    utils: [
      'btm-nav-xs',
      'active',
      'btm-nav-label',
      'btm-nav-sm',
      'btm-nav-md',
      'btm-nav-lg',
    ],
  },
  'menu': {
    base: [
      'menu',
      'menu-title',
      'disabled',
      'menu-dropdown',
      'menu-dropdown-show',
      'badge',
    ],
    styled: [
      'active',
      'focus',
      'menu-dropdown-toggle',
    ],
    utils: [
      'menu-horizontal',
      'menu-title',
      'menu-vertical',
      'menu-xs',
      'menu-sm',
      'menu-md',
      'menu-lg',
    ],
  },
  'navbar': {
    base: [
      'navbar',
      'navbar-start',
      'navbar-center',
      'navbar-end',
    ],
    styled: [],
    utils: [],
  },
  'file-input': {
    base: [
      'file-input',
    ],
    styled: [
      'file-input-bordered',
      'file-input-ghost',
      'file-input-primary',
      'file-input-success',
      'file-input-warning',
      'file-input-error',
      'file-input-neutral',
      'file-input-secondary',
      'file-input-accent',
      'file-input-info',
      'file-input-disabled',
    ],
    utils: [
      'file-input-xs',
      'file-input-sm',
      'file-input-md',
      'file-input-lg',
    ],
  },
  'rating': {
    base: [
      'rating',
    ],
    styled: [
      'rating-hidden',
      'rating-half',
    ],
    utils: [
      'rating-xs',
      'rating-sm',
      'rating-md',
      'rating-lg',
      'rating-half',
      'rating-hidden',
    ],
  },
  'drawer': {
    base: [
      'drawer',
      'drawer-content',
      'drawer-side',
      'drawer-overlay',
      'drawer-toggle',
      'drawer-end',
    ],
    styled: [
      'drawer-button',
    ],
    utils: [
      'drawer-open',
      'drawer-toggle',
      'drawer-side',
      'drawer-overlay',
    ],
  },
  'footer': {
    base: [
      'footer',
      'footer-center',
    ],
    styled: [
      'footer-title',
    ],
    utils: [],
  },
  'hero': {
    base: [
      'hero',
      'hero-overlay',
      'hero-content',
    ],
    styled: [],
    utils: [],
  },
}
