import type { GetCssSchemaMethod } from '@/types'
import { css } from '@/types'

const schema: GetCssSchemaMethod = (opts) => {
  const { selector } = opts
  return {
    selector,
    defaults: {
      base: css`
        ${selector} {
          // @b
          @apply fixed bottom-0 left-0 right-0 flex w-full flex-row items-center justify-around;
          padding-bottom: env(safe-area-inset-bottom);
          & > * {
            @apply relative flex h-full basis-full cursor-pointer flex-col items-center justify-center gap-1;
          }
        }
      `,
      styled: css`
        ${selector} {
          @apply bg-base-100 h-16 text-current;
          & > * {
            @apply border-current;

            &:not(.active) {
              @apply pt-0.5;
            }

            /* active */
            &:where(.active) {
              @apply bg-base-100 border-t-2;
            }
            // @gv disabled="true" ["disabled"]
            &.disabled,
            &[disabled] {
              @apply bg-neutral text-base-content pointer-events-none border-opacity-0 bg-opacity-10 text-opacity-20;
            }
            @media (hover: hover) {
              &.disabled:hover,
              &[disabled]:hover {
                @apply bg-neutral text-base-content pointer-events-none border-opacity-0 bg-opacity-10 text-opacity-20;
              }
            }
            .label {
              @apply text-base;
            }
          }
        }
      `,
      utils: css`
        ${selector} {
          &-xs {
            // @v size="xs"
            @apply h-10;
            & > *:where(.active) {
              @apply border-t-[1px];
            }
            ${selector}-label {
              @apply text-xs;
            }
          }
          &-sm {
            // @v size="sm"
            @apply h-12;
            & > *:where(.active) {
              @apply border-t-2;
            }
            ${selector}-label {
              @apply text-xs;
            }
          }
          &-md {
            // @v size="md"
            @apply h-16;
            & > *:where(.active) {
              @apply border-t-2;
            }
            ${selector}-label {
              @apply text-sm;
            }
          }
          &-lg {
            // @v size="lg"
            @apply h-20;
            & > *:where(.active) {
              @apply border-t-4;
            }
            ${selector}-label {
              @apply text-base;
            }
          }
        }
      `,
    },
  }
}

export default {
  schema,
}
