# 用 @icestack/ui 构建适配微信小程序的 daisyui

- [用 @icestack/ui 构建适配微信小程序的 daisyui](#用-icestackui-构建适配微信小程序的-daisyui)
  - [前言](#前言)
  - [思考与实践](#思考与实践)
  - [如何使用?](#如何使用)
    - [安装](#安装)
    - [初始化配置](#初始化配置)
    - [构建样式](#构建样式)
  - [作为 tailwindcss plugin 来使用](#作为-tailwindcss-plugin-来使用)
    - [安装](#安装-1)
    - [配置](#配置)
    - [智能提示](#智能提示)
  - [在微信小程序里使用](#在微信小程序里使用)
    - [安装](#安装-2)
    - [注册](#注册)
    - [构建](#构建)
  - [演示小程序](#演示小程序)
  - [收到启发的项目](#收到启发的项目)
  - [参考地址](#参考地址)

## 前言

`daisyui` 是 `tailwindcss` 中最流行的纯 `CSS` 框架，然而它作用的平台只有 `h5`，直接在小程序中使用会报错，因为小程序的 `CSS` 选择器有很多限制，无法像 `h5` 那样自由。那么怎么样才能构建出适配小程序版本的 `daisyui` 呢？

## 思考与实践

在阅读了 `daisyui` 了诸多源码之后，我展开了思索，因为我认为它还能做的更好更自由。

为此我构建了 [`icestack`](https://github.com/sonofmagic/icestack) 项目。和 `daisyui` 相同的是，它们都用于构建纯 `CSS` 框架。不同的是 [`icestack`](https://github.com/sonofmagic/icestack) 的目的快速的生成一套属于你自己的 CSS 框架。也就是说你可以用 `@icestack/ui` 构建出 `n` 个你自己定制化之后的 `daisyui`。

当然你可以使用内部提供的一套默认 `范式`(默认就是 `daisyui`), 也可以对它进行覆盖或者扩展。

你可以根据配置项，自由的去操纵所有 `CSS`范式的表现性状，包括不但限于:

- 添加/减少/覆盖/修改 主题色给不同的组件 (比如: 按钮默认有 `default`, `primary`,`success`,`warning`,`error`, 你再去添加个`secondary`,`accent`色，并声明它们`hover/focus/active`等等状态)
- 添加/减少/覆盖/修改组件的大小，形状，样式 (比如:按钮默认的尺寸有 `sm`,`md`,`lg` 三种尺寸，你可以再往里面添加 `xs`,`xl`,`2xl`... 的大小尺寸)
- 不同的 `CSS` 组件走不同的 `postcss` 处理流程
- 添加新的`CSS`组件到这套体系中来。

而且，这个生成器生成的 `CSS 范式` 结果入侵性非常小，默认情况下，它不会携带任何的 `css reset/normalize/preflight` 样式，只会全局注入一些计算出的 `CSS` 变量。

它的生成结果也非常的直观，你可以使用它自定义出想要的 `UI` 行为后，进行二次封装，或者提取成 `preset`, 从而在多个项目中共享。

## 如何使用?

### 安装

首先你必须安装好 `nodejs` 环境:

然后使用 `npm init` 创建 `package.json`，再在 `package.json` 目录下，执行命令:

```sh
# yarn / pnpm
npm i -D @icestack/ui
```

`@icestack/ui` 将会被下载并安装在你的本地，同时一个二进制命令 `icestack` 将会被注册

### 初始化配置

首先在安装好 `@icestack/ui` 之后你可以执行:

```bash
npx icestack init
```

这个命令会在当前执行目录下生成一个 `icestack.config.cjs` 文件，默认内容如下:

```js filename="icestack.config.cjs"
/**
 * @type {import('@icestack/ui').Config}
 */
const config = {
  outdir: './my-ui'
}

module.exports = config
```

### 构建样式

你可以在 `config` 中，配置你自己的样式和选项，完成之后执行:

```bash
npx icestack build
```

或者把这个脚本加入你的 `package.json`:

```diff filename="package.json"
{
  "scripts": {
+   "build:ui": "icestack build"
  },
}

```

然后执行 `npm run build:ui` 也能达到同样的效果。这样当前目录的 `my-ui` 就生成了很多的 `css/js` 文件，你可以直接引入使用，当然它们也可以作为 tailwindcss plugin 来使用。

## 作为 tailwindcss plugin 来使用

### 安装

在以 CLI 使用 `@icestack/ui` 执行 `icestack build` 后，它把所有的资源文件生成在你的本地的目录中了

然后我们安装 `@icestack/tailwindcss`

```sh
# yarn / pnpm
npm i -D @icestack/tailwindcss
```

### 配置

然后传递一个 `loadDirectory` 配置项告诉插件刚刚生成的位置:

```js filename="tailwind.config.js"
const path = require('node:path')
const { icestackPlugin } = require('@icestack/tailwindcss')

/** @type {import('tailwindcss').Config} */
module.exports = {
  // ...
  plugins: [
    icestackPlugin({
      loadDirectory: path.resolve(__dirname, 'my-ui'),
      // other options
      // 是否注入 theme ,为 true 生成器的 primary success warning 这些颜色会进入 tailwindcss theme extend 配置
      loadConfig: true
    })
  ]
}
```

接着只要我们正常运行项目，当前目录下的 `my-ui` 里就生成了对应的 `css`和 `js` 相关的代码

### 智能提示

通常我们每次保存 `tailwind.config.js` 文件，`tailwindcss` 插件就会去重新读取插件并生成智能提示

所以我们每一次执行 `icestack build` 后，都可以去 `tailwind.config.js` 进行文件的保存操作，这样智能提示就有了。

当然现在构建出的版本还是 `h5` 的，我们要通过加载 `@icestack/presets` 里的小程序预设来构建出适配小程序的样式。

## 在微信小程序里使用

> 目前 `@icestack/presets` 必须要配合 [`weapp-tailwindcss`](https://weapp-tw.icebreaker.top/) 一起使用，在使用前请确保 [`weapp-tailwindcss`](https://weapp-tw.icebreaker.top/) 安装配置成功。

### 安装

`@icestack/presets` 内部实现了一套预设来兼容微信小程序

你可以使用 `@icestack/presets` 中导出的 `miniprogramPreset` 来构建出小程序版本的默认 `ui` 库

首先我们安装 `@icestack/presets`

```sh
# yarn / pnpm
npm i -D @icestack/presets
```

### 注册

然后在 `icestack.config.cjs` 中注册

```js filename="icestack.config.cjs"
const { miniprogramPreset } = require('@icestack/presets')
/**
 * @type {import('@icestack/ui').Config}
 */
const config = {
  // 可以根据环境变量，把 h5 和 小程序的 outdir 设置为不同的目录
  outdir: './my-ui',
  presets: [miniprogramPreset()]
}

module.exports = config
```

### 构建

然后你执行命令:

```bash
npx icestack build
```

构建出的就是适配小程序的库了。

当然还有更多更自由的使用方式，在此不细讲，详见[icestack官网](https://ui.icebreaker.top/zh-CN)

## 演示小程序

![Image](https://pic4.zhimg.com/80/v2-e30dae2d59a2c29f91af3088d72cd611.jpg)

[小程序源码 Github 地址](https://github.com/sonofmagic/icestack/tree/main/apps/taro-app)

## 收到启发的项目

本项目收到了 `tailwindcss`,`sass`,`postcss`,`daisyui`,`antd`,`vant` 等等项目和思想的启发。

## 参考地址

[Github](https://github.com/sonofmagic/icestack)

[icestack官网](https://ui.icebreaker.top/zh-CN)

[Storybook 演示地址](https://story.ui.icebreaker.top)

[weapp-tailwindcss官网](https://weapp-tw.icebreaker.top/)
