<br>

<p align="center">
<img src="./assets/logo.svg" style="width:100px;" />
</p>

<h1 align="center">IceStack</h1>

[![npm][npm]][npm-url] [![][license]][license-url] [![][stars]][gh-url] [![][dl]][npm-url] [![codecov][codecov]][codecov-url]

IceStack UI, Web UI for Mobile and PC , open-source Css Headless component library generator

## Documents

### [Official website →](https://ui.icebreaker.top/)

### [See all components →](https://ui.icebreaker.top/components/overview)

### [How to use →](https://ui.icebreaker.top/docs/usage)

## Repos

### Usage

- [@icestack/ui](./packages/ui/) - IceStack UI, Web UI for Mobile and PC , open-source Css Headless component library generator
- [@icestack/tailwindcss](./packages/tailwindcss/) - IceStack UI For Tailwindcss plugin
- [@icestack/unocss](./packages/unocss/) - IceStack UI For Unocss plugin
- [@icestack/postcss](./packages/postcss/) - IceStack UI For Postcss plugin
- [@icestack/cva](./packages/cva/) - The class-variance-authority function collection of IceStack UI

### Plugins

- [css-to-tailwindcss-plugin](./plugins/css-to-tailwindcss-plugin) - Transform your `css/scss` to `tailwindcss plugin`
- [compose-tailwindcss-plugins](./plugins/compose-tailwindcss-plugins) - Compose your multiple tailwindcss plugins into one
- [postcss-custom-property-prefixer](./plugins/postcss-custom-property-prefixer) - Add prefix to your css custom-property postcss plugin
- [postcss-cva](./plugins/postcss-cva) - Generate cva functions base on css comments

### Core

- [@icestack/postcss-utils](./packages/postcss-utils/) - Postcss utils hub
- [@icestack/preset-default](./packages/preset-default/) - The default preset of @icestack/ui
- [@icestack/theme-algorithm](./packages/theme-algorithm/) - The default theme-algorithm of @icestack/ui
- [@icestack/scss](./packages/scss/) - The scss utils of @icestack/ui
- [@icestack/types](./packages/types/) - Typescript types
- [@icestack/shared](./packages/shared/) - Shared utils
- [@icestack/logger](./packages/logger/) - Logger
- [@icestack/cli](./packages/cli/) - Cli package
- [@icestack/config](./packages/config/) - Config package
- [@icestack/core](./packages/core/) - Core package
- [@icestack/generator](./packages/generator/) - Code generator package

### Presets

- [@icestack/presets](./packages/presets/) - Included all presets
- [@icestack/preset-weapp](./packages/preset-weapp/) - Weapp preset
- [@icestack/preset-mockup](./packages/preset-mockup/) - Daisyui mockup components preset
- (WIP) [@icestack/preset-daisyui](./packages/preset-daisyui/) - Daisyui preset
- (WIP) [@icestack/preset-unicorn](./packages/preset-unicorn/) - Unicorn preset

### Applications

- [@icestack/app-website](./website/) - Source code of <https://ui.icebreaker.top>
- [@icestack/app-weapp](./apps/taro-app/) - Source code of weapp "爱思史塔克"
- [nuxt-admin-app](./examples/nuxt-admin-app/) - Source code of <https://nuxt.icebreaker.top/>
- [@icestack/app-storybook](./storybook/) - Source code of <https://story.ui.icebreaker.top>

## License

[MIT](./LICENSE) License &copy; 2023-PRESENT [sonofmagic](https://github.com/sonofmagic)

[codecov]: https://codecov.io/github/sonofmagic/icestack/graph/badge.svg?token=iDn2ElhNax
[codecov-url]: https://codecov.io/github/sonofmagic/icestack
[npm]: https://badgen.net/github/tag/sonofmagic/icestack?label=version&color=green
[npm-url]: https://www.npmjs.com/package/@icestack/ui
[license]: https://badgen.net/github/license/sonofmagic/icestack?color=green
[license-url]: https://github.com/sonofmagic/icestack/blob/main/LICENSE
[stars]: https://badgen.net/github/stars/sonofmagic/icestack?color=green
[gh-url]: https://github.com/sonofmagic/icestack
[dl]: https://badgen.net/npm/dt/@icestack/ui?label=installs&icon=npm&color=green
