library widgets;

import 'package:flare_flutter/flare_actor.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:percent_indicator/percent_indicator.dart';
import 'package:provider/provider.dart';
import 'package:quiz_programming/config/constants/assets.dart';
import 'package:quiz_programming/config/constants/palette.dart';
import 'package:quiz_programming/config/constants/styles.dart';
import 'package:quiz_programming/config/utils/correct_answer_definer.dart';
import 'package:quiz_programming/data/models/response_model/quiz_response.dart';
import 'package:quiz_programming/data/models/view_model/difficulty_model.dart';
import 'package:quiz_programming/data/utils/difficulty.dart';
import 'package:quiz_programming/domain/repositories/quiz_repository.dart';
import 'package:quiz_programming/domain/services/navigation/index.dart';
import 'package:quiz_programming/logic/cubit/counter_cubit.dart';
import 'package:sizer/sizer.dart';
import 'dart:math' as math;
part 'splash/splash_animation.dart';
part 'intro/intro_button.dart';
part 'intro/intro_image.dart';
part 'intro/intro_title.dart';
part 'buttons/counter_next_button.dart';
part 'counter/counter_title.dart';
part 'counter/animated_circles.dart';
part 'counter/counter_value.dart';
part 'counter/plasma_background.dart';
part 'difficulty/difficulty_slider.dart';
part 'difficulty/difficulty_title.dart';
part 'quiz/question_card.dart';
part 'quiz/progress_bar.dart';
part 'quiz/option.dart';
part 'quiz/linear_percent_show_indicator.dart';
part 'buttons/emphasized_button.dart';
part 'score/score_title.dart';
part 'score/circular_percent_show_indicator.dart';
part 'score/score_desc.dart';
part 'score/score_correct_answers_title.dart';
part 'score/correct_answer_checkbox_widget.dart';
part 'score/correct_answers_builder.dart';
part 'home/home_appbar.dart';
part 'home/percentage_bubble.dart';
part 'home/test_bubbles.dart';
part 'home/last_activity.dart';
