<p align="center">
<img src="/src/static/logo.png" alt="Logo" width="30%" />
</p>
<h1 align="center">Hacktoberfest Participants - Community 🎃 </h1>
<p align="center">
  <a href="https://github.com/iamdarshshah/hacktoberfest-participants/blob/master/LICENSE">
    <img src="https://img.shields.io/github/license/iamdarshshah/hacktoberfest-participants?logo=github&style=plastic" alt="GitHub license" />
  </a>
  <a href="https://github.com/iamdarshshah/hacktoberfest-participants/stargazers">
    <img src="https://img.shields.io/github/stars/iamdarshshah/hacktoberfest-participants?logo=github&style=plastic" alt="GitHub stars" />
  </a>
  <a href="https://github.com/iamdarshshah/hacktoberfest-participants/network">
    <img src="https://img.shields.io/github/forks/iamdarshshah/hacktoberfest-participants?logo=github&style=plastic" alt="GitHub forks" />
  </a>
  <a href="https://github.com/iamdarshshah/hacktoberfest-participants/graphs/contributors">
        <img src="https://img.shields.io/github/contributors/iamdarshshah/hacktoberfest-participants?logo=github&style=plastic" alt="Contributors"  />
    </a>
  <a href="https://github.com/iamdarshshah/hacktoberfest-participants/issues">
    <img src="https://img.shields.io/github/issues/iamdarshshah/hacktoberfest-participants?logo=github&style=plastic" alt="GitHub issues" />
  </a>
  <a href="https://github.com/iamdarshshah/hacktoberfest-participants">
    <img src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg?logo=git&style=plastic&logoColor=white" alt="PRs Welcome" />
  </a>
  <a href="https://github.com/iamdarshshah/hacktoberfest-participants">
    <img src="https://img.shields.io/github/last-commit/iamdarshshah/hacktoberfest-participants?logo=github&style=plastic" alt="GitHub last commit" />
  </a>
</p>

<p align="center">
  <i>A platform that shows a list of all the hackers, participated in month-long challenge Hacktoberfest presented by DigitalOcean.</i>
</p>

---

Our aim for this project is to have a list of all the participants, contributed
to various Open Source projects during Hactoberfest Challenge. Not only that, we
will be able to see stats for every contributor part of this community. We are
basically aiming to help the community people by showcasing them on this list
and people can connect with each other being a part of the community. Let's come
together and make this Open Source world a better place. Go add yourself to the
list. 🚀

<div align="center">
  <table border="0" cellspacing="0" cellpadding="0">
    <thead>
      <tr>
        <th>
          <strong><a href="https://ireact.tech">Light Theme 🌞</a></strong>
        </th>
        <th>
          <strong><a href="https://ireact.tech">Dark Theme 🌛</a></strong>
        </th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>
            <img
              alt="Light Theme"
              src="https://github.com/iamdarshshah/hacktoberfest-participants/blob/master/src/static/light-theme.png"
            />
        </td>
        <td>
            <img
              alt="Dark Theme"
              src="https://github.com/iamdarshshah/hacktoberfest-participants/blob/master/src/static/dark-theme.png"
            />
        </td>
      </tr>
    </tbody>
  </table>
</div>

## 🏃 Steps to add yourself in the list

1. In the top-right corner of the page, click Fork. Create a local clone of your
   fork:

   ```sh
   git clone https://github.com/YOUR-USERNAME/hacktoberfest-participants
   ```

2. Change directory

   ```sh
   cd hacktoberfest-participants
   ```

3. Create new file under **src/contributors/** with name _[your-username].json_
4. Add this json content and edit it with your details

```json
{
  "name": "REQUIRED PARAMETER",
  "desc": "REQUIRED PARAMETER",
  "github": "REQUIRED PARAMETER",
  "twitter": "OPTIONAL PARAMETER",
  "linkedin": "OPTIONAL PARAMETER"
}
```

> NOTE: The parameters mentioned as `REQUIRED` are must needed! and you can
> ignore the `OPTIONAL` parameters, But don't push _blank optional parameter_.
> Either completely ignore them or else add the required details to it.

5. Commit and generate your awesome pull request with us at
   **iamdarshshah/hacktoberfest-participants**

> Take a look [here](./example-showcase/add_me.md) for detailed version.

## 🤝 Contributing

Pull requests are welcome.

See the [guidelines](CONTRIBUTING.md) for contributing to this project.

## ⚖️ License

[MIT](LICENSE)

> Disclaimer: This website is a fan and community made creation. It is not
> affiliated with [Hacktoberfest](https://hacktoberfest.digitalocean.com/)
