﻿/*******************************************************************************
 * iNethinkCMS - 网站内容管理系统
 * Copyright (C) 2012-2013 inethink.com
 * 
 * @author jackyang <69991000@qq.com>
 * @website http://cms.inethink.com
 * @version 1.3.6.0 (2013-08-14)
 * 
 * This is licensed under the GNU LGPL, version 3.0 or later.
 * For details, see: http://www.gnu.org/licenses/gpl-3.0.html
*******************************************************************************/
using System;
using System.Data;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text.RegularExpressions;
using iNethinkCMS.Web.UI;

namespace iNethinkCMS.Web
{
    public partial class special : BasePage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            # region 页面传值分析
            string rID;
            int vID;
            rID = Request.QueryString["ID"];
            if (rID == null || rID.IndexOf(",", 0) > 0 || Command.Command_Validate.IsNumber(rID) == false)
            {
                Response.Write("<H3>栏目ID错误!</H3>");
                Response.End();
            }
            vID = Convert.ToInt32(rID);

            string rPage;
            rPage = Request.QueryString["page"];

            int vPage = 1;
            if (rPage != string.Empty && rPage != null && Command.Command_Validate.IsNumber(rPage))
            {
                vPage = Convert.ToInt32(rPage);
            }
            #endregion

            #region 获取页面信息
            string vHtml = "";
            bool vWebPageCache = Command.Command_Configuration.GetConfigBool("WebPageCache"); //判断是否启用了页面缓存
            if (vWebPageCache == false)
            {
                vHtml = Fun_GetSpecialContent(vID, vPage);
            }
            else
            {
                int vCacheTime = Command.Command_Configuration.GetConfigInt("CacheTime");
                string specialCacheKey = Command.Command_Configuration.GetConfigString("CacheKey") + "_SpecialCache_" + vID + "_" + vPage;
                object specialCacheInfo = Command.Command_DataCache.GetCache(specialCacheKey);

                //判断缓存是否存在
                if (specialCacheInfo == null)
                {
                    vHtml = Fun_GetSpecialContent(vID, vPage);
                    Command.Command_DataCache.SetCache(specialCacheKey, (object)vHtml, DateTime.Now.AddSeconds(vCacheTime), TimeSpan.Zero);
                }
                else
                {
                    vHtml = specialCacheInfo.ToString();
                }
            }

            vHtml = WebUI_Function.Fun_UrlRewriter(vHtml);
            Response.Write(vHtml);
            #endregion
        }

        private string Fun_GetSpecialContent(int byID, int byPage)
        {
            //获取当前栏目信息
            BLL.BLL_iNethinkCMS_Special bll = new BLL.BLL_iNethinkCMS_Special();
            Model.Model_iNethinkCMS_Special model = new Model.Model_iNethinkCMS_Special();

            model = bll.GetModel(byID);
            if (model == null)
            {
                Response.Write("<H3>不存在该栏目!</H3>");
                Response.End();
            }

            if (model.Display == 0)
            {
                Response.Write("<H3>该栏目已被关闭!</H3>");
                Response.End();
            }

            //当该页面启用了跳转时,则跳转!
            if (model.SpecialUrl != null && model.SpecialUrl != string.Empty)
            {
                //Response.Redirect(model.SpecialUrl);
                Response.Clear();
                Response.Status = "301 Moved Permanently";
                Response.AddHeader("Location", model.SpecialUrl);
                Response.End();
            }


            string vTemplateUrl = vTemplateUrl = model.SpecialTemplate;
            DataTable dt = bll.GetList("[ID] = " + byID).Tables[0];
            DataRow dr = dt.Rows[0];

            WebUI_Template wt = new WebUI_Template();
            wt.Load_Template(vTemplateUrl);
            wt.vPage = byPage;
            wt.vCID = byID;

            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{sys:title}"), siteConfig.WebName, RegexOptions.IgnoreCase);
            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{sys:seotitle}"), seoConfig.SeoTitle, RegexOptions.IgnoreCase);
            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{sys:keywords}"), seoConfig.IndexKeywords, RegexOptions.IgnoreCase);
            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{sys:description}"), seoConfig.IndexDescription, RegexOptions.IgnoreCase);
            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{sys:sitepath}"), "<a href=\"/\">首页</a> > 专题 > " + dr["SpecialName"].ToString(), RegexOptions.IgnoreCase);

            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{field:specialtitle}"), dr["SpecialTitle"].ToString(), RegexOptions.IgnoreCase);
            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{field:specialkeyword}"), dr["SpecialKeyword"].ToString(), RegexOptions.IgnoreCase);
            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{field:specialdescription}"), dr["SpecialDescription"].ToString(), RegexOptions.IgnoreCase);

            wt.vContent = wt.Parser_Tags(0, @"\{field:(.+?)\}", wt.vContent, dr);   //数据信息替换

            wt.Parser_MyTag();
            wt.Parser_List();
            wt.Parser_Page();
            wt.Parser_IF();
            return wt.vContent;
        }
    }
}