﻿/*******************************************************************************
 * iNethinkCMS - 网站内容管理系统
 * Copyright (C) 2012-2013 inethink.com
 * 
 * @author jackyang <69991000@qq.com>
 * @website http://cms.inethink.com
 * @version 1.3.6.0 (2013-08-14)
 * 
 * This is licensed under the GNU LGPL, version 3.0 or later.
 * For details, see: http://www.gnu.org/licenses/gpl-3.0.html
*******************************************************************************/
using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using iNethinkCMS.Helper;
using iNethinkCMS.Command;
using iNethinkCMS.Web.UI;

namespace iNethinkCMS.Web.plugs.guestbook
{
    public partial class manage : Admin_BasePage
    {
        private string vXmlPath = @"/plugs/guestbook/setting.xml";
        private string vState;
        private string vTemplatepath;
        private string vTimeinterval;
        private string vContentlength;
        private string vContentclearhtml;
        private string vSecuritycode;

        protected void Page_Load(object sender, EventArgs e)
        {
            CheckUserPower("c");
            if (!IsPostBack)
            {
                if (Request.UrlReferrer != null)
                {
                    ViewState["reJumpUrl"] = Request.UrlReferrer.AbsoluteUri;
                }
                else
                {
                    ViewState["reJumpUrl"] = Request.Url.AbsoluteUri;
                }

                vState = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"state\"]", "value").Value.Trim();
                vTemplatepath = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"templatepath\"]", "value").Value.Trim();
                vTimeinterval = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"timeinterval\"]", "value").Value.Trim();
                vContentlength = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"contentlength\"]", "value").Value.Trim();
                vContentclearhtml = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"contentclearhtml\"]", "value").Value.Trim();
                vSecuritycode = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"securitycode\"]", "value").Value.Trim();
                this.txtState.SelectedValue = vState;
                this.txtTemplatepath.Text = vTemplatepath;
                this.txtTimeinterval.Text = vTimeinterval;
                this.txtContentlength.Text = vContentlength;
                this.txtContentclearhtml.SelectedValue = vContentclearhtml;
                this.txtSecuritycode.SelectedValue = vSecuritycode;
            }
        }

        protected void Button_Submit_Click(object sender, EventArgs e)
        {
            vState = this.txtState.SelectedValue;
            vTemplatepath = this.txtTemplatepath.Text.Trim();
            vTimeinterval = this.txtTimeinterval.Text.Trim();
            vContentlength = this.txtContentlength.Text.Trim();
            vContentclearhtml = this.txtContentclearhtml.SelectedValue;
            vSecuritycode = this.txtSecuritycode.SelectedValue;

            if (this.vTemplatepath.Length == 0)
            {
                MessageBox.Show(this, "请输入模板路径!");
                return;
            }
            if (!Command_Validate.IsNumber(vTimeinterval))
            {
                MessageBox.Show(this, "时间间隔只能为数字!");
                return;
            }
            if (!Command_Validate.IsNumber(vContentlength))
            {
                MessageBox.Show(this, "留言内容长度只能为数字!");
                return;
            }

            XMLHelper.CreateOrUpdateXmlAttributeByXPath(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"state\"]", "value", vState);
            XMLHelper.CreateOrUpdateXmlAttributeByXPath(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"templatepath\"]", "value", vTemplatepath);
            XMLHelper.CreateOrUpdateXmlAttributeByXPath(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"timeinterval\"]", "value", vTimeinterval);
            XMLHelper.CreateOrUpdateXmlAttributeByXPath(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"contentlength\"]", "value", vContentlength);
            XMLHelper.CreateOrUpdateXmlAttributeByXPath(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"contentclearhtml\"]", "value", vContentclearhtml);
            XMLHelper.CreateOrUpdateXmlAttributeByXPath(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"securitycode\"]", "value", vSecuritycode);

            Response.Redirect(ViewState["reJumpUrl"].ToString());


        }
    }
}