﻿/*******************************************************************************
 * iNethinkCMS - 网站内容管理系统
 * Copyright (C) 2012-2013 inethink.com
 * 
 * @author jackyang <69991000@qq.com>
 * @website http://cms.inethink.com
 * @version 1.3.6.0 (2013-08-14)
 * 
 * This is licensed under the GNU LGPL, version 3.0 or later.
 * For details, see: http://www.gnu.org/licenses/gpl-3.0.html
*******************************************************************************/
using System;
using System.Collections.Generic;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text.RegularExpressions;
using iNethinkCMS.Web.UI;
using iNethinkCMS.Helper;
using iNethinkCMS.Command;

namespace iNethinkCMS.Web.plugs.guestbook
{
    public partial class index : BasePage
    {
        private string vXmlPath = @"/plugs/guestbook/setting.xml";
        private string vState;
        private string vTemplatepath;
        private string vTimeinterval;
        private string vContentlength;
        private string vContentclearhtml;
        private string vSecuritycode;

        protected void Page_Load(object sender, EventArgs e)
        {
            vState = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"state\"]", "value").Value.Trim();
            vTemplatepath = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"templatepath\"]", "value").Value.Trim();
            vTimeinterval = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"timeinterval\"]", "value").Value.Trim();
            vContentlength = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"contentlength\"]", "value").Value.Trim();
            vContentclearhtml = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"contentclearhtml\"]", "value").Value.Trim();
            vSecuritycode = XMLHelper.GetXmlAttribute(Server.MapPath(vXmlPath), "//plugs//config//key[@name=\"securitycode\"]", "value").Value.Trim();

            //判断是否开启
            if (vState == "0")
            {
                Response.Write("<H3>留言板功能尚未开启!</H3>");
                Response.End();
            }

            string vAct = "";
            vAct = Request.QueryString["Act"] != null ? Request.QueryString["Act"] : "";

            switch (vAct)
            {
                case "guestbooksubmit":
                    #region 提交留言信息
                    //防止外部提交
                    if (Command_Function.Fun_CheckPost())
                    {
                        Response.Write("<H3>请勿外部提交!</H3>");
                        Response.End();
                    }

                    //判断时间限制
                    if (int.Parse(vTimeinterval) > 0)
                    {
                        string vLastPostTimeStr = Command_Session.Get("GuestBook_PostTime_Last");
                        if (Command_Validate.IsDateTime(vLastPostTimeStr))
                        {
                            DateTime vLastPostTime = DateTime.Parse(vLastPostTimeStr);
                            TimeSpan Ts = new System.TimeSpan(DateTime.Now.Ticks - vLastPostTime.Ticks);

                            if (Ts.TotalSeconds <= int.Parse(vTimeinterval))
                            {
                                Response.Write("E000");
                                Response.End();
                            }
                        }
                    }

                    //取值
                    string vGuestbookUserName = Request.Form["sGuestbookUserName"];
                    string vGuestbookUserIP = Command.Command_Function.GetUserIp();
                    string vGuestbookTel = Request.Form["sGuestbookTel"];
                    string vGuestbookCompany = Request.Form["sGuestbookCompany"];
                    string vGuestbookAddress = Request.Form["sGuestbookAddress"];
                    string vGuestbookEmail = Request.Form["sGuestbookEmail"];
                    string vGuestbookQQ = Request.Form["sGuestbookQQ"];
                    string vGuestbookContent = Request.Form["sGuestbookContent"];
                    string vGuestbookSecuritycode = Request.Form["sGuestbookSecuritycode"];
                    DateTime vGuestbookTime = DateTime.Now;
                    string vReplyUserName = "";
                    string vReplyContent = "";
                    //DateTime vReplyTime;
                    int vDisplay = 0;
                    int vOrderNum = 0;

                    vGuestbookUserName = Command.Command_StringPlus.Left(Command.Command_Validate.SqlTextClear(Command.Command_StringPlus.LostHTML(vGuestbookUserName)), 20);
                    vGuestbookCompany = Command.Command_StringPlus.Left(Command.Command_Validate.SqlTextClear(Command.Command_StringPlus.LostHTML(vGuestbookCompany)), 100);
                    vGuestbookAddress = Command.Command_StringPlus.Left(Command.Command_Validate.SqlTextClear(Command.Command_StringPlus.LostHTML(vGuestbookAddress)), 100);
                    vGuestbookTel = Command.Command_StringPlus.Left(Command.Command_Validate.SqlTextClear(Command.Command_StringPlus.LostHTML(vGuestbookTel)), 100);
                    vGuestbookEmail = Command.Command_StringPlus.Left(Command.Command_Validate.SqlTextClear(Command.Command_StringPlus.LostHTML(vGuestbookEmail)), 100);
                    vGuestbookQQ = Command.Command_StringPlus.Left(Command.Command_Validate.SqlTextClear(Command.Command_StringPlus.LostHTML(vGuestbookQQ)), 100);

                    if (vContentclearhtml == "1")
                    {
                        vGuestbookContent = Command.Command_StringPlus.LostHTML(vGuestbookContent);
                    }
                    vGuestbookContent = vGuestbookContent.Replace("{", "").Replace("}", "").Replace("'", "").Replace("\"", "").Replace("%", "");
                    vGuestbookContent = Command.Command_StringPlus.Left(vGuestbookContent, int.Parse(vContentlength));

                    vGuestbookSecuritycode = Command.Command_Validate.SqlTextClear(vGuestbookSecuritycode);

                    //验证
                    if (String.IsNullOrEmpty(vGuestbookUserName))
                    {
                        Response.Write("E001");
                        Response.End();
                    }
                    if (String.IsNullOrEmpty(vGuestbookContent))
                    {
                        Response.Write("E002");
                        Response.End();
                    }
                    //判断验证码情况
                    if (vSecuritycode == "1")
                    {
                        if (String.IsNullOrEmpty(vGuestbookSecuritycode))
                        {
                            Response.Write("E003");
                            Response.End();
                        }

                        if (vGuestbookSecuritycode != Command.Command_Session.Get("verificationcode"))
                        {
                            Response.Write("E004");
                            Response.End();
                        }
                    }


                    //入库
                    iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook model = new iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook();
                    iNethinkCMS.BLL.BLL_iNethinkCMS_Plugs_Guestbook bll = new iNethinkCMS.BLL.BLL_iNethinkCMS_Plugs_Guestbook();

                    model.GuestbookUserName = vGuestbookUserName;
                    model.GuestbookUserIP = vGuestbookUserIP;
                    model.GuestbookCompany = vGuestbookCompany;
                    model.GuestbookAddress = vGuestbookAddress;
                    model.GuestbookTel = vGuestbookTel;
                    model.GuestbookEmail = vGuestbookEmail;
                    model.GuestbookQQ = vGuestbookQQ;
                    model.GuestbookContent = vGuestbookContent;
                    model.GuestbookTime = vGuestbookTime;
                    model.ReplyUserName = vReplyUserName;
                    model.ReplyContent = vReplyContent;
                    //model.ReplyTime = vReplyTime;
                    model.Display = vDisplay;
                    model.OrderNum = vOrderNum;

                    bll.Add(model);

                    //写入提交时间Session信息
                    iNethinkCMS.Command.Command_Session.Add("GuestBook_PostTime_Last", DateTime.Now.ToString());

                    Response.Write("E100");

                    #endregion
                    break;
                default:
                    #region 留言页面显示

                    string rPage;
                    rPage = Request.QueryString["page"];

                    int vPage = 1;
                    if (rPage != string.Empty && rPage != null && Command.Command_Validate.IsNumber(rPage))
                    {
                        vPage = Convert.ToInt32(rPage);
                    }

                    string vHtml = "";
                    bool vWebPageCache = Command.Command_Configuration.GetConfigBool("WebPageCache"); //判断是否启用了页面缓存
                    if (vWebPageCache == false)
                    {
                        vHtml = Fun_GetGuestBookContent(vPage);
                    }
                    else
                    {
                        int vCacheTime = Command.Command_Configuration.GetConfigInt("CacheTime");
                        string guestbookCacheKey = Command.Command_Configuration.GetConfigString("CacheKey") + "_GuestBookCache_" + vPage;
                        object guestbookCacheInfo = Command.Command_DataCache.GetCache(guestbookCacheKey);

                        //判断缓存是否存在
                        if (guestbookCacheInfo == null)
                        {
                            vHtml = Fun_GetGuestBookContent(vPage);
                            Command.Command_DataCache.SetCache(guestbookCacheKey, (object)vHtml, DateTime.Now.AddSeconds(vCacheTime), TimeSpan.Zero);
                        }
                        else
                        {
                            vHtml = guestbookCacheInfo.ToString();
                        }
                    }
                    vHtml = WebUI_Function.Fun_UrlRewriter(vHtml);
                    Response.Write(vHtml);


                    #endregion
                    break;
            }
        }

        private string Fun_GetGuestBookContent(int byPage)
        {
            string vTemplateUrl = vTemplatepath;
            WebUI_Template wt = new WebUI_Template();
            wt.Load_Template(vTemplateUrl);
            wt.vPage = byPage;

            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{sys:title}"), siteConfig.WebName, RegexOptions.IgnoreCase);
            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{sys:seotitle}"), seoConfig.SeoTitle, RegexOptions.IgnoreCase);
            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{sys:keywords}"), seoConfig.IndexKeywords, RegexOptions.IgnoreCase);
            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{sys:description}"), seoConfig.IndexDescription, RegexOptions.IgnoreCase);
            wt.vContent = Regex.Replace(wt.vContent, Regex.Escape("{sys:sitepath}"), "<a href=\"/\">首页</a>&nbsp;>&nbsp;留言板", RegexOptions.IgnoreCase);

            wt.Parser_MyTag();
            wt.Parser_List();
            wt.Parser_Page();
            wt.Parser_IF();
            return wt.vContent;
        }
    }
}