﻿/*******************************************************************************
 * iNethinkCMS - 网站内容管理系统
 * Copyright (C) 2012-2013 inethink.com
 * 
 * @author jackyang <69991000@qq.com>
 * @website http://cms.inethink.com
 * @version 1.3.6.0 (2013-08-14)
 * 
 * This is licensed under the GNU LGPL, version 3.0 or later.
 * For details, see: http://www.gnu.org/licenses/gpl-3.0.html
*******************************************************************************/
using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using iNethinkCMS.Command;
using iNethinkCMS.Web.UI;

namespace iNethinkCMS.Web.plugs.guestbook
{

    public partial class guestbook_manage : Admin_BasePage
    {
        iNethinkCMS.BLL.BLL_iNethinkCMS_Plugs_Guestbook bll = new iNethinkCMS.BLL.BLL_iNethinkCMS_Plugs_Guestbook();
        iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook model = new iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook();

        private string vNavInfo = "当前位置：";
        private string vAct = "";
        private int vPage = 1;
        private int vID = 0;
        private string vSQL = "";
        private string vKeyType = "";
        private string vKey = "";

        private string vGuestbookUserName;
        private string vGuestbookUserIP;
        private string vGuestbookCompany;
        private string vGuestbookAddress;
        private string vGuestbookTel;
        private string vGuestbookEmail;
        private string vGuestbookQQ;
        private string vGuestbookContent;
        private DateTime vGuestbookTime;
        private string vReplyUserName;
        private string vReplyContent;
        private DateTime vReplyTime;
        private int vDisplay;
        private int vOrderNum;

        protected void Page_Load(object sender, EventArgs e)
        {
            CheckUserPower("a");

            #region
            vAct = Request.QueryString["Act"] != null ? Request.QueryString["Act"] : "";
            if (Request.QueryString["Page"] != null && Request.QueryString["Page"].Trim() != "")
            {
                if (!int.TryParse(Request.QueryString["Page"], out vPage))
                {
                    vPage = 1;
                }
            }
            vKeyType = Request.QueryString["sKeyType"] != null ? Request.QueryString["sKeyType"] : "";
            vKey = Request.QueryString["sKey"] != null ? Request.QueryString["sKey"] : "";
            vKey = vKey.Replace("'", "");
            if (Request.QueryString["ID"] != null && Request.QueryString["ID"].Trim() != "")
            {
                if (!int.TryParse(Request.QueryString["ID"], out vID))
                {
                    Response.Write("ID Error");
                    Response.End();
                }
            }

            if (vKey.Length > 0)
            {
                if (vKeyType == "ID")
                {
                    if (iNethinkCMS.Command.Command_Validate.IsNumber(vKey) == true)
                    {
                        vSQL += vKeyType + " = " + vKey + "";
                    }
                    else
                    {
                        vKey = "";
                    }
                }
                else
                {
                    vSQL += vKeyType + " Like '%" + vKey + "%'";
                }
            }
            #endregion

            this.mainID.Visible = false;
            this.guideID.Visible = false;
            switch (vAct)
            {
                case "guide":

                    this.guideID.Visible = true;
                    if (vID == 0)
                    {
                        this.navInfoID.InnerText = vNavInfo + "留言添加";
                        this.Button_Submit.Click += new EventHandler(Button_Submit_Click_Add);
                    }
                    else
                    {
                        this.navInfoID.InnerText = vNavInfo + "留言管理";
                        this.Button_Submit.Click += new EventHandler(Button_Submit_Click_Edit);
                    }
                    if (!IsPostBack)
                    {
                        if (Request.UrlReferrer != null)
                        {
                            ViewState["reJumpUrl"] = Request.UrlReferrer.AbsoluteUri;
                        }
                        Fun_SetValue(vID); //获取frm基本信息
                    }
                    break;

                case "delete":
                    Fun_Delete(vID);
                    break;

                default:
                    this.navInfoID.InnerText = vNavInfo + "留言管理";
                    this.mainID.Visible = true;
                    if (!IsPostBack)
                    {
                        this.sKeyType.SelectedValue = vKeyType;
                        this.sKey.Text = vKey;
                    }
                    PageListInfo();
                    break;
            }

        }

        #region mainID 列表
        protected void PageListInfo()
        {
            int vPageSize = int.Parse(siteConfig.PageListNum);
            int vRecordCount = bll.GetRecordCount(vSQL);

            Repeater.DataSource = bll.GetListByPage(vSQL, "ID Desc", (vPage - 1) * vPageSize, vPage * vPageSize);
            Repeater.DataBind();

            string pTemp = "";
            int vPageCount = 1;
            if (vRecordCount > 0)
            {
                vPageCount = (int)Math.Ceiling((double)vRecordCount / (double)vPageSize);
                pTemp = WebUI_PageList.GetPagingInfo_Manage(vPageCount, vRecordCount, vPage, vPageSize);
            }

            this.pagelist.InnerHtml = pTemp;
            this.iNoInfo.Visible = vRecordCount == 0 ? true : false;
        }

        protected void Button_Search_Click(object sender, EventArgs e)
        {
            Response.Redirect(Request.Path + "?skeytype=" + this.sKeyType.SelectedValue + "&skey=" + this.sKey.Text);
        }

        #endregion

        #region guideID 信息修改/添加
        private void Fun_SetValue(int byID)
        {
            if (byID == 0)
            {
                this.txtGuestbookUserName.Text = "";
                this.txtGuestbookUserIP.Text = "";
                this.txtGuestbookCompany.Text = "";
                this.txtGuestbookAddress.Text = "";
                this.txtGuestbookTel.Text = "";
                this.txtGuestbookEmail.Text = "";
                this.txtGuestbookQQ.Text = "";
                this.txtGuestbookContent.Text = "";
                this.txtGuestbookTime.Text = "";
                this.txtReplyUserName.Text = SysLoginUserTrueName;
                this.txtReplyContent.Text = "";
                this.txtReplyTime.Text = DateTime.Now.ToString();
                this.txtDisplay.Checked = false;
                this.txtOrderNum.Text = "0";
            }
            else
            {
                model = bll.GetModel(byID);
                this.txtGuestbookUserName.Text = model.GuestbookUserName;
                this.txtGuestbookUserIP.Text = model.GuestbookUserIP;
                this.txtGuestbookCompany.Text = model.GuestbookCompany;
                this.txtGuestbookAddress.Text = model.GuestbookAddress;
                this.txtGuestbookTel.Text = model.GuestbookTel;
                this.txtGuestbookEmail.Text = model.GuestbookEmail;
                this.txtGuestbookQQ.Text = model.GuestbookQQ;
                this.txtGuestbookContent.Text = model.GuestbookContent;
                this.txtGuestbookTime.Text = model.GuestbookTime.ToString();
                this.txtReplyUserName.Text = String.IsNullOrEmpty(model.ReplyUserName) == true ? SysLoginUserTrueName : model.ReplyUserName;
                this.txtReplyContent.Text = model.ReplyContent;
                this.txtReplyTime.Text = String.IsNullOrEmpty(model.ReplyTime.ToString()) == true ? DateTime.Now.ToString() : model.ReplyTime.ToString(); ;
                this.txtDisplay.Checked = model.Display == 1 ? true : false;
                this.txtOrderNum.Text = String.IsNullOrEmpty(model.OrderNum.ToString()) == true ? "0" : model.OrderNum.ToString();
            }
        }

        private bool Fun_GetValue()
        {
            if (this.txtGuestbookUserName.Text.Trim().Length == 0)
            {
                MessageBox.Show(this, "请输入留言人!");
                return false;
            }
            if (this.txtGuestbookContent.Text.Trim().Length == 0)
            {
                MessageBox.Show(this, "请输入留言内容!");
                return false;
            }

            if (this.txtDisplay.Checked == true)
            {
                if (this.txtReplyUserName.Text.Trim().Length == 0)
                {
                    MessageBox.Show(this, "请输入回复人!");
                    return false;
                }
                if (this.txtReplyContent.Text.Trim().Length == 0)
                {
                    MessageBox.Show(this, "请输入回复内容!");
                    return false;
                }
                if (!Command_Validate.IsNumber(this.txtOrderNum.Text.Trim()))
                {
                    MessageBox.Show(this, "排序权重只能输入数字!");
                    return false;
                }
            }

            vGuestbookUserName = this.txtGuestbookUserName.Text.Trim();
            vGuestbookUserIP = this.txtGuestbookUserIP.Text.Trim();
            vGuestbookCompany = this.txtGuestbookCompany.Text.Trim();
            vGuestbookAddress = this.txtGuestbookAddress.Text.Trim();
            vGuestbookTel = this.txtGuestbookTel.Text.Trim();
            vGuestbookEmail = this.txtGuestbookEmail.Text.Trim();
            vGuestbookQQ = this.txtGuestbookQQ.Text.Trim();
            vGuestbookContent = this.txtGuestbookContent.Text.Trim();
            vGuestbookTime = DateTime.Parse(this.txtGuestbookTime.Text.Trim());
            vReplyUserName = this.txtReplyUserName.Text.Trim();
            vReplyContent = this.txtReplyContent.Text.Trim();
            vReplyTime = DateTime.Parse(this.txtReplyTime.Text.Trim());
            vDisplay = this.txtDisplay.Checked == true ? 1 : 0;
            vOrderNum = int.Parse(this.txtOrderNum.Text.Trim());
            return true;
        }

        protected void Button_Submit_Click_Add(object sender, EventArgs e)
        {
            if (Fun_GetValue() == true)
            {
                model.GuestbookUserName = vGuestbookUserName;
                model.GuestbookUserIP = vGuestbookUserIP;
                model.GuestbookCompany = vGuestbookCompany;
                model.GuestbookAddress = vGuestbookAddress;
                model.GuestbookTel = vGuestbookTel;
                model.GuestbookEmail = vGuestbookEmail;
                model.GuestbookQQ = vGuestbookQQ;
                model.GuestbookContent = vGuestbookContent;
                model.GuestbookTime = vGuestbookTime;
                model.ReplyUserName = vReplyUserName;
                model.ReplyContent = vReplyContent;
                model.ReplyTime = vReplyTime;
                model.Display = vDisplay;
                model.OrderNum = vOrderNum;
                bll.Add(model);

                Response.Redirect(Request.Path);

            }
        }

        protected void Button_Submit_Click_Edit(object sender, EventArgs e)
        {
            if (Fun_GetValue() == true)
            {
                if (bll.GetRecordCount("ID = " + vID) == 0)  //判断该ID是否被删除
                {
                    MessageBox.ShowAndRedirect(this, "你所需要更新的记录 [" + vID + "] 不存在!", ViewState["reJumpUrl"].ToString());
                    return;
                }

                model.ID = vID;
                model.GuestbookUserName = vGuestbookUserName;
                model.GuestbookUserIP = vGuestbookUserIP;
                model.GuestbookCompany = vGuestbookCompany;
                model.GuestbookAddress = vGuestbookAddress;
                model.GuestbookTel = vGuestbookTel;
                model.GuestbookEmail = vGuestbookEmail;
                model.GuestbookQQ = vGuestbookQQ;
                model.GuestbookContent = vGuestbookContent;
                model.GuestbookTime = vGuestbookTime;
                model.ReplyUserName = vReplyUserName;
                model.ReplyContent = vReplyContent;
                model.ReplyTime = vReplyTime;
                model.Display = vDisplay;
                model.OrderNum = vOrderNum;
                bll.Update(model);

                Response.Redirect(ViewState["reJumpUrl"].ToString());
            }
        }
        #endregion

        #region Delete 数据删除
        protected void Fun_Delete(int byID)
        {
            if (bll.Delete(byID) == true)
            {
                Response.Redirect(Request.UrlReferrer.AbsoluteUri);
            }
        }
        #endregion

    }
}