﻿/*******************************************************************************
 * iNethinkCMS - 网站内容管理系统
 * Copyright (C) 2012-2013 inethink.com
 * 
 * @author jackyang <69991000@qq.com>
 * @website http://cms.inethink.com
 * @version 1.3.6.0 (2013-08-14)
 * 
 * This is licensed under the GNU LGPL, version 3.0 or later.
 * For details, see: http://www.gnu.org/licenses/gpl-3.0.html
*******************************************************************************/
using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using iNethinkCMS.Helper;

namespace iNethinkCMS.DAL
{
    /// <summary>
    /// 数据访问类:DAL_iNethinkCMS_Plugs_Guestbook
    /// </summary>
    public partial class DAL_iNethinkCMS_Plugs_Guestbook
    {
        public DAL_iNethinkCMS_Plugs_Guestbook()
        { }
        /// <summary>
        /// 是否存在该记录
        /// </summary>
        public bool Exists(int ID)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select count(1) from iNethinkCMS_Plugs_Guestbook");
            strSql.Append(" where ID=@ID");
            SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)
			};
            parameters[0].Value = ID;

            return SQLHelper.Exists(strSql.ToString(), parameters);
        }


        /// <summary>
        /// 增加一条数据
        /// </summary>
        public int Add(iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into iNethinkCMS_Plugs_Guestbook(");
            strSql.Append("GuestbookUserName,GuestbookUserIP,GuestbookCompany,GuestbookAddress,GuestbookTel,GuestbookEmail,GuestbookQQ,GuestbookContent,GuestbookTime,ReplyUserName,ReplyContent,ReplyTime,Display,OrderNum)");
            strSql.Append(" values (");
            strSql.Append("@GuestbookUserName,@GuestbookUserIP,@GuestbookCompany,@GuestbookAddress,@GuestbookTel,@GuestbookEmail,@GuestbookQQ,@GuestbookContent,@GuestbookTime,@ReplyUserName,@ReplyContent,@ReplyTime,@Display,@OrderNum)");
            strSql.Append(";select @@IDENTITY");
            SqlParameter[] parameters = {
					new SqlParameter("@GuestbookUserName", SqlDbType.NVarChar,20),
					new SqlParameter("@GuestbookUserIP", SqlDbType.NVarChar,15),
					new SqlParameter("@GuestbookCompany", SqlDbType.NVarChar,200),
					new SqlParameter("@GuestbookAddress", SqlDbType.NVarChar,200),
					new SqlParameter("@GuestbookTel", SqlDbType.NVarChar,200),
					new SqlParameter("@GuestbookEmail", SqlDbType.NVarChar,200),
					new SqlParameter("@GuestbookQQ", SqlDbType.NVarChar,200),
					new SqlParameter("@GuestbookContent", SqlDbType.NText),
					new SqlParameter("@GuestbookTime", SqlDbType.DateTime),
					new SqlParameter("@ReplyUserName", SqlDbType.NVarChar,20),
					new SqlParameter("@ReplyContent", SqlDbType.NText),
					new SqlParameter("@ReplyTime", SqlDbType.DateTime),
					new SqlParameter("@Display", SqlDbType.SmallInt,2),
					new SqlParameter("@OrderNum", SqlDbType.Int,4)};
            parameters[0].Value = model.GuestbookUserName;
            parameters[1].Value = model.GuestbookUserIP;
            parameters[2].Value = model.GuestbookCompany;
            parameters[3].Value = model.GuestbookAddress;
            parameters[4].Value = model.GuestbookTel;
            parameters[5].Value = model.GuestbookEmail;
            parameters[6].Value = model.GuestbookQQ;
            parameters[7].Value = model.GuestbookContent;
            parameters[8].Value = model.GuestbookTime;
            parameters[9].Value = model.ReplyUserName;
            parameters[10].Value = model.ReplyContent;
            parameters[11].Value = model.ReplyTime;
            parameters[12].Value = model.Display;
            parameters[13].Value = model.OrderNum;

            object obj = SQLHelper.GetSingle(strSql.ToString(), parameters);
            if (obj == null)
            {
                return 0;
            }
            else
            {
                return Convert.ToInt32(obj);
            }
        }
        /// <summary>
        /// 更新一条数据
        /// </summary>
        public bool Update(iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update iNethinkCMS_Plugs_Guestbook set ");
            strSql.Append("GuestbookUserName=@GuestbookUserName,");
            strSql.Append("GuestbookUserIP=@GuestbookUserIP,");
            strSql.Append("GuestbookCompany=@GuestbookCompany,");
            strSql.Append("GuestbookAddress=@GuestbookAddress,");
            strSql.Append("GuestbookTel=@GuestbookTel,");
            strSql.Append("GuestbookEmail=@GuestbookEmail,");
            strSql.Append("GuestbookQQ=@GuestbookQQ,");
            strSql.Append("GuestbookContent=@GuestbookContent,");
            strSql.Append("GuestbookTime=@GuestbookTime,");
            strSql.Append("ReplyUserName=@ReplyUserName,");
            strSql.Append("ReplyContent=@ReplyContent,");
            strSql.Append("ReplyTime=@ReplyTime,");
            strSql.Append("Display=@Display,");
            strSql.Append("OrderNum=@OrderNum");
            strSql.Append(" where ID=@ID");
            SqlParameter[] parameters = {
					new SqlParameter("@GuestbookUserName", SqlDbType.NVarChar,20),
					new SqlParameter("@GuestbookUserIP", SqlDbType.NVarChar,15),
					new SqlParameter("@GuestbookCompany", SqlDbType.NVarChar,200),
					new SqlParameter("@GuestbookAddress", SqlDbType.NVarChar,200),
					new SqlParameter("@GuestbookTel", SqlDbType.NVarChar,200),
					new SqlParameter("@GuestbookEmail", SqlDbType.NVarChar,200),
					new SqlParameter("@GuestbookQQ", SqlDbType.NVarChar,200),
					new SqlParameter("@GuestbookContent", SqlDbType.NText),
					new SqlParameter("@GuestbookTime", SqlDbType.DateTime),
					new SqlParameter("@ReplyUserName", SqlDbType.NVarChar,20),
					new SqlParameter("@ReplyContent", SqlDbType.NText),
					new SqlParameter("@ReplyTime", SqlDbType.DateTime),
					new SqlParameter("@Display", SqlDbType.SmallInt,2),
					new SqlParameter("@OrderNum", SqlDbType.Int,4),
					new SqlParameter("@ID", SqlDbType.Int,4)};
            parameters[0].Value = model.GuestbookUserName;
            parameters[1].Value = model.GuestbookUserIP;
            parameters[2].Value = model.GuestbookCompany;
            parameters[3].Value = model.GuestbookAddress;
            parameters[4].Value = model.GuestbookTel;
            parameters[5].Value = model.GuestbookEmail;
            parameters[6].Value = model.GuestbookQQ;
            parameters[7].Value = model.GuestbookContent;
            parameters[8].Value = model.GuestbookTime;
            parameters[9].Value = model.ReplyUserName;
            parameters[10].Value = model.ReplyContent;
            parameters[11].Value = model.ReplyTime;
            parameters[12].Value = model.Display;
            parameters[13].Value = model.OrderNum;
            parameters[14].Value = model.ID;

            int rows = SQLHelper.ExecuteSql(strSql.ToString(), parameters);
            if (rows > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public bool Delete(int ID)
        {

            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from iNethinkCMS_Plugs_Guestbook ");
            strSql.Append(" where ID=@ID");
            SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)
			};
            parameters[0].Value = ID;

            int rows = SQLHelper.ExecuteSql(strSql.ToString(), parameters);
            if (rows > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// 批量删除数据
        /// </summary>
        public bool DeleteList(string IDlist)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from iNethinkCMS_Plugs_Guestbook ");
            strSql.Append(" where ID in (" + IDlist + ")  ");
            int rows = SQLHelper.ExecuteSql(strSql.ToString());
            if (rows > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }


        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook GetModel(int ID)
        {

            StringBuilder strSql = new StringBuilder();
            strSql.Append("select  top 1 ID,GuestbookUserName,GuestbookUserIP,GuestbookCompany,GuestbookAddress,GuestbookTel,GuestbookEmail,GuestbookQQ,GuestbookContent,GuestbookTime,ReplyUserName,ReplyContent,ReplyTime,Display,OrderNum from iNethinkCMS_Plugs_Guestbook ");
            strSql.Append(" where ID=@ID");
            SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)
			};
            parameters[0].Value = ID;

            iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook model = new iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook();
            DataSet ds = SQLHelper.Query(strSql.ToString(), parameters);
            if (ds.Tables[0].Rows.Count > 0)
            {
                return DataRowToModel(ds.Tables[0].Rows[0]);
            }
            else
            {
                return null;
            }
        }


        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook DataRowToModel(DataRow row)
        {
            iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook model = new iNethinkCMS.Model.Model_iNethinkCMS_Plugs_Guestbook();
            if (row != null)
            {
                if (row["ID"] != null && row["ID"].ToString() != "")
                {
                    model.ID = int.Parse(row["ID"].ToString());
                }
                if (row["GuestbookUserName"] != null)
                {
                    model.GuestbookUserName = row["GuestbookUserName"].ToString();
                }
                if (row["GuestbookUserIP"] != null)
                {
                    model.GuestbookUserIP = row["GuestbookUserIP"].ToString();
                }
                if (row["GuestbookCompany"] != null)
                {
                    model.GuestbookCompany = row["GuestbookCompany"].ToString();
                }
                if (row["GuestbookAddress"] != null)
                {
                    model.GuestbookAddress = row["GuestbookAddress"].ToString();
                }
                if (row["GuestbookTel"] != null)
                {
                    model.GuestbookTel = row["GuestbookTel"].ToString();
                }
                if (row["GuestbookEmail"] != null)
                {
                    model.GuestbookEmail = row["GuestbookEmail"].ToString();
                }
                if (row["GuestbookQQ"] != null)
                {
                    model.GuestbookQQ = row["GuestbookQQ"].ToString();
                }
                if (row["GuestbookContent"] != null)
                {
                    model.GuestbookContent = row["GuestbookContent"].ToString();
                }
                if (row["GuestbookTime"] != null && row["GuestbookTime"].ToString() != "")
                {
                    model.GuestbookTime = DateTime.Parse(row["GuestbookTime"].ToString());
                }
                if (row["ReplyUserName"] != null)
                {
                    model.ReplyUserName = row["ReplyUserName"].ToString();
                }
                if (row["ReplyContent"] != null)
                {
                    model.ReplyContent = row["ReplyContent"].ToString();
                }
                if (row["ReplyTime"] != null && row["ReplyTime"].ToString() != "")
                {
                    model.ReplyTime = DateTime.Parse(row["ReplyTime"].ToString());
                }
                if (row["Display"] != null && row["Display"].ToString() != "")
                {
                    model.Display = int.Parse(row["Display"].ToString());
                }
                if (row["OrderNum"] != null && row["OrderNum"].ToString() != "")
                {
                    model.OrderNum = int.Parse(row["OrderNum"].ToString());
                }
            }
            return model;
        }

        /// <summary>
        /// 获得数据列表
        /// </summary>
        public DataSet GetList(string strWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select ID,GuestbookUserName,GuestbookUserIP,GuestbookCompany,GuestbookAddress,GuestbookTel,GuestbookEmail,GuestbookQQ,GuestbookContent,GuestbookTime,ReplyUserName,ReplyContent,ReplyTime,Display,OrderNum ");
            strSql.Append(" FROM iNethinkCMS_Plugs_Guestbook ");
            if (strWhere.Trim() != "")
            {
                strSql.Append(" where " + strWhere);
            }
            return SQLHelper.Query(strSql.ToString());
        }

        /// <summary>
        /// 获得前几行数据
        /// </summary>
        public DataSet GetList(int Top, string strWhere, string filedOrder)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select ");
            if (Top > 0)
            {
                strSql.Append(" top " + Top.ToString());
            }
            strSql.Append(" ID,GuestbookUserName,GuestbookUserIP,GuestbookCompany,GuestbookAddress,GuestbookTel,GuestbookEmail,GuestbookQQ,GuestbookContent,GuestbookTime,ReplyUserName,ReplyContent,ReplyTime,Display,OrderNum ");
            strSql.Append(" FROM iNethinkCMS_Plugs_Guestbook ");
            if (strWhere.Trim() != "")
            {
                strSql.Append(" where " + strWhere);
            }
            strSql.Append(" order by " + filedOrder);
            return SQLHelper.Query(strSql.ToString());
        }

        /// <summary>
        /// 获取记录总数
        /// </summary>
        public int GetRecordCount(string strWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select count(1) FROM iNethinkCMS_Plugs_Guestbook ");
            if (strWhere.Trim() != "")
            {
                strSql.Append(" where " + strWhere);
            }
            object obj = SQLHelper.GetSingle(strSql.ToString());
            if (obj == null)
            {
                return 0;
            }
            else
            {
                return Convert.ToInt32(obj);
            }
        }
        /// <summary>
        /// 分页获取数据列表
        /// </summary>
        public DataSet GetListByPage(string strWhere, string orderby, int startIndex, int endIndex)
        {
            if (!string.IsNullOrEmpty(strWhere.Trim()))
            {
                strWhere = " Where " + strWhere;
            }

            if (!string.IsNullOrEmpty(orderby.Trim()))
            {
                orderby = " Order By " + orderby;
            }

            //startIndex = startIndex - 1;

            StringBuilder strSql = new StringBuilder();
            strSql.Append("SELECT * FROM iNethinkCMS_Plugs_Guestbook Where ID Not IN ");
            strSql.Append("(Select Top " + startIndex + " ID From iNethinkCMS_Plugs_Guestbook" + strWhere + orderby + ")");
            strSql.Append(" And ID In ");
            strSql.Append("(Select Top " + endIndex + " ID From iNethinkCMS_Plugs_Guestbook" + strWhere + orderby + ")");
            strSql.Append(orderby);
            return SQLHelper.Query(strSql.ToString());
        }

    }
}

