[![forthebadge](https://forthebadge.com/images/badges/built-with-love.svg)](https://forthebadge.com)
[![forthebadge](https://forthebadge.com/images/badges/works-on-my-machine-1.svg)](https://forthebadge.com)

# Online Web Clock
> **An online, digital clock web app built with Bootstrap 5.3.3, focused on customizability.  
Inspired by [online-clock](https://github.com/tmasri/online-clock) by tmasri**

**Website:** [View in your browser!](https://online-clock.pages.dev)

**Need compatibility with older browsers?** [Check out the compatibility repository](https://github.com/iKarTehFox/web-clock-compatibility)!

# Install guide and features
The documentation for Online Web Clock has moved! You can find it in the [Docs](https://online-clock-docs.pages.dev/)!  
There, you can find [installation instructions](https://online-clock-docs.pages.dev/docs/installation) and a [list of all features](https://online-clock-docs.pages.dev/docs).
 
# Gallery
### Preview of the clock  
 ![A screenshot of the main web clock page. The time 12:00 PM and date of August 1st, 2024 is shown against a white background.](/src/assets/images/main.png)  
### Menu options pane
 ![A screenshot of the menu options panel. The "Date and Time" section is opened.](/src/assets/images/menu.png)  
### Customization example
 ![A screenshot of the main web clock page with many customizations applied, such as custom font, background image, date format, and weather widget.](/src/assets/images/customizable.png)  
 > Like this look? Download [the preset](/src/assets/onlinewebclock-preset.json)!
 
# Acknowledgements (OSS)
- **Axios**  ([GitHub](https://github.com/axios/axios)): Licensed under MIT License  
Copyright (c) 2014-present Matt Zabriskie & Collaborators
- **Bootstrap** ([Link](https://getbootstrap.com/)): Licensed under MIT License  
Copyright (c) 2011-2024 The Bootstrap Authors
- **Iconify** ([Link](https://iconify.design)): Licensed under MIT License  
Copyright (c) 2021-PRESENT Vjacheslav Trushkin
- **Material Design Icons by Pictogrammers** ([GitHub](https://github.com/Templarian/MaterialDesign)): Icons licensed under Apache License 2.0  

- **Luxon** ([GitHub](https://github.com/moment/luxon)): Licensed under MIT License  
Copyright 2019 JS Foundation and other contributors
- **number-to-words** ([GitHub](https://github.com/marlun78/number-to-words)): Licensed under MIT License  
Copyright (c) 2015 Martin Eneqvist
- **qrcode** ([GitHub](https://github.com/soldair/node-qrcode)): Licensed under MIT License
- **Social Buttons for Bootstrap** ([GitHub](https://github.com/lipis/bootstrap-social)): Licensed under MIT License  
Copyright (c) 2013-2016 Panayiotis Lipiridis
- **Toastify**  ([GitHub](https://github.com/apvarun/toastify-js)): Licensed under MIT License  
Copyright (c) 2018 apvarun
- **ts-luxon** ([Link](https://www.npmjs.com/package/ts-luxon)): Licensed under MIT License  
Copyright (c) 2023 Tony Samperi and other contributors
- **ts-pattern** ([Link](https://www.npmjs.com/package/ts-pattern)): Licensed under MIT License  
- **Webpack** ([Link](https://webpack.js.org/)): Licensed under MIT License  
Copyright JS Foundation and other contributors  

Each license can be found in the code's respective files or website.
 
# Acknowledgements (Fonts)
 
- **Dancing Script** ([Link](https://fonts.google.com/specimen/Dancing+Script)): Licensed under SIL Open Font License 1.1

- **Merriweather** ([Link](https://fonts.google.com/specimen/Merriweather)): Licensed under SIL Open Font License 1.1

- **Nanum Brush Script** ([Link](https://fonts.google.com/specimen/Nanum+Brush+Script)): Licensed under SIL Open Font License 1.1
 
- **Lato** ([Link](https://fonts.google.com/specimen/Lato)): Licensed under SIL Open Font License 1.1
 
- **Montserrat** ([Link](https://fonts.google.com/specimen/Montserrat)): Licensed under SIL Open Font License 1.1
 
- **Open Sans** ([Link](https://fonts.google.com/specimen/Open+Sans)): Licensed under SIL Open Font License 1.1
 
- **Oswald** ([Link](https://fonts.google.com/specimen/Oswald)): Licensed under SIL Open Font License 1.1

- **Pangolin** ([Link](https://fonts.google.com/specimen/Pangolin)): Licensed under SIL Open Font License 1.1
 
- **Poppins** ([Link](https://fonts.google.com/specimen/Poppins)): Licensed under SIL Open Font License 1.1
 
- **Roboto** ([Link](https://fonts.google.com/specimen/Roboto)): Licensed under Apache License 2.0

- **Tektur** ([Link](https://fonts.google.com/specimen/Tektur)): Licensed under SIL Open Font License 1.1
 
- **Ubuntu** ([Link](https://fonts.google.com/specimen/Ubuntu)): Licensed under Ubuntu Font License 1.0
 
- **Ubuntu Mono** ([Link](https://fonts.google.com/specimen/Ubuntu+Mono)): Licensed under Ubuntu Font License 1.0
 
 Each license can be found in their respective folders in /src/fonts
