# -*- coding: utf-8 -*-
from unittest.case import TestCase
from unittest.mock import patch, call


from 臺灣言語工具.語音合成.語音標仔轉換 import 語音標仔轉換
from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器


class 語音標仔轉換單元試驗(TestCase):

    @patch('臺灣言語工具.語音合成.語音標仔轉換.語音標仔轉換._句物件轉完整合成標仔')
    def test_章物件轉合成標仔(self, 句物件轉標仔mock):
        章物件 = 拆文分析器.建立章物件('食飽未？食飽矣！')
        語音標仔轉換.物件轉完整合成標仔(章物件)
        句物件轉標仔mock.assert_has_calls([
            call(拆文分析器.建立句物件('食飽未？')),
            call(拆文分析器.建立句物件('食飽矣！')),
        ])

    def test_轉合成標仔的函式愛定義(self):
        章物件 = 拆文分析器.建立章物件('食飽未？食飽矣！')
        with self.assertRaises(NotImplementedError):
            語音標仔轉換.物件轉完整合成標仔(章物件)

    def test_單一音值提主要音值(self):
        self.assertEqual(語音標仔轉換.提出標仔主要音值('tsʰ'), 'tsʰ')

    def test_三連音提主要音值(self):
        self.assertEqual(語音標仔轉換.提出標仔主要音值('a-sp+t'), 'sp')

    def test_三連音對照表提主要音值(self):
        self.assertEqual(語音標仔轉換.提出標仔主要音值('ab-s+ui ab-s+ue'), 's')

    def test_陣列提主要音值(self):
        self.assertEqual(
            語音標仔轉換.提出標仔陣列主要音值(['l', 'ab-s+ui ab-s+ue']),
            ['l', 's'])

    def test_跳脫功能(self):
        self.assertEqual(語音標仔轉換.跳脫標仔(
            'pʰ-au+tsʰ/調:x<ˋ>ˋ/詞:0!1@1/句:0^2_2'),
            'p\\312\\260-au+ts\\312\\260/\\350\\252\\277:x<\\313\\213>\\313\\213/\\350\\251\\236:0!1@1/\\345\\217\\245:0^2_2'
        )

    def test_跳脫陣列功能(self):
        self.assertEqual(語音標仔轉換.跳脫標仔陣列([
            'x-sil+x/調:x<x>x/詞:x!x@x/句:x^x_x',
            'sil-p+oŋ/調:x<ˇ>ˊ/詞:0!1@1/句:0^2_2',
            'p-oŋ+tsʰ/調:x<ˇ>ˊ/詞:0!1@1/句:0^2_2',
            'oŋ-tsʰ+u/調:ˇ<ˊ>x/詞:0!1@1/句:1^1_2',
            'tsʰ-u+sil/調:ˇ<ˊ>x/詞:0!1@1/句:1^1_2',
            'x-sil+x/調:x<x>x/詞:x!x@x/句:x^x_x'
        ]), [
            'x-sil+x/\\350\\252\\277:x<x>x/\\350\\251\\236:x!x@x/\\345\\217\\245:x^x_x',
            'sil-p+o\\305\\213/\\350\\252\\277:x<\\313\\207>\\313\\212/\\350\\251\\236:0!1@1/\\345\\217\\245:0^2_2',
            'p-o\\305\\213+ts\\312\\260/\\350\\252\\277:x<\\313\\207>\\313\\212/\\350\\251\\236:0!1@1/\\345\\217\\245:0^2_2',
            'o\\305\\213-ts\\312\\260+u/\\350\\252\\277:\\313\\207<\\313\\212>x/\\350\\251\\236:0!1@1/\\345\\217\\245:1^1_2',
            'ts\\312\\260-u+sil/\\350\\252\\277:\\313\\207<\\313\\212>x/\\350\\251\\236:0!1@1/\\345\\217\\245:1^1_2',
            'x-sil+x/\\350\\252\\277:x<x>x/\\350\\251\\236:x!x@x/\\345\\217\\245:x^x_x'
        ])

    def test_空的句物件(self):
        句物件 = 拆文分析器.建立句物件('')
        完整標仔 = 語音標仔轉換.物件轉完整合成標仔(句物件)
        self.assertEqual(
            完整標仔,
            ['x-sil+x/調:x<x>x/詞:x!x@x/句:x^x_x', ]
        )

    def test_空的章物件(self):
        句物件 = 拆文分析器.建立章物件('')
        完整標仔 = 語音標仔轉換.物件轉完整合成標仔(句物件)
        self.assertEqual(
            完整標仔,
            ['x-sil+x/調:x<x>x/詞:x!x@x/句:x^x_x', ]
        )
