# -*- coding: utf-8 -*-
from unittest.case import TestCase


from 臺灣言語工具.語音合成.漢語語音標仔轉換 import 漢語語音標仔轉換
from 臺灣言語工具.音標系統.閩南語.臺灣閩南語羅馬字拼音 import 臺灣閩南語羅馬字拼音
from 臺灣言語工具.音標系統.客話.臺灣客家話拼音 import 臺灣客家話拼音
from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器


class 漢語語音標仔轉換單元試驗(TestCase):

    def setUp(self):
        self.閩南語 = 'gua1 ai2 tshua2-bun7-le7'
        self.客家話 = 'tienˊ-dangˋ labˋ-suiˋ'

    def test_臺灣閩南語羅馬字拼音完整標仔(self):
        # [我 gua2, 愛 ai3, 蔡 tsʰua3, 文 bun5, 莉 ni7, , ,]
        句物件 = 拆文分析器.對齊句物件(self.閩南語, self.閩南語)
        音值句物件 = 句物件.轉音(臺灣閩南語羅馬字拼音, 函式='音值')
        完整標仔 = 漢語語音標仔轉換.物件轉完整合成標仔(音值句物件)
        self.檢驗標仔有對無(
            完整標仔,
            [
                'x-sil+x/調:x<x>x/詞:x!x@x/句:x^x_x',
                'sil-g+ua/調:x<1>2/詞:0!1@1/句:0^3_3',
                'g-ua+ʔ/調:x<1>2/詞:0!1@1/句:0^3_3',
                'ua-ʔ+ai/調:1<2>2/詞:0!1@1/句:1^2_3',
                'ʔ-ai+tsʰ/調:1<2>2/詞:0!1@1/句:1^2_3',
                'ai-tsʰ+ua/調:2<2>7/詞:0!3@3/句:2^1_3',
                'tsʰ-ua+b/調:2<2>7/詞:0!3@3/句:2^1_3',
                'ua-b+un/調:2<7>7/詞:1!2@3/句:2^1_3',
                'b-un+l/調:2<7>7/詞:1!2@3/句:2^1_3',
                'un-l+e/調:7<7>x/詞:2!1@3/句:2^1_3',
                'l-e+sil/調:7<7>x/詞:2!1@3/句:2^1_3',
                'x-sil+x/調:x<x>x/詞:x!x@x/句:x^x_x',
            ]
        )

    def test_臺灣閩南語羅馬字拼音音值標仔(self):
        # [我 gua2, 愛 ai3, 蔡 tsʰua3, 文 bun5, 莉 ni7, , ,]
        句物件 = 拆文分析器.對齊句物件(self.閩南語, self.閩南語)
        音值句物件 = 句物件.轉音(臺灣閩南語羅馬字拼音, 函式='音值')
        完整標仔 = 漢語語音標仔轉換.物件轉完整合成標仔(音值句物件)
        音值標仔 = 漢語語音標仔轉換.提出標仔陣列主要音值(完整標仔)
        self.檢驗標仔有對無(
            音值標仔,
            [
                'sil',
                'g',
                'ua',
                'ʔ',
                'ai',
                'tsʰ',
                'ua',
                'b',
                'un',
                'l',
                'e',
                'sil',
            ]
        )

    def test_臺灣客家話拼音完整標仔(self):
        句物件 = 拆文分析器.對齊句物件(self.客家話, self.客家話)
        音值句物件 = 句物件.轉音(臺灣客家話拼音, 函式='通用音值')
        完整標仔 = 漢語語音標仔轉換.物件轉完整合成標仔(音值句物件)
        self.檢驗標仔有對無(
            完整標仔,
            [
                'x-sil+x/調:x<x>x/詞:x!x@x/句:x^x_x',
                'sil-t+ien/調:x<ˊ>ˋ/詞:0!2@2/句:0^2_2',
                't-ien+d/調:x<ˊ>ˋ/詞:0!2@2/句:0^2_2',
                'ien-d+ang/調:ˊ<ˋ>ˋ/詞:1!1@2/句:0^2_2',
                'd-ang+l/調:ˊ<ˋ>ˋ/詞:1!1@2/句:0^2_2',
                'ang-l+ab/調:ˋ<ˋ>ˋ/詞:0!2@2/句:1^1_2',
                'l-ab+s/調:ˋ<ˋ>ˋ/詞:0!2@2/句:1^1_2',
                'ab-s+ui/調:ˋ<ˋ>x/詞:1!1@2/句:1^1_2',
                's-ui+sil/調:ˋ<ˋ>x/詞:1!1@2/句:1^1_2',
                'x-sil+x/調:x<x>x/詞:x!x@x/句:x^x_x',
            ]
        )

    def test_臺灣客家話拼音音值標仔(self):
        句物件 = 拆文分析器.對齊句物件(self.客家話, self.客家話)
        音值句物件 = 句物件.轉音(臺灣客家話拼音, 函式='通用音值')
        完整標仔 = 漢語語音標仔轉換.物件轉完整合成標仔(音值句物件)
        音值標仔 = 漢語語音標仔轉換.提出標仔陣列主要音值(完整標仔)
        self.檢驗標仔有對無(
            音值標仔,
            [
                'sil',
                't',
                'ien',
                'd',
                'ang',
                'l',
                'ab',
                's',
                'ui',
                'sil',
            ]
        )

    def 檢驗標仔有對無(self, 結果, 答案):
        self.assertEqual(len(結果), len(答案))
        for 結, 答 in zip(結果, 答案):
            self.assertEqual(結, 答, (結, 答))
