# -*- coding: utf-8 -*-
import unittest
from unittest.mock import patch
from 臺灣言語工具.解析整理.座標揀集內組 import 座標揀集內組
from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
from 臺灣言語工具.基本物件.集 import 集
from 臺灣言語工具.解析整理.解析錯誤 import 解析錯誤
from 臺灣言語工具.基本物件.句 import 句


class 座標揀集內組單元試驗(unittest.TestCase):

    def test_章物件(self):
        結果章物件 = 座標揀集內組.揀(拆文分析器.建立章物件('媠巧靚'), [0])
        self.assertEqual(結果章物件, 拆文分析器.建立章物件('媠巧靚'))

    @patch('臺灣言語工具.解析整理.座標揀集內組.座標揀集內組._揀句物件')
    def test_章物件有用句物件(self, 揀句物件mock):
        座標揀集內組.揀(拆文分析器.建立章物件('媠巧靚'), [0])
        self.assertEqual(揀句物件mock.call_count, 1)

    def test_句物件(self):
        媠組 = 拆文分析器.建立組物件('媠')
        巧組 = 拆文分析器.建立組物件('巧')
        靚組 = 拆文分析器.建立組物件('靚')
        媠巧靚集 = 集([媠組, 巧組, 靚組])
        結果句物件 = 座標揀集內組.揀(
            句([媠巧靚集, 媠巧靚集, 媠巧靚集]),
            [0, 1, 2]
        )
        self.assertEqual(結果句物件, 句([
            集([媠組]),
            集([巧組]),
            集([靚組]),
        ]))

    def test_集物件(self):
        媠組 = 拆文分析器.建立組物件('媠')
        巧組 = 拆文分析器.建立組物件('巧')
        靚組 = 拆文分析器.建立組物件('靚')
        媠巧靚集 = 集([媠組, 巧組, 靚組])

        結果集物件 = 座標揀集內組.揀(媠巧靚集, [1])
        self.assertEqual(結果集物件, 集([巧組]))

    def test_無選擇參數預設頭一個(self):
        媠組 = 拆文分析器.建立組物件('媠')
        巧組 = 拆文分析器.建立組物件('巧')
        靚組 = 拆文分析器.建立組物件('靚')
        媠巧靚集 = 集([媠組, 巧組, 靚組])

        結果集物件 = 座標揀集內組.揀(媠巧靚集)
        self.assertEqual(結果集物件, 集([媠組]))

    def test_選擇參數傷濟袂錯誤(self):
        媠組 = 拆文分析器.建立組物件('媠')
        巧組 = 拆文分析器.建立組物件('巧')
        靚組 = 拆文分析器.建立組物件('靚')
        媠巧靚集 = 集([媠組, 巧組, 靚組])

        座標揀集內組.揀(媠巧靚集, [2, 2, 2])

    def test_選擇參數傷少錯誤(self):
        媠組 = 拆文分析器.建立組物件('媠')
        巧組 = 拆文分析器.建立組物件('巧')
        靚組 = 拆文分析器.建立組物件('靚')
        媠巧靚集 = 集([媠組, 巧組, 靚組])

        with self.assertRaises(解析錯誤):
            座標揀集內組.揀(媠巧靚集, [])

    def test_選擇參數傷大愛錯誤(self):
        媠組 = 拆文分析器.建立組物件('媠')
        巧組 = 拆文分析器.建立組物件('巧')
        靚組 = 拆文分析器.建立組物件('靚')
        媠巧靚集 = 集([媠組, 巧組, 靚組])

        with self.assertRaises(解析錯誤):
            座標揀集內組.揀(媠巧靚集, [3, 4, 5])

    def test_空集(self):
        with self.assertRaises(解析錯誤):
            座標揀集內組.揀(
                拆文分析器.建立集物件(''),
            )

# 	def test_組詞字物件(self):
