# 斷詞（Word Segmentation）
```python3
閩南語辭典 = 型音辭典(2)
閩南語辭典.加詞(拆文分析器.對齊詞物件('阿媠', 'a1-sui2'))
閩南語辭典.加詞(拆文分析器.對齊詞物件('愛 ', 'ai3'))
閩南語辭典.加詞(拆文分析器.對齊詞物件('我', 'gua2'))
閩南語辭典.加詞(拆文分析器.對齊詞物件('我', 'ngoo2'))
閩南語語言模型 = KenLM語言模型('我愛阿媠.arpa')

閩南語語句 = '我愛阿媠'

處理減號 = 文章粗胚.建立物件語句前處理減號(臺灣閩南語羅馬字拼音, 閩南語語句)
斷詞的章物件 = (
    拆文分析器.建立章物件(處理減號)
    .轉音(臺灣閩南語羅馬字拼音)
    .揣詞(拄好長度辭典揣詞, 閩南語辭典)
    .揀(語言模型揀集內組, 閩南語語言模型)
)
```

漢語有漢字佮音標兩種表示法，而且漢字袂親像南島語、英語會用空白共詞分開。所以斷詞是針對漢語處理的技術

* 做法
  * 南島語
    *  沒斷詞問題，本來就斷好了
  * 閩南語和客語
    *  長詞優先
    *  用語言模型選
  * 華語
    *  中研院斷詞系統
* 需要語料
  * 閩南語/客語辭典
  

## 母語斷詞
部份漢語語料是漢字佮羅馬字混雜，為了讓語料能更一致，斷詞有兩種方法

### 兩步斷詞
先用辭典切出對應的斷點，才閣揀出其中一個當結果
```python3
a='11'
```

#### 函式定義
```python3
    def 揣詞(self, 揣詞方法, *參數陣列, **參數物件):
    def 揀(self, 揀集內組方法, *參數陣列, **參數物件):
```

### 直接斷詞
仝款用辭典佮語言模型，`辭典語言模型斷詞`會試逐種組合，毋過速度較慢
