# 常見情境

## 白話字臺羅轉換
```python3
>>> from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
>>> from 臺灣言語工具.音標系統.閩南語.臺灣閩南語羅馬字拼音相容教會羅馬字音標 import 臺灣閩南語羅馬字拼音相容教會羅馬字音標
>>> from 臺灣言語工具.音標系統.閩南語.臺灣閩南語羅馬字拼音 import 臺灣閩南語羅馬字拼音
>>> from 臺灣言語工具.基本物件.公用變數 import 分字符號
>>> from 臺灣言語工具.基本物件.公用變數 import 分詞符號
>>> 
>>> 臺羅 = 'Pe̍h-uē-jī tī tsia'
>>> 白話字物件 = (
...     拆文分析器.建立句物件(臺羅)
...     .轉音(臺灣閩南語羅馬字拼音, '轉白話字')
... )
>>> print(白話字物件.看語句())
Pe̍h-oē-jī tī chia
>>>
>>> 白話字 = 'Pe̍h-oē-jī tī chia'
>>> 臺羅物件 = (
...     拆文分析器.建立句物件(白話字)
...     .轉音(臺灣閩南語羅馬字拼音相容教會羅馬字音標)  # 先全部轉做臺羅數字調
...     .轉音(臺灣閩南語羅馬字拼音, '轉閏號調')  # 才閣轉做臺羅閏號調，調號佇韻面頂
... )
>>> print(臺羅物件.看語句())
pe̍h-uē-jī tī tsia
```
## 台羅調號數字調轉換
```python3
>>> from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
>>> from 臺灣言語工具.音標系統.閩南語.臺灣閩南語羅馬字拼音 import 臺灣閩南語羅馬字拼音
>>> 
>>> 台羅 = 'Tiān-náu mā ē kóng Tâi-gí!'
>>> 台羅物件 = 拆文分析器.建立句物件(台羅)
>>> 
>>> 台羅物件.轉音(臺灣閩南語羅馬字拼音).看語句()
tian7-nau2 ma7 e7 kong2 tai5-gi2!
>>> 
>>> 數字調 = 'tian7-nau2 ma7 e7 kong2 tai5-gi2!'
>>> 數字調物件 = 拆文分析器.建立句物件(數字調)
>>> 數字調物件.轉音(臺灣閩南語羅馬字拼音, '轉調符').看語句()
'tiān-náu mā ē kóng tâi-gí!'
```


### 通用拼音轉臺羅
```python3
from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
from 臺灣言語工具.音標系統.閩南語.通用拼音音標 import 通用拼音音標

通用組物件 = 拆文分析器.建立句物件('臺語語言來講古', 'dai5-qi4 qi4-qen5 lai5 gong2-go4')
臺羅組物件 = 通用組物件.轉音(通用拼音音標)  # 會轉成臺羅數字調音標
print(臺羅組物件.看型())  # 臺語語言來講古
print(臺羅組物件.看音())  # tai5-gi2 gi2-gian5 lai5 kong7-koo2
```

## 照羅馬字來斷詞、斷字
```python3
>>> from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
>>> from 臺灣言語工具.音標系統.閩南語.臺灣閩南語羅馬字拼音 import 臺灣閩南語羅馬字拼音
>>> 
>>> 台羅 = 'Tiān-náu mā ē kóng Tâi-gí!'
>>> 漢字 = '電腦mā會講台語！'
>>> 台羅物件 = 拆文分析器.建立句物件(漢字, 台羅)
>>> 
>>> for 詞 in 台羅物件.網出詞物件():
...     print(詞.看語句(), '|', 詞.看音())
... 
電腦 | Tiān-náu
mā | mā
會 | ē
講 | kóng
台語 | Tâi-gí
！ | !
>>>
>>> for 字 in 台羅物件.篩出字物件():
...     print(字.看語句(), '|', 字.看音())
... 
電 | Tiān
腦 | náu
mā | mā
會 | ē
講 | kóng
台 | Tâi
語 | gí
！ | !

# 漢字羅馬字字數bô-kâng會擲錯誤
>>> 漢字 = '電腦mā會曉講台語！' 
>>> 台羅 = 'Tiān-náu mā ē kóng Tâi-gí!'  # 漢字比羅馬字加一字
>>> 台羅物件 = 拆文分析器.建立句物件(漢字, 台羅)
Traceback (most recent call last):
臺灣言語工具.解析整理.解析錯誤.解析錯誤: 詞組內底的型「電腦mā會曉講台語！」比音「Tiān-náu mā ē kóng Tâi-gí!」濟！
配對結果：[詞：[字：電 Tiān, 字：腦 náu], 詞：[字：mā mā], 詞：[字：會 ē], 詞：[字：曉 kóng], 詞：[字：講 Tâi, 字：台 gí], 詞：[字：語 !]]
```

## 查辭典、斷詞、補漢字、補羅馬字
```python3
from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
from 臺灣言語工具.辭典.型音辭典 import 型音辭典
from 臺灣言語工具.語言模型.實際語言模型 import 實際語言模型
from 臺灣言語工具.斷詞.拄好長度辭典揣詞 import 拄好長度辭典揣詞
from 臺灣言語工具.斷詞.語言模型揀集內組 import 語言模型揀集內組

辭典 = 型音辭典(4)  # 一个詞上濟四个字，為著長詞演算法
辭典.加詞(拆文分析器.建立詞物件('我', 'gua2'))
辭典.加詞(拆文分析器.建立詞物件('我', 'ngoo2'))
辭典.加詞(拆文分析器.建立詞物件('的', 'e5'))
辭典.加詞(拆文分析器.建立詞物件('豬仔', 'ti1-a2'))

語言模型 = 實際語言模型(2)  # 參考前後文，連紲2个詞為單位（bi-grams）
語言模型.看(拆文分析器.建立句物件('我的', 'gua2 e5'))  # 予`gua2`的機率比`ngoo2`的機率懸

# from 臺灣言語工具.語言模型.KenLM語言模型 import KenLM語言模型
# 語言模型 = KenLM語言模型('我的.arpa')

揣詞結果物件 = (
    拆文分析器.建立句物件('我e5豬仔')
    .揣詞(拄好長度辭典揣詞, 辭典)  # 斷詞的演算法
    .揀(語言模型揀集內組, 語言模型)  # 揀詞的演算法
)
print(揣詞結果物件.看型())  # 我的豬仔
print(揣詞結果物件.看音())  # gua2 e5 ti1-a2
```

## 檢查音標有合法無
```
from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
from 臺灣言語工具.音標系統.閩南語.臺灣閩南語羅馬字拼音 import 臺灣閩南語羅馬字拼音

音標 = 臺灣閩南語羅馬字拼音相容教會羅馬字音標('pe̍h')
拆文分析器.建立句物件('peh8', 'peh8').音標敢著(臺灣閩南語羅馬字拼音)  # True
拆文分析器.建立句物件('XXX', 'XXX').音標敢著(臺灣閩南語羅馬字拼音)  # False
```
目前支援的[音標系統](https://github.com/sih4sing5hong5/tai5-uan5_gian5-gi2_kang1-ku7/tree/master/%E8%87%BA%E7%81%A3%E8%A8%80%E8%AA%9E%E5%B7%A5%E5%85%B7/%E9%9F%B3%E6%A8%99%E7%B3%BB%E7%B5%B1)

* 台語/閩南語
  * 臺灣閩南語羅馬字拼音（臺羅）
  * 教會羅馬字音標（白話字）
  * 臺灣閩南語羅馬字拼音相容教會羅馬字音標
  * 通用拼音音標
  * 方音符號吳守禮改良式
  * 臺灣語言音標（TLPA）
* 客家話
  * 臺灣客家話拼音
* 官話
  * 官話注音符號

