<?php

namespace think\addons;

use think\Container;
use think\facade\Config;
use think\facade\Hook;

/**
 * 插件执行默认控制器
 */
class Route extends Controller
{
    /**
     * 插件执行
     */
    public function execute()
    {
        $this->request = Container::get('request');

        // 格式化路由的插件位置
        $this->action = $this->request->param('action');
        $this->controller = $this->request->param('controller');
        $this->addon = $this->request->param('addon');
        

        if (!empty($this->addon) && !empty($this->controller) && !empty($this->action)) {
            // 获取类的命名空间
            $class = get_addon_class($this->addon,'controller', $this->controller);
            if (class_exists($class)) {
                $model = new $class();
                if ($model === false) {
                    abort(500, lang('addon init fail'));
                }
                // 调用操作
                if (!method_exists($model, $this->action)) {
                    abort(500, lang('Controller Class Method Not Exists'));
                }
                // 监听addons_init
                Hook::listen('addons_init', $this);
                return call_user_func_array([$model, $this->action], [$this->request]);
            } else {
                abort(500, lang('Controller Class Not Exists'));
            }
        }
        abort(500, lang('addon cannot name or action'));
    }
}
