<?php

namespace think\addons;

use app\common\model\Config as ConfigModel;
use think\facade\Env;
use think\facade\Request;
use think\facade\Config;
use think\Loader;
use think\Container;

/**
 * 插件基类控制器
 * Class Controller
 * @package think\addons
 */
class Controller extends \think\Controller
{
    /**
     * 架构函数
     * @param App $app App对象
     * @access public
     */
    public function __construct($app = null)
    {
        parent::__construct($app);
    }


    /**
     * 加载模板输出
     * @access protected
     * @param  string $template 模板文件名
     * @param  array  $vars     模板输出变量
     * @param  array  $config   模板参数
     * @return mixed
     */
    protected function fetch($template = '', $vars = [], $config = [])
    {
        $controller=$this->request->param('controller');
        $addon=$this->request->param('addon');
        $action=$this->request->param('action');
        $addonViewPath=__ROOT__.'addons/'.$addon.'/view/'.Loader::parseName($controller,0).'/';

        if($template===''||$template===false){
            $template=$addonViewPath.$action.'.'.config('template.view_suffix');
        }
        else if(preg_match('/^\w+(\.*\w*)$/',$template,$par_arr)){
            if($par_arr[1]){
                $template=$addonViewPath.$template;
            }
            else{
                $template=$addonViewPath.$template.'.'.config('template.view_suffix');
            }
        }
        return parent::fetch($template, $vars, $config);
    }

    /**
     * 如果在非第一页没有数据时，跳转到最后一页
     */
    public function ifPageNoData($lists){
        $currentPage=$lists->currentPage();
        $page=input('page/d');
        $page=$page?$page:1;
        if($currentPage!=$page){
            //page是url传递的
            //$currentPage是程序生成的。超出数据分页数，$currentPage为最后一页页码
            $currentUrl=$this->request->url();
            $newUrl=preg_replace('/([\?\&])page=\d+/','$1'."page=$currentPage",$currentUrl);
            header("Location: $newUrl");
            exit();
        }
    }
    /**
     * 获得当前路由及参数列表
     * @return mixed
     */
    public function getRouteQuery(){
        $queryArr=$this->request->param();
        unset($queryArr['addon'],$queryArr['controller'],$queryArr['action']);
        $queryArr['s']=$this->request->pathinfo();
        return $queryArr;
    }

    /**
     * 初始化请求参数
     * @param $param 默认参数值
     * @return array
     */
    public function initParam($param){
        $get=input();
        return array_merge($param,$get);
    }
}
