# think-addons
一款基于thinkphp5.1 开发的插件管理扩展.



## 安装
> composer require zhuopro/think-addons


## 创建插件

### 创建插件目录
> 在addons目录中创建test目录
###创建插件说明文件
>在test目录中，新建info.ini文件，其内容如下
```
name = test
title = 示例插件名称
description = 示例插件说明文字

;当前插件状态1代表启用，0代表禁用
status = 1

;当前插件是否具有配置信息
config = 0
author = 作者
version = 1.0.1
```
### 创建插件类
> 在test目录中创建Test.php类文件。注意：类文件首字母需大写

```
<?php
namespace addons\test;	// 注意命名空间规范

use think\Addons;

/**
 * 插件测试
 * @author byron sampson
 */
class Test extends Addons	// 需继承think\addons\Addons类
{

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        return true;
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        return true;
    }

    /**
     * 实现的testHook钩子方法
     * @return mixed
     */
    public function testHook($param)
    {
		// 调用钩子时候的参数信息
        print_r($param);
		// 当前插件的配置信息，配置信息存在当前目录的config.php文件中，见下方
        print_r($this->getConfig());
		// 可以返回模板，模板文件默认读取的为插件目录中的文件。模板名不能为空！
        return $this->fetch('info');
    }

}
```

### 创建插件配置文件
> 在test目录中创建config.php类文件，插件配置文件可以省略。
>配置项的类型可选值有[text,radio,checkbox,select,textarea,image,images]。
>其中image和images是单图上传和多图上传

```
<?php
return [
    'display' => [
        'title' => '是否显示:',
        'type' => 'radio',
        'options' => [
            '1' => '显示',
            '0' => '不显示'
        ],
        'value' => '1'
    ]
];
```
>配置项中，只有title、type、value字段是必须存在的。

### 创建插件的controller文件
> 在test目录中创建controller目录，在controller目录中创建Index.php文件。
> controller类的用法与tp5.1中的controller一致。

```
<?php
namespace addons\test\controller;

class Index
{
    public function link()
    {
        echo 'hello link';
    }
}
```
> 如果需要使用view模板则需要继承`\think\addons\Controller`类。
> 如果需要使用后台的权限验证需要继承`\think\addons\AdminAuth`类。

```
<?php
namespace addons\test\controller;

use think\addons\AdminAuth;

class Action extends AdminAuth
{
    public function link()
    {
        return $this->fetch();
    }
}
```

### 创建插件视图文件
> 在test目录中创建view目录，在view目录中创建index目录，在其中创建link.html。
>插件的视图用法与thinkphp5.1的大致相同，不过要注意的在插件中，生成url使用的是addon_url方法，而非url方法。

```
<h1>hello tpl</h1>

如果插件中需要有链接或提交数据的业务，可以在插件中创建controller业务文件，
要访问插件中的controller时使用addon_url生成url链接。
如下：

<a href="{:addon_url('test-action-method')}"> test</a>

格式为：
test为插件名，ation为controller中的类名，method为controller中的方法
```
### 创建插件安装sql文件
>如果有需要可以在插件目录中创建install.sql文件。插件安装时，会执行文件内的sql语句。
### 创建插件菜单
>如果有需要可以在插件目录中创建menu.json文件。插件安装时，会将菜单插入到后台菜单中。
```
[{
  "title": "示例插件",
  "url": "addons/test-index-index",
  "child": [{
      "title": "详情",
      "url": "addons/test-index-detail"
    },
    {
      "title": "删除",
      "url": "addons/test-index-del"
    }
  ]
}]
```

## 使用钩子
> 创建好插件后就可以在正常业务中使用该插件中的钩子了
> 使用钩子的时候第二个参数可以省略

### 模板中使用钩子

```
<div>{:hook('test_hook', ['id'=>1])}</div>
```

### php业务中使用
> 只要是thinkphp5.1正常流程中的任意位置均可以使用

```
$res = hook('test_hook', ['id'=>1])  //钩子中使用 return 可以接受返回结果
echo $res;
```
##注意事项
- 生成url使用的是addon_url方法，而非url方法。
- 生成url时，必须要显示指定地址。如addon_url('test-Index-index'),而非addon_url('');