/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50644
Source Host           : localhost:3306
Source Database       : hulacwms3pro

Target Server Type    : MYSQL
Target Server Version : 50644
File Encoding         : 65001

Date: 2021-09-11 18:58:22
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `zz_admin_auth_group`
-- ----------------------------
DROP TABLE IF EXISTS `zz_admin_auth_group`;
CREATE TABLE `zz_admin_auth_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户组id,自增主键',
  `module` varchar(20) NOT NULL DEFAULT '' COMMENT '用户组所属模块',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '组类型',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '用户组中文名称',
  `description` varchar(80) NOT NULL DEFAULT '' COMMENT '描述信息',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '用户组状态：为1正常，为0禁用,-1为删除',
  `rules` varchar(500) NOT NULL DEFAULT '' COMMENT '用户组拥有的规则id，多个规则 , 隔开',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of zz_admin_auth_group
-- ----------------------------
INSERT INTO `zz_admin_auth_group` VALUES ('1', 'admin', '1', '默认用户组', '默认用户组', '1', '1,2,195,196,68,70,75,86,87,88,89');

-- ----------------------------
-- Table structure for `zz_admin_log`
-- ----------------------------
DROP TABLE IF EXISTS `zz_admin_log`;
CREATE TABLE `zz_admin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_member_id` int(11) DEFAULT NULL,
  `admin_member_username` varchar(255) DEFAULT NULL,
  `url` varchar(1000) DEFAULT NULL COMMENT '访问url',
  `route` varchar(50) DEFAULT NULL COMMENT '访问路由',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `content` longtext COMMENT '内容',
  `ip` varchar(100) DEFAULT NULL COMMENT 'ip地址',
  `useragent` varchar(500) DEFAULT NULL COMMENT 'useragent',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `delete_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of zz_admin_log
-- ----------------------------

-- ----------------------------
-- Table structure for `zz_admin_member`
-- ----------------------------
DROP TABLE IF EXISTS `zz_admin_member`;
CREATE TABLE `zz_admin_member` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `username` char(16) NOT NULL COMMENT '用户名',
  `nickname` char(10) NOT NULL DEFAULT '' COMMENT '昵称',
  `password` char(32) NOT NULL COMMENT '密码',
  `group_id` int(10) NOT NULL DEFAULT '0' COMMENT '权限分组id',
  `reg_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '注册时间',
  `reg_ip` bigint(20) NOT NULL DEFAULT '0' COMMENT '注册IP',
  `last_login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `last_login_ip` varchar(20) NOT NULL DEFAULT '0' COMMENT '最后登录IP',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '用户状态',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COMMENT='用户表';

-- ----------------------------
-- Records of zz_admin_member
-- ----------------------------
INSERT INTO `zz_admin_member` VALUES ('1', 'admin', '超级管理员', '4b8368b0f4786175f97d8706a957ae4a', '0', '1530325649', '0', '1627894284', '::1', '1627894284', '1');

-- ----------------------------
-- Table structure for `zz_admin_menu`
-- ----------------------------
DROP TABLE IF EXISTS `zz_admin_menu`;
CREATE TABLE `zz_admin_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `hide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏{radio[0:显示,1:隐藏]}',
  `tip` varchar(255) NOT NULL DEFAULT '' COMMENT '提示',
  `is_dev` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否仅开发者模式可见',
  `icon` char(50) DEFAULT NULL COMMENT '菜单图标',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `delete_time` int(10) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=246 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of zz_admin_menu
-- ----------------------------
INSERT INTO `zz_admin_menu` VALUES ('1', '后台首页', '0', '1', 'Index/main', '0', '', '0', 'layui-icon-home', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('2', '内容管理', '0', '2', '', '0', '', '0', 'layui-icon-template-1', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('16', '后台管理', '0', '3', '', '0', '', '0', 'layui-icon-auz', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('17', '管理员信息', '16', '1', 'AdminMember/index', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('140', '友情链接', '2', '4', 'FriendLink/index', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('27', '权限管理', '16', '2', 'AdminAuthGroup/index', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('68', '系统管理', '0', '4', '', '0', '', '0', 'layui-icon-set', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('69', '网站设置', '68', '1', 'Config/groups', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('70', '配置管理', '68', '2', 'Config/index', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('75', '菜单管理', '68', '3', 'AdminMenu/index', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('218', '插件应用', '0', '5', '', '0', '', '1', 'layui-icon-app', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('219', '插件管理', '218', '0', 'Addons/index', '0', '', '1', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('195', '编辑管理员', '17', '99', 'AdminMember/edit', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('194', '启用禁用', '17', '99', 'AdminMember/set_status', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('141', '留言管理', '2', '5', 'MessageForm/index', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('136', '文章列表', '2', '1', 'Document/index', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('137', '栏目分类', '2', '2', 'DocumentCategory/index', '0', '文章分类', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('138', '新增文章', '136', '1', 'Document/add', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('139', '编辑文章', '136', '2', 'Document/edit', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('191', '启用禁用', '140', '99', 'FriendLink/enable', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('143', '添加分类', '137', '2', 'DocumentCategory/add', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('144', '编辑分类', '137', '3', 'DocumentCategory/edit', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('192', '排序', '140', '99', 'FriendLink/sort', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('146', '新增', '140', '1', 'FriendLink/add', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('147', '编辑', '140', '2', 'FriendLink/edit', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('148', '留言详情', '141', '1', 'MessageForm/details', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('149', '新增管理员', '17', '1', 'AdminMember/add', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('150', '授权', '17', '2', 'AdminMember/auth', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('151', '新增', '27', '1', 'AdminAuthGroup/add', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('152', '编辑', '27', '2', 'AdminAuthGroup/edit', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('157', '新增', '70', '1', 'Config/add', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('158', '编辑', '70', '2', 'Config/edit', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('159', '新增', '75', '1', 'AdminMenu/add', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('160', '编辑', '75', '2', 'AdminMenu/edit', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('161', '访问授权', '27', '3', 'AdminAuthGroup/access', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('162', '成员授权', '27', '4', 'AdminAuthGroup/user', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('166', '删除文章', '136', '3', 'Document/del', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('167', '删除分类', '137', '5', 'Documentcategory/del', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('168', '删除', '140', '3', 'FriendLink/del', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('169', '删除留言', '141', '2', 'MessageForm/del', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('170', '删除管理员', '17', '3', 'AdminMember/del', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('171', '删除权限', '27', '5', 'AdminAuthGroup/del', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('174', '删除配置', '70', '993', 'Config/del', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('175', '删除菜单', '75', '3', 'AdminMenu/del', '0', '', '0', '', '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('184', '显示隐藏', '136', '99', 'Document/enable', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('185', '排序', '136', '99', 'Document/sort', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('190', '显示隐藏', '137', '99', 'DocumentCategory/set_display', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('196', '修改昵称', '17', '99', 'AdminMember/nickname', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('197', '启用禁用', '27', '99', 'AdminAuthGroup/set_status', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('199', '显示隐藏', '75', '99', 'AdminMenu/hide', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('200', '排序', '75', '99', 'AdminMenu/sort', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('203', '上传附件', '16', '99', '', '1', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('204', '上传视频', '203', '99', 'Upload/video', '0', '', '1', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('205', '上传文件', '203', '99', 'Upload/file', '0', '', '1', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('206', '编辑器上传', '16', '99', 'Ueditor/index', '1', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('207', '上传图片', '206', '99', 'Ueditor/picture', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('208', '上传文件', '206', '99', 'Ueditor/file', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('209', '上传视频', '206', '99', 'Ueditor/video', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('210', '上传图片', '203', '99', 'Upload/picture', '0', '', '1', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('233', '访问日志', '218', '0', 'addons/admin_log-index-index', '0', '', '0', null, '1', '1631354905', null);
INSERT INTO `zz_admin_menu` VALUES ('234', '日志详情', '233', '0', 'addons/admin_log-index-detail', '0', '', '0', null, '1', '1631354905', null);
INSERT INTO `zz_admin_menu` VALUES ('235', '删除日志', '233', '0', 'addons/admin_log-index-del', '0', '', '0', null, '1', '1631354905', null);
INSERT INTO `zz_admin_menu` VALUES ('236', '插件配置', '219', '0', 'Addons/config', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('237', '启用禁用', '219', '0', 'Addons/enable', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('238', '安装插件', '219', '0', 'Addons/local', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('239', '删除插件', '219', '0', 'Addons/del', '0', '', '0', null, '1', '0', null);
INSERT INTO `zz_admin_menu` VALUES ('240', '备份/还原', '218', '0', 'addons/databack-index-index', '0', '', '0', null, '1', '1631357691', null);
INSERT INTO `zz_admin_menu` VALUES ('241', '优化表', '240', '0', 'addons/databack-index-optimize', '0', '', '0', null, '1', '1631357691', null);
INSERT INTO `zz_admin_menu` VALUES ('242', '修复表', '240', '0', 'addons/databack-index-repair', '0', '', '0', null, '1', '1631357691', null);
INSERT INTO `zz_admin_menu` VALUES ('243', '删除备份', '240', '0', 'addons/databack-index-del', '0', '', '0', null, '1', '1631357691', null);
INSERT INTO `zz_admin_menu` VALUES ('244', '备份数据库', '240', '0', 'addons/databack-index-export', '0', '', '0', null, '1', '1631357691', null);
INSERT INTO `zz_admin_menu` VALUES ('245', '还原数据库', '240', '0', 'addons/databack-index-import', '0', '', '0', null, '1', '1631357691', null);
INSERT INTO `zz_admin_menu` VALUES ('246', '修改管理员密码', '1', '0', 'AdminMember/resetpwd/', '1', '', '0', null, '1', '0', null);

-- ----------------------------
-- Table structure for `zz_config`
-- ----------------------------
DROP TABLE IF EXISTS `zz_config`;
CREATE TABLE `zz_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '配置名称',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '配置类型',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '配置说明',
  `group` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '配置分组',
  `extra` varchar(255) NOT NULL DEFAULT '' COMMENT '配置值',
  `remark` varchar(100) NOT NULL DEFAULT '' COMMENT '配置说明',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态',
  `value` text COMMENT '配置值',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `issync` tinyint(4) NOT NULL DEFAULT '0',
  `module` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0全部\r\n1前台\r\n2后台',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_name` (`name`),
  KEY `type` (`type`),
  KEY `group` (`group`)
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of zz_config
-- ----------------------------
INSERT INTO `zz_config` VALUES ('1', 'WEB_SITE_TITLE', '1', '网站标题', '1', '', '网站标题前台显示标题', '1378898976', '1588951530', '1', 'HulaCWMS-呼啦企业网站管理系统演示', '0', '0', '1');
INSERT INTO `zz_config` VALUES ('2', 'WEB_SITE_DESCRIPTION', '2', '网站描述', '1', '', '网站搜索引擎描述', '1378898976', '1588951534', '1', 'HulaCWMS(呼啦企业网站管理系统)诞生于2019年8月（www.kaifashu.com），是自主研发的一套专门用户管理企业网站的管理系统，以提供分享精品呼啦源码及建站过程常遇到的问题解决方案汇总为主要宗旨。系统特点：清爽美观，系统做减法，用户体验就很棒。', '1', '0', '1');
INSERT INTO `zz_config` VALUES ('3', 'WEB_SITE_KEYWORD', '2', '网站关键字', '1', '', '网站搜索引擎关键字', '1378898976', '1588951539', '1', 'HulaCWMS,呼啦企业网站管理系统演示,cms,内容管理系统', '8', '0', '1');
INSERT INTO `zz_config` VALUES ('4', 'WEB_SITE_CLOSE', '4', '关闭站点', '1', '0:关闭,1:开启', '站点关闭后用户不能访问', '1378898976', '1588951296', '1', '1', '1', '0', '1');
INSERT INTO `zz_config` VALUES ('5', 'CONFIG_TYPE_LIST', '3', '配置类型列表', '0', '', '主要用于数据解析和页面表单的生成', '1378898976', '1588951305', '1', '0:数字\n1:字符\n5:图片\n2:文本\n3:数组\n4:枚举', '2', '1', '2');
INSERT INTO `zz_config` VALUES ('6', 'WEB_SITE_ICP', '1', '网站备案号', '1', '', '设置在网站底部显示的备案号，如：“鲁ICP备00000001号-1”', '1378900335', '1592625538', '1', '鲁ICP备00000001号-1', '9', '0', '1');
INSERT INTO `zz_config` VALUES ('7', 'CONFIG_MODULE', '3', '配置作用域', '0', '', '在管理配置时，可以设置该配置项的所在作用域。', '1588949815', '1588951419', '1', '0:全站作用\n1:仅前台作用\n2:仅后台作用', '0', '1', '2');
INSERT INTO `zz_config` VALUES ('8', 'COMPANY_TEL', '1', '公司联系电话', '3', '', '公司联系电话，用于前台展示', '1571490284', '1588951334', '1', '010-123456', '0', '0', '1');
INSERT INTO `zz_config` VALUES ('9', 'COMPANY_EMAIL', '1', '公司联系邮箱', '3', '', '公司联系邮箱，用于前台展示', '1571490326', '1588951587', '1', 'zz@zhuopro.com', '0', '0', '1');
INSERT INTO `zz_config` VALUES ('10', 'CONFIG_GROUP_LIST', '3', '配置分组', '0', '', '配置分组', '1379228036', '1588951434', '1', '1:基本\n3:联系\n4:系统', '4', '1', '2');
INSERT INTO `zz_config` VALUES ('11', 'LIST_ROWS', '0', '后台每页记录数', '0', '', '后台数据每页显示记录数', '1379503896', '1588951440', '1', '15', '10', '1', '2');
INSERT INTO `zz_config` VALUES ('12', 'COMPANY_ADD', '0', '公司联系地址', '3', '', '公司联系地址，用于前台展示', '1571490386', '1588951450', '1', '青岛市黄岛区长江路街道', '0', '0', '0');
INSERT INTO `zz_config` VALUES ('13', 'COMPANY_QQ', '1', '联系QQ', '3', '', '公司联系QQ，用于前台显示', '1574838586', '1588951607', '1', '123456', '0', '0', '1');
INSERT INTO `zz_config` VALUES ('18', 'DEVELOP_MODE', '4', '开启开发者模式', '4', '0:关闭\n1:开启', '是否开启开发者模式', '1383105995', '1588951648', '1', '1', '11', '1', '2');
INSERT INTO `zz_config` VALUES ('19', 'WEB_TEMPLATE_PATH', '0', '网站前台模板目录', '0', '', '相对路径，必须以字母或数字开头', '1571313339', '1591866150', '1', 'default', '0', '1', '0');
INSERT INTO `zz_config` VALUES ('20', 'WEB_POWERBY', '0', '网站版权', '0', '', '网站版权，用于前台显示', '1571490683', '1588951665', '1', 'power by HulaCWMS 灼灼文化', '0', '0', '1');
INSERT INTO `zz_config` VALUES ('21', 'WEB_REWRITE', '4', '伪静态', '4', '0:关闭,1:开启,2:PATH_INFO模式', '', '1571491840', '1626671527', '1', '2', '0', '1', '1');
INSERT INTO `zz_config` VALUES ('22', 'WEB_TONGJI', '4', '开启网站统计', '4', '0:关闭,1:开启', '是否开始网站统计', '1587980376', '1595158804', '1', '1', '0', '1', '0');

-- ----------------------------
-- Table structure for `zz_document`
-- ----------------------------
DROP TABLE IF EXISTS `zz_document`;
CREATE TABLE `zz_document` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `writer` varchar(50) NOT NULL DEFAULT '' COMMENT '作者',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '标识',
  `title` varchar(500) NOT NULL DEFAULT '' COMMENT '标题',
  `category_id` int(10) unsigned NOT NULL COMMENT '所属分类',
  `keywords` varchar(500) DEFAULT '',
  `description` text COMMENT '描述',
  `type` varchar(50) NOT NULL DEFAULT 'article' COMMENT '内容类型',
  `isrecommend` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否推荐',
  `istop` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否置顶',
  `link_str` varchar(500) NOT NULL DEFAULT '0' COMMENT '外链',
  `cover_path` varchar(500) NOT NULL DEFAULT '0' COMMENT '封面',
  `images` text COMMENT '图集',
  `display` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '可见性',
  `view` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  PRIMARY KEY (`id`),
  KEY `idx_category_status` (`category_id`,`status`),
  KEY `idx_status_type_pid` (`status`,`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=172 DEFAULT CHARSET=utf8 COMMENT='文档模型基础表';

-- ----------------------------
-- Records of zz_document
-- ----------------------------
INSERT INTO `zz_document` VALUES ('154', '1', 'admin', '', '多样的动态模板', '84', 'Various dynamic templates', '为了满足多场景、不同需求，系统支持通过URL传参的方式渲染指定模板文件。动态模板文件中可以使用所有模板标签，甚至可以使用php原生代码。这样做的好处，可以让你跳脱出系统本身的机制，响应自定义的数据。比如你可以在动态模板中响应一段JSON，或者响应一段html片段。', 'article', '0', '0', '', '/uploads/picture/20200925/a93688a72cc898cfd08e6133f730a9e6.png', null, '1', '0', '99', '1600996312', '1601030476', '1');
INSERT INTO `zz_document` VALUES ('155', '1', 'admin', '', '强大的配置管理', '84', 'Powerful configuration management', '配置管理的强大在于，它可以创建诸如数字、字符、图片、数组、枚举等类型的配置项，通过系统的解析，显示在网站管理中。可以给客户提供可视化、点选式的动态配置功能。另外配置管理加入了作用域的概念，使得的配置缓存颗粒最小化。', 'article', '0', '0', '', '/uploads/picture/20200925/4a0aa87737dc4364d61883f673d8e7f1.png', null, '1', '0', '99', '1600996370', '1601030417', '1');
INSERT INTO `zz_document` VALUES ('156', '1', 'admin', '', '呼啦企业网站管理系统_目录结构', '85', '', '因HulaCWMS是基于thinkPHP5.1开发的，所以部分目录结构可以参考thinkPHP5.1的文档', 'article', '0', '0', '', '/uploads/picture/20200925/69c34ef5f53c2b77241746ebf85df86f.jpg', null, '1', '0', '99', '1600996601', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('157', '1', 'admin', '', '关于呼啦企业网站管理系统（序言）', '85', '', '呼啦企业网站管理系统专注于企业、政府单位网站建设，以免费开源的方式，帮助广大站长、个人或企业开发者大大降低了开发成本和维护成本。快速锁定意向客户，培养长线营收。目前呼啦企业网站管理系统的资源下载站已制作了上百套不同行业的网站模板，欢迎下载试用。', 'article', '0', '0', '', '/uploads/picture/20200925/99e9dfb06321dc9441d16209f2a7543b.jpg', null, '1', '1', '99', '1600996637', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('158', '1', 'admin', '', 'HulaCWMS如何自助升级', '85', '', '下载呼啦企业网站管理系统最新版，下载地址：http://www.kaifashu.com/article/detail/id/198.html', 'article', '0', '0', '', '/uploads/picture/20200925/40d05bfab8d287447ee823faf3e367f7.jpg', null, '1', '2', '99', '1600996685', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('159', '1', 'admin', '', '5个简单的DIV+CSS建设网页操作', '85', '', '大家都知道用DIV+CSS的布局来设计网站便于优化，更容易被收录，比如两个同时上线的网站，拥有同样的外链，在推广2个月后，保证使用DIV+CSS布局的站点获得的排名比传统的TABLE 要好，用DIV+CSS建设该网站首先是从整体布局入手', 'article', '0', '0', '', '/uploads/picture/20200925/ebfdfa96b3580dbeea1ee93c42ecabb7.jpg', null, '1', '2', '99', '1600996729', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('160', '1', 'admin', '', '8种程序员必备的学习工具', '85', '', '程序员在学习过程中经常需要使用搜索引擎来检索资料，国内常用的也就是百度了。可以的话，搜索引擎首先还是推荐使用 Google，如果不能使用，可以使用以下几个作为备用', 'article', '0', '0', '', '/uploads/picture/20200925/76ef90228697527b55901727272a2de7.jpg', null, '1', '12', '99', '1600996796', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('161', '1', 'admin', '', '下载体验', '109', '', '快速锁定意向客户，培养长线营收。目前呼啦企业网站管理系统的资源下载站已制作了上百套不同行业的网站模板，欢迎下载试用。', 'article', '0', '0', 'http://www.kaifashu.com/article/detail/id/198.html', '', null, '1', '0', '99', '1600996852', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('162', '1', 'admin', '', '应用模板', '109', '', '一套数据，多套模板。呼啦资源下载站提供了上百套不同行业的网站模板，并支持一键切换，欢迎下载试用。', 'article', '0', '0', 'http://www.kaifashu.com/muban/lists/cid/104.html', '', null, '1', '0', '99', '1600996912', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('163', '1', 'admin', '', '常见问题', '109', '', '疑难问题一网打尽。例如：在HulaCWMS中，我们创建了许多常用的配置项，他们都可以在模板中通过{:config()}的方式调用', 'article', '0', '0', 'http://www.kaifashu.com/article/lists/id/136.html', '', null, '1', '0', '99', '1600996947', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('164', '1', 'admin', '', '网站模板化', '113', 'home', '呼啦资源下载站提供了上百套不同行业的网站模板，并支持一键切换，欢迎下载试用。呼啦企业网站管理系统专注于企业、政府单位网站建设，以免费开源的方式，帮助广大站长、个人或企业开发者大大降低了开发成本和维护成本。快速锁定意向客户，培养长线营收。', 'article', '0', '0', '', '', null, '1', '0', '1', '1600996986', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('165', '1', 'admin', '', '栏目分类显示', '113', 'profile', '采用无限级栏目分类和树状结构显示，上下级分明，便于操作。为了更友好的用户体验，我们让系统记住了栏目分类是被折叠或是被展开的状态。呼啦企业网站管理系统专注于企业、政府单位网站建设，以免费开源的方式，帮助广大站长、个人或企业开发者大大降低了开发成本和维护成本。快速锁定意向客户，培养长线营收。', 'article', '0', '0', '', '', null, '1', '0', '2', '1600997018', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('166', '1', 'admin', '', '访问统计数据', '113', 'contact', '呼啦企业网站建站系统更倾向于营销型网站，客户可以根据整站统计数据功能，实时了解并掌握网站被访问的统计数据，以了解公司的产品热度。呼啦企业网站管理系统专注于企业、政府单位网站建设，以免费开源的方式，帮助广大站长、个人或企业开发者大大降低了开发成本和维护成本。快速锁定意向客户，培养长线营收。', 'article', '0', '0', '', '', null, '1', '0', '3', '1600997060', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('167', '1', 'admin', '', '马化藤', '117', '', '因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。', 'article', '0', '0', '', '/uploads/picture/20200925/ec6a4a303eb0c18b0977ade4a3efd7d9.png', null, '1', '0', '99', '1600997092', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('168', '1', 'admin', '', '乔布四', '117', '', '因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。', 'article', '0', '0', '', '/uploads/picture/20200925/ec6a4a303eb0c18b0977ade4a3efd7d9.png', null, '1', '0', '99', '1600997180', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('169', '1', 'admin', '', '任正菲', '117', '', '因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。', 'article', '0', '0', '', '/uploads/picture/20200925/ec6a4a303eb0c18b0977ade4a3efd7d9.png', null, '1', '0', '99', '1600997211', '1620738546', '1');
INSERT INTO `zz_document` VALUES ('170', '1', 'admin', '', '马芸', '117', '', '因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。', 'article', '0', '0', '', '/uploads/picture/20200925/ec6a4a303eb0c18b0977ade4a3efd7d9.png', null, '1', '0', '99', '1600997231', '1625470432', '1');

-- ----------------------------
-- Table structure for `zz_document_article`
-- ----------------------------
DROP TABLE IF EXISTS `zz_document_article`;
CREATE TABLE `zz_document_article` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `content` text COMMENT '文章内容',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文档模型文章表';

-- ----------------------------
-- Records of zz_document_article
-- ----------------------------
INSERT INTO `zz_document_article` VALUES ('154', '<p>为了满足多场景、不同需求，系统支持通过URL传参的方式渲染指定模板文件。动态模板文件中可以使用所有模板标签，甚至可以使用php原生代码。这样做的好处，可以让你跳脱出系统本身的机制，响应自定义的数据。比如你可以在动态模板中响应一段JSON，或者响应一段html片段。</p>');
INSERT INTO `zz_document_article` VALUES ('155', '<p>配置管理的强大在于，它可以创建诸如数字、字符、图片、数组、枚举等类型的配置项，通过系统的解析，显示在网站管理中。可以给客户提供可视化、点选式的动态配置功能。另外配置管理加入了作用域的概念，使得的配置缓存颗粒最小化。</p>');
INSERT INTO `zz_document_article` VALUES ('156', '<p>										</p><p><span style=\"color: rgb(91, 192, 222); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(244, 248, 250);\">因HulaCWMS是基于thinkPHP5.1开发的，所以部分目录结构可以参考thinkPHP5.1的文档（</span><a href=\"https://www.kancloud.cn/manual/thinkphp5_1/353950\" target=\"_blank\" style=\"text-decoration-line: none; outline: none; color: rgb(65, 131, 196); cursor: pointer; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased;\">点击查看</a><span style=\"color: rgb(91, 192, 222); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(244, 248, 250);\">）</span></p><pre style=\"margin-top: 14px; margin-bottom: 14px; padding: 16px; border-radius: 3px; background-color: rgb(247, 247, 247); box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: Consolas, Monaco, &quot;Andale Mono&quot;, &quot;Ubuntu Mono&quot;, monospace; font-size: 15px; line-height: 1.45; overflow: auto; border: 0px; color: rgb(82, 82, 82);\">www&nbsp;&nbsp;WEB部署目录（或者子目录）\n├─application&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;应用目录\n├─config&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;应用配置目录\n│&nbsp;&nbsp;├─app.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;应用配置\n│&nbsp;&nbsp;├─cache.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;缓存配置\n│&nbsp;&nbsp;├─cookie.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cookie配置\n│&nbsp;&nbsp;├─database.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;数据库配置\n│&nbsp;&nbsp;├─log.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;日志配置\n│&nbsp;&nbsp;├─session.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Session配置\n│&nbsp;&nbsp;├─template.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;模板引擎配置\n│&nbsp;&nbsp;└─trace.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Trace配置\n│\n├─route&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;路由定义目录\n│&nbsp;&nbsp;├─route.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;路由定义\n│&nbsp;&nbsp;└─...&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;更多\n├─thinkphp&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;框架系统目录\n├─extend&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;扩展类库目录\n├─runtime&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;应用的运行时目录\n├─vendor&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;第三方类库目录（Composer依赖库）\n├─template&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;模板目录\n├─theme&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;主题风格目录（后台脚本、样式）\n├─index.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;入口文件\n├─admin.php&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;后台入口文件\n└─.htaccess&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;用于apache的重写</pre><blockquote class=\"danger\" style=\"border-left: 4px solid rgb(217, 83, 79); margin: 14px 0px 0px; padding: 5px 5px 5px 15px; background-color: rgb(253, 247, 247); color: rgb(217, 83, 79); font-size: 15px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 1.2; border-top-color: rgb(217, 83, 79); border-right-color: rgb(217, 83, 79); border-bottom-color: rgb(217, 83, 79); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif;\"><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2;\">在<code style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: Consolas, Monaco, &quot;Andale Mono&quot;, &quot;Ubuntu Mono&quot;, monospace; font-size: 1em; display: inline-block; border-radius: 4px; padding: 0.2em 0.4em; background-color: rgb(247, 247, 247); word-break: break-all; white-space: pre; line-height: 1.3; margin: -0.2em 0.4em;\">mac</code>或者<code style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: Consolas, Monaco, &quot;Andale Mono&quot;, &quot;Ubuntu Mono&quot;, monospace; font-size: 1em; display: inline-block; border-radius: 4px; padding: 0.2em 0.4em; background-color: rgb(247, 247, 247); word-break: break-all; white-space: pre; line-height: 1.3; margin: -0.2em 0.4em;\">linux</code>环境下面，注意需要设置<code style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: Consolas, Monaco, &quot;Andale Mono&quot;, &quot;Ubuntu Mono&quot;, monospace; font-size: 1em; display: inline-block; border-radius: 4px; padding: 0.2em 0.4em; background-color: rgb(247, 247, 247); word-break: break-all; white-space: pre; line-height: 1.3; margin: -0.2em 0.4em;\">runtime</code>目录权限为777。</p></blockquote><p><br/></p><p><br/></p><p><br/></p><p>									</p>');
INSERT INTO `zz_document_article` VALUES ('157', '<p><br/></p><h2 style=\"list-style: none; padding: 0px 0px 0.3em; margin: 0px 0px 14px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.225; font-weight: 400; font-size: 1.3em; border-bottom: 1px solid rgb(238, 238, 238); color: rgb(82, 82, 82); background-color: rgb(255, 255, 255);\">关于呼啦企业网站管理系统</h2><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\">呼啦企业网站管理系统专注于企业、政府单位网站建设，以免费开源的方式，帮助广大站长、个人或企业开发者大大降低了开发成本和维护成本。快速锁定意向客户，培养长线营收。目前呼啦企业网站管理系统的<a href=\"http://www.kaifashu.com/\" target=\"_blank\" style=\"text-decoration-line: none; outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; background-color: transparent;\">资源下载站</a>已制作了上百套不同行业的网站模板，欢迎下载试用。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\">因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。让您不再为了培训客户如何使用后台而烦恼！</p><h2 style=\"list-style: none; padding: 0px 0px 0.3em; margin: 14px 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.225; font-weight: 400; font-size: 1.3em; border-bottom: 1px solid rgb(238, 238, 238); color: rgb(82, 82, 82); background-color: rgb(255, 255, 255);\"><a style=\"outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; background-color: transparent; position: absolute; margin-top: -10px;\"></a>呼啦企业网站管理系统功能模块</h2><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\"><img src=\"https://img.kancloud.cn/99/84/998429d587a31fd4d2ab8e1220fdefb4_554x374.png\" alt=\"\"/></p><ul class=\" list-paddingleft-2\" style=\"list-style-type: none;\"><li><h3 style=\"list-style: none; padding: 0px; margin: 0px; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.43; font-weight: 400; font-size: 1.2em;\"><a style=\"outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; position: absolute; margin-top: -10px;\"></a>网站模板化</h3></li></ul><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\">一套数据，多套模板。<br/><a href=\"http://www.kaifashu.com/\" target=\"_blank\" style=\"text-decoration-line: none; outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; background-color: transparent;\">呼啦资源下载站</a>提供了上百套不同行业的网站模板，并支持一键切换，欢迎下载试用。</p><ul class=\" list-paddingleft-2\" style=\"list-style-type: none;\"><li><h3 style=\"list-style: none; padding: 0px; margin: 0px; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.43; font-weight: 400; font-size: 1.2em;\"><a style=\"outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; position: absolute; margin-top: -10px;\"></a>栏目分类</h3></li></ul><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\"><img src=\"https://img.kancloud.cn/a1/09/a1099815fbc72b61c89ac53b49220e8f_554x358.png\" alt=\"\"/><br/>采用无限级栏目分类和树状结构显示，上下级分明，便于操作。为了更友好的用户体验，我们让系统记住了栏目分类是被折叠或是被展开的状态。</p><ul class=\" list-paddingleft-2\" style=\"list-style-type: none;\"><li><h3 style=\"list-style: none; padding: 0px; margin: 0px; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.43; font-weight: 400; font-size: 1.2em;\"><a style=\"outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; position: absolute; margin-top: -10px;\"></a>访问统计</h3></li></ul><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\"><img src=\"https://img.kancloud.cn/f6/08/f60843b7aa19181183ed7a26ea2455b7_554x359.png\" alt=\"\"/><br/>呼啦企业网站建站系统更倾向于营销型网站，客户可以根据整站统计数据功能，实时了解并掌握网站被访问的统计数据，以了解公司的产品热度。</p><ul class=\" list-paddingleft-2\" style=\"list-style-type: none;\"><li><h3 style=\"list-style: none; padding: 0px; margin: 0px; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.43; font-weight: 400; font-size: 1.2em;\"><a style=\"outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; position: absolute; margin-top: -10px;\"></a>文章内容</h3></li></ul><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\">系统在设计时为文章模块做了扩展预留，当基础文章内容模块不能满足您的实际业务需求时，可以快速扩展出其他文章类型，如产品型文章类型、下载型文章类型。</p><ul class=\" list-paddingleft-2\" style=\"list-style-type: none;\"><li><h3 style=\"list-style: none; padding: 0px; margin: 0px; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.43; font-weight: 400; font-size: 1.2em;\"><a style=\"outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; position: absolute; margin-top: -10px;\"></a>配置管理</h3></li></ul><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\"><img src=\"https://img.kancloud.cn/d0/49/d049f75e63540b90779d6dfc0c0bdf76_554x376.png\" alt=\"\"/><br/>配置管理的强大在于，它可以创建诸如数字、字符、图片、数组、枚举等类型的配置项，通过系统的解析，显示在网站管理中。可以给客户提供可视化、点选式的动态配置功能。另外配置管理加入了作用域的概念，使得的配置缓存颗粒最小化。</p><ul class=\" list-paddingleft-2\" style=\"list-style-type: none;\"><li><h3 style=\"list-style: none; padding: 0px; margin: 0px; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.43; font-weight: 400; font-size: 1.2em;\"><a style=\"outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; position: absolute; margin-top: -10px;\"></a>开发者模式</h3></li></ul><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\">安卓操作系统中有个开发者模式，呼啦企业网站管理系统正是借鉴了该功能。当技术人员创建的功能页面不想因为客户的不慎操作而导致系统出错时，可以开启本功能。</p><ul class=\" list-paddingleft-2\" style=\"list-style-type: none;\"><li><h3 style=\"list-style: none; padding: 0px; margin: 0px; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.43; font-weight: 400; font-size: 1.2em;\"><a style=\"outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; position: absolute; margin-top: -10px;\"></a>多媒体上传</h3></li></ul><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\">系统内置了单图片、多图片、视频、压缩包、office套餐等文件的上传，上传功能严格验证了文件的类型和大小，确保系统的安全和稳定。</p><ul class=\" list-paddingleft-2\" style=\"list-style-type: none;\"><li><h3 style=\"list-style: none; padding: 0px; margin: 0px; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.43; font-weight: 400; font-size: 1.2em;\"><a style=\"outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; position: absolute; margin-top: -10px;\"></a>SEO友好</h3></li></ul><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\">在SEO中伪静态功能是最基本功能，更多的可以通过配置路由实现自定义页面URL。而在模板标签中系统还内置了例如上一篇、下一篇和面包屑导航等功能。</p><ul class=\" list-paddingleft-2\" style=\"list-style-type: none;\"><li><h3 style=\"list-style: none; padding: 0px; margin: 0px; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, Arial, Helvetica, sans-serif; line-height: 1.43; font-weight: 400; font-size: 1.2em;\"><a style=\"outline: none; color: rgb(65, 131, 196); cursor: pointer; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; position: absolute; margin-top: -10px;\"></a>动态模板</h3></li></ul><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; white-space: normal; box-sizing: inherit; -webkit-tap-highlight-color: transparent; text-size-adjust: none; -webkit-font-smoothing: antialiased; line-height: 2; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; background-color: rgb(255, 255, 255);\">为了满足多场景、不同需求，系统支持通过URL传参的方式渲染指定模板文件。动态模板文件中可以使用所有模板标签，甚至可以使用php原生代码。这样做的好处，可以让你跳脱出系统本身的机制，响应自定义的数据。比如你可以在动态模板中响应一段JSON，或者响应一段html片段。</p><p><br/></p><p><br/></p><p><br/></p><p><br/></p>');
INSERT INTO `zz_document_article` VALUES ('158', '<p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><strong>下载呼啦企业网站管理系统最新版</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><strong>下载地址：</strong><a href=\"http://www.kaifashu.com/article/detail/id/198.html\" target=\"_blank\" title=\"呼啦企业网站管理系统最新版\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\"><strong>http://www.kaifashu.com/article/detail/id/198.html</strong></a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><strong><br/></strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><strong>1、没有修改过内核文件的升级办法</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">1.1 在下载到最新的完整安装包后，复制application文件夹到自己的网站目录下并覆盖;</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">1.2 复制config文件夹下的admin文件夹、index文件夹、config.php文件到自己的网站目录下的config文件夹并覆盖；</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">1.3 完成升级。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><strong>2、修改过内核文件的升级版本</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">自己分析，自己升级。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><strong>建议网站上线后，修改默认的后台入口，比如将“admin.php”修改为“hula.php”</strong></p><p><br/></p><p><br/></p><p><br/></p>');
INSERT INTO `zz_document_article` VALUES ('159', '<p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">大家都知道用DIV+CSS的布局来设计网站便于优化，更容易被收录，比如两个同时上线的网站，拥有同样的外链，在推广2个月后，保证使用DIV+CSS布局的站点获得的排名比传统的TABLE 要好，用DIV+CSS建设该网站首先是从整体布局入手，构思好网站的整体布局结构，一般我们按以下步骤来建设一个网站的页面:</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">1、顶部部分，其中包括了MENU、LOGO和一幅Banner图片；</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">2、<span style=\"list-style: none; padding: 0px; margin: 0px; color: rgb(77, 77, 77); font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif;\">页面中间部分，那就是我们的主体了，这里就以我们为一客户做的站点为例来说明。考虑到该行业要求打开首页快速，所以我们在网站发布的信息设 计为三列。</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">3、底部，包括一些版权信息。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">根据以上设想，我们定义如下div的结构</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">DIV结构如下：</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">　　</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">│body {}　/*这是一个HTML元素*/</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">　　</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">└#Container {}　/*页面层容器*/</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">　　　　　</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">├#Header {}　/*页面头部*/</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">　　　　　</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">├#MianBody {}　/*页面主体*/</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">　　　　　</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">│　├#mainbody-left {}　/*主体页面左边*/</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">　　　　　</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">│　└#mainbody-center {}　/*主体页面中间*/</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">│　└#MainBody -right{}　/*主体页面右边*/</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">　</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">└#footer {}　/*页面底部*/</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">用DIV+CSS做一个导航栏是很简单的，而且我们可以通过css来对导航栏的样式方便的作出调整。用div设置导航栏一般就用&lt;ul&gt;和&lt;li&gt;标签。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">4、嵌套效果不不同.<br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">有些情况下如果div中嵌套的图片大于外层div的高度，则IE6中对高度的设置始终无效，这时要注意对该css添加overflow属性，overloaw:hidden,则可隐藏超出边界的部分</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">5、高度显示效果不同</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">一般情况下只需要使用height: 100px;即可，当显示效果不同时，则可以_height: 100px;来对IE6的高度进行设置。</p><p><br/></p><p><br/></p><p><br/></p>');
INSERT INTO `zz_document_article` VALUES ('160', '<h1 style=\"list-style: none; padding: 0px; margin: 8px 0px 16px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 28px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 36px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">1、搜索资源网站</h1><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">程序员在学习过程中经常需要使用搜索引擎来检索资料，国内常用的也就是百度了。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">可以的话，搜索引擎首先还是推荐使用 Google，如果不能使用，可以使用以下几个作为备用：</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">Bing</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">Bing 国际版：<a href=\"https://cn.bing.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://cn.bing.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">比百度好用，之前被停用了几天，最近可以了。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">Stack Overflow</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">Stack Overflow：<a href=\"https://stackoverflow.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://stackoverflow.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">如果常用 Google，很多技术问题的答案就在这个网站上，如果无法使用 Google也 可以直接在这个网站上检索就好了。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">DuckDuckGo</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">DuckDuckGo：<a href=\"https://duckduckgo.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://duckduckgo.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">根据官网的介绍来看，这个搜索引擎不会收集用户信息，而且没有广告。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">jiumo search</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">文档搜索引擎 jiumo search 鸠摩搜书：<a href=\"https://www.jiumodiary.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.jiumodiary.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">可以用来找一些技术文档手册，很多在百度网盘里。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">Gitlogs</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">Gitlogs：<a href=\"https://www.gitlogs.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.gitlogs.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">Gitlogs 是专门针对 GitHub 项目的搜索引擎，通过他可以快速找到想要项目。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">Ebooke</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">Ebooke：<a href=\"https://ebookee.org/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://ebookee.org/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">Ebookee 是一个基于互联网并提供免费电子书下载的搜索引擎网站。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">SemanticScholar</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">SemanticScholar：<a href=\"https://www.semanticscholar.org/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.semanticscholar.org/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">SemanticScholar 是一个免费的学术搜索引擎，其检索结果来自于期刊、学术会议资料或者是学术机构的文献。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">Iconfinder</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">图标搜索：<a href=\"https://www.iconfinder.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.iconfinder.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">可以用来查找 logo 图片。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">LibreStock</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">LibreStock：<a href=\"https://librestock.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://librestock.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">LibreStock 上可以检索一些优质的高清图片。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">TinEye</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">TinEye：<a href=\"https://www.tineye.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.tineye.com</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">用图片来检索图片，可以通过上传图片或输入图片的 URL 来检索。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">Pexels</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">Pexels：<a href=\"https://www.pexels.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.pexels.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">高质量的图片网站，可以免费使用。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">CC Search</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">CC Search：<a href=\"https://ccsearch.creativecommons.org/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://ccsearch.creativecommons.org/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">CC Search 上搜索到的图片资源都是无版权的，可以免费使用。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">Unsplash</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">Unsplash：<a href=\"https://unsplash.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://unsplash.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">免费高清素材网站。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">The App Store</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">The App Store：<a href=\"https://theappstore.org/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://theappstore.org/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">The App Store 是一个针对苹果手机、iPad、Mac 设备的应用搜索工具。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><h1 style=\"list-style: none; padding: 0px; margin: 8px 0px 16px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 28px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 36px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">2、正则表达式相关工具</h1><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">以下两个工具可以通过图形的方式来展示正则表达式，更易于理解：</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://jex.im/regulex/#!flags=&re=%5E(a%7Cb)*%3F%24\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://jex.im/regulex/#!flags=&amp;re=%5E(a%7Cb)*%3F%24</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://regexr.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://regexr.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><h1 style=\"list-style: none; padding: 0px; margin: 8px 0px 16px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 28px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 36px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">3、图片相关工具</h1><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"list-style: none; padding: 0px; margin: 0px; color: rgb(79, 79, 79); font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; font-size: 24px; font-variant-ligatures: common-ligatures;\">picdiet</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://www.picdiet.com/zh-cn\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.picdiet.com/zh-cn</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">独特且强悍的JavaScript 算法，能极速压缩 80% 的图片大小，而不损害其质量。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">SmartResize：</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://www.smartresize.com/zh-cn\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.smartresize.com/zh-cn</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">这个工具基于 javascript+HTML5 编写而成的，可以批量裁剪缩放图片。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 24px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 32px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\">TinyPNG：</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://tinypng.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://tinypng.com/</a><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">免费的在线图片压缩工具，压缩率高，且无损画质，可以直接拖拽使用。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 28px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 36px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\"><strong>4、在线编译器</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">包含前后端（php、java、c等）都可以在线运行测试</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://www.onlinegdb.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.onlinegdb.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://rextester.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://rextester.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://c.runoob.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://c.runoob.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; white-space: normal; box-sizing: border-box; outline: 0px; font-size: 28px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 36px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures; background-color: rgb(255, 255, 255);\"><strong>5、文件转换转换工具</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">以下工具支持各种格式（PDF、图片、Word）相互转换。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://www.online-convert.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.online-convert.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px; color: rgb(87, 86, 86); font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\"><br/></p><p><a href=\"https://www.pdftoword.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer; font-family: &quot;Microsoft Yahei&quot;, &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);\">https://www.pdftoword.com/</a></p><p><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><a href=\"https://smallpdf.com/cn\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://smallpdf.com/cn</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><a href=\"https://convertio.co/zh/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://convertio.co/zh/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><a href=\"https://cn.office-converter.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://cn.office-converter.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><a href=\"https://tools.pdf24.org/zh/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://tools.pdf24.org/zh/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; box-sizing: border-box; outline: 0px; font-size: 28px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 36px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures;\"><strong>6、HTML、CSS、JS、设计类的工具</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">JSFiddle:&nbsp;<a href=\"https://jsfiddle.net/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://jsfiddle.net/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">JSON 解析器:&nbsp;<a href=\"https://c.runoob.com/front-end/53\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://c.runoob.com/front-end/53</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">在线 PS:&nbsp;<a href=\"http://www.kantu.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">http://www.kantu.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">CodePen:<a href=\"https://codepen.io/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://codepen.io/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">Runoob:&nbsp;<a href=\"https://c.runoob.com/front-end/61\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://c.runoob.com/front-end/61</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">表格转换工具:&nbsp;<a href=\"https://tableconvert.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://tableconvert.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">支持的 Markdown、HTML table、CSV 和 Excel 的相互转换。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">DesignCap:&nbsp;<a href=\"https://www.designcap.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.designcap.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">在线设计海报，内置众多模板及素材。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; box-sizing: border-box; outline: 0px; font-size: 28px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 36px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures;\"><strong>7、思维导图工具</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">推荐几款绘图工具：</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">ProcessOn：<a href=\"https://www.processon.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.processon.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">免费在线制图，支持流程图、原型图、思维导图、网络拓扑图、UML、组织结构图等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">Xmind：<a href=\"https://www.xmind.cn/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.xmind.cn/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">跨平台、跨终端，拥有全功能的思维导图软件。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">MindMeister：<a href=\"https://www.mindmeister.com/zh\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.mindmeister.com/zh</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">已有超过1000万个用户的在线思维导图工具。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">MindMaster：<a href=\"https://www.edrawsoft.cn/mindmaster/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.edrawsoft.cn/mindmaster/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">多平台思维导图软件，可用于Windows，Mac和Linux等桌面环境，也可以在线使用或在苹果，安卓等移动端上使用。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">百度脑图：<a href=\"http://naotu.baidu.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">http://naotu.baidu.com/</a>简洁的在线思维导图工具</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">Gliffy：<a href=\"https://www.gliffy.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.gliffy.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">我们可以通过在 Chrome 浏览器上安装 gliffy 插件，在线创建流程图、UML图、线框图、BPNM、组织架构图等。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 8px; margin-bottom: 16px; list-style: none; padding: 0px; box-sizing: border-box; outline: 0px; font-size: 28px; font-family: &quot;Microsoft YaHei&quot;, &quot;SF Pro Display&quot;, Roboto, Noto, Arial, &quot;PingFang SC&quot;, sans-serif; color: rgb(79, 79, 79); line-height: 36px; overflow-wrap: break-word; font-variant-ligatures: common-ligatures;\"><strong>8、文档笔记平台</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">推荐几个常用的国内外云笔记平台，有一些国外的访问速度比较慢，影响体验。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">现在云笔记使用广泛，可以总结归纳自己的一些知识储备或者相关的业务资料，加上他们自带的跨平台特性，用起来还是很方便的。</p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">印象笔记：<a href=\"https://www.yinxiang.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.yinxiang.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">有道笔记：<a href=\"https://note.youdao.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://note.youdao.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">为知笔记：<a href=\"https://www.wiz.cn/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.wiz.cn/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">石墨文档：<a href=\"https://shimo.im/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://shimo.im/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">OneNote：<a href=\"https://www.onenote.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://www.onenote.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">幕布：<a href=\"https://mubu.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://mubu.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">Google keep：<a href=\"https://keep.google.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://keep.google.com/</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; list-style: none; padding: 0px;\">Simplenote：<a href=\"https://simplenote.com/\" style=\"text-decoration-line: none; outline: none; color: rgb(0, 153, 229); cursor: pointer;\">https://simplenote.com/</a></p><p><br/></p><p><br/></p><p><br/></p>');
INSERT INTO `zz_document_article` VALUES ('161', '<p>本地体验HulaCWMS</p>');
INSERT INTO `zz_document_article` VALUES ('162', '<p>海量模板应用</p>');
INSERT INTO `zz_document_article` VALUES ('163', '<p>疑难问题一网打尽</p>');
INSERT INTO `zz_document_article` VALUES ('164', '<p>一套数据，多套模板。<br/>呼啦资源下载站提供了上百套不同行业的网站模板，并支持一键切换，欢迎下载试用。</p>');
INSERT INTO `zz_document_article` VALUES ('165', '<p>采用无限级栏目分类和树状结构显示，上下级分明，便于操作。为了更友好的用户体验，我们让系统记住了栏目分类是被折叠或是被展开的状态。</p>');
INSERT INTO `zz_document_article` VALUES ('166', '<p>呼啦企业网站建站系统更倾向于营销型网站，客户可以根据整站统计数据功能，实时了解并掌握网站被访问的统计数据，以了解公司的产品热度。</p>');
INSERT INTO `zz_document_article` VALUES ('167', '<p>因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。</p>');
INSERT INTO `zz_document_article` VALUES ('168', '<p>因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。</p>');
INSERT INTO `zz_document_article` VALUES ('169', '<p>因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。</p>');
INSERT INTO `zz_document_article` VALUES ('170', '<p>因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。</p>');

-- ----------------------------
-- Table structure for `zz_document_category`
-- ----------------------------
DROP TABLE IF EXISTS `zz_document_category`;
CREATE TABLE `zz_document_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL COMMENT '标志',
  `title` varchar(500) NOT NULL COMMENT '标题',
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '分类类别：0列表，1单篇，2链接',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `child` varchar(255) NOT NULL DEFAULT '',
  `parent_id` varchar(255) NOT NULL DEFAULT '',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `meta_title` varchar(50) NOT NULL DEFAULT '' COMMENT 'SEO的网页标题',
  `keywords` varchar(500) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` text COMMENT '描述',
  `template_index` varchar(100) NOT NULL DEFAULT '' COMMENT '频道页模板',
  `template_lists` varchar(100) NOT NULL DEFAULT '' COMMENT '列表页模板',
  `template_detail` varchar(100) NOT NULL DEFAULT '' COMMENT '详情页模板',
  `link_str` varchar(500) NOT NULL DEFAULT '0' COMMENT '外链',
  `view` int(10) NOT NULL DEFAULT '0' COMMENT '访问数',
  `display` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '可见性',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '数据状态',
  `icon` varchar(500) NOT NULL DEFAULT '' COMMENT '分类图标',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=120 DEFAULT CHARSET=utf8 COMMENT='分类表';

-- ----------------------------
-- Records of zz_document_category
-- ----------------------------
INSERT INTO `zz_document_category` VALUES ('84', 'Features', '特色', '1', '0', '', '', '1', '一套数据，多套模板。', '', '呼啦资源下载站提供了上百套不同行业的网站模板，并支持一键切换，欢迎下载试用。', 'features.html', '', '', '', '374', '1', '1572075448', '1600998216', '1', '');
INSERT INTO `zz_document_category` VALUES ('85', 'News', '新闻', '0', '0', '', '', '4', '', '', '', '', 'blog.html', 'single-blog.html', '', '248', '1', '1572075515', '1620737503', '1', '');
INSERT INTO `zz_document_category` VALUES ('86', 'about', '关于', '1', '0', '', '', '6', '关于呼啦企业网站管理系统', '', '呼啦企业网站管理系统专注于企业、政府单位网站建设，以免费开源的方式，帮助广大站长、个人或企业开发者大大降低了开发成本和维护成本。快速锁定意向客户，培养长线营收。目前呼啦企业网站管理系统的资源下载站已制作了上百套不同行业的网站模板，欢迎下载试用。', 'contact.html', '', '', '', '172', '1', '1572075555', '1601031495', '1', '');
INSERT INTO `zz_document_category` VALUES ('107', 'Products', '产品', '1', '0', '118,116,115,115,116,118,116,116', '', '2', '清爽美观的产品，专注于企业网站建设。', '', '因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。', 'price.html', '', '', '', '44', '1', '1600950511', '1601032357', '1', '');
INSERT INTO `zz_document_category` VALUES ('113', '', '我们的优点', '0', '0', '', '', '99', '为什么选择呼啦企业网站管理系统？', '', '呼啦企业网站管理系统具有无限级栏目分类、访问统计数据、SEO友好、多媒体上传等多种优点，站在客户角度，实现了友好交互，通俗易懂，轻松上手操作。', '', '', '', '', '0', '0', '1600950569', '1601031845', '1', '');
INSERT INTO `zz_document_category` VALUES ('114', '', '普通版', '2', '107', '', '107', '1', '', '00', '1、程序功能：没有限制；2、前台版权：必须保留；3、后台版权：必须保留；4、程序安装：自行负责。简单明了，轻松上手。普通版，你值得拥有！', '', '', '', 'http://www.kaifashu.com/article/detail/id/198.html', '0', '1', '1600950721', '1620802576', '-1', '');
INSERT INTO `zz_document_category` VALUES ('115', '', '商业授权', '2', '107', '', '107', '2', '', '68', '1、程序功能：没有限制；2、前台版权：允许去除；3、后台版权：允许去除；4、程序安装：协助安装。商业授权，避免法律纠纷，永无后顾之忧。', '', '', '', 'https://www.kaifashu.com/code/detail/681', '0', '1', '1600950765', '1620802617', '1', '');
INSERT INTO `zz_document_category` VALUES ('116', '', '多语言版', '2', '107', '', '107', '3', '', '98', '1、程序功能：没有限制；2、前台版权：允许去除；3、后台版权：允许去除；4、程序安装：协助安装。多种语言，一键转换。专门技术对接，处理程序异常。', '', '', '', 'https://www.kaifashu.com/code/detail/682', '0', '1', '1600950893', '1620802629', '1', '');
INSERT INTO `zz_document_category` VALUES ('117', '', '用户评价', '0', '0', '', '', '99', '上帝眼中的我们', '', '呼啦企业网站管理系统专注于企业、政府单位网站建设，以免费开源的方式，帮助广大站长、个人或企业开发者大大降低了开发成本和维护成本。一套数据，多套模板。呼啦资源下载站提供了上百套不同行业的网站模板，并支持一键切换，欢迎下载试用。', '', '', '', '', '0', '0', '1600951181', '1620737599', '1', '');
INSERT INTO `zz_document_category` VALUES ('118', '', '产品页面', '1', '107', '', '107', '4', '', '', '', 'price.html', '', '', '', '15', '1', '1600995517', '1601030637', '1', '');
INSERT INTO `zz_document_category` VALUES ('109', '', '首页展示', '0', '0', '', '', '98', '', '', '', '', '', '', '', '1', '0', '1600996206', '1625470493', '1', '/uploads/picture/20200925/28764c829cb169e5cfcf9851958fb7ca.png');

-- ----------------------------
-- Table structure for `zz_document_category_content`
-- ----------------------------
DROP TABLE IF EXISTS `zz_document_category_content`;
CREATE TABLE `zz_document_category_content` (
  `id` int(11) NOT NULL,
  `content` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of zz_document_category_content
-- ----------------------------
INSERT INTO `zz_document_category_content` VALUES ('84', '');
INSERT INTO `zz_document_category_content` VALUES ('86', '<p style=\"margin-top: 0px; margin-bottom: 0px; box-sizing: inherit; line-height: 2; padding: 0px; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; white-space: normal; background-color: rgb(252, 252, 252);\">呼啦企业网站管理系统专注于企业、政府单位网站建设，以免费开源的方式，帮助广大站长、个人或企业开发者大大降低了开发成本和维护成本。快速锁定意向客户，培养长线营收。目前呼啦企业网站管理系统的<a href=\"http://www.kaifashu.com/\" target=\"_blank\" style=\"box-sizing: inherit; background-color: transparent; color: rgb(65, 131, 196); text-decoration-line: none;\">资源下载站</a>已制作了上百套不同行业的网站模板，欢迎下载试用。</p><p style=\"margin-top: 0px; margin-bottom: 0px; box-sizing: inherit; line-height: 2; padding: 0px; color: rgb(82, 82, 82); font-family: &quot;Helvetica Neue&quot;, NotoSansHans-Regular, AvenirNext-Regular, arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft Yahei&quot;, &quot;WenQuanYi Micro Hei&quot;, serif; font-size: 15px; white-space: normal; background-color: rgb(252, 252, 252);\">因为专注所以专业，呼啦企业网站管理系统后台界面清爽美观，自适应的布局符合新时代的审美观和用户体验。本着系统就是给客户使用的设计原则，后台菜单做减法，通俗易懂。让您不再为了培训客户如何使用后台而烦恼！</p><p><br/></p><p><br/></p>');
INSERT INTO `zz_document_category_content` VALUES ('108', '');
INSERT INTO `zz_document_category_content` VALUES ('109', '');
INSERT INTO `zz_document_category_content` VALUES ('85', '');
INSERT INTO `zz_document_category_content` VALUES ('107', '');
INSERT INTO `zz_document_category_content` VALUES ('113', '');
INSERT INTO `zz_document_category_content` VALUES ('115', '');
INSERT INTO `zz_document_category_content` VALUES ('116', '');
INSERT INTO `zz_document_category_content` VALUES ('118', '');

-- ----------------------------
-- Table structure for `zz_friend_link`
-- ----------------------------
DROP TABLE IF EXISTS `zz_friend_link`;
CREATE TABLE `zz_friend_link` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `uid` int(10) NOT NULL DEFAULT '1' COMMENT '添加者',
  `title` varchar(500) NOT NULL DEFAULT '' COMMENT '链接网站名称',
  `url` varchar(500) NOT NULL DEFAULT '' COMMENT '链接地址',
  `image` varchar(500) NOT NULL DEFAULT '' COMMENT '图片连接的图片',
  `description` text COMMENT '描述',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态 0禁用',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of zz_friend_link
-- ----------------------------
INSERT INTO `zz_friend_link` VALUES ('12', '1', '灼灼文化', 'http://www.zhuopro.com', '', '', '2', '1572100561', '1600938267', '0');
INSERT INTO `zz_friend_link` VALUES ('13', '1', 'HulaCWMS', 'http://www.kaifashu.com/hulacwms.html', '', '', '3', '1572100592', '1620737636', '0');

-- ----------------------------
-- Table structure for `zz_message_form`
-- ----------------------------
DROP TABLE IF EXISTS `zz_message_form`;
CREATE TABLE `zz_message_form` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '姓名',
  `tel` varchar(15) NOT NULL COMMENT '手机',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '邮箱',
  `content` text NOT NULL COMMENT '留言内容',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '留言时间',
  `is_reply` int(10) DEFAULT '0' COMMENT '回复状态 0未回复',
  `reply_uid` int(10) DEFAULT NULL COMMENT '回复人',
  `reply_content` text COMMENT '回复内容',
  `status` int(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of zz_message_form
-- ----------------------------

-- ----------------------------
-- Table structure for `zz_picture`
-- ----------------------------
DROP TABLE IF EXISTS `zz_picture`;
CREATE TABLE `zz_picture` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id自增',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '路径',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片链接',
  `md5` char(32) NOT NULL DEFAULT '' COMMENT '文件md5',
  `sha1` char(40) NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=188 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of zz_picture
-- ----------------------------
INSERT INTO `zz_picture` VALUES ('148', '/uploads/picture/20200102/8c25bf552d0578860f7cb872bb02bc26.jpg', '', '7ea1bd2df0d848a5dc0692fd0bf6abfa', '961fb0e30afd0ea9146f4d965d3fd715f81b4a52', '1', '1577949386');
INSERT INTO `zz_picture` VALUES ('147', '/uploads/picture/20200102/ee7a1653c9984cc4e3d5fbb7938c4225.jpg', '', 'ffc1003704e6c1c8e7e4c50c506d6b73', '2319ee209b122eb4f8723a745c1b578774cb1806', '1', '1577949378');
INSERT INTO `zz_picture` VALUES ('149', '/uploads/picture/20200102/a105c3e519e74fed13f8b08f53af383d.jpg', '', 'ff1fab17aadf02ae18c160fdb19f9c85', 'fcaf70d98b6f73c0ae6f011f54917c0fd130cfdb', '1', '1577949411');
INSERT INTO `zz_picture` VALUES ('150', '/uploads/picture/20200102/36acdc5ec8a46d89ddbbbb4540800c48.jpg', '', '11ca41510c2f0f9efae8bbabd7c8e96a', '5b18c742bfe6f460a7cf95f8a0b7fd4d032c690d', '1', '1577956071');
INSERT INTO `zz_picture` VALUES ('151', '/uploads/picture/20200102/47497f194152268a5424820852e989c2.png', '', 'f42c6c5facf531e9dc694709df8bd623', '984d21daee0f09fa558222548ce2591ad4e23530', '1', '1577956096');
INSERT INTO `zz_picture` VALUES ('152', '/uploads/picture/20200102/4287ff66730caf66615ee3891d315049.jpg', '', '19e73404adfd4b092bf5931de2de60b0', '74a3b2f4dc499364ecebed157b3c24b14459ee98', '1', '1577956114');
INSERT INTO `zz_picture` VALUES ('153', '/uploads/picture/20200102/4cee1949f53e11ed3224eb6e0731b33d.jpg', '', 'd69a6085967f6be0048908d6155c1e32', '26b968ff6df58ca888d5572356c2975a23456786', '1', '1577956134');
INSERT INTO `zz_picture` VALUES ('154', '/uploads/picture/20200103/4bb3ccaa15d8fd36ba2b4a7ed0b1e5ef.jpg', '', 'e2478bd64308a0e29b35fc263a4fbaf8', '297f49715bf0a64c13dcd491c8c967b0039c3cf2', '1', '1578021448');
INSERT INTO `zz_picture` VALUES ('155', '/uploads/picture/20200427/263c6ab66e7ed327a919375c19616be2.jpg', '', 'bfb357a65f2ddba052af82f95ec4d776', 'db023af35f5cd95773c25c72503e2447e8dd7f0a', '1', '1587987193');
INSERT INTO `zz_picture` VALUES ('156', '/uploads/picture/20200428/8260efae9f590a032cee82307214fcb2.jpg', '', '0325e78d4a0554c169c478e64e4f0384', 'e93bbf32f69c02192b21e85947f39fa1f4b50fe2', '1', '1588085629');
INSERT INTO `zz_picture` VALUES ('157', '/uploads/picture/20200428/a076f534446e463889df54c31a3674f2.jpg', '', '3a08648bc18ed5f32f85c96cac1d9976', '694cb2c0842af0a8536c66007cdfb2587caec859', '1', '1588085629');
INSERT INTO `zz_picture` VALUES ('158', '/uploads/picture/20200508/20f0fdad449a06bbbd59dcf6a0d51148.jpg', '', 'ff7ae4bc80eb88e791a07fbe488cd1b5', '1842b049eda89d0c995c947e2d42ec62f039fdb4', '1', '1588948298');
INSERT INTO `zz_picture` VALUES ('159', '/uploads/picture/20200508/255cf1784bb9b1e26b33393d3210ee07.jpg', '', 'd74f7cd18a7c6b9348aae5794ca4512c', 'c86a300fa43546e7bd8ecb094e5e4b19b2002b8c', '1', '1588948303');
INSERT INTO `zz_picture` VALUES ('160', '/uploads/picture/20200508/bdce757edbff306bda899b09dee5b39a.jpg', '', 'f9a968af36933c07c35261ed7902f133', '4bbc691fbf8d049b0887178e7e7fae3668eb5e58', '1', '1588948377');
INSERT INTO `zz_picture` VALUES ('161', '/uploads/picture/20200508/0864d46da7dfdc9afa6b1afabfbcd74b.png', '', '8b9b2735801f8c3f55db47510c6ac002', '6a4130811bb18f3fa2b56836fe9788fa116f11ba', '1', '1588948377');
INSERT INTO `zz_picture` VALUES ('162', '/uploads/picture/20200525/946e4ae4ce48e8aeceacb5558daebf0e.jpg', '', '0dd4d580de53cdcd06ced82e9babfb8f', '9a082b1bfde7df29135067ab4124d6aeb08ba992', '1', '1590410634');
INSERT INTO `zz_picture` VALUES ('163', '/uploads/picture/20200608/a780818b65eb93f20339d030dd87e8f9.jpg', '', '2d1ae16235a9817b3def6b3c161659be', '72f1bec8f384a31ea3a74211c70cbabd7cae7bbd', '1', '1591588033');
INSERT INTO `zz_picture` VALUES ('164', '/uploads/picture/20200608/63e94b7614787ced07893bfebbc4384c.jpg', '', 'cb26f5d0ce175b6c8f20df194d02346b', 'c197521b3a3fc46cb28b370c7627603fe13e8d1d', '1', '1591588116');
INSERT INTO `zz_picture` VALUES ('165', '/uploads/picture/20200608/9ed7f25ec68d220978ff0b3e61ac7e8a.jpg', '', '18947b0055a3d42e2d9318682468ed25', 'c12190e03ba6a6ae5c19c0e89457712949f24571', '1', '1591588126');
INSERT INTO `zz_picture` VALUES ('166', '/uploads/picture/20200608/4309929d15a86a53295355617921d4fd.jpg', '', 'cdb193f2005e777a380e513e5e766b1d', '7d073cd3b68022f1bab5ba555529a08ba78c8882', '1', '1591588197');
INSERT INTO `zz_picture` VALUES ('167', '/uploads/picture/20200924/c94a4de67a4adb97a74d6b576dc4b48f.jpg', '', 'd1a2c2ee67211bae799fe28a76be6b36', '4a803556c81966df6474b8280ba5f4825953562a', '1', '1600937363');
INSERT INTO `zz_picture` VALUES ('168', '/uploads/picture/20200925/28764c829cb169e5cfcf9851958fb7ca.png', '', 'fffb75c3808b508123731e3acd8cc23f', '81f94ef90e61e48f83c164b0d913fb4bfe761daf', '1', '1600996199');
INSERT INTO `zz_picture` VALUES ('169', '/uploads/picture/20200925/a93688a72cc898cfd08e6133f730a9e6.png', '', '6a7e7b78d78cc9adec035f6ab01bd6ee', '7d7f763e4ccc9254fe45758a43fcb0bcb23dc823', '1', '1600996307');
INSERT INTO `zz_picture` VALUES ('170', '/uploads/picture/20200925/4a0aa87737dc4364d61883f673d8e7f1.png', '', '144ef464c31cf60ae763b4bc930abc35', '669bda3ede519899bedd49f02056fac172617085', '1', '1600996361');
INSERT INTO `zz_picture` VALUES ('171', '/uploads/picture/20200925/69c34ef5f53c2b77241746ebf85df86f.jpg', '', '85515b5ab999fd8c5d8cc69313106264', 'd458324b9d8cf66e3cec210ceeb304ff4cd52228', '1', '1600996599');
INSERT INTO `zz_picture` VALUES ('172', '/uploads/picture/20200925/99e9dfb06321dc9441d16209f2a7543b.jpg', '', '1ec80ebeea8c2b15fb9dcd269c03dcd4', 'e9a8107153f4f0f141695de4f2be7ebf3813af5f', '1', '1600996627');
INSERT INTO `zz_picture` VALUES ('173', '/uploads/picture/20200925/40d05bfab8d287447ee823faf3e367f7.jpg', '', '53194b0e74d6b03a2e4acaed1a64462d', '42793195d1db888863442abefbee1ed7904fbee5', '1', '1600996678');
INSERT INTO `zz_picture` VALUES ('174', '/uploads/picture/20200925/ebfdfa96b3580dbeea1ee93c42ecabb7.jpg', '', '5263da3096f0b8b0c0d6f7f326095cbd', '4ff9e256eb6d365d9b7e3e94eba2aa9a98f45484', '1', '1600996721');
INSERT INTO `zz_picture` VALUES ('175', '/uploads/picture/20200925/76ef90228697527b55901727272a2de7.jpg', '', 'b0c45047a2cc622462ffb3fb585834f0', 'd7897905f3e0f2af062880cd67d9811bd5627920', '1', '1600996789');
INSERT INTO `zz_picture` VALUES ('176', '/uploads/picture/20200925/ec6a4a303eb0c18b0977ade4a3efd7d9.png', '', 'bc21b89cf98218a30797cf436245a018', '334bb7fa8c44a91284c48ab1539a8fbd9b870ada', '1', '1600997082');
INSERT INTO `zz_picture` VALUES ('177', '/uploads/picture/20200925/c52d208036c52ae0e0e0c61435c8ee88.png', '', 'c0f628447781a20c09c988459b619009', 'b775b6b30bd4a77f8075d808113d050a8a590827', '1', '1600998025');
INSERT INTO `zz_picture` VALUES ('178', '/uploads/picture/20200925/b424cb0b36b6f323ce66ef37d650ae36.png', '', 'd29dae72f44c9ad07df202f8b7f7df82', '613433916f69fa3218bb058a301d9f2897d85418', '1', '1600998049');
INSERT INTO `zz_picture` VALUES ('179', '/uploads/picture/20200925/73f3c4bf79dc53757429afededa6e7e8.png', '', 'c2bd68c25fca8b5654f80d4eca73afe4', 'f4ab3ce28756b182942b12d14bd5dd78e43de46a', '1', '1600998074');
INSERT INTO `zz_picture` VALUES ('180', '/uploads/picture/20200925/7b4acc5558e46550e3a747373995d5f9.png', '', 'd331f402bdd5a9bf048009b7bda05f7f', 'ff7d71a73997d9ede35b81133320be966e88af97', '1', '1600998099');
INSERT INTO `zz_picture` VALUES ('181', '/uploads/picture/20200925/fb21c13e4aa896f895d305a85522ac17.png', '', 'e6b53e87ed3057135ae7b9dd3e97d357', '2f42bfe0366e3417c388781084387ac7da48e76e', '1', '1600998121');
INSERT INTO `zz_picture` VALUES ('182', '/uploads/picture/20200925/ac1f7fade8454442f8e4e926b71dfcc1.png', '', '7249f43ac84a09cb8181e5f90617c9c9', '63053f0393eb403781a6d3b6748c0723c5b2c9fc', '1', '1600998142');
INSERT INTO `zz_picture` VALUES ('183', '/uploads/picture/20210511/7d060e3cd70b2abe0343b552f05d6642.png', '', 'd17b884b5675dcaf4cc72e09ff240571', '10578de7ab3c9a090ebd8013b58c8657fe52ef63', '1', '1620737978');
INSERT INTO `zz_picture` VALUES ('184', '/uploads/picture/20210511/0fdccd89454dbfa62ddc4bdefab3f911.png', '', 'e532595a22c24f908248f5c7bb8f160d', '5aa01cee2d459f9d0880f89942db472003530054', '1', '1620739416');
INSERT INTO `zz_picture` VALUES ('185', '/uploads/picture/20210511/a14bcc3dec66288dc98922eac407213e.png', '', '194e5d0d9a887df083148e0d5882e5ab', '4edfc3659ca8570594f4351729fdf904ca57e213', '1', '1620739424');
INSERT INTO `zz_picture` VALUES ('186', '/uploads/picture/20210512/2e9ac62d76ad91716443b9342fd1e80a.jpg', '', '24f83ae7732b6cce5c7d193099dd0c91', '32012a439b7ab9d1cba051567488c996a5ee24e7', '1', '1620802828');
INSERT INTO `zz_picture` VALUES ('187', '/uploads/picture/20210720/4b0f21a23bb75d8747986be706019c6c.jpg', '', '57c9ee6a5d2c48ff7949cf844cff3509', '0b4bd32102ec579c6995dc0821d078fc0c7c7b7b', '1', '1626710715');

-- ----------------------------
-- Table structure for `zz_pv_log`
-- ----------------------------
DROP TABLE IF EXISTS `zz_pv_log`;
CREATE TABLE `zz_pv_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) NOT NULL DEFAULT '0' COMMENT '时间段',
  `view` int(10) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `date` varchar(255) NOT NULL DEFAULT '' COMMENT '访问时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of zz_pv_log
-- ----------------------------

-- ----------------------------
-- Table structure for `zz_url_log`
-- ----------------------------
DROP TABLE IF EXISTS `zz_url_log`;
CREATE TABLE `zz_url_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT 'url 受访的页面url',
  `pv` int(10) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '页面名称',
  `date` varchar(255) NOT NULL DEFAULT '' COMMENT '访问时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=322 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of zz_url_log
-- ----------------------------

-- ----------------------------
-- Table structure for `zz_uv_log`
-- ----------------------------
DROP TABLE IF EXISTS `zz_uv_log`;
CREATE TABLE `zz_uv_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(255) NOT NULL DEFAULT '0' COMMENT '访问ip',
  `time` int(10) NOT NULL DEFAULT '0' COMMENT '时间',
  `date` varchar(255) NOT NULL DEFAULT '' COMMENT '访问时间',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of zz_uv_log
-- ----------------------------
