<?php

namespace app\common\validate;

use think\Validate;

/**
 * 文章分类验证器
 */
class DocumentCategory extends Validate
{
    protected $rule = [
        'title|标题' => [
            'require',
            'max' => 50,
        ],
        'pid|上级分类ID' => [
            'require',
            'number',
        ],
        'sort|排序' => [
            'require',
            'number',
        ],
        'meta_title|标题' => [
            'max' => 500,
        ],
        'keywords|网页关键字' => [
            'max' => 500,
        ],
        'link_str|外链' => [
            'max' => 500,
        ],
        'icon|分类图标' => [
            'max' => 500,
        ],
        'template_index|单篇模板' => [
            'path'=>'^[a-zA-Z0-9].*$',
        ],
        'template_lists|列表模板' => [
            'path'=>'^[a-zA-Z0-9].*$',
        ],
        'template_detail|详情模板' => [
            'path'=>'^[a-zA-Z0-9].*$',
        ],
    ];
    protected $message  =   [
        'template_index.path' => '模板路径仅以英文或数字开头！',
        'template_lists.path' => '模板路径仅以英文或数字开头！',
        'template_detail.path' => '模板路径仅以英文或数字开头！',
    ];
    //更新排序
    protected $scene = [
        'sort' => ['sort']
    ];
}
