<?php
namespace app\common\model;
use app\common\model\DocumentCategory as DocumentCategoryModel;
use think\Db;

/**
 * {$TABLE.Comment}
 * Class {$TABLE.Name}
 * @package app\common\model
 */
class DocumentCategoryContent extends Base {

    /**
     * 添加文章分类
     * @param $data
     */
    public function add_data($data)
    {
        if(!$data){
            return false;
        }
        $data['keywords'] = keyword_repalce_split($data['keywords']);
        $data['status'] = 1;
        $documentCategoryModel=new DocumentCategoryModel();
        $re=true;
        // 启动事务
        Db::startTrans();
        try {
            $documentCategoryResult=$documentCategoryModel->add($data);
            if(!$documentCategoryResult){
                throw new \Exception('新增分类失败！');
            }
            $content = isset($data['content'])?$data['content']:'';
            //如果有填写分类内容，将数据保存到分类附表
            $contentResult=$this->save([
                'id'      =>  $documentCategoryResult,
                'content' =>  $content
            ]);
            if(!$contentResult){
                throw new \Exception('新增分类内容失败！');
            }

            //如果不是顶级分类  需要处理
            if((int)$data['pid']!=0){
                //更新上级分类child_id
                $data['id']=$documentCategoryResult;
                $documentCategoryModel->edit_category_child_item(0,$data['pid'],$data);
                $documentCategoryModel->set_category_parent_id($data['id'],'');
            }
            // 提交事务
            Db::commit();
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            $re=false;
        }
        if(!$re){
            return $re;
        }
        return $documentCategoryResult;

    }

    /**
     * 编辑文章
     * @param $data 数据
     *  @param $categoryInfo  原数据
     */
    public function edit_data($data,$categoryInfo)
    {
        if(!$data){
            return false;
        }
        $data['keywords'] = keyword_repalce_split($data['keywords']);
        $documentCategoryModel=new DocumentCategoryModel();
        $re=true;
        // 启动事务
        Db::startTrans();
        try {
            $documentCategoryResult=$documentCategoryModel->edit($data);
            if(!$documentCategoryResult){
                throw new \Exception('编辑文章分类失败！');
            }
            $content = isset($data['content'])?$data['content']:'';

            $dcr=DocumentCategoryContent::get($data['id']);
            if(!$dcr){
                $dcr=new DocumentCategoryContent();
                $dcr->id=$data['id'];
            }
            $dcr->content=$content;
            //副表
            $contentResult=$dcr->save();
            if(!$contentResult){
                throw new \Exception('编辑文章分类失败！');
            }

            //判断是否更改了上级分类
            if($categoryInfo['pid']!=$data['pid']){
                //更新原分类树
                $documentCategoryModel->edit_category_child_item($categoryInfo['pid'],$data['pid'],$categoryInfo);
                //更新父级id
                $documentCategoryModel->set_category_parent_id($data['id'],$categoryInfo['child']);
            }

            // 提交事务
            Db::commit();
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            $re=false;
        }
        return $re;
    }
}