<?php
namespace app\common\model;

/**
 * {$TABLE.Comment}
 * Class {$TABLE.Name}
 * @package app\common\model
 */
class Document extends Base {

    //自动时间戳
    protected $autoWriteTimestamp = true;
    /**
     * @var array   是否推荐
     */
    public $isrecommendList=[

        0=>'不推荐',

        1=>'推荐',

    ];

    public function getIsrecommendAttr($value)
    {
        return $this->isrecommendList[$value];
    }
    /**
     * @var array   是否置顶
     */
    public $istopList=[

        0=>'不置顶',

        1=>'置顶',

    ];

    public function getIstopAttr($value)
    {
        return $this->istopList[$value];
    }
    /**
     * @var array   是否显示
     */
    public $displayList=[

        0=>'隐藏',

        1=>'显示',

    ];

    public function getDisplayAttr($value)
    {
        return $this->displayList[$value];
    }
    //兼容老版本，时间需要格式化
    public function getCreateTimeAttr($value)
    {
        return $value;
    }
    
    /**
     * keywords修改器
     * @param $data
     */
    public function setKeywordsAttr($str)
    {
        $str=str_replace("，",",",$str);
        $str=str_replace(";",",",$str);
        $str=str_replace("；",",",$str);
        $str=str_replace("|",",",$str);
        $str=str_replace("、",",",$str);
        $str=str_replace("\\",",",$str);
        return $str;
    }
    /**
     * 关联DocumentCategory模型
     * @return \think\model\relation\BelongsTo
     */
    public function documentCategory(){
        return $this->belongsTo('DocumentCategory','category_id');
    }

}