<?php
namespace app\common\model;

/**
 * 配置
 * Class Config
 * @package app\common\model
 */
class Config extends Base {
    protected $autoWriteTimestamp = true;

    /**
     * @var string 缓存前缀
     */
    private $cachePrefix='ZZ_CONFIG_';

    /**
     * 初始化模块配置缓存
     * @param $module 模块名称
     * @return array|void
     */
    public function load($module){
        $config=cache($this->cachePrefix.$module);
        //2021.2.27日修改
        $map[]=['status','=',1];
        if($module=='admin'){
            $map[]=['module','=',2];
        }elseif ($module=='index'){
            $map[]=['module','=',1];
        }
        if(!$config){
            $data   = $this->where($map)->whereOr('module',0)->field('type,name,value')->select()->toArray();
            $config = array();
            if($data && is_array($data)){
                foreach ($data as $value) {
                    //解析数组
                    if($value['type']==3){
                        $array = preg_split('/[,;\r\n]+/', trim($value['value'], ",;\r\n"));
                        if(strpos($value['value'],':')){
                            $value['value']  = array();
                            foreach ($array as $val) {
                                list($k, $v) = explode(':', $val);
                                $value['value'][$k]   = $v;
                            }
                        }else{
                            $value['value'] =    $array;
                        }

                    }
                    $config[$value['name']] = $value['value'];
                }
            }

            cache($this->cachePrefix.$module,$config);
        }

        return $config;
    }

    /**
     * 清除模块配置缓存
     * @param $module 模块名称
     */
    public function removeCache($module){
        if(is_array($module)){
            foreach ($module as $key=>$item){
                cache($this->cachePrefix.$key, null);
            }
        }
        else{
            cache($this->cachePrefix.$module, null);
        }
    }
}