<?php
namespace app\common\model;
use app\common\validate\AdminMember as AdminMemberValidate;

/**后台管理员
 * Class AdminMember
 * @package app\common\model
 */
class AdminMember extends Base {

    protected $autoWriteTimestamp = true;
    /**
     * @var array   管理员状态
     */
    public $statusList=[0=>'禁用',1=>'启用'];

    public function getStatusAttr($value)
    {
        return $this->statusList[$value];
    }

    /**管理员登录
     * @param $data 用户名和密码
     * @return bool
     */
    public function Login($data){
        $validate=new AdminMemberValidate();
        if(!$validate->scene('login')->check($data)){
            $this->error=$validate->getError();
            return false;
        }
        $data['password']=zz_ucenter_md5($data['password'], config('UC_AUTH_KEY'));
        $detail=$this->where('username',$data['username'])->where('password',$data['password'])->find();
        if(!$detail){
            $this->error='用户名或密码错误！';
            return false;
        }
        if((int)$detail->id!=1){
            if((int)$detail->getData('status')<1){
                $this->error='该用户已删除或禁用，请联系管理员！';
                return false;
            }
            if((int)$detail->group_id==0){
                $this->error='该用户没有被分配到任何用户权限组，无法登录！';
                return false;
            }
            //判断用户组
            $authGroup=AdminAuthGroup::get((int)$detail->group_id);
            if(!$authGroup){
                $this->error='用户权限组不存在或已被删除，无法登录！';
                return false;
            }
            if((int)$authGroup['status']!=1){
                $this->error='当前用户所在用户权限组已被删除或禁用，无法登录！';
                return false;
            }
        }
        //更新用户登录信息
        $detail->last_login_time=time();
        $detail->last_login_ip=request()->ip();
        $detail->save();
        return $detail;
    }
    /**
     * 关联adminAuth模型
     * @return \think\model\relation\BelongsTo
     */
    public function adminAuthGroup(){
        return $this->belongsTo('AdminAuthGroup','group_id','id');
    }

    /**
     * 判断用户权限
     * @param $path 当前pathinfo
     * @return AdminAuthGroup|bool
     */
    public function checkAuth($path)
    {
        $adminAuthGroupInfo=$this->admin_auth_group;
        if(!$adminAuthGroupInfo){
            $groupId=$this->getData('group_id');
            if (!$groupId) {
                $this->error = '错误：未分配权限！';
                return false;
            }
            $adminAuthGroupInfo = AdminAuthGroup::getList($groupId);
        }
        if (!$adminAuthGroupInfo) {
            $this->error = '错误：无法获取用户组权限！';
            return false;
        }
        if ($adminAuthGroupInfo->getData('status') < 1) {
            $this->error = '错误：用户权限组已被禁用，请联系管理员！';
            return false;
        }
        if (empty($adminAuthGroupInfo->rules)) {
            $this->error = '错误：用户权限组没有分配权限！';
            return false;
        }
        //首页不在权限控制内
        if (strtolower($path) == 'index/index') {
            return true;
        }

        //使用当前访问的url地址去数据库中检索
        $adminMenu = AdminMenu::where('url', 'like', "$path%")->field('id')->select();

        //如果后台菜单中无记录，无权限访问。
        if (!$adminMenu) {
            $this->error = '错误：无权限！';
            return false;
        }
        //再次确定以path_info搜索来的后台菜单id，在权限组的id列表中
        $ruleArr = explode(',', $adminAuthGroupInfo->rules);
        foreach ($adminMenu as $item) {
            if (in_array($item['id'], $ruleArr)) {
                return true;
            }
        }
        $this->error = '错误：无权限！';
        return false;
    }

    /**
     * 获取当前用户的权限菜单
     * @param int $isDev 是否开启开发者模式
     * @return bool|mixed
     */
    public function getAdminMenu($isDev=0){
        //如果是超级管理员，直接获取权限菜单
        if($this->id==1){
            return AdminMenu::getAuthMenu($isDev);
        }

        $adminAuthGroupInfo=$this->admin_auth_group;
        if(!$adminAuthGroupInfo){
            $groupId=$this->getData('group_id');
            if (!$groupId) {
                $this->error = '错误：未分配权限！';
                return false;
            }
            $adminAuthGroupInfo = AdminAuthGroup::getList($groupId);
        }
        if (!$adminAuthGroupInfo) {
            $this->error = '错误：无法获取用户组权限！';
            return false;
        }

        return AdminMenu::getAuthMenu($isDev,$adminAuthGroupInfo->id,$adminAuthGroupInfo->rules);
    }

    /**
     * 根据用户名确定用户是否存在
     * @param $username
     * @return AdminMember
     */
    public function isHas($username){
        return $this->where('username',$username)->find();
    }
    /**
     * 绑定权限
     * @param $data
     */
    public function bindAuth($data){
        $res=$this->where('username',$data['username'])->find();
        if(!$res){
            $this->error='该用户不存在或已删除！';
            return false;
        }
        if($res['id']==1){
            $this->error='该用户为超级管理员，无法授权！';
            return false;
        }
        if($res['group_id']!=0){
            $this->error='该用户已被分配到其他权限组，无法授权！';
            return false;
        }
        $data['id']=$res['id'];
        $re=$this->edit($data);
        if($re){
            return true;
        }
        else{
            $this->error=$this->getError();
            return false;
        }

    }
}