<?php

namespace app\common\model;


/**
 * 后台权限
 * Class AdminAuth
 * @package app\common\model
 */
class AdminAuthGroup extends Base
{
    protected $autoWriteTimestamp = true;

    /**
     * 获取权限组列表，当$id不为空时，返回当前id的权限组数组
     * @param bool $id 权限组id
     * @return AdminAuthGroup|array|mixed
     */
    public static function getList($id=false){
        $lists=cache('ADMIN_AUTH_GROUP_LIST');
        if(!$lists){
            $tempLists=AdminAuthGroup::all();
            $lists=[];
            foreach ($tempLists as $item){
                $lists[$item['id']]=$item;
            }
            cache('ADMIN_AUTH_GROUP_LIST',$lists);
        }
        if($id){
            return isset($lists[$id])?$lists[$id]:false;
        }
        return $lists;
    }

    /**
     * 添加，清除缓存
     * @param $data
     * @return bool|mixed
     */
    public function add($data)
    {
        $re=parent::add($data);
        if($re)
            AdminAuthGroup::removeCache();
        return $re;
    }

    /**
     * 编辑，清除缓存
     * @param $data
     * @return bool
     */
    public function edit($data)
    {
        $re=parent::edit($data);
        if($re)
            AdminAuthGroup::removeCache($data['id']);
        return $re;
    }

    /**
     * 判断用户组名称是否重复
     * @param $title
     * @return AdminAuth
     */
    public function isRepeatTitle($title, $id = false)
    {
        if ($id) {
            return $this->where('title', $title)->where('id', '<>', $id)->find();
        } else {
            return $this->where('title', $title)->find();
        }
    }

    /**
     * 清除缓存
     * @param bool $id
     */
    public static function removeCache($id=false){
        cache('ADMIN_AUTH_GROUP_LIST',null);
        if($id)
            AdminMenu::removeAuthMenuCache($id);
    }
}