<?php
// +----------------------------------------------------------------------
// | HulaCWMS 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\admin\controller;
use app\common\model\FriendLink as FriendLinkModel;
use app\common\validate\Friendlink as FriendlinkValidate;

class FriendLink extends Auth {
	/**
	 * 友情链接管理
	 */
	public function index() {
        $param=[
            'nickname'=>''
        ];
        $param=$this->initParam($param);
        $map[] = ['status','>',-1];
        if($param['nickname']!=''){
            $map[]=['title','like','%'.$param['nickname'].'%'];
        }
        $model=new FriendLinkModel();
		$lists = $model
            -> where($map)
            -> order('sort asc')
            ->paginate($this->config['LIST_ROWS'],false,['query' => $this->getRouteQuery()]);
		$this -> assign('lists', $lists);
        $this->assign('param',$param);
		return $this -> fetch();
	}


    /**
     * 新增
     */
    public function add(){
        if($this->request->isGet()){
            return $this -> fetch();
        }
        $thisModel=new FriendLinkModel();
        $postData=$this->request->param();
        //验证器
        $friendlinkValidate = new FriendlinkValidate();
        if (!$friendlinkValidate -> check($postData)) {
            $this -> error($friendlinkValidate -> getError());
        }
        $re=$thisModel->add($postData);
        if($re){
            cache('DATA_FRIEND_LINK', null);
            $this->success('新增成功！','index');
        }
        else{
            $this->error($thisModel->getError());
        }
    }


    /**
     * 编辑
     */
    public function edit(){
        $thisModel=new FriendLinkModel();
        if($this->request->isGet()){
            $id=input('id');
            $info=$thisModel->get($id);
            $this->assign('info',$info);
            return $this -> fetch();
        }
        $paramData=$this->request->param();
        //验证器
        $friendlinkValidate = new FriendlinkValidate();
        if (!$friendlinkValidate -> check($paramData)) {
            $this -> error($friendlinkValidate -> getError());
        }
        $re=$thisModel->edit($paramData);
        if($re){
            cache('DATA_FRIEND_LINK', null);
            $this->success('编辑成功！','');
        }
        else{
            $this->error($thisModel->getError());
        }
    }

    /**
     * 修改状态
     */
    public function enable(){
        if ($this->request->isPost()){
            $data['id']=input('id/d');
            $data['status']=input('val/d');
            $thisModel=new FriendLinkModel();
            $res=$thisModel->edit($data);
            if($res){
                if ($data['status'] == 1) {
                    //禁用
                    $friendlink_status = "friendlink_status_qi";
                }
                if ($data['status'] == 0) {
                    //启用
                    $friendlink_status = "friendlink_status_jin";
                }
                cache('DATA_FRIEND_LINK', null);
                $this->success('操作成功！');
            }else{
                $this->error($thisModel->getError());
            }
        }
    }

    /**
     * 排序
     */
    public function sort(){
        if ($this->request->isPost()){
            $data['id']=input('id/d');
            $data['sort']=input('sort');
            $model=new FriendLinkModel();
            $friendlinkValidate = new FriendlinkValidate();
            if (!$friendlinkValidate -> scene('sort') -> check($data)) {
                $this -> error($friendlinkValidate -> getError());
            }
            $re=$model->edit($data);
            if($re){
                cache('DATA_FRIEND_LINK', null);
                // 添加行为记录
                $this->success('操作成功！');
            }else{
                $this->error($model->getError());
            }
        }
    }

    /**
     * 删除
     */
    public function del(){
        $id=$this->request->param('ids/a');
        if (empty($id)) {
            $this -> error('请选择要操作的数据!');
        }
        $thisModel=new FriendLinkModel();
        //伪删除
        $where[] =['id','in',$id];
        $re=$thisModel->save([
            'status'  => -1
        ],$where);
        if($re){
            cache('DATA_FRIEND_LINK', null);
            $this->success('删除成功！');
        }
        else{
            $this->error($thisModel->getError());
        }
    }

}
